from dataclasses import dataclass
from typing import List, Optional


@dataclass
class LogConfig:
    name: str = "log"
    group: str = "logging"
    # logs
    logdir: str = "/tmp/wandb"
    # wandb
    wandb_project_name: str = "ad_experiments"
    wandb_entity: Optional[str] = None
    wandb_log_freq: int = 8
    # Configure run organization
    wandb_group_name: Optional[str] = None
    wandb_tags: Optional[List[str]] = None
    wandb_run_name: str = ""
    wandb_run_version: Optional[str] = None  # To resume wandb run
    wandb_offline: bool = False
    # Put checkpoints on wandb
    wandb_checkpoints: bool = False
    # Log gradients and parameters during training
    wandb_watch: bool = False
    # How often to set a checkpoint
    checkpoint_every_n_epochs: int = 16
    # The last how many checkpoints should be kept
    keep_last_n_checkpoints: int = 1
    # Specify whether ROC curves should be logged for each score
    log_roc_curve: bool = False
