from dataclasses import dataclass

from omegaconf import MISSING

from .enums import ResNetType


@dataclass
class ModelConfig:
    name: str = MISSING
    group: str = "model"


@dataclass
class ResNet(ModelConfig):
    name: str = "resnet"
    resnet_type: ResNetType = ResNetType.resnet18
    pretrain: bool = False
