#!/bin/bash
# LLaMA-130M, SRON, 1 Node, 4 3090
module load cuda/11.8

export optimizer=sron
export lr=2.0e-2
export seed=0
export OMP_NUM_THREADS=1
export weight_decay=0.0
export momentum=0.0
export scale=5.0e-2


torchrun --standalone --nproc_per_node 4 torchrun_main.py \
    --model_type llama \
    --model_config configs/llama_130m.json \
    --lr $lr \
    --scale $scale \
    --batch_size 64 \
    --total_batch_size 512 \
    --num_training_steps 20000 \
    --warmup_ratio $warmup_ratio \
    --dtype bfloat16 \
    --eval_every 1000 \
    --save_every 100000 \
    --seed $seed \
    --momentum $momentum \
    --save_dir llama_130m/$optimizer/seed_$seed+$lr*$scale+wd_$weight_decay \
    --optimizer $optimizer > logs/llama130m/$optimizer/seed_$seed+$lr*$scale+wd_$weight_deca.out 2>&1 &
wait

echo 'Done!'