### **Coverage**  
A supervolcano eruption (VEI 8, >1,000 km³ magma) next year would affect global systems, with impacts spanning geology, climate, health, agriculture, and economics. Key domains:  
- **Geology**: Ash fall (meters thick over 1000+ km²), pyroclastic flows, and tectonic disruption.  
- **Climate**: Global cooling via sulfate aerosols.  
- **Health**: Respiratory failure, acid rain, and starvation.  
- **Agriculture**: Crop failure in major growing regions.  
- **Economy**: Global GDP contraction, supply chain collapse, and infrastructure damage.  


### **Causality**  
Eruption mechanics drive impacts:  
- **Tephra**: 100–1000+ km³ ash blocks sunlight, reducing solar input.  
- **Sulfur Dioxide (SO₂)**: 1000–10,000+ Mt SO₂ forms stratospheric aerosols, causing 5–15°C global cooling for 3–5 years (vs. 0.5°C from 1991 Pinatubo, VEI 6).  
- **Carbon Dioxide (CO₂)**: 10–100 Mt CO₂ (less impactful than cooling in short term).  
- **Location**: Eruption in a populated region (e.g., Yellowstone, Indonesia’s Toba) amplifies societal impacts; remote eruptions (e.g., oceanic) reduce local effects but still cause global climate shifts.  


### **Feasibility**  
- **Geological Likelihood**: Supereruptions occur every 100,000–1,000,000 years (last: Toba, 75k years ago). A "next year" event is astronomically rare (~1 in 10⁵–10⁶ chance), but not impossible.  
- **Preparedness Limits**: No global early-warning system for supereruptions; evacuation of large areas (e.g., Yellowstone’s 2.2 million km²) is logistically unfeasible.  


### **Uncertainty & Adaptation**  
- **Eruption Size/Type**: A VEI 8 is the worst case, but VEI 7 (e.g., 1991 Pinatubo) would still cause 2–5°C cooling and crop failures.  
- **Human Response**: Preparedness (e.g., food stockpiles, greenhouses) could mitigate 30–50% of impacts, but global coordination is limited.  
- **Long-Term Climate**: SO₂ aerosols fade in 3–5 years, but CO₂ and ash may cause 10–20% reduced photosynthesis for a decade, worsening food shortages.  


### **Scenarios & Timeline**  
| **Timeline**       | **No Preparedness**                          | **With Preparedness**                      |  
|---------------------|----------------------------------------------|--------------------------------------------|  
| **0–3 months**      | Ash fall disrupts air travel, local infrastructure. | Partial evacuation; airports closed; food distribution begins. |  
| **3–12 months**     | 5–15°C global cooling; crop failure in 60% of growing regions. | Famine in 20–30% of vulnerable regions (vs. 70% without prep). |  
| **1–5 years**       | 20–30% global GDP drop; 1–3 billion deaths from starvation. | GDP drops 5–10%; 200–500 million deaths; recovery in 10–20 years. |  


### **Traceability & Consistency**  
- **Assumptions**: Eruption volume (1,000–5,000 km³), SO₂ emissions (2,000–10,000 Mt), and location (populated vs. remote) are critical.  
- **Consistency**: Impacts align with historical analogs (e.g., 1815 Tambora eruption, 1816 "Year Without a Summer") scaled up by 10–100x.  
- **Limitations**: No supereruption has occurred in modern history, so projections rely on geological modeling and analogs.  


**Conclusion**: A supervolcano eruption next year would cause catastrophic, multi-year global disruption, with mortality and economic collapse absent preparedness.