from __future__ import annotations

from dataclasses import dataclass, field
from typing import List, Dict, Any, Optional


@dataclass
class ScenarioDefinition:
    proposition: str
    premises: List[str]
    constraints: List[str]
    timescales: List[str]
    uncertainties: List[str]
    expert_plan: List[str]
    # Raw natural-language output from the ProblemRefinerAgent
    refinement_raw: Optional[str] = None


@dataclass
class ExpertInput:
    scenario: ScenarioDefinition
    shared_frame_summary: Optional[str] = None  # Provided from conflict resolver in rounds >= 2
    round_index: int = 1


@dataclass
class ExpertOutput:
    role: str
    reasoning_steps: List[str]
    conclusions: List[str]
    assumptions: List[str]
    uncertainties: List[str]
    dependency_notes: List[str]
    # Raw natural-language output from the DomainExpertAgent
    raw_text: Optional[str] = None


@dataclass
class ConflictReport:
    consensus_points: List[str]
    conditional_branches: Dict[str, str]  # condition -> description
    remaining_uncertainties: List[str]
    notes: List[str] = field(default_factory=list)
    # Raw natural-language output from the ConflictResolverAgent
    raw_text: Optional[str] = None


@dataclass
class OrchestratorConfig:
    rounds: int = 3
    expert_roles: List[str] = field(
        default_factory=lambda: [
            "Physics",
            "ChemistryMaterials",
            "BiologyEcology",
            "Economics",
            "EngineeringInfrastructure",
            "EnvironmentalScience",
        ]
    )
    dependency_map: Dict[str, List[str]] = field(
        default_factory=lambda: {
            "Economics": ["BiologyEcology"],
            "EngineeringInfrastructure": ["Physics", "EnvironmentalScience"],
        }
    )
    model_id: str = "doubao-seed-1-6-flash-250715"

