from __future__ import annotations

import math
from typing import List, Tuple


def safe_log10_ratio(numerator: float, denominator: float, eps: float = 1e-12) -> float:
    """Utility: log10(numerator/denominator) with numerical safety."""
    return math.log10(max(numerator, eps) / max(denominator, eps))


def bounded_growth(current: float, rate: float, steps: int, cap: float) -> List[float]:
    """Generic bounded growth utility for toy projections in expert reasoning."""
    values = [current]
    for _ in range(steps):
        next_val = min(values[-1] * (1 + rate), cap)
        values.append(next_val)
    return values


def sigmoid(x: float) -> float:
    return 1.0 / (1.0 + math.exp(-x))

