import datetime
import uuid
from rlf.exp_mgr import config_mgr


class wandb_logger(object):
    def __init__(self, args):
        self.wandb = None
        self._create_prefix(args=args)
        self.args = args

    def _create_wandb(self, log_dir: str = None):
        if self.args.wand:
            import wandb
            # from wandb_credentials import WANDB_API_KEY
            # wandb.login(key=WANDB_API_KEY)

            config_mgr.init("./config.yaml")
            wb_proj_name = config_mgr.get_prop("proj_name")
            wb_entity = config_mgr.get_prop("wb_entity")
            wandb.init(project=wb_proj_name, entity=wb_entity, name=self.args.prefix,
                    reinit=True, config=self.args, dir=log_dir)
            self.args.prefix = self.prefix
            self.wandb = wandb

    def wandb_log_image(self, images: list, step: int, log_string):
        if self.wandb is not None:
            self.wandb.log({log_string: [self.wandb.Image(image) for image in images]}, step=step)

    def wandb_log_video(self, path_to_video: str, step: int, log_string, format="mp4"):
        if self.wandb is not None:
            self.wandb.log(
                {log_string: self.wandb.Video(path_to_video, fps=4, format=format)})  # doesn't support step=step

    def wandb_log(self, data: dict, step: int):
        if self.wandb is not None:
            self.wandb.log(data, step=step)

    def _create_prefix(self, args: dict):
        assert args.prefix is not None and args.prefix != '', 'Must specify a prefix to use W&B'
        d = datetime.datetime.today()
        # date_id = f"{d.month}{d.day}{d.hour}{d.minute}{d.second}"
        unique_id = uuid.uuid4().hex[:8]  # Shortened version of UUID
        before = f"{args.seed}-{unique_id}-"

        if args.prefix != 'debug' and args.prefix != 'NONE':
            self.prefix = before + args.prefix
            print('Assigning full prefix %s' % self.prefix)
        else:
            self.prefix = args.prefix
        args.prefix = self.prefix


