# ManiSkill Environment for Constraint Expert Project

## Installation

```bash
conda create -n ce python=3.10
conda activate ce
pip install -r requirements.txt
```

## Usage

Visualize Robot
```bash
python -m examples.demo_robot -r widowx250s_custom
```

Visualize Environment with Random Action
```bash
python -m examples.demo_random_action --env-id WidowXLiftCubeBase-v1 --render-mode human
```

Keyboard Teleoperation
```bash
python -m examples.demo_manual_action --env-id WidowXLiftCubeBase-v1
```

Joystick Teleoperation
```bash
PYTHONPATH=$(pwd) python -m widowx_expert.examples.demo_manual_action_joystick --env-id WidowXLiftCubeBase-v1
```

Test Environment with Random Action
```bash
python widowx_expert/examples/test_env_random_action.py --env-id WidowXLiftCube-v2
```

Save demos with Random Action
```bash
python widowx_expert/examples/save_traj_random_action.py --env_name WidowXLiftCube-v2
```

Save demos with joystick
```bash
python widowx_expert/examples/save_traj_joystick.py --env_name WidowXLiftCube-v2
```

Combine saved demos into one file
```bash
python widowx_expert/utils/combine_trajs.py --traj_load_dir /traj/saving/dir
```





