
import click
import os

from principal_tradeoff_analysis.experiment import PTAExperiment



def run_from_config(config_path: str):
    print("Running run from config")

    exp = PTAExperiment.load_from_config(config_path)

    exp.run()

@click.command()
@click.option("--config", default = "", help="Path to config file. Look in /configs for examples")
def main(config: str):
    """Strategic Geometry Main Entry Point"""
    print("Calling main")
    assert type(config) == str, "--config must be a path"

    if len(config) > 0:
        assert os.path.isfile(config), "--config must be a path"
        print(f"Running Experiment from the config = {config} ")
        run_from_config(config)

    
if __name__ == "__main__":
    """
    Main entry point for running experiments
    """
    main()