# Principal Trade-off Analysis (PTA)

This repository is for reproducing research as seen in the above paper.
To reproduce the experiments in the paper follow the following instructions

## 1. Install
--- 
There are a few ways to install the repository. Our preferred method is poetry but its not a strict requirement.

### 1.a Install with poetry (https://python-poetry.org/docs/)
--- 
This is the best way to ensure results are reproduced correctlyFirst install by first making sure poetry is installed 

`pip install poetry`

Then git clone the repo and cd into the downloaded project

Next run install the project with poetry. This will automatically create a virtual environment for you. 

`poetry install` 

### 1.b Pip install 
--- 

Create a virtualenv using your preferred method and then install all of the requirements. 

`pip install -r requirements.txt`

## Run Experiments

The experiment_config.yaml file defines all of the experiments to be run. Currently each experiment of the paper is set to run. You can adjust parameters as you see fit to run your own experiments. The config file has a number of flags that are self explanatory and have comments where needed. 

To run an experiment adjust the `experiment_config.yaml` to run what experiment you want the current configuration will output all of the figures for the paper so dont adjust anything if thats what you want. 

Run experiments defined in config file

`./run_exp.sh`


### Note: 
* The output for the experiments will go into the ./output/ folder. 
* There is already figures from the paper stored there
* We did additional editing in Powerpoint beyond what the experiments produce to better illustrate concepts and so the figures being produced will not have those additional graphics
* Data will be output to ./data/ during the experiments. The pokemon data is already present in ./data/experiment4/ but the blotto data will be built from scratch