# This is a sample Python script.

# Press ⌃R to execute it or replace it with your code.
# Press Double ⇧ to search everywhere for classes, files, tool windows, actions, and settings.

import copy
import itertools

import numpy as np
import matplotlib.pyplot as plt
import pandas as pd


def memory_bias_continuous():
    T = 2000
    dt = 0.01
    # epsilon=1e-14
    epsilon=0

    df_memory_function = pd.DataFrame()
    weights = [(w * dt + (epsilon if w * dt > 0 else -epsilon)) for w in range(1, 2 * T+1)] # 0.01 -> 10
    sym_weights = [(w * dt + (epsilon if w * dt > 0 else -epsilon)) for w in range(-T, T)] # 0.01 -> 10
        
    df_memory_function[r"linear, $\lambda=-w,w>0$"] = np.abs(np.array([1/(w**3+epsilon) for w in weights]))
    df_memory_function[r"exponential, $\lambda=-\exp(w),w\in\mathbb{R}$"] = np.abs(np.array([1/(np.exp(w)*w+epsilon) for w in sym_weights]))
    df_memory_function[r"softplus, $\lambda=-\log(1+\exp(w)),w\in\mathbb{R}$"] = np.abs(np.array([1 / (np.log(1+np.exp(w))**2+epsilon) / (1+np.exp(-w)) / (np.abs(w)+epsilon) for w in sym_weights]))
    df_memory_function[r"best, $\lambda=-\frac{1}{w^2},w\in\mathbb{R}$"] = np.abs(np.array([1 for w in sym_weights]))

    plt.clf()
    plt.figure(1, figsize=(19, 14), dpi=550)

    line_styles = ["--", "-.", "-", ":"]
    line_styles_cycle = itertools.cycle(line_styles)
    # line_widths = [- item * 1.3 + 4.9 for item in range(4)]
    line_widths = [4, 4, 2, 4]
    line_widths_cycle = itertools.cycle(line_widths)
    line_colors = ["b", '#ff7f0e', "c", "r"]

    for column, line_style, line_width, line_color in zip(
        df_memory_function.columns, line_styles_cycle, line_widths_cycle, line_colors
    ):
        if "linear" in column:
            plt.plot(
                weights,
                df_memory_function[column],
                line_style,
                linewidth=line_width,
                label=column,
                color=line_color,
            )
        else:
            plt.plot(
                sym_weights,
                df_memory_function[column],
                line_style,
                linewidth=line_width,
                label=column,
                color=line_color,
            )

    plt.xlabel(r"Weight $w$", fontsize=16)
    plt.ylabel(r"Gradient-weight ratio at weight $w$: $\frac{G_f(w)}{|w|}$", fontsize=16)
    plt.xscale('symlog')
    plt.yscale("log")
    plt.ylim([1e-10, 1e10])
    plt.legend(prop={'size': 12.2})
    plt.subplots_adjust(top=0.93)
    plt.tight_layout()
    plt.savefig(f"./gradient_scale.pdf")
    plt.savefig(f"./gradient_scale.png")

def memory_bias_discrete():
    T = 2000
    dt = 0.01
    # epsilon=1e-14
    epsilon=0

    df_memory_function = pd.DataFrame()
    weights = [(w * dt + (epsilon if w * dt > 0 else -epsilon)) for w in range(1, 2 * T+1)] # 0.01 -> 10
    sym_weights = [(w * dt + (epsilon if w * dt > 0 else -epsilon)) for w in range(-T, T)] # 0.01 -> 10
    
    # np.exp(-w) / ((1-np.exp(-w))**2 * w+ epsilon)
    df_memory_function[r"linear, $\lambda=\exp(-w),w>0$"] = np.abs(np.array([np.exp(-w)/((1-np.exp(-w))**2*w+epsilon) for w in weights]))

    # np.exp(-np.exp(w)) * np.exp(w) / ((1-np.exp(-np.exp(w)))**2 * w+ epsilon)
    df_memory_function[r"exponential, $\lambda=\exp(-\exp(w)),w\in\mathbb{R}$"] = np.abs(np.array([np.exp(w-np.exp(w)) / ( (1-np.exp(-np.exp(w)))**2 * w+ epsilon) for w in sym_weights]))

    # 1 / (np.exp(w) * w + epsilon)
    df_memory_function[r"softplus, $\lambda=\frac{1}{(1+\exp(w))},w\in\mathbb{R}$"] = np.abs(np.array([1 / (np.exp(w) * w + epsilon) for w in sym_weights]))

    # 1
    df_memory_function[r"best, $\lambda=1-\frac{1}{w^2+0.5},w\in\Omega$"] = np.abs(np.array([1 for w in sym_weights]))

    plt.clf()
    plt.figure(1, figsize=(19, 14), dpi=550)

    line_styles = ["--", "-.", "-", ":"]
    line_styles_cycle = itertools.cycle(line_styles)
    # line_widths = [- item * 1.3 + 4.9 for item in range(4)]
    line_widths = [4, 4, 2, 4]
    line_widths_cycle = itertools.cycle(line_widths)
    line_colors = ["b", '#ff7f0e', "c", "r"]

    for column, line_style, line_width, line_color in zip(
        df_memory_function.columns, line_styles_cycle, line_widths_cycle, line_colors
    ):
        if "linear" in column:
            plt.plot(
                weights,
                df_memory_function[column],
                line_style,
                linewidth=line_width,
                label=column,
                color=line_color,
            )
        else:
            plt.plot(
                sym_weights,
                df_memory_function[column],
                line_style,
                linewidth=line_width,
                label=column,
                color=line_color,
            )

    plt.xlabel(r"Weight $w$", fontsize=16)
    plt.ylabel(r"Gradient-weight ratio at weight $w$: $\frac{G_f(w)}{|w|}$", fontsize=16)
    plt.xscale('symlog')
    plt.yscale("log")
    plt.ylim([1e-10, 1e10])
    # plt.legend(prop={'size': 12})
    plt.subplots_adjust(top=0.93)
    plt.tight_layout()
    plt.savefig(f"./gradient_scale_discrete.pdf")
    plt.savefig(f"./gradient_scale_discrete.png")


# Press the green button in the gutter to run the script.
if __name__ == "__main__":
    memory_bias_continuous()
    memory_bias_discrete()
