# Interactive Speculative Planning


<img width="699" alt="Screen Shot 2024-07-30 at 2 04 35 PM" src="https://github.com/user-attachments/assets/d338555c-7d8c-43eb-86ec-30e675916d65">

## Abstract
Agents are increasingly employed as user-centric tools for human task delegation, assisting with a wide range of requests by generating thoughts, interacting with user proxies, and producing final action plans. However, agents based on large language models (LLMs) often encounter significant planning latency due to two main factors: the efficiency constraints of the underlying LLMs, exacerbated by their large size and high demand, and the structural complexity of the agents, which necessitates extensive intermediate step generation to produce the final output. This paper introduces a human-centered efficient agent planning method -- interactive speculative planning -- to enhance the efficiency of agent planning while incorporating human interaction to further accelerate the system. Our approach promotes the co-design of the agent system and user interface, emphasizing the importance of an agent system that can seamlessly handle user interactions and interruptions. 
By treating human interruptions as an integral part of the system, we not only make it more user-centric but also accelerate the entire system by providing correct intermediate steps.


## Experiment & Command
### Simulation Experiment
The simulation experiment uses time.sleep() to simulate a normal agent call process. Thus we are able to control the speed of both the approximation agent and the target agent to know precisely how much time is saved.

Run the below command to see the simulation.
```
k=4 # max number of approximation steps to generate everytime
acc=0.5 # accuracy of the approximation agent
approximation_sleep_time=2 # the running speed of the approximation agent for each step
# the running speed of the target agent for each step is set to be 8

python simulation.py --k k --acc acc --approximation_sleep_time approximation_sleep_time
```

### OpenAGI Experiment
The OpenAGI setting uses the agent to generate plan first and then do the execution. Thus here, we focus on the planning step without execution.

In openagi.py, set the OPENAI_API_KEY:
```
os.environ['OPENAI_API_KEY'] = your_key
```

There are three setting that we can choose:

Setting 1: The approximation agent uses direct-generation-based planning with a GPT-4o backbone, and the target agent uses chain-of-thought (CoT)-based planning with a GPT-4-turbo backbone. 

Setting 2: The approximation agent uses direct-generation-based planning with a GPT-4o backbone, and the target agent uses ReAct-based planning with a GPT-4-turbo backbone.

Setting 3: The approximation agent uses direct-generation-based planning with a GPT-3.5-turbo backbone, and the target agent uses direct-generation-based planning with a GPT-4-turbo backbone. 
```
target_type = "direct" # could be "react" (setting 1), "cot" (setting 2), "direct" (setting 3)
task_id = 1 # the datapoint to run
python openagi.py --task_id task_id --target_type target_type
```

### TravelPlanner Experiment
The TravelPlanner mainly adopts the code from [TravelPlanner](https://github.com/OSU-NLP-Group/TravelPlanner) and integrate the interactive speculative planning code into it.

To run speculative planning on TravelPlanner, you need to first download code and database following instructions in [TravelPlanner](https://github.com/OSU-NLP-Group/TravelPlanner) to download data. A different virtual environment to fit TravelPlanner is also necessary.
```
git clone https://github.com/OSU-NLP-Group/TravelPlanner

conda create -n travelplanner python=3.9
conda activate travelplanner
pip install -r requirements.txt
```

Then put the threes python files under travelplanner_supplement in downloaded TravelPlanner's code under the directory TravelPlanner/agents. 

In tool_agents_sp.py, set the openai api key:
```
os.environ['OPENAI_API_KEY'] = your_key
```

To run the experiment:
```
cd TravelPlanner/agents
task_id = 1
python sp_travel_planner.py --task_id task_id
```
