import random
import numpy as np
import os
from datetime import date, datetime
import sys
import asyncio
from async_timeout import timeout
import time


class Logger(object):
    def __init__(self, log_path, on=False):
        self.log_path = log_path
        self.on = on
        if self.on:
            while os.path.isfile(self.log_path):
                self.log_path = self.log_path[:-4] + '+'+ self.log_path[-4:]
        print('Logging to', self.log_path)
        with open(self.log_path, 'w') as f:
            f.write("")
            f.close()

    def log(self, string, newline=True):
        if os.path.isfile(self.log_path):
            #if self.on:
            with open(self.log_path, "a") as f:
                today = date.today()
                today_date = today.strftime("%m/%d/%Y")
                now = datetime.now()
                current_time = now.strftime("%H:%M:%S")
                string = today_date + ", " + current_time + ": " + string
                f.write(string)
                if newline:
                    f.write("\n")

            sys.stdout.write(string)
            if newline:
                sys.stdout.write("\n")
            sys.stdout.flush()
        else:
            with open(self.log_path, 'w') as f:
                f.write("")
                f.close()

async def cancel(task):
    start = time.time()
    task.cancel()
    try:
        async with timeout(-1):
            await task
        end = time.time()
    except asyncio.CancelledError:
        end = time.time()
        return "task cancelled"
    except asyncio.exceptions.TimeoutError:
        end = time.time()
        return "time out for canceling task"
    except Exception as e:
        end = time.time()
        return "exception:" + str(e)
