# Movement-to-Action Transformer Networks for Temporal Action Proposal Generation

This is the implementation of the approach described in the paper.


### Dependencies
Below are the packages in my environment:

- Python 3.8
- PyTorch 1.9.1
- transformers 4.12.3
- pandas 1.3.2
- torchvision 0.9.0+cu111
- numpy 1.21.2
- Matplotlib, if you want to visualize predictions.

### Feature Extraction
The atomic movement representations can be generated by running

```sh
cd part_move
python part_recog.py
```
The semantic movement representations can be generated by running
 
```sh
cd part_move
python effort.py
```

### Training

```
python main.py
```

By default the application runs in training mode. This will train a new model for 50 epochs. 

### Testing

```
python main.py --eval --resume outputs/checkpoint_best_sum_ar.pth
```
This output the results on Thumos14 Dataset.

## References

We especially thank the contributors of the RTD-Net and DETR for providing helpful code.

