#!/usr/bin/env bash
# file: run_loop.sh

# Write the tasks and models to iterate through into arrays
#pair_jailbreakbench pair_strongreject pair_harmbench pap_jailbreakbench pap_strongreject pap_harmbench
TASKS=(pair_jailbreakbench pair_strongreject pair_harmbench pap_jailbreakbench pap_strongreject pap_harmbench)
# Please specify the model paths and names to be evaluated
MODELS=()
MODELS_NAME=()

# Get array lengths
num_tasks=${#TASKS[@]}
num_models=${#MODELS[@]}

for ((i=0; i<num_tasks; i++)); do
  for ((j=0; j<num_models; j++)); do
    task=${TASKS[i]}
    model=${MODELS[j]}
    model_name=${MODELS_NAME[j]}
    echo ">>>> Starting: python attack_eval.py --task $task --model $model_name"
    CUDA_VISIBLE_DEVICES=6,7  python attack_eval.py \
        --model_path $model \
        --target_name $model_name \
        --dataset_name $task \
        --backdoor MathAttack-v3 \
        --judge "strongreject_judge" \
        --output_path ./ \
        --num_generate 8
    rc=$?
    if [ $rc -ne 0 ]; then
        echo "<<<< Failed! task=$task model=$model exit code $rc, script terminated."
        exit $rc
    fi
  done
done
echo "==== All completed ===="

