import json
from typing import List

import numpy as np
import torch
from debate.arithmetic.common import (
    construct_message_standard,
    gen_question,
)
from debate.gen_utils import (
    Debate,
    Debates,
    construct_assistant_message,
    generate_answer_standard,
)
from tqdm import trange
from transformers import AutoModelForCausalLM, AutoTokenizer

tokenizer = AutoTokenizer.from_pretrained("mistralai/Mistral-7B-Instruct-v0.2")
model = AutoModelForCausalLM.from_pretrained(
    "mistralai/Mistral-7B-Instruct-v0.2",
    device_map="auto",
    torch_dtype=torch.bfloat16,
)

if __name__ == "__main__":
    agents = 3
    rounds = 3
    trials = 5
    questions = 100

    np.random.seed(0)

    all_trial_data: List[Debates] = []
    for trial in trange(trials):
        response_dict: Debates = {}
        all_trial_data.append(response_dict)
        for q_i in trange(questions):
            question, answer = gen_question()
            agent_contexts: Debate = [
                [{"role": "user", "content": question}] for agent in range(agents)
            ]

            for round in range(rounds):
                torch.cuda.empty_cache()
                for i, agent_context in enumerate(agent_contexts):
                    if round != 0:
                        agent_contexts_other = (
                            agent_contexts[:i] + agent_contexts[i + 1 :]
                        )
                        message = construct_message_standard(
                            other_agents=agent_contexts_other,
                            conv_idx=2 * round - 1,
                        )
                        agent_context.append(message)

                    completion = generate_answer_standard(
                        agent_context, model, tokenizer
                    )

                    assistant_message = construct_assistant_message(completion)
                    agent_context.append(assistant_message)

                response_dict[question] = (agent_contexts, answer)
                all_trial_data[-1] = response_dict
                json.dump(
                    all_trial_data,
                    open(f"arith_{agents}_{rounds}_{trials}_standard.json", "w"),
                )
