# DMWM: Dual-Mind World Model with Long-Term Imagination

This repository is the official implementation of ***DMWM: Dual-Mind World Model with Long-Term Imagination*** 
submitted to 2025 NeurIPS with ***submission id:14706***. 

!["The proposed dual-mind world model"](Figure/pipline.png "The proposed dual-mind world model")

## Requirements
To install all dependencies with Anaconda run using the following commands.
```bash
conda env create -f conda_env.yml 
```
```bash
source activate DMWM
```

Suggested GPU:
All experiments in the paper were conducted on a single NVIDIA RTX 3090 GPU. 

Training Env: Google DeepMind Infrastructure for Physics-Based Simulation. (https://github.com/google-deepmind/dm_control#rendering)



## Training

To train the model(s) in the paper, run this command:
Taking walker-walk task as an example:
```bash
python main.py --algo dreamer --env walker-walk --action-repeat 2 --id your_named-experiement
```

Some useful commands:
```bash
python main.py --algo dreamer --env walker-walk --action-repeat 2 --logic-overshooting-distance 10 --id your_named-experiement
```

```bash
python main.py --algo dreamer --env walker-walk --action-repeat 2 --planning-horizon 50 --id your_named-experiement
```

```bash
python main.py --algo dreamer --env walker-walk --action-repeat 2 --planning-horizon 50 --logic-overshooting-distance 50 --id your_named-experiement
```

## Evaluation

To evaluate my model on ImageNet, run:

```bash
python main.py --models saved_path --test
```

