from matplotlib import pyplot as plt
import numpy as np
from tueplots import bundles, figsizes, cycler
from tueplots.constants.color import palettes

plt.rcParams.update(bundles.neurips2022())
plt.rcParams.update(figsizes.neurips2022())
bundle = bundles.neurips2022()
bundle['figure.figsize'] = (4.0, 3.3)
# bundle['font.size'] = 14
bundle['axes.labelsize'] = 12
# bundle['legend.fontsize'] = 8
bundle['xtick.labelsize'] = 12
bundle['ytick.labelsize'] = 12
bundle['axes.titlesize'] = 18
plt.rcParams.update(bundle)


colorlist = ['tab:blue', 'tab:orange', 'tab:green']
fig, ax = plt.subplots(1,1)
mpo_means = []
mpo_stds = []
# data = np.load(f'./neurips_ostrich_eval/speed/mpo_speed.npy')
data = np.load(f'./obstacles_mpo_robust.npy')
mpo_means.append(np.mean(data))
mpo_stds.append(np.std(data))
# data = np.load(f'./neurips_ostrich_eval/speed/dep_mpo_speed.npy')
data = np.load(f'./obstacles_depmpo_robust.npy')
mpo_means.append(np.mean(data))
mpo_stds.append(np.std(data))
# data = np.load(f'./neurips_ostrich_eval/speed/td4_speed.npy')
data = np.load(f'./obstacles_td4.npy')
mpo_means.append(np.mean(data))
mpo_stds.append(np.std(data))

x = np.arange(len(mpo_means))
bars = ax.bar(x, height=mpo_means, yerr=mpo_stds, color=colorlist)
ax.set_xticks(x)
ax.set_xticklabels(['MPO','DEP-MPO','TD4'])


ax.set_ylabel('achieved distance (m)')
plt.tight_layout()
plt.savefig('slopetrotter.pdf')
plt.show()
