from matplotlib import pyplot as plt
import numpy as np
from tueplots import bundles, figsizes, cycler
from tueplots.constants.color import palettes

def change_figsize(fig_dict, fraction_width, fraction_height=1):
    fig_dict['figure.figsize'] = fig_dict['figure.figsize'][0] * fraction_width, fig_dict['figure.figsize'][1] * fraction_height
    return fig_dict

plt.rcParams.update(bundles.neurips2022())
fig_dict = figsizes.neurips2022()

plt.rcParams.update(change_figsize(fig_dict, fraction_width=0.4, fraction_height=1.0))
#bundle['figure.figsize'] = (4.0, 3.3)
## bundle['font.size'] = 14
#bundle['axes.labelsize'] = 12
## bundle['legend.fontsize'] = 8
#bundle['xtick.labelsize'] = 12
#bundle['ytick.labelsize'] = 12
#bundle['axes.titlesize'] = 18

width = 0.5
window = 10
colors = ['tab:blue', 'tab:orange', 'tab:green']
fig, ax = plt.subplots(1,1)
distances = ['005', '01', '015', '02', '025']
mpo_means = []
mpo_stds = []
for d in distances:
    # data = np.load(f'./stepdown_mpo_robust_{d}.npy')
    data = np.load(f'./stepdown_mpo_robust_no_correction_{d}.npy')
    print(data.shape)
    data_packets = [data[k*window: (k+1) * window] for k in range(0, data.shape[-1] // window)]
    data_packets = np.array(data_packets)
    mpo_means.append(np.mean(np.mean(data_packets, axis=0), axis=-1))
    # mpo_stds.append(np.std(data))
    print(data_packets.shape)
    mpo_stds.append(np.std(np.mean(data_packets, axis=0)))

x = np.arange(len(mpo_means))
ax.bar(x-width/3, height=mpo_means, width=width/3, yerr=mpo_stds, label='MPO', color='tab:blue')


mpo_means = []
mpo_stds = []
for d in distances:
    # data = np.load(f'./stepdown_depmpo_robust_{d}.npy')
    data = np.load(f'./stepdown_depmpo_robust_no_correction_{d}.npy')
    data_packets = [data[k*window: (k+1) * window] for k in range(0, data.shape[-1] // window)]
    data_packets = np.array(data_packets)
    mpo_means.append(np.mean(np.mean(data_packets, axis=0), axis=-1))
    # mpo_stds.append(np.std(data))
    mpo_stds.append(np.std(np.mean(data_packets, axis=0)))

x = np.arange(len(mpo_means))
ax.bar(x, height=mpo_means, width=width/3, yerr=mpo_stds, label='DEP-MPO', color='tab:orange')
mpo_means = []
mpo_stds = []
for d in distances:
    # data = np.load(f'./stepdown_td4_{d}.npy')
    data = np.load(f'./stepdown_td4_no_correction_{d}.npy')
    data_packets = [data[k*window: (k+1) * window] for k in range(0, data.shape[-1] // window)]
    data_packets = np.array(data_packets)
    mpo_means.append(np.mean(np.mean(data_packets, axis=0), axis=-1))
    mpo_stds.append(np.std(np.mean(data_packets, axis=0)))
    # mpo_stds.append(np.std(data))

x = np.arange(len(mpo_means))
ax.bar(x+width/3, height=mpo_means, width=width/3, yerr=mpo_stds, label='TD4', color='tab:green')
xticks = np.arange(len(mpo_means))
ax.set_xticks(xticks)
ax.set_xticklabels(['5', '10', '15', '20', '25'])
ax.set_ylim([0, 1.1])
ax.legend()
ax.set_xlabel('step height (cm)')
ax.set_ylabel('avg. success rate')
plt.tight_layout()
plt.savefig('robustness_ostrich_no_correction.pdf')
# plt.savefig('robustness_ostrich.pdf')
# plt.show()
