from matplotlib import pyplot as plt
import numpy as np
width = 0.35
window = 10
colors = ['tab:blue', 'tab:orange', 'tab:green']
fig, ax = plt.subplots(1,1)
distances = ['0','05', '10', '15', '20']
mpo_means = []
mpo_stds = []
for d in distances:
    data = np.load(f'./obstacle_100er/mpo_{d}cm.npy')
    data_packets = [data[k*window: (k+1) * window] for k in range(0, data.shape[-1] // window)]
    data_packets = np.array(data_packets)
    mpo_means.append(np.mean(data))
    mpo_stds.append(np.std(np.mean(data_packets, axis=0)))

x = np.arange(len(mpo_means))
ax.bar(x-width/3, height=mpo_means, width=width/3, yerr=mpo_stds, label='MPO', color='tab:blue')


mpo_means = []
mpo_stds = []
for d in distances:
    data = np.load(f'./obstacle_100er/dep_mpo_{d}cm_robust.npy')
    data_packets = [data[k*window: (k+1) * window] for k in range(0, data.shape[-1] // window)]
    data_packets = np.array(data_packets)
    mpo_means.append(np.mean(data))
    mpo_stds.append(np.std(np.mean(data_packets, axis=0)))

x = np.arange(len(mpo_means))
ax.bar(x, height=mpo_means, width=width/3, yerr=mpo_stds, label='DEP-MPO', color='tab:orange')
mpo_means = []
mpo_stds = []
for d in distances:
    data = np.load(f'./obstacle_100er/td4_{d}cm.npy')
    data_packets = [data[k*window: (k+1) * window] for k in range(0, data.shape[-1] // window)]
    data_packets = np.array(data_packets)
    mpo_means.append(np.mean(data))
    mpo_stds.append(np.std(np.mean(data_packets, axis=0)))

x = np.arange(len(mpo_means))
ax.bar(x+width/3, height=mpo_means, width=width/3, yerr=mpo_stds, label='TD4', color='tab:green')
xticks = np.arange(len(mpo_means))
ax.set_xticks(xticks)
ax.set_xticklabels(['0', '5', '10', '15', '20'])
ax.set_ylim([0, 1.1])
ax.legend()
ax.set_xlabel('step height (cm)')
ax.set_ylabel('avg. success rate')
plt.tight_layout()
plt.savefig('robustness_ostrich.pdf')
# plt.show()
