import numpy as np
from scipy.integrate import quad
from functools import partial
from matplotlib import pyplot as plt
from scipy.stats import norm, truncnorm
from tueplots import bundles, figsizes

plt.rcParams.update(bundles.neurips2022()) 
plt.rcParams.update(figsizes.neurips2022()) 
bundle = bundles.neurips2022()
bundle['figure.figsize'] = (6.5, 2.8)
# bundle['font.size'] = 14
bundle['axes.labelsize'] = 16
# bundle['legend.fontsize'] = 8   
bundle['xtick.labelsize'] = 14
bundle['ytick.labelsize'] = 14
bundle['axes.titlesize'] = 22
bundle['legend.fontsize'] = 14
plt.rcParams.update(bundle)



# def gauss(x, mu, sigma):
#     A = 1 / np.sqrt(2*np.pi*np.square(sigma))
#     gauss = np.exp(-0.5 * np.square(x - mu) / (2* np.square(sigma) + 0.001))
#     return A * gauss * x
# 
# def gauss_square(x, mu, sigma):
#     A = 1 / np.sqrt(2*np.pi*np.square(sigma))
#     gauss = np.exp(-0.5 * np.square(x - mu) / (2* np.square(sigma) + 0.001))
#     return A * gauss * x * x
# 
# results = []
# sigmas = np.linspace(0.001, 2, 100)
# for sigma in sigmas:
#     f = partial(gauss, mu=0, sigma=sigma)
#     f_square = partial(gauss_square, mu=0, sigma=sigma)
#     res, err = quad(f, -100, 100)
#     res_square, err = quad(f_square, -1, 1)
# 
#     results.append(res_square - np.square(res))


# a = -1
# b = 1
# eff_sigma = []
# fig, ax = plt.subplots(1,1)
# scales = np.linspace(0.001, 10, 100)
# for scale in scales:
#     rv = norm(loc=0, scale=scale)
#     f = lambda x: rv.pdf(x) * x
#     f_square = lambda x: rv.pdf(x) * x * x
#     res = np.sqrt(quad(f_square, a, b)[0]  + rv.pdf(1) + rv.pdf(-1))
#     eff_sigma.append(res)
# 
#     # x = np.linspace(-2,2, 1000)
# print(np.max(eff_sigma))
# ax.plot(scales, eff_sigma)
#     # ax.plot(x, truncrv.pdf(x))
# plt.show()


# a = -1
# b = 1
# eff_sigma = []
# fig, ax = plt.subplots(1,1)
# scales = np.linspace(1, 100, 100)
# for scale in scales:
#     rv = norm(loc=0, scale=scale)
#     vals = rv.rvs(size=10000)
#     vals = np.clip(vals, a, b)
#     # plt.hist(vals)
#     # plt.show()
#     eff_sigma.append(np.std(vals))
# print(np.max(eff_sigma))
# ax.plot(scales, eff_sigma)
#     #ax.plot(x, truncrv.pdf(x))
# plt.show()



scales = np.linspace(0.01, 3, 100)
sigmas = []
sigmas_clipped = []
for scale in scales:
    vals = np.random.normal(0, scale, size=(10000,))
    vals_clipped = np.clip(vals, -1, 1)
    sigmas.append(np.std(vals, axis=-1))
    sigmas_clipped.append(np.std(vals_clipped, axis=-1))
     

vals = np.random.normal(0, 1, size=(10000,))
vals_clipped = np.clip(vals, -1 ,1)
# vals = np.mean(vals, axis=0)
# vals_clipped = np.mean(vals_clipped, axis=0)
eff_std_vals = np.std(vals, axis=-1)
eff_std_vals_clipped = np.std(vals_clipped, axis=-1)
fig, ax = plt.subplots(1,2)
ax[0].hist(vals, label='Gaussian')
ax[0].hist(vals_clipped, alpha=0.8, label='clip-Gaussian')
ax[1].plot(scales, sigmas, label='Gaussian')
ax[1].plot(scales, sigmas_clipped, label='clipped Gaussian')
ax[1].set_xlabel(r'generating std $\sigma$')
ax[1].set_ylabel(r'effective std $\sigma$')
ax[0].set_xlabel('value')
ax[0].set_ylabel('frequency')
# ax[0].legend(bbox_to_anchor=(0, 1.1), loc='lower left', ncol=2, frameon=False)
labels = ['Gaussian', 'clip-Gaussian']
fig.legend(labels=labels, loc = (0.31, 0.9), ncol=2, frameon=False)

fig.tight_layout()
fig.subplots_adjust(top=0.9)
plt.savefig('clt.pdf')
plt.show()



