from matplotlib import pyplot as plt
import numpy as np
from tueplots import bundles, figsizes
# plt.style.use(['seaborn'])
plt.rcParams.update(bundles.icml2022())
plt.rcParams.update(figsizes.icml2022_half())
bundle = bundles.icml2022()
bundle['figure.figsize'] = (3.5, 2.8)
bundle['font.size'] = 14
bundle['axes.labelsize'] = 10
bundle['legend.fontsize'] = 8
bundle['xtick.labelsize'] = 8
bundle['ytick.labelsize'] = 8
bundle['axes.titlesize'] = 10
plt.rcParams.update(bundle)
plt.rcParams.update(figsizes.icml2022_half())

dep_arm26 = (3.29, 0.652)
# bang150_arm26 = (2.84, 0.463)
uniform_arm26 = (1.446, 0.221)
dep_arm750 = (19.94, 2.53)
# bang150_arm750 = (12.40, 2.295)
uniform_arm750 = (6.342, 2.295)
# arm26 = [uniform_arm26, bang150_arm26, dep_arm26]
arm26 = [uniform_arm26, dep_arm26]
# arm750 = [uniform_arm750, bang150_arm750, dep_arm750]
arm750 = [uniform_arm750, dep_arm750]
envs = [arm26, arm750]
colors = ['tab:blue', 'tab:red', 'tab:green']
# labels = ['uniform','bang-bang', 'DEP']
labels = ['noise', 'DEP']
# titles = [r'$\textsc{Arm2dof6m}$', r'$\textsc{Arm7dof50m}$']
titles = ['arm2dof6m', 'arm7dof50m']
file_names = ['arm2dof6m', 'arm7dof50m']

for env, title, file_name in zip(envs, titles, file_names):
    fig, ax = plt.subplots(1, 1)
    mean_val = [x[0] for x in env]
    std_val = [x[1] for x in env]
    bars = ax.bar(np.arange(len(env)), mean_val, yerr=std_val)
    ax.set_xticks(np.arange(len(env)), labels)
    for bar, color in zip(bars, colors):
        bar.set_color(color)
    ax.set_title(title)
    ax.set_ylabel('entropy') 
    # if file_name == 'arm2dof6m':
    #     fig.text(0.02, 0.9, 'B', fontsize=20)
    fig.savefig(f'entropy_plot_{file_name}.pdf')
