import numpy as np
from scipy.stats import ttest_ind

# arm 26 ------------------
depmpo = np.load('./run_means_depmpo_arm26.npy')
herdepmpo = np.load('./run_means_herdepmpo_arm26.npy')
hermpo = np.load('./run_means_hermpo_arm26.npy')

print('arm26')
print(f'{np.mean(depmpo)} +- {np.std(depmpo)}')
print(f'{np.mean(hermpo)} +- {np.std(hermpo)}')
print(ttest_ind(depmpo, hermpo))

# ostrich foraging ------------------
dephermpo = np.load('./run_means_herdepmpo_ostrichforaging.npy')
hermpo = np.load('./run_means_hermpo_ostrichforaging.npy')

print('ostrich-foraging')
print(f'{np.mean(dephermpo)} +- {np.std(dephermpo)}')
print(f'{np.mean(hermpo)} +- {np.std(hermpo)}')
print(ttest_ind(dephermpo, hermpo))

# arm750 ------------------
dephermpo = np.load('./run_means_herdepmpo_arm750.npy')
hermpo = np.load('./run_means_hermpo_arm750.npy')

print('arm750')
print(f'{np.mean(dephermpo)} +- {np.std(dephermpo)}')
print(f'{np.mean(hermpo)} +- {np.std(hermpo)}')
print(ttest_ind(dephermpo, hermpo))

## human-run------------------
depmpo = np.load('./run_means_depmpo_hyfydy.npy')
mpo = np.load('./run_means_mpo_hyfydy.npy')
#
print('human-run')
print(f'{np.mean(depmpo)} +- {np.std(depmpo)}')
print(f'{np.mean(mpo)} +- {np.std(mpo)}')
print(ttest_ind(depmpo, mpo))
#
## ostrich-run------------------
depmpo = np.load('./run_means_depmpo_ostrich.npy')
mpo = np.load('./run_means_mpo_ostrich.npy')
#
print('ostrich-run')
print(f'{np.mean(depmpo)} +- {np.std(depmpo)}')
print(f'{np.mean(mpo)} +- {np.std(mpo)}')
print(ttest_ind(depmpo, mpo))
