import gym
import matplotlib
import matplotlib.animation as animation
import numpy as np
import PIL.Image
import torch
import warmup
from IPython.display import HTML
from matplotlib import pyplot as plt
from pudb import set_trace

# Graphics-related


def display_video(frames, framerate=60):
    height, width, _ = frames[0].shape
    dpi = 10000
    orig_backend = matplotlib.get_backend()
    matplotlib.use("Agg")  # Switch to headless 'Agg' to inhibit figure rendering.
    fig, ax = plt.subplots(1, 1, figsize=(width / dpi, height / dpi), dpi=dpi)
    matplotlib.use(orig_backend)  # Switch back to the original backend.
    ax.set_axis_off()
    ax.set_aspect("equal")
    ax.set_position([0, 0, 1, 1])
    im = ax.imshow(frames[0])

    def update(frame):
        im.set_data(frame)
        return [im]

    interval = 1000 / framerate
    anim = animation.FuncAnimation(
        fig=fig, func=update, frames=frames, interval=interval, blit=True, repeat=False
    )
    writervideo = animation.FFMpegWriter(fps=framerate)
    anim.save("uniform_noise_arm750.mp4", writer=writervideo)


frames = []
for env_str in ["arm750-v0"]:
    env = gym.make(env_str)
    # env.set_target(env.interesting_targets['above_shoulder'])
    # env.set_target(env.interesting_targets['chest_height'])
    for ep in range(100000):
        ep_steps = 0
        state = env.reset()
        while True:
            action = env.action_space.sample()
            action = np.random.randint(-1, 2, size=action.shape)
            next_state, reward, done, info = env.step(action)
            frame = env.render(mode="human")
            frames.append(frame)
            if ep_steps >= 100:
                break

                # if done or (ep_steps >= env.max_episode_steps):
                break
            ep_steps += 1


display_video(frames)
print("Video done")
