import numpy as np
from gym import spaces
from gym import utils
from gym.envs.mujoco import mujoco_env

from .muscle_arm import MuscleArm


class Arm26(MuscleArm):
    def __init__(self, identifier=None):
        self.model_type = "arm26"
        self.nq = 2
        super(Arm26, self).__init__(identifier)
        self.set_gravity([9.81, 0, 0])
        self.has_init = True

    def reset_model(self):
        self.apply_muscle_settings()
        self.randomise_init_state()
        if self.random_goals:
            # self.target = np.random.uniform([-0.4, 0.4, 0.], [1.2, 0.7, 0.])
            # self.target = self.sample_circular_goal()
            self.target = self.sample_rectangular_goal()
        self.sim.data.qpos[-2:] = self.target[:2]
        return self._get_obs()

    def sample_rectangular_goal(self):
        return np.random.uniform([-0.2, 0.5, 0.0], [0.15, 0.65, 0.0])

    def sample_circular_goal(self):
        rho = np.random.uniform(-1.0, 0)
        phi = np.random.uniform(0.5 * np.pi, np.pi)
        # no typo here, MuJoCo coordinates are rotated wrt the distribution
        y = rho * np.cos(phi)
        x = rho * np.sin(phi)
        return np.array([x, y, 0.0])

    def viewer_setup(self):
        self.viewer.cam.trackbodyid = 2
        self.viewer.cam.distance = self.model.stat.extent * 0.4
        self.viewer.cam.lookat[:] = [0.15, -0.0, 1.35]
        self.viewer.cam.elevation = -90
        self.viewer.cam.azimuth = 180
