def set_parameters(model, parameters, muscle_idxs, joint_idxs):

    # First parameters are muscle scales, then tendon stiffness and damping, and finally joint softness
    nmuscles = len(muscle_idxs)
    njoints = len(joint_idxs)

    # Set muscle scales, and tendon stiffness and damping
    for muscle_idx in muscle_idxs:
        model.actuator_gainprm[muscle_idx][3] = parameters[muscle_idx]
        model.tendon_stiffness[muscle_idx] = parameters[nmuscles + muscle_idx]
        model.tendon_damping[muscle_idx] = parameters[2 * nmuscles + muscle_idx]

    # Set joint stiffness and damping
    for idx, joint_idx in enumerate(joint_idxs):
        model.jnt_stiffness[joint_idx] = parameters[3 * nmuscles + idx]
        model.dof_damping[joint_idx] = parameters[3 * nmuscles + 0 * njoints + idx]
        # model.jnt_solimp[joint_idx, 2] = parameters[3 * nmuscles + 1 * njoints + idx]
