ARM26 = """
<mujoco model="2-link 6-muscle arm">
    <!--  Copyright © 2018, Roboti LLC

          This file is licensed under the MuJoCo Resource License (the "License").
          You may not use this file except in compliance with the License.
          You may obtain a copy of the License at

            https://www.roboti.us/resourcelicense.txt
    -->

    <option timestep={timestep} iterations="50" solver="Newton" tolerance="1e-10"/>

    <size njmax="50" nconmax="10" nstack="200" nuserdata="12" nuser_actuator="6"/>

    <visual>
        <rgba haze=".3 .3 .3 1"/>
      <quality shadowsize="10000" offsamples="32" numslices="64" numquads="32"/>
</visual>


    <default>
        <joint type="hinge" pos="0 0 0" axis="0 0 1" limited="true" range="0 120" damping="0.1"/>
        {actuator_default}
    </default>

    <asset>
        <texture type="skybox" builtin="gradient" rgb1="0.6 0.6 0.6" rgb2="0 0 0" width="512" height="512"/>

        <texture name="texplane" type="2d" builtin="checker" rgb1=".25 .25 .25" rgb2=".3 .3 .3" width="512" height="512" mark="cross" markrgb=".8 .8 .8"/>

        <material name="matplane" reflectance="0.3" texture="texplane" texrepeat="1 1" texuniform="true"/>
    </asset>

    <worldbody>
        <geom name="floor" pos="0 0 -0.5" size="0 0 1" type="plane" material="matplane"/>
        <!--<site name="target" size="0.02" pos="0.35 0.85 0"/>-->

        <light directional="true" diffuse=".8 .8 .8" specular=".2 .2 .2" pos="0 0 5" dir="0 0 -1"/>

        <site name="s0" pos="-0.15 0 0" size="0.02"/>
        <site name="x0" pos="0 -0.15 0" size="0.02" rgba="0 .7 0 1" group="1"/>

        <body pos="0 0 0">
                    <camera name="track" mode="trackcom" pos="0 -3 .5" xyaxes="1 0 0 0 0 1"/>
            <geom name="upper arm" type="capsule" size="0.045" fromto="0 0 0  0.5 0 0" rgba=".5 .1 .1 1"/>
            <joint name="shoulder"/>
            <geom name="shoulder" type="cylinder" pos="0 0 0" size=".1 .05" rgba=".5 .1 .8 .5" mass="0" group="1"/>

            <site name="s1" pos="0.15 0.06 0" size="0.02"/>
            <site name="s2" pos="0.15 -0.06 0" size="0.02"/>
            <site name="s3" pos="0.4 0.06 0" size="0.02"/>
            <site name="s4" pos="0.4 -0.06 0" size="0.02"/>
            <site name="s5" pos="0.25 0.1 0" size="0.02"/>
            <site name="s6" pos="0.25 -0.1 0" size="0.02"/>
            <site name="x1" pos="0.5 -0.15 0" size="0.02" rgba="0 .7 0 1" group="1"/>

            <body pos="0.5 0 0">
                <geom name="forearm" type="capsule" size="0.035" fromto="0 0 0  0.5 0 0" rgba=".5 .1 .1 1"/>
            <site name="endeffector" size="0.02" pos="0.5 0 0"/>
                <joint name="elbow"/>
                <geom name="elbow" type="cylinder" pos="0 0 0" size=".08 .05" rgba=".5 .1 .8 .5" mass="0" group="1"/>

                <site name="s7" pos="0.11 0.05 0" size="0.02"/>
                <site name="s8" pos="0.11 -0.05 0" size="0.02"/>
            </body>
        </body>
    <body name="target" pos="0 0 0">
            <joint armature="0" axis="1 0 0" damping="100000" frictionloss="100000" limited="true" name="target_x" pos="0
            0 0" range="-1 1" ref="0" stiffness="0" type="slide"/>
            <joint armature="0" axis="0 1 0" damping="100000" frictionloss="100000" limited="true" name="target_y" pos="0
            0 0" range="-1 1" ref="0" stiffness="0" type="slide"/>
            <geom conaffinity="0" contype="0" name="target" pos="0 0 0" rgba="0.9 0.2 0.2 1" size=".02" type="sphere"/>
    </body>
    </worldbody>
    {tendons}
    <actuator>
    {actuator}
    </actuator>
</mujoco>
"""


ARM26_MOTOR_ACTUATOR = """
        <motor gear="30" name="shouldermotor" joint="shoulder"/>
        <motor gear="30" name="elbowmotor" joint="elbow"/>
"""


ARM26_MUSCLE_ACTUATOR = """
        <general name="SF" tendon="SF"  lengthrange="0.10248 0.340378"/>
        <general name="SE" tendon="SE" lengthrange="0.340334 0.54"/>
        <general name="EF" tendon="EF" lengthrange="0.0102 0.2164"/>
        <general name="EE" tendon="EE" lengthrange="0.216 0.384"/>
        <general name="BF" tendon="BF" lengthrange="0.33 0.8"/>
        <general name="BE" tendon="BE" lengthrange="0.8 1.17"/>
"""

ARM26_MUSCLE_ACTUATOR_MONO = """
        <general name="SF" tendon="SF"  lengthrange="0.10248 0.340378"/>
        <general name="SE" tendon="SE" lengthrange="0.340334 0.54"/>
        <general name="EF" tendon="EF" lengthrange="0.0102 0.2164"/>
        <general name="EE" tendon="EE" lengthrange="0.216 0.384"/>
"""

ARM26_MUSCLE_TENDON = """
    <tendon>
        <spatial name="SF" width="0.01">
            <site site="s0"/>
            <geom geom="shoulder"/>
            <site site="s1"/>
        </spatial>

        <spatial name="SE" width="0.01">
            <site site="s0"/>
            <geom geom="shoulder" sidesite="x0"/>
            <site site="s2"/>
        </spatial>

        <spatial name="EF" width="0.01">
            <site site="s3"/>
            <geom geom="elbow"/>
            <site site="s7"/>
        </spatial>

        <spatial name="EE" width="0.01">
            <site site="s4"/>
            <geom geom="elbow" sidesite="x1"/>
            <site site="s8"/>
        </spatial>

        <spatial name="BF" width="0.009" rgba=".4 .6 .4 1">
            <site site="s0"/>
            <geom geom="shoulder"/>
            <site site="s5"/>
            <geom geom="elbow"/>
            <site site="s7"/>
        </spatial>

        <spatial name="BE" width="0.009" rgba=".4 .6 .4 1">
            <site site="s0"/>
            <geom geom="shoulder" sidesite="x0"/>
            <site site="s6"/>
            <geom geom="elbow" sidesite="x1"/>
            <site site="s8"/>
        </spatial>
    </tendon>
"""

ARM26_MUSCLE_TENDON_MONO = """
    <tendon>
        <spatial name="SF" width="0.01">
            <site site="s0"/>
            <geom geom="shoulder"/>
            <site site="s1"/>
        </spatial>

        <spatial name="SE" width="0.01">
            <site site="s0"/>
            <geom geom="shoulder" sidesite="x0"/>
            <site site="s2"/>
        </spatial>

        <spatial name="EF" width="0.01">
            <site site="s3"/>
            <geom geom="elbow"/>
            <site site="s7"/>
        </spatial>

        <spatial name="EE" width="0.01">
            <site site="s4"/>
            <geom geom="elbow" sidesite="x1"/>
            <site site="s8"/>
        </spatial>
    </tendon>
"""

ARM26_MUSCLE_DEFAULT = """
    <general dyntype={dyntype} gaintype={gaintype} biastype={biastype} dynprm="{dynprm_act} {dynprm_deact}" gainprm="0.75 1.05 -1 200 0.5 1.6 1.5 1.3 1.2" biasprm="0.75 1.05 -1 200 0.5 1.6 1.5 1.3 1.2" ctrlrange="0 1" ctrllimited="true"/>
"""


ARM26_MOTOR_DEFAULT = """
        <motor ctrllimited="true" ctrlrange="-1 1"/>
"""

ARM26_MOTOR_ACTUATOR_DOUBLE = """
        <motor gear="30" name="shouldermotor" joint="shoulder" ctrlrange="-1 0"/>
        <motor gear="30" name="shouldermotor2" joint="shoulder" ctrlrange="0 1"/>
        <motor gear="30" name="elbowmotor" joint="elbow" ctrlrange="-1 0"/>
        <motor gear="30" name="elbowmotor2" joint="elbow" ctrlrange="0 1"/>
"""
