ARM750 = """
<?xml version="1.0" encoding="utf-8"?>
<mujoco model="MoBL_ARMS_Upper_Limb_Model_OpenSim">
  <compiler inertiafromgeom="auto" angle="radian" balanceinertia="true" boundmass="0.001" boundinertia="0.001"></compiler>

  <default>
    <joint limited="true" damping="0.5" armature="0.01" stiffness="0"></joint>
    <geom contype="1" conaffinity="1" condim="3" rgba="0.8 0.6 .4 1" margin="0.001" solref=".02 1" solimp=".8 .8 .01" material="geom"></geom>
    <site size="0.001" ></site>
    <tendon width="0.001" rgba=".95 .3 .3 1" limited="false"></tendon>
    {actuator_default}
  </default>
  <option timestep={timestep} integrator="Euler" collision="predefined">
    <flag energy="enable"></flag>
  </option>
  <size nconmax="400" nuser_jnt="1" nuserdata="53" nuser_actuator="50"></size>
  <visual>
    <map fogstart="3" fogend="5" force="0.1"></map>
    <!--<quality shadowsize="2048"></quality>-->
    <quality shadowsize="20000" offsamples="32" numslices="64" numquads="32"/>
  </visual>
  <worldbody>
    <geom name="floor" pos="0 0 0" size="10 10 0.125" type="plane" material="MatPlane" condim="3"></geom>
    <body name="thorax" pos="       0 6.12323e-17        1" quat="0.7071067811865475 0.7071067811865475 0.0 0.0">
      <light mode="trackcom" directional="false" diffuse=".8 .8 .8" specular="0.3 0.3 0.3" pos="0 0 4.0" dir="0 0 -1"></light>
      <geom name="thorax" type="mesh" mesh="thorax"></geom>
      <site name="PECM1-P3" pos="  -7e-05  0.00821  0.10454"></site>
      <site name="PECM2-P4" pos="0.03091 -0.03922 0.09705"></site>
      <site name="PECM2-P5" pos="0.02769 -0.04498 0.02271"></site>
      <site name="PECM2-P3" pos=" 0.02083 -0.02005  0.11555"></site>
      <site name="PECM3-P4" pos="0.0525 -0.08417 0.08935"></site>
      <site name="PECM3-P5" pos="0.05724 -0.11654 0.03787"></site>
      <site name="PECM3-P3" pos=" 0.02984 -0.0544459   0.1151"></site>
      <site name="LAT1-P4" pos="-0.11828 -0.10118 0.03316"></site>
      <site name="LAT1-P5" pos="-0.09578 -0.11724 0.00882"></site>
      <site name="LAT2-P4" pos="-0.10992 -0.16908 0.02878"></site>
      <site name="LAT2-P5" pos="-0.07186 -0.18818 0.00815"></site>
      <site name="LAT3-P4" pos="-0.11157 -0.19387 0.05532"></site>
      <site name="LAT3-P5" pos="-0.07117 -0.24858 0.00907"></site>
      <joint name="r_z" type="hinge" pos="0 0 0" axis="       0        0        1" limited="true" range="-6.28319  6.28319" ref="0" armature="0" damping="0" stiffness="0"></joint>
      <body name="clavicle" pos="0.006325  0.00693 0.025465" quat="1.0 0.0 0.0 0.0">
scorers
        <geom name="clavicle" type="mesh" mesh="clavicle"></geom>
        <inertial pos="-0.011096 0.0063723 0.054168" mass="0.156" fullinertia="0.00024259 0.00025526 4.442e-05 -1.898e-05 -6.994e-05 5.371e-05"></inertial>
        <site name="DELT1-P4" pos="-0.014 0.01106 0.08021"></site>
        <site name="DELT2-P2" pos="0.0191703 0.0244002 0.162891"></site>
        <site name="PECM1-P4" pos="0.00321 -0.00013 0.05113"></site>
        <joint name="sternoclavicular_r2" type="hinge" pos="0 0 0" axis="  0.0153 0.989299  -0.1451" limited="false" range="-99999.9  99999.9" ref="0"></joint>
        <joint name="sternoclavicular_r3" type="hinge" pos="0 0 0" axis="-0.994473        0 -0.104997" limited="false" range="-99999.9  99999.9" ref="0"></joint>
        <body name="clavphant" pos="-0.01433  0.02007 0.135535" quat="1.0 0.0 0.0 0.0">
          <inertial pos="       0        0        0" mass="0.0001" fullinertia="       1        1        1        0        0        0"></inertial>
          <joint name="unrotscap_r3" type="hinge" pos="0 0 0" axis="-0.994473        0 -0.104997" limited="false" range="-99999.9  99999.9" ref="0"></joint>
          <joint name="unrotscap_r2" type="hinge" pos="0 0 0" axis="  0.0153 0.989299  -0.1451" limited="false" range="-99999.9  99999.9" ref="0"></joint>
          <body name="scapula" pos="       0        0        0" quat="1.0 0.0 0.0 0.0">
            <geom name="scapula" type="mesh" mesh="scapula"></geom>
            <inertial pos="-0.054694 -0.035032 -0.043734" mass="0.70396" fullinertia="0.0012429 0.0011504 0.0013651 0.0004494 0.00040922 0.0002411"></inertial>
            <site name="DELT1-P3" pos="0.04347 -0.03252 0.00099"></site>
            <site name="DELT2-P3" pos="5e-005 0.00294 0.02233"></site>
            <site name="DELT2-P4" pos="-0.01078 -0.00034 0.0062"></site>
            <site name="DELT3-P1" pos="-0.05573 0.00122 -0.02512"></site>
            <site name="DELT3-P2" pos="-0.07247 -0.03285 0.01233"></site>
            <site name="SUPSP-P2" pos="-0.01918 0.00127 -0.01271"></site>
            <site name="SUPSP-P3" pos="-0.044 -0.01512 -0.05855"></site>
            <site name="INFSP-P2" pos="-0.07382 -0.05476 -0.04781"></site>
            <site name="SUBSC-P2" pos="-0.01831 -0.05223 -0.02457"></site>
            <site name="SUBSC-P3" pos="-0.07246 -0.03943 -0.06475"></site>
            <site name="TMIN-P2" pos="-0.09473 -0.07991 -0.04737"></site>
            <site name="TMIN-P3" pos="-0.09643 -0.08121 -0.05298"></site>
            <site name="TMAJ-P2" pos="-0.10264 -0.10319 -0.05829"></site>
            <site name="TMAJ-P3" pos="-0.10489 -0.10895 -0.07117"></site>
            <site name="LAT1-P2" pos="-0.08052 -0.06821 -0.02908"></site>
            <site name="LAT1-P3" pos="-0.10925 -0.07239 -0.07422"></site>
            <site name="LAT2-P2" pos="-0.08345 -0.08695 -0.02453"></site>
            <site name="LAT2-P3" pos="-0.11524 -0.10749 -0.08863"></site>
            <site name="LAT3-P2" pos="-0.08438 -0.11598 -0.02995"></site>
            <site name="LAT3-P3" pos="-0.11279 -0.13833 -0.08911"></site>
            <site name="CORB-P1" pos="0.0125 -0.04127 -0.02652"></site>
            <site name="CORB-P2" pos="0.00483 -0.06958 -0.01563"></site>
            <site name="TRIlong-P1" pos="-0.04565 -0.04073 -0.01377"></site>
            <site name="BIClong-P1" pos="-0.03123 -0.02353 -0.01305"></site>
            <site name="BIClong-P2" pos="-0.02094 -0.01309 -0.00461"></site>
            <site name="BICshort-P1" pos="0.01268 -0.03931 -0.02625"></site>
            <site name="BICshort-P2" pos="0.00093 -0.06704 -0.01593"></site>
            <joint name="acromioclavicular_r2" type="hinge" pos="0 0 0" axis="0.157095 0.947269 -0.279291" limited="false" range="-99999.9  99999.9" ref="0"></joint>
            <joint name="acromioclavicular_r3" type="hinge" pos="0 0 0" axis="-0.754084 0.297594 0.585487" limited="false" range="-99999.9  99999.9" ref="0"></joint>
            <joint name="acromioclavicular_r1" type="hinge" pos="0 0 0" axis="  0.6377   0.1186   0.7611" limited="false" range="-99999.9  99999.9" ref="0"></joint>
            <body name="scapphant" pos="-0.00955   -0.034    0.009" quat="1.0 0.0 0.0 0.0">
              <inertial pos="       0        0        0" mass="0.0001" fullinertia="       1        1        1        0        0        0"></inertial>
              <joint name="unrothum_r1" type="hinge" pos="0 0 0" axis="  0.6377   0.1186   0.7611" limited="false" range="-99999.9  99999.9" ref="0"></joint>
              <joint name="unrothum_r3" type="hinge" pos="0 0 0" axis="-0.754084 0.297594 0.585487" limited="false" range="-99999.9  99999.9" ref="0"></joint>
              <joint name="unrothum_r2" type="hinge" pos="0 0 0" axis="0.157095 0.947269 -0.279291" limited="false" range="-99999.9  99999.9" ref="0"></joint>
              <body name="humphant" pos="       0        0        0" quat="1.0 0.0 0.0 0.0">
                <inertial pos="       0        0        0" mass="0.0001" fullinertia="       1        1        1        0        0        0"></inertial>
                <joint name="elv_angle" type="hinge" pos="0 0 0" axis="  0.0048 0.999089   0.0424" limited="true" range=" -1.5708  2.26893" ref="0" damping="3.045599544730105e-05" solimplimit="  0.0001     0.99 0.523599      0.5        1" user="1"></joint>
                <body name="humphant1" pos="       0        0        0" quat="1.0 0.0 0.0 0.0">
                  <inertial pos="       0        0        0" mass="0.0001" fullinertia="       1        1        1        0        0        0"></inertial>
                  <joint name="shoulder_elv" type="hinge" pos="0 0 0" axis="-0.998261   0.0023 0.058898" limited="true" range="       0  3.14159" ref="0" damping="3.045599544730105e-05" solimplimit="  0.0001     0.99 0.523599      0.5        1" user="1"></joint>
                  <joint name="shoulder1_r2" type="hinge" pos="0 0 0" axis="  0.0048 0.999089   0.0424" limited="false" range="-99999.9  99999.9" ref="0"></joint>
                  <body name="humerus" pos="       0        0        0" quat="1.0 0.0 0.0 0.0">
                    <geom name="humerus" type="mesh" mesh="humerus"></geom>
                    <inertial pos="0.018064 -0.140141 -0.012746" mass="1.99757" fullinertia="0.0122776 0.00255133 0.0125789 -0.00034741 -0.0002325 0.0012293"></inertial>
                    <site name="DELT1-P1" pos="0.00896 -0.11883 0.00585"></site>
                    <site name="DELT1-P2" pos="0.01623 -0.11033 0.00412"></site>
                    <site name="DELT2-P1" pos="0.00461 -0.13611 0.0056"></site>
                    <site name="DELT3-P3" pos="0.00206 -0.07602 0.01045"></site>
                    <site name="SUPSP-P1" pos="0.00256 0.01063 0.02593"></site>
                    <site name="INFSP-P1" pos="-0.00887 0.00484 0.02448"></site>
                    <site name="SUBSC-P1" pos="0.01403 0.0084 -0.01331"></site>
                    <site name="TMIN-P1" pos="-0.0011 -0.01264 0.02156"></site>
                    <site name="TMAJ-P1" pos="0.00998 -0.05419 -0.00568"></site>
                    <site name="PECM1-P1" pos="0.01169 -0.04191 0.0078"></site>
                    <site name="PECM1-P2" pos="  0.0191  -0.0301  0.00143"></site>
                    <site name="PECM2-P1" pos="0.01274 -0.04289 0.00785"></site>
                    <site name="PECM2-P2" pos=" 0.01748 -0.03533  0.00033"></site>
                    <site name="PECM3-P1" pos="0.01269 -0.04375 0.0075"></site>
                    <site name="PECM3-P2" pos="0.0159185 -0.045833 -0.00378312"></site>
                    <site name="LAT1-P1" pos="0.0105 -0.03415 -0.00653"></site>
                    <site name="LAT2-P1" pos="0.00968 -0.04071 -0.00611"></site>
                    <site name="LAT3-P1" pos="0.01208 -0.03922 -0.00416"></site>
                    <site name="CORB-P3" pos="0.00743 -0.15048 -0.00782"></site>
                    <site name="TRIlong-P2" pos="-0.02714 -0.11441 -0.00664"></site>
                    <site name="TRIlong-P3" pos="-0.03184 -0.22637 -0.01217"></site>
                    <site name="TRIlong-P4" pos="-0.01743 -0.26757 -0.01208"></site>
                    <site name="TRIlat-P1" pos="-0.00599 -0.12646 0.00428"></site>
                    <site name="TRIlat-P2" pos="-0.02344 -0.14528 0.00928"></site>
                    <site name="TRIlat-P3" pos="-0.03184 -0.22637 -0.01217"></site>
                    <site name="TRIlat-P4" pos="-0.01743 -0.26757 -0.01208"></site>
                    <site name="TRImed-P1" pos="-0.00838 -0.13695 -0.00906"></site>
                    <site name="TRImed-P2" pos="-0.02601 -0.15139 -0.0108"></site>
                    <site name="TRImed-P3" pos="-0.03184 -0.22637 -0.01217"></site>
                    <site name="TRImed-P4" pos="-0.01743 -0.26757 -0.01208"></site>
                    <site name="ANC-P1" pos="-0.00744 -0.28359 0.00979"></site>
                    <site name="BIClong-P3" pos="0.02131 0.01793 0.01028"></site>
                    <site name="BIClong-P4" pos="0.02378 -0.00511 0.01201"></site>
                    <site name="BIClong-P5" pos="0.01345 -0.02827 0.00136"></site>
                    <site name="BIClong-P6" pos="0.01068 -0.07736 -0.00165"></site>
                    <site name="BIClong-P7" pos="0.01703 -0.12125 0.00024"></site>
                    <site name="BIClong-P8" pos="0.0228 -0.1754 -0.0063"></site>
                    <site name="BICshort-P3" pos="0.01117 -0.07576 -0.01101"></site>
                    <site name="BICshort-P4" pos="0.01703 -0.12125 -0.01079"></site>
                    <site name="BICshort-P5" pos="0.0228 -0.1754 -0.0063"></site>
                    <site name="BRA-P1" pos="0.0068 -0.1739 -0.0036"></site>
                    <site name="BRD-P1" pos="-0.0098 -0.19963 0.00223"></site>
                    <site name="ECRL-P1" pos="-0.0073 -0.2609 0.0091"></site>
                    <site name="ECRB-P1" pos="0.01349 -0.29048 0.01698"></site>
                    <site name="ECU-P1" pos="0.00083 -0.28955 0.0188"></site>
                    <site name="FCR-P1" pos="0.00758 -0.27806 -0.03705"></site>
                    <site name="FCU-P1" pos="0.00219 -0.2774 -0.0388"></site>
                    <site name="PL-P1" pos="0.00457 -0.27519 -0.03865"></site>
                    <site name="PT-P1" pos="0.0036 -0.2759 -0.0365"></site>
                    <site name="FDSL-P1" pos="0.00421 -0.27598 -0.03864"></site>
                    <site name="FDSR-P1" pos="0.00479 -0.2788 -0.03731"></site>
                    <site name="EDCL-P1" pos="-0.0004 -0.28831 0.0187"></site>
                    <site name="EDCR-P1" pos="-0.00156 -0.28936 0.01782"></site>
                    <site name="EDCM-P1" pos="0.00051 -0.28984 0.01949"></site>
                    <site name="EDCI-P1" pos="0.00065 -0.28898 0.01869"></site>
                    <site name="EDM-P1" pos="0.00089 -0.28919 0.01847"></site>
                    <joint name="shoulder_rot" type="hinge" pos="0 0 0" axis="  0.0048 0.999089   0.0424" limited="true" range=" -1.5708 0.349066" ref="0" damping="3.045599544730105e-05" solimplimit="  0.0001     0.99 0.523599      0.5        1" user="1"></joint>
                    <body name="ulna" pos="  0.0061  -0.2904  -0.0123" quat="1.0 0.0 0.0 0.0">
                      <geom name="ulna" type="mesh" mesh="ulna"></geom>
                      <inertial pos="0.00971783 -0.0959509 0.024286" mass="1.1053" fullinertia="0.00541309 0.00115318 0.00494361 0.00031686 -7.615e-05 0.00109169"></inertial>
                      <site name="TRIlong-P5" pos="-0.0219 0.01046 -0.00078"></site>
                      <site name="TRIlat-P5" pos="-0.0219 0.01046 -0.00078"></site>
                      <site name="TRImed-P5" pos="-0.0219 0.01046 -0.00078"></site>
                      <site name="ANC-P2" pos="-0.02532 -0.00124 0.006"></site>
                      <site name="SUP-P3" pos="-0.0136 -0.03384 0.02013"></site>
                      <site name="BRA-P4" pos="-0.0032 -0.0239 0.0009"></site>
                      <site name="ECU-P2" pos="-0.01391 -0.03201 0.02947"></site>
                      <site name="ECU-P3" pos="-0.01705 -0.05428 0.02868"></site>
                      <site name="ECU-P4" pos="-0.01793 -0.09573 0.03278"></site>
                      <site name="PT-P2" pos="0.00846 -0.03373 -0.01432"></site>
                      <site name="PT-P3" pos=" 0.01219 -0.06516 -0.00219"></site>
                      <site name="PQ-P2" pos="0.00193 -0.20972 0.03632"></site>
                      <site name="FDSM-P1" pos="-0.00669 -0.02713 -0.00191"></site>
                      <site name="FDSI-P1" pos="-0.00676 -0.02819 -0.00137"></site>
                      <site name="FDPL-P1" pos="-0.00628 -0.03214 0.00254"></site>
                      <site name="FDPR-P1" pos="-0.00502 -0.03374 0.00273"></site>
                      <site name="FDPM-P1" pos="-0.00522 -0.03327 0.0021"></site>
                      <site name="FDPI-P1" pos="-0.00647 -0.03176 0.0028"></site>
                      <site name="EDM-P2" pos="-0.00977 -0.03907 0.03085"></site>
                      <site name="EDM-P3" pos="-0.00755 -0.08267 0.03646"></site>
                      <site name="EIP-P1" pos="-0.00394 -0.16652 0.03682"></site>
                      <site name="EIP-P2" pos="0.00171 -0.17469 0.04049"></site>
                      <site name="EPL-P1" pos="-0.01412 -0.09706 0.02952"></site>
                      <joint name="elbow_flexion" type="hinge" pos="0 0 0" axis="  0.0494   0.0366 0.998108" limited="true" range="       0.3  2.2" ref="0" damping="3.045599544730105e-05" solimplimit="  0.0001     0.99 0.514872      0.5        1" user="1"></joint>
                      <body name="radius" pos="  0.0004 -0.011503 0.019999" quat="1.0 0.0 0.0 0.0">
                        <geom name="radius" type="mesh" mesh="radius"></geom>
                        <inertial pos="0.0336341 -0.181559   0.0156" mass="0.23359" fullinertia="0.00043855 8.859e-05 0.00040258 3.014e-05 -4.24e-06 6.418e-05"></inertial>
                        <site name="SUP-P1" pos="0.00996 -0.06096 0.00075"></site>
                        <site name="SUP-P2" pos="0.01201 -0.0517 -0.00107"></site>
                        <site name="BIClong-P11" pos="-0.002 -0.0375 -0.002"></site>
                        <site name="BIClong-P9" pos=" 0.00273 -0.0343493 -0.0119845"></site>
                        <site name="BICshort-P8" pos="-0.002 -0.0375 -0.002"></site>
                        <site name="BICshort-P6" pos=" 0.00273 -0.0343493 -0.0119845"></site>
                        <site name="BRD-P2" pos="0.03577 -0.12742 0.02315"></site>
                        <site name="BRD-P3" pos="0.0419 -0.221 0.0224"></site>
                        <site name="ECRL-P2" pos="0.03195 -0.13463 0.02779"></site>
                        <site name="ECRL-P3" pos="0.04243 -0.23684 0.0362"></site>
                        <site name="ECRB-P2" pos="0.02905 -0.13086 0.02385"></site>
                        <site name="ECRB-P3" pos="0.03549 -0.22805 0.03937"></site>
                        <site name="ECU-P5" pos="-0.01421 -0.22696 0.03481"></site>
                        <site name="FCR-P2" pos="0.0211 -0.21943 0.00127"></site>
                        <site name="FCU-P3" pos="0.01082 -0.22327 0.00969"></site>
                        <site name="FCU-P2" pos="0.0101156 -0.183524 0.00202653"></site>
                        <site name="PL-P2" pos="0.02531 -0.23915 -0.00276"></site>
                        <site name="PT-P5" pos="0.0254 -0.1088 0.0198"></site>
                        <site name="PQ-P1" pos="0.03245 -0.19998 0.01962"></site>
                        <site name="FDSL-P2" pos="0.01377 -0.18718 0.00205"></site>
                        <site name="FDSR-P2" pos="0.01571 -0.18666 0.00267"></site>
                        <site name="FDSM-P2" pos="0.01899 -0.18706 0.00424"></site>
                        <site name="FDSI-P2" pos="0.02145 -0.18623 0.00552"></site>
                        <site name="FDPL-P2" pos="0.01409 -0.18516 0.00861"></site>
                        <site name="FDPR-P2" pos="0.0158 -0.18629 0.00803"></site>
                        <site name="FDPM-P2" pos="0.01906 -0.18644 0.00785"></site>
                        <site name="FDPI-P2" pos="0.0208 -0.1856 0.00915"></site>
                        <site name="EDCL-P3" pos="0.00993 -0.22304 0.03618"></site>
                        <site name="EDCL-P2" pos="  0.0013 -0.0382544 0.0129514"></site>
                        <site name="EDCR-P3" pos="0.00882 -0.22366 0.04284"></site>
                        <site name="EDCR-P2" pos="  0.0026 -0.0392844 0.0144214"></site>
                        <site name="EDCM-P3" pos="0.0144 -0.22323 0.04223"></site>
                        <site name="EDCM-P2" pos=" 0.00316 -0.0388544 0.0141814"></site>
                        <site name="EDCI-P3" pos="0.01533 -0.22314 0.04196"></site>
                        <site name="EDCI-P2" pos=" 0.00228 -0.0385544 0.0137314"></site>
                        <site name="EDM-P4" pos="0.00454 -0.22641 0.03678"></site>
                        <site name="EIP-P3" pos="0.01076 -0.22783 0.03664"></site>
                        <site name="EPL-P2" pos="0.00124 -0.13668 0.0227"></site>
                        <site name="EPL-P3" pos="0.02702 -0.21872 0.03828"></site>
                        <site name="EPL-P4" pos="0.03382 -0.22754 0.04607"></site>
                        <site name="EPL-P5" pos="0.04234 -0.23771 0.04173"></site>
                        <site name="EPB-P1" pos="0.01924 -0.14695 0.02114"></site>
                        <site name="EPB-P2" pos="0.02276 -0.15857 0.02665"></site>
                        <site name="EPB-P3" pos="0.03831 -0.19722 0.03834"></site>
                        <site name="EPB-P4" pos="0.05235 -0.23611 0.02699"></site>
                        <site name="FPL-P1" pos="0.00971 -0.09458 0.01769"></site>
                        <site name="FPL-P2" pos="0.01658 -0.13525 0.01915"></site>
                        <site name="FPL-P3" pos="0.01869 -0.17932 0.01988"></site>
                        <site name="FPL-P4" pos="0.038 -0.23171 0.0158"></site>
                        <site name="APL-P1" pos="0.01154 -0.09477 0.01681"></site>
                        <site name="APL-P2" pos="0.0303 -0.1397 0.03507"></site>
                        <site name="APL-P3" pos="0.03993 -0.16072 0.034"></site>
                        <site name="APL-P4" pos="0.04397 -0.17845 0.03134"></site>
                        <site name="APL-P5" pos="0.05505 -0.23084 0.02368"></site>
                        <!--<site name="endeffector" pos="0.0305 -0.25084 0.01868" size="0.01"></site>-->
                        <joint name="pro_sup" type="hinge" pos="0 0 0" axis="-0.017161 0.992666 -0.119668" limited="true" range=" -1.5708   1.5708" ref="0" damping="3.045599544730105e-05" solimplimit="  0.0001     0.99 0.523599      0.5        1" user="1"></joint>
                        <body name="proximal_row" pos="   0.018   -0.242    0.025" quat="1.0 0.0 0.0 0.0">
                          <geom name="lunate" type="mesh" mesh="lunate"></geom>
                          <geom name="sdfastSCAPHOIDw" type="mesh" mesh="sdfastSCAPHOIDw"></geom>
                          <geom name="sdfastPISIFORMw" type="mesh" mesh="sdfastPISIFORMw"></geom>
                          <geom name="sdfastTRIQUETRALw" type="mesh" mesh="sdfastTRIQUETRALw"></geom>
                          <inertial pos="       0        0        0" mass="0.0001" fullinertia="   1e-05    1e-05    1e-05        0        0        0"></inertial>
                          <joint name="deviation" type="hinge" pos="0 0 0" axis="-0.819064 -0.135611 -0.557444" limited="true" range="-0.174533 0.436332" ref="0" damping="3.045599544730105e-05" solimplimit="  0.0001     0.99 0.0785397      0.5        1" user="1"></joint>
                          <joint name="flexion" type="hinge" pos="0 0 0" axis="0.956427 -0.252207 0.147104" limited="true" range="-0.785398 0.785398" ref="0" damping="7.615395125226858e-06" solimplimit="  0.0001     0.99    0.001      0.5        1" user="1"></joint>
                          <body name="hand" pos="0.003992 -0.015054 0.002327" quat="1.0 0.0 0.0 0.0">
                            <geom name="sdfast_1seg_hand_fr_c_5mc" type="mesh" mesh="sdfast_1seg_hand_fr_c_5mc"></geom>
                            <geom name="sdfast_1seg_hand_fr_c_4mc" type="mesh" mesh="sdfast_1seg_hand_fr_c_4mc"></geom>
                            <geom name="sdfast_1seg_hand_fr_c_3mc" type="mesh" mesh="sdfast_1seg_hand_fr_c_3mc"></geom>
                            <geom name="sdfast_1seg_hand_fr_c_2mc" type="mesh" mesh="sdfast_1seg_hand_fr_c_2mc"></geom>
                            <geom name="sdfast_1seg_hand_fr_c_trapezium" type="mesh" mesh="sdfast_1seg_hand_fr_c_trapezium"></geom>
                            <geom name="sdfast_1seg_hand_fr_c_trapezoid" type="mesh" mesh="sdfast_1seg_hand_fr_c_trapezoid"></geom>
                            <geom name="sdfast_1seg_hand_fr_c_hamate" type="mesh" mesh="sdfast_1seg_hand_fr_c_hamate"></geom>
                            <geom name="capitate" type="mesh" mesh="capitate"></geom>
                            <geom name="hand_2proxph" type="mesh" mesh="hand_2proxph"></geom>
                            <geom name="hand_2midph" type="mesh" mesh="hand_2midph"></geom>
                            <geom name="hand_2distph" type="mesh" mesh="hand_2distph"></geom>
                            <geom name="hand_3proxph" type="mesh" mesh="hand_3proxph"></geom>
                            <geom name="hand_3midph" type="mesh" mesh="hand_3midph"></geom>
                            <geom name="hand_3distph" type="mesh" mesh="hand_3distph"></geom>
                            <geom name="hand_4proxph" type="mesh" mesh="hand_4proxph"></geom>
                            <geom name="hand_4midph" type="mesh" mesh="hand_4midph"></geom>
                            <geom name="hand_4distph" type="mesh" mesh="hand_4distph"></geom>
                            <geom name="hand_5proxph" type="mesh" mesh="hand_5proxph"></geom>
                            <geom name="hand_5midph" type="mesh" mesh="hand_5midph"></geom>
                            <geom name="hand_5distph" type="mesh" mesh="hand_5distph"></geom>
                            <geom name="hand_thumbprox" type="mesh" mesh="hand_thumbprox"></geom>
                            <geom name="hand_thumbdist" type="mesh" mesh="hand_thumbdist"></geom>
                            <geom name="hand_1mc" type="mesh" mesh="hand_1mc"></geom>
                            <inertial pos="-0.00301314 -0.0424993 -0.00112205" mass="0.5819" fullinertia=" 0.00011    6e-05  0.00015    9e-07   -2e-07  1.2e-05"></inertial>
                            <site name="ECRL-P4" pos="0.01717 -0.02122 0.00583"></site>
                            <site name="ECRB-P4" pos="0.005 -0.01136 0.0085"></site>
                            <site name="ECU-P6" pos="-0.02251 -0.01401 -0.00128"></site>
                            <site name="FCR-P3" pos="0.01124 -0.01844 -0.00418"></site>
                            <site name="FCU-P4" pos="-0.02036 -0.01765 -0.00752"></site>
                            <site name="PL-P3" pos="0.00917 -0.01898 -0.01754"></site>
                            <site name="PL-P4" pos="0.00227 -0.03096 0.00493"></site>
                            <site name="FDSL-P3" pos="-0.00235 -0.01393 -0.01376"></site>
                            <site name="FDSL-P4" pos="-0.01995 -0.04281 -0.00742"></site>
                            <site name="FDSL-P5" pos="-0.02044 -0.05981 -0.01878"></site>
                            <site name="FDSL-P6" pos="-0.01713 -0.07245 -0.02753"></site>
                            <site name="FDSL-P7" pos="-0.01156 -0.07271 -0.03656"></site>
                            <site name="FDSL-P8" pos="-0.01059 -0.07271 -0.03796"></site>
                            <site name="FDSR-P3" pos="-0.00082 -0.01344 -0.01359"></site>
                            <site name="FDSR-P4" pos="-0.00977 -0.05179 4e-005"></site>
                            <site name="FDSR-P5" pos="-0.01323 -0.0667 -0.0102"></site>
                            <site name="FDSR-P6" pos="-0.00788 -0.08027 -0.02503"></site>
                            <site name="FDSR-P7" pos="-0.00299 -0.08125 -0.03395"></site>
                            <site name="FDSR-P8" pos="0.00062 -0.08092 -0.03892"></site>
                            <site name="FDSM-P3" pos="0.0068 -0.01377 -0.01399"></site>
                            <site name="FDSM-P4" pos="0.00471 -0.03332 -0.00132"></site>
                            <site name="FDSM-P5" pos="0.00542 -0.0566 0.0006"></site>
                            <site name="FDSM-P6" pos="0.00555 -0.07224 -0.00338"></site>
                            <site name="FDSM-P7" pos="0.01167 -0.0881 -0.0167"></site>
                            <site name="FDSM-P8" pos="0.01301 -0.0887 -0.02977"></site>
                            <site name="FDSM-P9" pos="0.01568 -0.08577 -0.03765"></site>
                            <site name="FDSI-P3" pos="0.00889 -0.01366 -0.01387"></site>
                            <site name="FDSI-P4" pos="0.01061 -0.03787 0.00024"></site>
                            <site name="FDSI-P5" pos="0.01782 -0.05108 0.00418"></site>
                            <site name="FDSI-P6" pos="0.01849 -0.07297 -0.00375"></site>
                            <site name="FDSI-P7" pos="0.02678 -0.08714 -0.01804"></site>
                            <site name="FDSI-P8" pos="0.02667 -0.0874 -0.02678"></site>
                            <site name="FDSI-P9" pos="0.0266 -0.08633 -0.02903"></site>
                            <site name="FDPL-P3" pos="-0.00088 -0.01027 -0.01188"></site>
                            <site name="FDPL-P4" pos="-0.01855 -0.04646 -0.00733"></site>
                            <site name="FDPL-P5" pos="-0.01808 -0.05841 -0.0156"></site>
                            <site name="FDPL-P6" pos="-0.01428 -0.07289 -0.02683"></site>
                            <site name="FDPL-P7" pos="-0.0092 -0.07483 -0.03684"></site>
                            <site name="FDPL-P8" pos="-0.00312 -0.07405 -0.04165"></site>
                            <site name="FDPL-P9" pos="0.00446 -0.07059 -0.04657"></site>
                            <site name="FDPR-P3" pos="0.00106 -0.01177 -0.01184"></site>
                            <site name="FDPR-P4" pos="-0.00855 -0.05542 0.00088"></site>
                            <site name="FDPR-P5" pos="-0.01079 -0.06588 -0.00817"></site>
                            <site name="FDPR-P6" pos="-0.00547 -0.08154 -0.02256"></site>
                            <site name="FDPR-P7" pos="-0.00056 -0.0823 -0.03367"></site>
                            <site name="FDPR-P8" pos="0.00609 -0.07837 -0.04238"></site>
                            <site name="FDPR-P9" pos="0.01211 -0.0738 -0.04858"></site>
                            <site name="FDPM-P3" pos="0.00335 -0.0128 -0.01144"></site>
                            <site name="FDPM-P4" pos="0.00302 -0.03447 -0.00611"></site>
                            <site name="FDPM-P5" pos="0.00252 -0.05863 0.00122"></site>
                            <site name="FDPM-P6" pos="0.00285 -0.06985 -0.00133"></site>
                            <site name="FDPM-P7" pos="0.00863 -0.08779 -0.01815"></site>
                            <site name="FDPM-P8" pos="0.01002 -0.08766 -0.02964"></site>
                            <site name="FDPM-P9" pos="0.01633 -0.08157 -0.04435"></site>
                            <site name="FDPM-P10" pos="0.01909 -0.07663 -0.05229"></site>
                            <site name="FDPI-P3" pos="0.00896 -0.01168 -0.01212"></site>
                            <site name="FDPI-P4" pos="0.01922 -0.05542 0.00438"></site>
                            <site name="FDPI-P5" pos="0.02073 -0.07021 -0.00286"></site>
                            <site name="FDPI-P6" pos="0.02904 -0.08588 -0.01782"></site>
                            <site name="FDPI-P7" pos="0.02924 -0.08672 -0.02769"></site>
                            <site name="FDPI-P8" pos="0.02914 -0.08235 -0.03979"></site>
                            <site name="FDPI-P9" pos="0.02847 -0.07771 -0.04766"></site>
                            <site name="EDCL-P4" pos="-0.02464 -0.04402 0.00169"></site>
                            <site name="EDCL-P5" pos="-0.02381 -0.04734 0.00077"></site>
                            <site name="EDCL-P6" pos="-0.02395 -0.06613 -0.01001"></site>
                            <site name="EDCL-P7" pos="-0.01798 -0.07847 -0.02711"></site>
                            <site name="EDCL-P8" pos="-0.01178 -0.07877 -0.03779"></site>
                            <site name="EDCL-P9" pos="-0.0015 -0.07586 -0.04586"></site>
                            <site name="EDCL-P10" pos="0.00201 -0.07487 -0.04794"></site>
                            <site name="EDCR-P4" pos="-0.01564 -0.0555 0.00934"></site>
                            <site name="EDCR-P5" pos="-0.01427 -0.05819 0.01161"></site>
                            <site name="EDCR-P6" pos="-0.0158 -0.07216 -0.00421"></site>
                            <site name="EDCR-P7" pos="-0.00825 -0.08735 -0.0226"></site>
                            <site name="EDCR-P8" pos="-0.00272 -0.08806 -0.03409"></site>
                            <site name="EDCR-P9" pos="0.00763 -0.08026 -0.04658"></site>
                            <site name="EDCR-P10" pos="0.01069 -0.07809 -0.04941"></site>
                            <site name="EDCM-P4" pos="0.00039 -0.05274 0.01491"></site>
                            <site name="EDCM-P5" pos="-0.00087 -0.05574 0.01452"></site>
                            <site name="EDCM-P6" pos="0.00186 -0.07718 0.00597"></site>
                            <site name="EDCM-P7" pos="0.01007 -0.09313 -0.01774"></site>
                            <site name="EDCM-P8" pos="0.01321 -0.09558 -0.03056"></site>
                            <site name="EDCM-P9" pos="0.01857 -0.08525 -0.04759"></site>
                            <site name="EDCM-P10" pos="0.02056 -0.07993 -0.05341"></site>
                            <site name="EDCM-P11" pos="0.02195 -0.07701 -0.05663"></site>
                            <site name="EDCI-P4" pos="0.01543 -0.0468 0.01639"></site>
                            <site name="EDCI-P5" pos="0.01897 -0.05654 0.01438"></site>
                            <site name="EDCI-P6" pos="0.01994 -0.07678 0.00594"></site>
                            <site name="EDCI-P7" pos="0.02945 -0.09162 -0.01245"></site>
                            <site name="EDCI-P8" pos="0.03121 -0.09349 -0.02905"></site>
                            <site name="EDCI-P9" pos="0.03013 -0.08487 -0.04268"></site>
                            <site name="EDCI-P10" pos="0.02929 -0.08103 -0.04966"></site>
                            <site name="EDM-P5" pos="-0.02059 -0.01032 0.00372"></site>
                            <site name="EDM-P6" pos="-0.02563 -0.04722 0.00023"></site>
                            <site name="EDM-P7" pos="-0.02549 -0.06511 -0.01098"></site>
                            <site name="EDM-P8" pos="-0.01933 -0.0781 -0.02718"></site>
                            <site name="EDM-P9" pos="-0.01346 -0.07892 -0.03894"></site>
                            <site name="EDM-P10" pos="-0.00216 -0.07521 -0.04589"></site>
                            <site name="EDM-P11" pos="0.00132 -0.07345 -0.04803"></site>
                            <site name="EIP-P4" pos="0.00388 -0.02234 0.01184"></site>
                            <site name="EIP-P5" pos="0.01693 -0.0564 0.01377"></site>
                            <site name="EIP-P6" pos="0.01735 -0.07692 0.00581"></site>
                            <site name="EIP-P7" pos="0.02765 -0.09314 -0.01511"></site>
                            <site name="EIP-P8" pos="0.02879 -0.09437 -0.02823"></site>
                            <site name="EIP-P9" pos="0.0287 -0.08524 -0.04295"></site>
                            <site name="EIP-P10" pos="0.02834 -0.07785 -0.05501"></site>
                            <site name="endeffector" pos="0.02834 -0.07785 -0.05501" size=0.005></site>
                            <site name="EPL-P6" pos="0.02428 0.00014 0.00608"></site>
                            <site name="EPL-P7" pos="0.02338 -0.00917 -0.00039"></site>
                            <site name="EPL-P8" pos="0.02905 -0.01427 -0.00489"></site>
                            <site name="EPL-P9" pos="0.04414 -0.03417 -0.01814"></site>
                            <site name="EPL-P10" pos="0.04867 -0.04646 -0.02487"></site>
                            <site name="EPL-P11" pos="0.04751 -0.0701 -0.03774"></site>
                            <site name="EPL-P12" pos="0.04011 -0.07565 -0.04283"></site>
                            <site name="EPB-P5" pos="0.03123 0.00256 -0.00327"></site>
                            <site name="EPB-P6" pos="0.02972 -0.00794 -0.01436"></site>
                            <site name="EPB-P7" pos="0.04422 -0.033 -0.02422"></site>
                            <site name="EPB-P8" pos="0.04528 -0.04785 -0.03186"></site>
                            <site name="FPL-P6" pos="0.01244 -0.02207 -0.02089"></site>
                            <site name="FPL-P7" pos="0.01641 -0.02621 -0.02221"></site>
                            <site name="FPL-P8" pos="0.02457 -0.03294 -0.02237"></site>
                            <site name="FPL-P9" pos="0.02827 -0.05482 -0.03055"></site>
                            <site name="FPL-P10" pos="0.03511 -0.06519 -0.03749"></site>
                            <site name="FPL-P11" pos="0.03533 -0.07656 -0.04118"></site>
                            <site name="FPL-P5" pos="0.0178892 0.0064176 -0.0168214"></site>
                            <site name="APL-P7" pos="0.02587 0.00205 -0.0165"></site>
                            <site name="APL-P8" pos="0.02878 -0.00674 -0.0187"></site>
                            <site name="APL-P9" pos="0.03076 -0.01583 -0.01885"></site>
                            <site name="APL-P6" pos="0.0332244 0.00608975 -0.00870125"></site>
                            <joint name="wrist_hand_r1" type="hinge" pos="0 0 0" axis="0.899136 -0.349053 -0.26404" limited="false" range="-99999.9  99999.9" ref="0"></joint>
                            <joint name="wrist_hand_r3" type="hinge" pos="0 0 0" axis="0.997119   0.0107 -0.075101" limited="false" range="-99999.9  99999.9" ref="0"></joint>
                          </body>
                        </body>
                      </body>
                    </body>
                  </body>
                </body>
              </body>
            </body>
          </body>
        </body>
      </body>
    </body>
    <body name="target" pos="0 0 0" >
                        <inertial pos="0 0 0" mass="0" />
            <joint armature="0" axis="1 0 0" damping="1000000" frictionloss="100000" limited="true" name="target_x" pos="0 0 0" range="-1 1" ref="0" stiffness="0" type="slide"/>
            <joint armature="0" axis="0 1 0" damping="1000000" frictionloss="100000" limited="true" name="target_y" pos="0 0 0" range="-1 1" ref="0" stiffness="0" type="slide"/>
            <joint armature="0" axis="0 0 1" damping="1000000" frictionloss="100000" limited="true" name="target_z" pos="0 0 0" range="-1 1" ref="0" stiffness="0" type="slide"/>
            <geom conaffinity="0" contype="0" name="target" pos="0 0 0" rgba="0.9 0.2 0.2 1" size=".04" type="sphere"/>
    </body>
  </worldbody>
  <asset>
    <mesh name="thorax" file="Geometry/thorax.stl" scale="       1        1        1"></mesh>
    <mesh name="clavicle" file="Geometry/clavicle.stl" scale="       1        1        1"></mesh>
    <mesh name="scapula" file="Geometry/scapula.stl" scale="       1        1        1"></mesh>
    <mesh name="humerus" file="Geometry/humerus.stl" scale="       1        1        1"></mesh>
    <mesh name="ulna" file="Geometry/ulna.stl" scale="       1        1        1"></mesh>
    <mesh name="radius" file="Geometry/radius.stl" scale="       1        1        1"></mesh>
    <mesh name="lunate" file="Geometry/lunate.stl" scale="       1        1        1"></mesh>
    <mesh name="sdfastSCAPHOIDw" file="Geometry/sdfastSCAPHOIDw.stl" scale="       1        1        1"></mesh>
    <mesh name="sdfastPISIFORMw" file="Geometry/sdfastPISIFORMw.stl" scale="       1        1        1"></mesh>
    <mesh name="sdfastTRIQUETRALw" file="Geometry/sdfastTRIQUETRALw.stl" scale="       1        1        1"></mesh>
    <mesh name="sdfast_1seg_hand_fr_c_5mc" file="Geometry/sdfast_1seg_hand_fr_c_5mc.stl" scale="       1        1        1"></mesh>
    <mesh name="sdfast_1seg_hand_fr_c_4mc" file="Geometry/sdfast_1seg_hand_fr_c_4mc.stl" scale="       1        1        1"></mesh>
    <mesh name="sdfast_1seg_hand_fr_c_3mc" file="Geometry/sdfast_1seg_hand_fr_c_3mc.stl" scale="       1        1        1"></mesh>
    <mesh name="sdfast_1seg_hand_fr_c_2mc" file="Geometry/sdfast_1seg_hand_fr_c_2mc.stl" scale="       1        1        1"></mesh>
    <mesh name="sdfast_1seg_hand_fr_c_trapezium" file="Geometry/sdfast_1seg_hand_fr_c_trapezium.stl" scale="       1        1        1"></mesh>
    <mesh name="sdfast_1seg_hand_fr_c_trapezoid" file="Geometry/sdfast_1seg_hand_fr_c_trapezoid.stl" scale="       1        1        1"></mesh>
    <mesh name="sdfast_1seg_hand_fr_c_hamate" file="Geometry/sdfast_1seg_hand_fr_c_hamate.stl" scale="       1        1        1"></mesh>
    <mesh name="capitate" file="Geometry/capitate.stl" scale="       1        1        1"></mesh>
    <mesh name="hand_2proxph" file="Geometry/hand_2proxph.stl" scale="       1        1        1"></mesh>
    <mesh name="hand_2midph" file="Geometry/hand_2midph.stl" scale="       1        1        1"></mesh>
    <mesh name="hand_2distph" file="Geometry/hand_2distph.stl" scale="       1        1        1"></mesh>
    <mesh name="hand_3proxph" file="Geometry/hand_3proxph.stl" scale="       1        1        1"></mesh>
    <mesh name="hand_3midph" file="Geometry/hand_3midph.stl" scale="       1        1        1"></mesh>
    <mesh name="hand_3distph" file="Geometry/hand_3distph.stl" scale="       1        1        1"></mesh>
    <mesh name="hand_4proxph" file="Geometry/hand_4proxph.stl" scale="       1        1        1"></mesh>
    <mesh name="hand_4midph" file="Geometry/hand_4midph.stl" scale="       1        1        1"></mesh>
    <mesh name="hand_4distph" file="Geometry/hand_4distph.stl" scale="       1        1        1"></mesh>
    <mesh name="hand_5proxph" file="Geometry/hand_5proxph.stl" scale="       1        1        1"></mesh>
    <mesh name="hand_5midph" file="Geometry/hand_5midph.stl" scale="       1        1        1"></mesh>
    <mesh name="hand_5distph" file="Geometry/hand_5distph.stl" scale="       1        1        1"></mesh>
    <mesh name="hand_thumbprox" file="Geometry/hand_thumbprox.stl" scale="       1        1        1"></mesh>
    <mesh name="hand_thumbdist" file="Geometry/hand_thumbdist.stl" scale="       1        1        1"></mesh>
    <mesh name="hand_1mc" file="Geometry/hand_1mc.stl" scale="       1        1        1"></mesh>
    <texture name="texplane" type="2d" builtin="checker" rgb1=".2 .3 .4" rgb2=".1 0.15 0.2" width="100" height="100"></texture>
    <texture name="texgeom" type="cube" builtin="flat" mark="cross" width="127" height="1278" rgb1="0.8 0.6 0.4" rgb2="0.8 0.6 0.4" markrgb="1 1 1" random="0.01"></texture>
    <material name="MatPlane" reflectance="0.5" texture="texplane" texrepeat="1 1" texuniform="true"></material>
    <material name="geom" texture="texgeom" texuniform="true"></material>
  </asset>
  <tendon>
  {tendons}
  </tendon>
  <actuator>
  {actuator}
  </actuator>
  <equality>
    <joint name="sternoclavicular_r2_con" joint1="sternoclavicular_r2" joint2="shoulder_elv" active="true" polycoef="1.11022e-16 -0.242001        0        0        0" solimp="0.9999 0.9999 0.001 0.5 2"></joint>
    <joint name="sternoclavicular_r3_con" joint1="sternoclavicular_r3" joint2="shoulder_elv" active="true" polycoef="-8.32667e-17   0.1025        0        0        0" solimp="0.9999 0.9999 0.001 0.5 2"></joint>
    <joint name="unrotscap_r2_con" joint1="unrotscap_r2" joint2="shoulder_elv" active="true" polycoef="-1.11022e-16 0.242001        0        0        0" solimp="0.9999 0.9999 0.001 0.5 2"></joint>
    <joint name="unrotscap_r3_con" joint1="unrotscap_r3" joint2="shoulder_elv" active="true" polycoef="8.32667e-17  -0.1025        0        0        0" solimp="0.9999 0.9999 0.001 0.5 2"></joint>
    <joint name="acromioclavicular_r1_con" joint1="acromioclavicular_r1" joint2="shoulder_elv" active="true" polycoef="-8.32667e-17    0.178        0        0        0" solimp="0.9999 0.9999 0.001 0.5 2"></joint>
    <joint name="acromioclavicular_r2_con" joint1="acromioclavicular_r2" joint2="shoulder_elv" active="true" polycoef="2.77556e-17 -0.0490002        0        0        0" solimp="0.9999 0.9999 0.001 0.5 2"></joint>
    <joint name="acromioclavicular_r3_con" joint1="acromioclavicular_r3" joint2="shoulder_elv" active="true" polycoef="-1.11022e-16 0.396002        0        0        0" solimp="0.9999 0.9999 0.001 0.5 2"></joint>
    <joint name="unrothum_r1_con" joint1="unrothum_r1" joint2="shoulder_elv" active="true" polycoef="8.32667e-17   -0.178        0        0        0" solimp="0.9999 0.9999 0.001 0.5 2"></joint>
    <joint name="unrothum_r2_con" joint1="unrothum_r2" joint2="shoulder_elv" active="true" polycoef="-2.77556e-17 0.0490002        0        0        0" solimp="0.9999 0.9999 0.001 0.5 2"></joint>
    <joint name="unrothum_r3_con" joint1="unrothum_r3" joint2="shoulder_elv" active="true" polycoef="1.11022e-16 -0.396002        0        0        0" solimp="0.9999 0.9999 0.001 0.5 2"></joint>
    <joint name="shoulder1_r2_con" joint1="shoulder1_r2" joint2="elv_angle" active="true" polycoef="       0       -1        0        0        0" solimp="0.9999 0.9999 0.001 0.5 2"></joint>
    <joint name="wrist_hand_r1_con" joint1="wrist_hand_r1" joint2="deviation" active="true" polycoef="2.77556e-17  1.35714 -0.818507        0        0" solimp="0.9999 0.9999 0.001 0.5 2"></joint>
    <joint name="wrist_hand_r3_con" joint1="wrist_hand_r3" joint2="flexion" active="true" polycoef="       0      0.5        0        0        0" solimp="0.9999 0.9999 0.001 0.5 2"></joint>
    <joint name="r_z_constraint" active="true" joint1="r_z" polycoef="0.174533        0        0        0        0"></joint>
    <weld name="origin_to_worldbody" body1="thorax" active="false"></weld>
  </equality>
</mujoco>
"""


ARM750_MUSCLE_DEFAULT = """
    <general dyntype={dyntype} gaintype={gaintype} biastype={biastype} dynprm="{dynprm_act} {dynprm_deact}" gainprm="0.75 1.05 -1 400 0.5 1.6 1.5 1.3 1.2" biasprm="0.75 1.05 -1 400 0.5 1.6 1.5 1.3 1.2" ctrlrange="0 1" ctrllimited="true"/>
"""


ARM750_MUSCLE_ACTUATOR = """
    <general name="DELT1" tendon="DELT1_tendon" lengthrange="0.002325     3.72"   ctrllimited="true" ctrlrange="       0        1"></general>
    <general name="DELT2" tendon="DELT2_tendon" lengthrange="0.0027375     4.38"   ctrllimited="true" ctrlrange="       0        1"></general>
    <general name="DELT3" tendon="DELT3_tendon" lengthrange=" 0.00095     1.52"   ctrllimited="true" ctrlrange="       0        1"></general>
    <general name="SUPSP" tendon="SUPSP_tendon" lengthrange="0.0009875     1.58"   ctrllimited="true" ctrlrange="       0        1"></general>
    <general name="INFSP" tendon="INFSP_tendon" lengthrange=" 0.00077    1.232"   ctrllimited="true" ctrlrange="       0        1"></general>
    <general name="SUBSC" tendon="SUBSC_tendon" lengthrange="0.000825     1.32"   ctrllimited="true" ctrlrange="       0        1"></general>
    <general name="TMIN" tendon="TMIN_tendon" lengthrange="0.0017825    2.852"   ctrllimited="true" ctrlrange="       0        1"></general>
    <general name="TMAJ" tendon="TMAJ_tendon" lengthrange="  0.0005      0.8"   ctrllimited="true" ctrlrange="       0        1"></general>
    <general name="PECM1" tendon="PECM1_tendon" lengthrange="   7e-05    0.112"   ctrllimited="true" ctrlrange="       0        1"></general>
    <general name="PECM2" tendon="PECM2_tendon" lengthrange="0.002225     3.56"   ctrllimited="true" ctrlrange="       0        1"></general>
    <general name="PECM3" tendon="PECM3_tendon" lengthrange="  0.0033     5.28"   ctrllimited="true" ctrlrange="       0        1"></general>
    <general name="LAT1" tendon="LAT1_tendon" lengthrange="   0.003      4.8"   ctrllimited="true" ctrlrange="       0        1"></general>
    <general name="LAT2" tendon="LAT2_tendon" lengthrange="0.0044125     7.06"   ctrllimited="true" ctrlrange="       0        1"></general>
    <general name="LAT3" tendon="LAT3_tendon" lengthrange="0.0035075    5.612"   ctrllimited="true" ctrlrange="       0        1"></general>
    <general name="CORB" tendon="CORB_tendon" lengthrange="0.002425     3.88"   ctrllimited="true" ctrlrange="       0        1"></general>
    <general name="TRIlong" tendon="TRIlong_tendon" lengthrange="0.003575     5.72"   ctrllimited="true" ctrlrange="       0        1"></general>
    <general name="TRIlat" tendon="TRIlat_tendon" lengthrange=" 0.00245     3.92"   ctrllimited="true" ctrlrange="       0        1"></general>
    <general name="TRImed" tendon="TRImed_tendon" lengthrange=" 0.00227    3.632"   ctrllimited="true" ctrlrange="       0        1"></general>
    <general name="ANC" tendon="ANC_tendon" lengthrange=" 0.00045     0.72"   ctrllimited="true" ctrlrange="       0        1"></general>
    <general name="SUP" tendon="SUP_tendon" lengthrange="  0.0007     1.12"   ctrllimited="true" ctrlrange="       0        1"></general>
    <general name="BIClong" tendon="BIClong_tendon" lengthrange="0.0068075   10.892"   ctrllimited="true" ctrlrange="       0        1"></general>
    <general name="BICshort" tendon="BICshort_tendon" lengthrange="0.0048075    7.692"   ctrllimited="true" ctrlrange="       0        1"></general>
    <general name="BRA" tendon="BRA_tendon" lengthrange="0.0013375     2.14"   ctrllimited="true" ctrlrange="       0        1"></general>
    <general name="BRD" tendon="BRD_tendon" lengthrange="0.003325     5.32"   ctrllimited="true" ctrlrange="       0        1"></general>
    <general name="ECRL" tendon="ECRL_tendon" lengthrange="  0.0061     9.76"   ctrllimited="true" ctrlrange="       0        1"></general>
    <general name="ECRB" tendon="ECRB_tendon" lengthrange="0.0055575    8.892"   ctrllimited="true" ctrlrange="       0        1"></general>
    <general name="ECU" tendon="ECU_tendon" lengthrange="0.0057125     9.14"   ctrllimited="true" ctrlrange="       0        1"></general>
    <general name="FCR" tendon="FCR_tendon" lengthrange="  0.0061     9.76"   ctrllimited="true" ctrlrange="       0        1"></general>
    <general name="FCU" tendon="FCU_tendon" lengthrange="0.006625     10.6"   ctrllimited="true" ctrlrange="       0        1"></general>
    <general name="PL" tendon="PL_tendon" lengthrange="0.006735   10.776"   ctrllimited="true" ctrlrange="       0        1"></general>
    <general name="PT" tendon="PT_tendon" lengthrange=" 0.00245     3.92"   ctrllimited="true" ctrlrange="       0        1"></general>
    <general name="PQ" tendon="PQ_tendon" lengthrange="0.000125      0.2"   ctrllimited="true" ctrlrange="       0        1"></general>
    <general name="FDSL" tendon="FDSL_tendon" lengthrange="0.008465   13.544"   ctrllimited="true" ctrlrange="       0        1"></general>
    <general name="FDSR" tendon="FDSR_tendon" lengthrange="  0.0082    13.12"   ctrllimited="true" ctrlrange="       0        1"></general>
    <general name="FDSM" tendon="FDSM_tendon" lengthrange="0.007375     11.8"   ctrllimited="true" ctrlrange="       0        1"></general>
    <general name="FDSI" tendon="FDSI_tendon" lengthrange="0.006875       11" ctrllimited="true" ctrlrange="       0        1"></general>
    <general name="FDPL" tendon="FDPL_tendon" lengthrange="0.0070475   11.276" ctrllimited="true" ctrlrange="       0        1"></general>
    <general name="FDPR" tendon="FDPR_tendon" lengthrange="0.0072875    11.66"   ctrllimited="true" ctrlrange="       0        1"></general>
    <general name="FDPM" tendon="FDPM_tendon" lengthrange="0.007575    12.12"   ctrllimited="true" ctrlrange="       0        1"></general>
    <general name="FDPI" tendon="FDPI_tendon" lengthrange="0.0075375    12.06"   ctrllimited="true" ctrlrange="       0        1"></general>
    <general name="EDCL" tendon="EDCL_tendon" lengthrange="0.008375     13.4"   ctrllimited="true" ctrlrange="       0        1"></general>
    <general name="EDCR" tendon="EDCR_tendon" lengthrange="0.009125     14.6"   ctrllimited="true" ctrlrange="       0        1"></general>
    <general name="EDCM" tendon="EDCM_tendon" lengthrange="0.009125     14.6"   ctrllimited="true" ctrlrange="       0        1"></general>
    <general name="EDCI" tendon="EDCI_tendon" lengthrange="0.009125     14.6"   ctrllimited="true" ctrlrange="       0        1"></general>
    <general name="EDM" tendon="EDM_tendon" lengthrange="0.008375     13.4"   ctrllimited="true" ctrlrange="       0        1"></general>
    <general name="EIP" tendon="EIP_tendon" lengthrange=" 0.00525      8.4"   ctrllimited="true" ctrlrange="       0        1"></general>
    <general name="EPL" tendon="EPL_tendon" lengthrange="0.0057625     9.22"   ctrllimited="true" ctrlrange="       0        1"></general>
    <general name="EPB" tendon="EPB_tendon" lengthrange="0.0028875     4.62"   ctrllimited="true" ctrlrange="       0        1"></general>
    <general name="FPL" tendon="FPL_tendon" lengthrange="0.004925     7.88"   ctrllimited="true" ctrlrange="       0        1"></general>
    <general name="APL" tendon="APL_tendon" lengthrange="0.0032375     5.18"   ctrllimited="true" ctrlrange="       0        1"></general>
"""

ARM750_MUSCLE_TENDON = """
    <spatial name="DELT1_tendon" springlength="0.093" damping="0.017">
      <site site="DELT1-P1"></site>
      <site site="DELT1-P2"></site>
      <site site="DELT1-P3"></site>
      <site site="DELT1-P4"></site>
    </spatial>
    <spatial name="DELT2_tendon" springlength="0.1095" damping="0.017">
      <site site="DELT2-P1"></site>
      <site site="DELT2-P2"></site>
      <site site="DELT2-P3"></site>
      <site site="DELT2-P4"></site>
    </spatial>
    <spatial name="DELT3_tendon" springlength="0.038" damping="0.017">
      <site site="DELT3-P1"></site>
      <site site="DELT3-P2"></site>
      <site site="DELT3-P3"></site>
    </spatial>
    <spatial name="SUPSP_tendon" springlength="0.0395" damping="0.017">
      <site site="SUPSP-P1"></site>
      <site site="SUPSP-P2"></site>
      <site site="SUPSP-P3"></site>
    </spatial>
    <spatial name="INFSP_tendon" springlength="0.0308" damping="0.017">
      <site site="INFSP-P1"></site>
      <site site="INFSP-P2"></site>
    </spatial>
    <spatial name="SUBSC_tendon" springlength="0.033" damping="0.017">
      <site site="SUBSC-P1"></site>
      <site site="SUBSC-P2"></site>
      <site site="SUBSC-P3"></site>
    </spatial>
    <spatial name="TMIN_tendon" springlength="0.0713" damping="0.017">
      <site site="TMIN-P1"></site>
      <site site="TMIN-P2"></site>
      <site site="TMIN-P3"></site>
    </spatial>
    <spatial name="TMAJ_tendon" springlength="0.02" damping="0.017">
      <site site="TMAJ-P1"></site>
      <site site="TMAJ-P2"></site>
      <site site="TMAJ-P3"></site>
    </spatial>
    <spatial name="PECM1_tendon" springlength="0.0028" damping="0.017">
      <site site="PECM1-P1"></site>
      <site site="PECM1-P2"></site>
      <site site="PECM1-P3"></site>
      <site site="PECM1-P4"></site>
    </spatial>
    <spatial name="PECM2_tendon" springlength="0.089" damping="0.017">
      <site site="PECM2-P1"></site>
      <site site="PECM2-P2"></site>
      <site site="PECM2-P3"></site>
      <site site="PECM2-P4"></site>
      <site site="PECM2-P5"></site>
    </spatial>
    <spatial name="PECM3_tendon" springlength="0.132" damping="0.017">
      <site site="PECM3-P1"></site>
      <site site="PECM3-P2"></site>
      <site site="PECM3-P3"></site>
      <site site="PECM3-P4"></site>
      <site site="PECM3-P5"></site>
    </spatial>
    <spatial name="LAT1_tendon" springlength="0.12" damping="0.017">
      <site site="LAT1-P1"></site>
      <site site="LAT1-P2"></site>
      <site site="LAT1-P3"></site>
      <site site="LAT1-P4"></site>
      <site site="LAT1-P5"></site>
    </spatial>
    <spatial name="LAT2_tendon" springlength="0.1765" damping="0.017">
      <site site="LAT2-P1"></site>
      <site site="LAT2-P2"></site>
      <site site="LAT2-P3"></site>
      <site site="LAT2-P4"></site>
      <site site="LAT2-P5"></site>
    </spatial>
    <spatial name="LAT3_tendon" springlength="0.1403" damping="0.017">
      <site site="LAT3-P1"></site>
      <site site="LAT3-P2"></site>
      <site site="LAT3-P3"></site>
      <site site="LAT3-P4"></site>
      <site site="LAT3-P5"></site>
    </spatial>
    <spatial name="CORB_tendon" springlength="0.097" damping="0.017">
      <site site="CORB-P1"></site>
      <site site="CORB-P2"></site>
      <site site="CORB-P3"></site>
    </spatial>
    <spatial name="TRIlong_tendon" springlength="0.143" damping="0.017">
      <site site="TRIlong-P1"></site>
      <site site="TRIlong-P2"></site>
      <site site="TRIlong-P3"></site>
      <site site="TRIlong-P4"></site>
      <site site="TRIlong-P5"></site>
    </spatial>
    <spatial name="TRIlat_tendon" springlength="0.098" damping="0.017">
      <site site="TRIlat-P1"></site>
      <site site="TRIlat-P2"></site>
      <site site="TRIlat-P3"></site>
      <site site="TRIlat-P4"></site>
      <site site="TRIlat-P5"></site>
    </spatial>
    <spatial name="TRImed_tendon" springlength="0.0908" damping="0.017">
      <site site="TRImed-P1"></site>
      <site site="TRImed-P2"></site>
      <site site="TRImed-P3"></site>
      <site site="TRImed-P4"></site>
      <site site="TRImed-P5"></site>
    </spatial>
    <spatial name="ANC_tendon" springlength="0.018" damping="0.017">
      <site site="ANC-P1"></site>
      <site site="ANC-P2"></site>
    </spatial>
    <spatial name="SUP_tendon" springlength="0.028" damping="0.017">
      <site site="SUP-P1"></site>
      <site site="SUP-P2"></site>
      <site site="SUP-P3"></site>
    </spatial>
    <spatial name="BIClong_tendon" springlength="0.2723" damping="0.017">
      <site site="BIClong-P1"></site>
      <site site="BIClong-P2"></site>
      <site site="BIClong-P3"></site>
      <site site="BIClong-P4"></site>
      <site site="BIClong-P5"></site>
      <site site="BIClong-P6"></site>
      <site site="BIClong-P7"></site>
      <site site="BIClong-P8"></site>
      <site site="BIClong-P9"></site>
      <site site="BIClong-P11"></site>
    </spatial>
    <spatial name="BICshort_tendon" springlength="0.1923" damping="0.017">
      <site site="BICshort-P1"></site>
      <site site="BICshort-P2"></site>
      <site site="BICshort-P3"></site>
      <site site="BICshort-P4"></site>
      <site site="BICshort-P5"></site>
      <site site="BICshort-P6"></site>
      <site site="BICshort-P8"></site>
    </spatial>
    <spatial name="BRA_tendon" springlength="0.0535" damping="0.017">
      <site site="BRA-P1"></site>
      <site site="BRA-P4"></site>
    </spatial>
    <spatial name="BRD_tendon" springlength="0.133" damping="0.017">
      <site site="BRD-P1"></site>
      <site site="BRD-P2"></site>
      <site site="BRD-P3"></site>
    </spatial>
    <spatial name="ECRL_tendon" springlength="0.244" damping="0.017">
      <site site="ECRL-P1"></site>
      <site site="ECRL-P2"></site>
      <site site="ECRL-P3"></site>
      <site site="ECRL-P4"></site>
    </spatial>
    <spatial name="ECRB_tendon" springlength="0.2223" damping="0.017">
      <site site="ECRB-P1"></site>
      <site site="ECRB-P2"></site>
      <site site="ECRB-P3"></site>
      <site site="ECRB-P4"></site>
    </spatial>
    <spatial name="ECU_tendon" springlength="0.2285" damping="0.017">
      <site site="ECU-P1"></site>
      <site site="ECU-P2"></site>
      <site site="ECU-P3"></site>
      <site site="ECU-P4"></site>
      <site site="ECU-P5"></site>
      <site site="ECU-P6"></site>
    </spatial>
    <spatial name="FCR_tendon" springlength="0.244" damping="0.017">
      <site site="FCR-P1"></site>
      <site site="FCR-P2"></site>
      <site site="FCR-P3"></site>
    </spatial>
    <spatial name="FCU_tendon" springlength="0.265" damping="0.017">
      <site site="FCU-P1"></site>
      <site site="FCU-P2"></site>
      <site site="FCU-P3"></site>
      <site site="FCU-P4"></site>
    </spatial>
    <spatial name="PL_tendon" springlength="0.2694" damping="0.017">
      <site site="PL-P1"></site>
      <site site="PL-P2"></site>
      <site site="PL-P3"></site>
      <site site="PL-P4"></site>
    </spatial>
    <spatial name="PT_tendon" springlength="0.098" damping="0.017">
      <site site="PT-P1"></site>
      <site site="PT-P2"></site>
      <site site="PT-P3"></site>
      <site site="PT-P5"></site>
    </spatial>
    <spatial name="PQ_tendon" springlength="0.005" damping="0.017">
      <site site="PQ-P1"></site>
      <site site="PQ-P2"></site>
    </spatial>
    <spatial name="FDSL_tendon" springlength="0.3386" damping="0.017">
      <site site="FDSL-P1"></site>
      <site site="FDSL-P2"></site>
      <site site="FDSL-P3"></site>
      <site site="FDSL-P4"></site>
      <site site="FDSL-P5"></site>
      <site site="FDSL-P6"></site>
      <site site="FDSL-P7"></site>
      <site site="FDSL-P8"></site>
    </spatial>
    <spatial name="FDSR_tendon" springlength="0.328" damping="0.017">
      <site site="FDSR-P1"></site>
      <site site="FDSR-P2"></site>
      <site site="FDSR-P3"></site>
      <site site="FDSR-P4"></site>
      <site site="FDSR-P5"></site>
      <site site="FDSR-P6"></site>
      <site site="FDSR-P7"></site>
      <site site="FDSR-P8"></site>
    </spatial>
    <spatial name="FDSM_tendon" springlength="0.295" damping="0.017">
      <site site="FDSM-P1"></site>
      <site site="FDSM-P2"></site>
      <site site="FDSM-P3"></site>
      <site site="FDSM-P4"></site>
      <site site="FDSM-P5"></site>
      <site site="FDSM-P6"></site>
      <site site="FDSM-P7"></site>
      <site site="FDSM-P8"></site>
      <site site="FDSM-P9"></site>
    </spatial>
    <spatial name="FDSI_tendon" springlength="0.275" damping="0.017">
      <site site="FDSI-P1"></site>
      <site site="FDSI-P2"></site>
      <site site="FDSI-P3"></site>
      <site site="FDSI-P4"></site>
      <site site="FDSI-P5"></site>
      <site site="FDSI-P6"></site>
      <site site="FDSI-P7"></site>
      <site site="FDSI-P8"></site>
      <site site="FDSI-P9"></site>
    </spatial>
    <spatial name="FDPL_tendon" springlength="0.2819" damping="0.017">
      <site site="FDPL-P1"></site>
      <site site="FDPL-P2"></site>
      <site site="FDPL-P3"></site>
      <site site="FDPL-P4"></site>
      <site site="FDPL-P5"></site>
      <site site="FDPL-P6"></site>
      <site site="FDPL-P7"></site>
      <site site="FDPL-P8"></site>
      <site site="FDPL-P9"></site>
    </spatial>
    <spatial name="FDPR_tendon" springlength="0.2915" damping="0.017">
      <site site="FDPR-P1"></site>
      <site site="FDPR-P2"></site>
      <site site="FDPR-P3"></site>
      <site site="FDPR-P4"></site>
      <site site="FDPR-P5"></site>
      <site site="FDPR-P6"></site>
      <site site="FDPR-P7"></site>
      <site site="FDPR-P8"></site>
      <site site="FDPR-P9"></site>
    </spatial>
    <spatial name="FDPM_tendon" springlength="0.303" damping="0.017">
      <site site="FDPM-P1"></site>
      <site site="FDPM-P2"></site>
      <site site="FDPM-P3"></site>
      <site site="FDPM-P4"></site>
      <site site="FDPM-P5"></site>
      <site site="FDPM-P6"></site>
      <site site="FDPM-P7"></site>
      <site site="FDPM-P8"></site>
      <site site="FDPM-P9"></site>
      <site site="FDPM-P10"></site>
    </spatial>
    <spatial name="FDPI_tendon" springlength="0.3015" damping="0.017">
      <site site="FDPI-P1"></site>
      <site site="FDPI-P2"></site>
      <site site="FDPI-P3"></site>
      <site site="FDPI-P4"></site>
      <site site="FDPI-P5"></site>
      <site site="FDPI-P6"></site>
      <site site="FDPI-P7"></site>
      <site site="FDPI-P8"></site>
      <site site="FDPI-P9"></site>
    </spatial>
    <spatial name="EDCL_tendon" springlength="0.335" damping="0.017">
      <site site="EDCL-P1"></site>
      <site site="EDCL-P2"></site>
      <site site="EDCL-P3"></site>
      <site site="EDCL-P4"></site>
      <site site="EDCL-P5"></site>
      <site site="EDCL-P6"></site>
      <site site="EDCL-P7"></site>
      <site site="EDCL-P8"></site>
      <site site="EDCL-P9"></site>
      <site site="EDCL-P10"></site>
    </spatial>
    <spatial name="EDCR_tendon" springlength="0.365" damping="0.017">
      <site site="EDCR-P1"></site>
      <site site="EDCR-P2"></site>
      <site site="EDCR-P3"></site>
      <site site="EDCR-P4"></site>
      <site site="EDCR-P5"></site>
      <site site="EDCR-P6"></site>
      <site site="EDCR-P7"></site>
      <site site="EDCR-P8"></site>
      <site site="EDCR-P9"></site>
      <site site="EDCR-P10"></site>
    </spatial>
    <spatial name="EDCM_tendon" springlength="0.365" damping="0.017">
      <site site="EDCM-P1"></site>
      <site site="EDCM-P2"></site>
      <site site="EDCM-P3"></site>
      <site site="EDCM-P4"></site>
      <site site="EDCM-P5"></site>
      <site site="EDCM-P6"></site>
      <site site="EDCM-P7"></site>
      <site site="EDCM-P8"></site>
      <site site="EDCM-P9"></site>
      <site site="EDCM-P10"></site>
      <site site="EDCM-P11"></site>
    </spatial>
    <spatial name="EDCI_tendon" springlength="0.365" damping="0.017">
      <site site="EDCI-P1"></site>
      <site site="EDCI-P2"></site>
      <site site="EDCI-P3"></site>
      <site site="EDCI-P4"></site>
      <site site="EDCI-P5"></site>
      <site site="EDCI-P6"></site>
      <site site="EDCI-P7"></site>
      <site site="EDCI-P8"></site>
      <site site="EDCI-P9"></site>
      <site site="EDCI-P10"></site>
    </spatial>
    <spatial name="EDM_tendon" springlength="0.335" damping="0.017">
      <site site="EDM-P1"></site>
      <site site="EDM-P2"></site>
      <site site="EDM-P3"></site>
      <site site="EDM-P4"></site>
      <site site="EDM-P5"></site>
      <site site="EDM-P6"></site>
      <site site="EDM-P7"></site>
      <site site="EDM-P8"></site>
      <site site="EDM-P9"></site>
      <site site="EDM-P10"></site>
      <site site="EDM-P11"></site>
    </spatial>
    <spatial name="EIP_tendon" springlength="0.21" damping="0.017">
      <site site="EIP-P1"></site>
      <site site="EIP-P2"></site>
      <site site="EIP-P3"></site>
      <site site="EIP-P4"></site>
      <site site="EIP-P5"></site>
      <site site="EIP-P6"></site>
      <site site="EIP-P7"></site>
      <site site="EIP-P8"></site>
      <site site="EIP-P9"></site>
      <site site="EIP-P10"></site>
    </spatial>
    <spatial name="EPL_tendon" springlength="0.2305" damping="0.017">
      <site site="EPL-P1"></site>
      <site site="EPL-P2"></site>
      <site site="EPL-P3"></site>
      <site site="EPL-P4"></site>
      <site site="EPL-P5"></site>
      <site site="EPL-P6"></site>
      <site site="EPL-P7"></site>
      <site site="EPL-P8"></site>
      <site site="EPL-P9"></site>
      <site site="EPL-P10"></site>
      <site site="EPL-P11"></site>
      <site site="EPL-P12"></site>
    </spatial>
    <spatial name="EPB_tendon" springlength="0.1155" damping="0.017">
      <site site="EPB-P1"></site>
      <site site="EPB-P2"></site>
      <site site="EPB-P3"></site>
      <site site="EPB-P4"></site>
      <site site="EPB-P5"></site>
      <site site="EPB-P6"></site>
      <site site="EPB-P7"></site>
      <site site="EPB-P8"></site>
    </spatial>
    <spatial name="FPL_tendon" springlength="0.197" damping="0.017">
      <site site="FPL-P1"></site>
      <site site="FPL-P2"></site>
      <site site="FPL-P3"></site>
      <site site="FPL-P4"></site>
      <site site="FPL-P5"></site>
      <site site="FPL-P6"></site>
      <site site="FPL-P7"></site>
      <site site="FPL-P8"></site>
      <site site="FPL-P9"></site>
      <site site="FPL-P10"></site>
      <site site="FPL-P11"></site>
    </spatial>
    <spatial name="APL_tendon" springlength="0.1295" damping="0.017">
      <site site="APL-P1"></site>
      <site site="APL-P2"></site>
      <site site="APL-P3"></site>
      <site site="APL-P4"></site>
      <site site="APL-P5"></site>
      <site site="APL-P6"></site>
      <site site="APL-P7"></site>
      <site site="APL-P8"></site>
      <site site="APL-P9"></site>
    </spatial>
"""
