# Add the path to the partent directory to use local version of package
import os
os.sys.path.append(os.path.dirname(os.path.abspath('.')))
import fairlyuncertain as fu
from tqdm import tqdm

parameter_name = 'gamma'
parameters = [0, 1, 1e1, 1e2, 1e3, 1e4, 1e5]

parameter_name = 'max_depth'
parameters = list(range(5, 16))

for is_binary in [True, False]:
    type = 'binary' if is_binary else 'regression'
    datasets = fu.binary_datasets if is_binary else fu.regression_datasets
    algorithm_names = fu.binary_uncertainty if is_binary else fu.regression_uncertainty
    algorithms = {algo_name: fu.algorithms[algo_name] for algo_name in algorithm_names}

    results = {}
    for dataset in tqdm(datasets):
        results[dataset] = fu.get_consistency_data(dataset, algorithms, parameter_name, parameters)
    
    # fu.plot_consistency(results, is_binary, algorithms, datasets, parameter_name)
    fu.plot_consistency_with_range(results, is_binary, algorithms, datasets, parameter_name)

    table = fu.get_consistency_table(results, datasets, algorithms)
    filename = f'tables/consistency_{parameter_name}_{type}.tex'

    fu.print_table(table, filename)