import json

from utils.prover9_interface import prover9_prove, FOL2Prover9Converter

# load data
with open("logic_data/middle_data/medium-500-0_500.json", 'r') as f:
    data = json.load(f)

# validate
converter = FOL2Prover9Converter()
for item in data:
    premises = item['context_fol']
    # premises = []
    # premises.extend(item['facts_fol'])
    # premises.extend(item['rules_fol'])
    premises.extend(item['distracting_facts_fol'])
    premises.extend(item['distracting_rules_fol'])


    for i in range(len(premises)):
        premises[i] = converter.convert_expression(premises[i])
    

    conclusion = item['conclusion_fol']
    conclusion = converter.convert_expression(conclusion)
    conclusion_negation = f"¬({item['conclusion_fol']})"
    conclusion_negation = converter.convert_expression(conclusion_negation)
    
    try:
        arguments = [(conclusion, premises)]
        result1, std_out = prover9_prove(arguments)
    
        arguments = [(conclusion_negation, premises)]
        result2, std_out = prover9_prove(arguments)
    
        if result1 == result2:
            result = "Uncertain"
        elif result1 == True and result2 == False:
            result = "True"
        else:
            result = "False"
        
        print(f"lable: {item['answer']}     answer: {result}")
        
        if item['answer'] != result:
            a = 1
    except:
        continue
