import json
import random
import pickle
import argparse
from typing import Dict, List, Tuple
from copy import deepcopy

import numpy as np
from tqdm.auto import tqdm

from utils.translator import Translator, NoiseTranslator, ProblemGenerator


def seed_everything(seed: int):
    random.seed(seed)
    np.random.seed(seed)
    

if __name__ == "__main__":
    parser = argparse.ArgumentParser()
    
    # required parameters
    parser.add_argument("--num", type=int, default=30)
    parser.add_argument("--mode", type=str, default='ultra_hard')
    parser.add_argument("--start", type=int, default=0)
    parser.add_argument("--end", type=int, default=30)
    
    # default parameters
    parser.add_argument("--model_name", type=str, default="MODEL_NAME")
    parser.add_argument("--base_url", type=str, default="localhost:6417")
    parser.add_argument("--predicate_path", type=str, default="data/wordnet_predicates.json")
    parser.add_argument("--example_path", type=str, default="data/translation_examples.json")
    parser.add_argument("--name_path", type=str, default="data/names")
    parser.add_argument("--seed", type=int, default=79)
    parser.add_argument("--verbose", action="store_true")
    
    args = parser.parse_args()
    seed_everything(args.seed)
    
    # load dataset
    with open(f'result/logic_data/{args.mode}-{args.num}.pickle', 'rb') as f:
        logic_data = pickle.load(f)
        
    # translate facts and rules
    translator = Translator(args)
    translated_problems = translator.translate_rules_and_facts(data=logic_data)
    
    # translate distracting facts and rules
    noise_translator = NoiseTranslator(args, translated_data=translated_problems)
    translated_problems = noise_translator.create_distracting_rules()
    
    # generate problems
    problem_generator = ProblemGenerator(args, translated_data=translated_problems)
    translated_problems = problem_generator.create_problems()
    
    # save result
    with open(f"result/{args.mode}-{args.num}-{args.start}_{args.end}.json", "w") as f:
        json.dump(translated_problems, f, indent=2, ensure_ascii=False)
    

