import json
import random
import pickle
from typing import List, Dict
import argparse
import time

import numpy as np

from utils.generator import ProblemGenerator


def seed_everything(seed: int):
    random.seed(seed)
    np.random.seed(seed)
    

if __name__ == "__main__":
    parser = argparse.ArgumentParser()
    parser.add_argument("--num", type=int, default=30)
    parser.add_argument("--mode", type=str, default='ultra_hard')
    
    # default arguments
    parser.add_argument("--seed", type=int, default=79)
    parser.add_argument("--goal_value_probs", type=str, default="[1/3, 1/3, 1/3]", help="The proportion of True, False and Uncertain. This value should be given in standard list format, such as [0.4, 0.3, 0.3]")
    parser.add_argument("--rule_candidate_path", type=str, default="data/rules.json")
    parser.add_argument("--rule_as_goal_proportion", type=str, default="[0.75, 0.25]")
    parser.add_argument("--fact_num_threshold", type=int, default=2, help="when the size of the fact pool exceeds the threshold, there will be a possibility that the fact will be directly given")
    parser.add_argument("--fact_num_prob", type=float, default=0.4)
    
    args = parser.parse_args()
    args.goal_value_probs = eval(args.goal_value_probs)
    args.rule_as_goal_proportion = eval(args.rule_as_goal_proportion)
    
    seed_everything(args.seed)
    
    start_time = time.time()
    problem_generator = ProblemGenerator(args)
    problems = problem_generator.generate_problems(verbose=False)
    
    with open(f"result/logic_data/{args.mode}-{args.num}-{args.seed}.pickle", 'wb') as f:
        pickle.dump(problems, f)
        
    duration = time.time() - start_time
    print(f"Total time: {duration}")
    print(f"Average time: {round(duration / args.num, 2)}")
    
    
        