#! /bin/bash
expWhich=$1
expRoutingModel=$2
expIdSuffix=$3
expDmsMult=$4

graphNames=("Aconet" "Agis" "Arnes" "Cernet" "Cesnet201006" "Grnet" "Iij" "Internode" "Janetlense" "Karen" "Marnet" "Niif" "PionierL3" "Sinet" "SwitchL3" "Ulaknet" "Uninett2011")
#graphNames=("Aconet")

echo "Running with experiment suffix $expIdSuffix for graphs $graphNames with routing model $expRoutingModel".

cd $RN_EXPERIMENT_DATA_DIR/topologies && ls | grep -P '(NR|NA|ER|EA)\d{5}\.graph' | xargs rm
rm -rf $RN_EXPERIMENT_DATA_DIR/demand_matrices/* && mkdir -p $RN_EXPERIMENT_DATA_DIR/demand_matrices
docker run --rm --name relnet-base --volume $RN_EXPERIMENT_DATA_DIR:/experiment_data --volume $RN_SOURCE_DIR:/relnet --volume $RN_EXPERIMENT_DATA_DIR/topologies:/topologies --volume $RN_EXPERIMENT_DATA_DIR/demand_matrices:/demand_matrices relnet/base \
  python /relnet/relnet/experiment_launchers/tm_gen_setup.py --threads 8 --topology_root /topologies --tm_root /demand_matrices --min_scale_factor 1 --locality 0 --skip_tmrun --which $expWhich --dms_mult $expDmsMult

for i in ${!graphNames[@]};
do
  graphName=${graphNames[$i]}
  echo "Doing graph $graphName with routing model $expRoutingModel"

  expId=${graphName}_${expRoutingModel}_${expIdSuffix}

  if [[ $expRoutingModel == "ecmp" ]];
    then
      setupEcmpFlag="--use_ecmp"
    else
      setupEcmpFlag=""
  fi

  rm -rf $RN_EXPERIMENT_DATA_DIR/${expId}

  (docker run --rm --name relnet-base-${expId} --volume $RN_EXPERIMENT_DATA_DIR:/experiment_data --volume $RN_SOURCE_DIR:/relnet --volume $RN_EXPERIMENT_DATA_DIR/topologies:/topologies --volume $RN_EXPERIMENT_DATA_DIR/demand_matrices:/demand_matrices relnet/base \
    python /relnet/setup_experiments.py --experiment_id ${expId} --experiment_part build_dataset --graph_name ${graphName}  --which ${expWhich} ${setupEcmpFlag} --dms_mult ${expDmsMult}) &

  sleep 5

done

wait

echo "data generation script finished."

