#! /bin/bash
expPart=$1
graphNames=("Aconet" "Agis" "Arnes" "Cernet" "Cesnet201006" "Grnet" "Iij" "Internode" "Janetlense" "Karen" "Marnet" "Niif" "PionierL3" "Sinet" "SwitchL3" "Ulaknet" "Uninett2011")
#graphNames=("Aconet")

graphNamesAll=( "${graphNames[@]}" "${graphNames[@]}" )

for i in ${!graphNamesAll[@]};
do
  graphName=${graphNamesAll[$i]}

  if [[ $i -lt ${#graphNames[@]} ]];
    then
      routingModel="ssp"
      echo "running ssp for $graphName."
    else
      routingModel="ecmp"
      echo "running ecmp for $graphName."
  fi

  # main experiments
  bash $RN_SOURCE_DIR/scripts/run_prod.sh setup $expPart main $routingModel final1d 1.0 $graphName && bash $RN_SOURCE_DIR/scripts/run_prod.sh run $expPart main $routingModel final1d 1.0 $graphName
  bash $RN_SOURCE_DIR/scripts/run_prod.sh setup $expPart main $routingModel final0d5 0.5 $graphName && bash $RN_SOURCE_DIR/scripts/run_prod.sh run $expPart main $routingModel final0d5 0.5 $graphName
  bash $RN_SOURCE_DIR/scripts/run_prod.sh setup $expPart main $routingModel final0d25 0.25 $graphName && bash $RN_SOURCE_DIR/scripts/run_prod.sh run $expPart main $routingModel final0d25 0.25 $graphName
  bash $RN_SOURCE_DIR/scripts/run_prod.sh setup $expPart main $routingModel final0d1 0.10 $graphName && bash $RN_SOURCE_DIR/scripts/run_prod.sh run $expPart main $routingModel final0d1 0.10 $graphName
  bash $RN_SOURCE_DIR/scripts/run_prod.sh setup $expPart main $routingModel final0d05 0.05 $graphName && bash $RN_SOURCE_DIR/scripts/run_prod.sh run $expPart main $routingModel final0d05 0.05 $graphName

  # topology variation exps
  bash $RN_SOURCE_DIR/scripts/run_prod.sh setup $expPart topvar $routingModel topvarfinal1d 1.0 $graphName && bash $RN_SOURCE_DIR/scripts/run_prod.sh run $expPart topvar $routingModel topvarfinal1d 1.0 $graphName

done