#! /bin/bash
expWhat=$1
expPart=$2
expWhich=$3
expRoutingModel=$4
expIdSuffix=$5
expDmsMult=$6

graphNames=( $7 )

echo "Running with experiment suffix $expIdSuffix for graphs $graphNames".

for i in ${!graphNames[@]};
do
  graphName=${graphNames[$i]}
  echo "Doing graph $graphName with routing model $expRoutingModel"

  expId=${graphName}_${expRoutingModel}_${expIdSuffix}

  if [[ $expRoutingModel == "ecmp" ]];
    then
      setupEcmpFlag="--use_ecmp"
    else
      setupEcmpFlag=""
  fi


  if [[ $expWhat == "setup" ]]; then
      docker exec -it relnet-manager /bin/bash -c "python setup_experiments.py \
      --experiment_id ${expId} --experiment_part ${expPart} --graph_name ${graphName}  --which ${expWhich} ${setupEcmpFlag} --dms_mult ${expDmsMult}"

  fi

  if [[ $expWhat == "run" ]]; then
      taskCount=$(cat $RN_EXPERIMENT_DATA_DIR/${expId}/models/${expPart}_tasks.count | tr -d '\n')

      for i in $(seq 1 $taskCount); do
        docker exec -it relnet-manager /bin/bash -c "python tasks.py --experiment_id ${expId} --experiment_part ${expPart} --task_id $i"
      done
  fi
done

echo "Done launching everything."
