#!/bin/bash
export PYTHONPATH=$PYTHONPATH:`realpath .`
export WANDB_MODE="offline"

model_name=llava7b-cadpo-example
model_base=./checkpoints/models--liuhaotian--llava-v1.5-7b
GPU_DEVICE_LIST="7"

deepspeed --master_port 29600 --include localhost:$GPU_DEVICE_LIST ./inbol/train_ca_dpo.py \
    --lora_enable True --lora_r 16 --lora_alpha 32 --mm_projector_lr 0 \
    --deepspeed ./scripts/zero3.json \
    --model_name_or_path $model_base \
    --version v1 \
    --img_path ./playground/data \
    --dpo_data_path ./data/cadpo_data_examples/preference_data_examples.json \
    --vision_tower openai/clip-vit-large-patch14-336 \
    --mm_projector_type mlp2x_gelu \
    --mm_vision_select_layer -2 \
    --mm_use_im_start_end False \
    --mm_use_im_patch_token False \
    --image_aspect_ratio pad \
    --group_by_modality_length True \
    --bf16 True \
    --output_dir ./checkpoints/$model_name-lora \
    --num_train_epochs 1 \
    --per_device_train_batch_size 8 \
    --per_device_eval_batch_size 4 \
    --gradient_accumulation_steps 1 \
    --evaluation_strategy "no" \
    --save_strategy "steps" \
    --save_steps 200 \
    --save_total_limit 1 \
    --learning_rate 2e-4 \
    --weight_decay 0. \
    --warmup_steps 0 \
    --lr_scheduler_type "cosine" \
    --logging_steps 1 \
    --tf32 True \
    --model_max_length 2048 \
    --gradient_checkpointing True \
    --dataloader_num_workers 4 \
    --lazy_preprocess True \
    --report_to wandb \
    --run_name "llava-v1.5" \
    --beta 0.1 \


CUDA_VISIBLE_DEVICES=$GPU_DEVICE python ./scripts/merge_lora_weights.py --model-base $model_base --model-path ./checkpoints/$model_name-lora --save-model-path ./checkpoints/$model_name-full

