#!/bin/bash
MODEL_OUTPUT_DIR=llava7b-idkit-example
BASE_MODEL="./checkpoints/models--liuhaotian--llava-v1.5-7b"
GPU_DEVICE=7
export WANDB_MODE="offline"

deepspeed --master_port 29600 --include localhost:$GPU_DEVICE ./inbol/llava/train/train_mem.py \
    --lora_enable True --lora_r 16 --lora_alpha 32 --mm_projector_lr 2e-5 \
    --deepspeed ./scripts/zero3.json \
    --model_name_or_path $BASE_MODEL \
    --version v1 \
    --data_path ./data/sft_data_examples/instruction_examples.json \
    --image_folder ./playground/data \
    --vision_tower openai/clip-vit-large-patch14-336 \
    --mm_projector_type mlp2x_gelu \
    --mm_vision_select_layer -2 \
    --mm_use_im_start_end False \
    --mm_use_im_patch_token False \
    --image_aspect_ratio pad \
    --group_by_modality_length False \
    --bf16 True \
    --output_dir ./checkpoints/$MODEL_OUTPUT_DIR-lora \
    --num_train_epochs 1 \
    --per_device_train_batch_size 16 \
    --per_device_eval_batch_size 4 \
    --gradient_accumulation_steps 1\
    --evaluation_strategy "no" \
    --save_strategy "steps" \
    --save_steps 100 \
    --save_total_limit 1 \
    --learning_rate 2e-4 \
    --weight_decay 0. \
    --warmup_ratio 0.03 \
    --lr_scheduler_type "cosine" \
    --logging_steps 1 \
    --tf32 True \
    --model_max_length 2048 \
    --gradient_checkpointing True \
    --dataloader_num_workers 4 \
    --lazy_preprocess True \
    --report_to wandb 

CUDA_VISIBLE_DEVICES=$GPU_DEVICE python ./scripts/merge_lora_weights.py --model-base $BASE_MODEL --model-path ./checkpoints/$MODEL_OUTPUT_DIR-lora --save-model-path ./checkpoints/$MODEL_OUTPUT_DIR-full

