# Internal-Coordinate Density Modelling of Protein Structure: Covariance Matters

## Approach
This model generates protein dynamics structures by sampling from a distribution over **dihedrals** and **bond angles** (bond lengths fixed), which from now will together be called $\kappa$, while still respecting constraints in **Euclidean space**. A VAE predicts a mean over $\kappa$ conditioned on $z$ and then we construct a full precision matrix over dihedrals and bond angles, which is composed of:
* A precision prior $\Sigma^{-1}_{prior}$, weighed by a tunable parameter $a$, based on the fluctuations over $\kappa$ in the dataset.
* A precision matrix over the constraints $\Sigma^{-1}_{constr}$ we're imposing, i.e. how much points are allowed to fluctuate radially in Euclidean space. The contributions of each point fluctuation are weighed by Lagrange multipliers $\lambda$ that are predicted by a U-Net. 

## Contents
* `data/`: a folder containing dynamics data and (optionally) pdb files. Due to limited file size for supplemental material during submission, we now only provide 1unc as a dataset.
* `VAE_ProteinEnsemble.yml`: list of requirements.
* `main_VAE_dynamics.py`: main training script. Run `python main_VAE_dynamics.py --help` for options.
* `resume_training.py`: resume training from last saved checkpoint. Run `python resume_training.py --help` for options.
* `eval_VAE_dynamics.py`: evaluate model. Run `python eval_VAE_dynamics.py --help` for options.
* `pnerf_specify.py`: code used to build structures from internal coordinate sequences.
* `trainer_VAE_dynamics.py`: containing the trainer class.
* `unet_model.py`: containing the U-Net model framework (based on https://github.com/milesial/Pytorch-UNet).
* `utils.py`: misscelaneous functions.
* `VAE_model.py`: containing the VAE framework.

## How to train
The model can be trained by running `python main_VAE_dynamics.py <--arguments>`, check `--help` for options. Logging of training curves and figures is done in wandb, and the final model is saved in the specified folder. 
