#add parent dir to find package. Only needed for source code build, pip install doesn't need it.
import os, inspect
currentdir = os.path.dirname(os.path.abspath(inspect.getfile(inspect.currentframe())))
parentdir = os.path.dirname(os.path.dirname(currentdir))
os.sys.path.insert(0,parentdir)

import gym
import numpy as np
import pybullet as p
import pybulletgym.envs
import time


def relu(x):
    return np.maximum(x, 0)


class SmallReactivePolicy:
    "Simple multi-layer perceptron policy, no internal state"
    def __init__(self, observation_space, action_space):
        assert weights_dense1_w.shape == (observation_space.shape[0], 128)
        assert weights_dense2_w.shape == (128, 64)
        assert weights_final_w.shape  == (64, action_space.shape[0])

    @staticmethod
    def act(ob):
        x = ob
        x = relu(np.dot(x, weights_dense1_w) + weights_dense1_b)
        x = relu(np.dot(x, weights_dense2_w) + weights_dense2_b)
        x = np.dot(x, weights_final_w) + weights_final_b
        return x


def main():
    print("create env")
    env = gym.make("AtlasPyBulletEnv-v0")
    env.render(mode="human")
    pi = SmallReactivePolicy(env.observation_space, env.action_space)

    env.reset()
    torsoId = -1
    for i in range(p.getNumBodies()):
        print(p.getBodyInfo(i))
        if p.getBodyInfo(i)[0].decode("utf8") == "pelvis":
           torsoId = i
           print("found pelvis")

    while 1:
        frame = 0
        score = 0
        restart_delay = 0
        obs = env.reset()
        print("frame")
        while 1:
            time.sleep(0.02)
            a = pi.act(obs)
            obs, r, done, _ = env.step(a)
            score += r
            frame += 1
            distance = 5
            yaw = 0
            humanPos, humanOrn = p.getBasePositionAndOrientation(torsoId)
            p.resetDebugVisualizerCamera(distance, yaw, -20, humanPos)

            still_open = env.render("human")
            if still_open is None:
                return
            if not done:
                continue
            if restart_delay == 0:
                print("score=%0.2f in %i frames" % (score, frame))
                restart_delay = 60*2  # 2 sec at 60 fps
            else:
                restart_delay -= 1
                if restart_delay == 0:
                    break

weights_dense1_w = np.array([
[ +0.2220, +0.1193, +0.0508, +0.0148, -0.3239, +0.1804, -0.0173, +0.0100, +0.1167, +0.2312, -0.1030, +0.0977, -0.0548, +0.1067, +0.0883, +0.0777, +0.0142, +0.0046, +0.0557, -0.2344, +0.2857, +0.1997, -0.0620, -0.0783, -0.2340, +0.6687, +0.4405, +0.0764, +0.0060, -0.0327, -0.0962, +0.2507, -0.1791, +0.2677, -0.0315, +0.2340, -0.1229, -0.2647, -0.0457, +0.1305, -0.2001, +0.2034, +0.4743, -0.0882, +0.3731, -0.0947, -0.2649, -0.1562, +0.0286, +0.3395, +0.0718, +0.2465, +0.0229, -0.2573, -0.1256, -0.2517, +0.3399, +0.0512, -0.1497, +0.2791, -0.0974, -0.0500, +0.1467, +0.0492, +0.0634, +0.2575, -0.0893, -0.1554, -0.1654, +0.1207, -0.1295, -0.0498, -0.0868, +0.3209, -0.0962, +0.2105, -0.1886, +0.0186, -0.0907, -0.0788, +0.1909, -0.2528, +0.1995, +0.0508, -0.1658, -0.2081, -0.0914, +0.1710, +0.3531, +0.2539, +0.0633, +0.1606, +0.2998, -0.0562, +0.1561, -0.0242, +0.0987, -0.4196, +0.1680, -0.1218, +0.0056, +0.3523, +0.1682, -0.0388, +0.0245, +0.1067, -0.3154, +0.2121, -0.4010, -0.0312, -0.1111, -0.1210, +0.1616, -0.0470, +0.3795, +0.1158, -0.2401, +0.3634, +0.3164, -0.0770, +0.1690, +0.3492, +0.2852, -0.0271, +0.0844, -0.0239, -0.2552, -0.0586],
[ -0.0697, -0.6115, -0.7202, +0.1934, -0.2311, -0.1600, -0.6983, -0.2887, +0.1818, +0.3089, -0.1357, +0.2132, +0.3283, -0.4033, +0.0862, -0.4311, +0.1303, +0.5153, +0.6128, +0.4180, +0.4926, -0.3220, +0.1567, +0.8200, -0.2180, +0.1932, -0.4759, -0.0713, -0.2882, +0.0242, -0.1404, +0.4966, -0.0781, +0.3006, -0.5546, -0.1149, +0.1876, -0.2728, -0.2523, +0.4123, -0.2112, -0.0117, +0.5478, +0.3864, +0.2143, +0.1441, -0.0425, -0.6777, -0.1099, -0.1662, +0.2586, +0.1145, +0.7425, +0.2425, -0.3996, +0.0101, -0.1026, +0.0254, +0.0275, +0.1232, -0.1648, +0.0196, +0.1270, -0.5435, -0.2267, -0.2348, -0.0104, +0.0612, +0.1796, +0.2669, -0.1969, -0.2506, +0.2779, -0.2371, -0.2475, -0.4112, +0.9987, +0.0777, +0.3850, +0.5349, +0.1461, -0.0033, -0.1412, +0.3160, +0.2954, -0.1282, -0.1804, +0.0162, -0.1457, -0.3173, -0.6547, +0.3356, -0.0172, +0.2192, +0.7492, -0.1179, -0.5990, -0.2993, +0.0393, -0.5170, -0.5353, -0.5348, +0.3256, -1.0442, -0.1156, -0.0281, +0.4146, -1.0774, +0.3030, -0.4683, -0.2026, -0.0905, +0.1942, +0.1587, +0.0247, -0.6200, -0.3881, -0.4711, +0.4877, -0.1679, +0.0945, +0.3798, -0.2053, +0.4070, -0.6194, +0.6088, +0.6449, -0.4745],
[ +0.1193, -0.1231, -0.0347, +0.1331, +0.1526, -0.3294, -0.0829, -0.1501, -0.0023, -0.1681, -0.2699, -0.1223, -0.0103, +0.0040, -0.0338, -0.3530, +0.0495, -0.1624, +0.0080, -0.1594, -0.1459, +0.1205, -0.2666, +0.2649, -0.3574, -0.1452, -0.4060, +0.1538, -0.1324, +0.1542, +0.0292, +0.0039, +0.1074, +0.1040, +0.0824, -0.1219, +0.0714, -0.0226, -0.0128, -0.0455, +0.1220, +0.3508, -0.0547, -0.0629, -0.0910, +0.3800, +0.2097, -0.0011, -0.3033, +0.1628, -0.0513, -0.0125, +0.1228, +0.0847, -0.0114, -0.0051, -0.2546, -0.2072, -0.2388, +0.2364, +0.0830, +0.1183, +0.0997, -0.1563, -0.2676, -0.3776, +0.1462, -0.1496, +0.0248, -0.3577, -0.2409, -0.1909, -0.1046, +0.1810, -0.2483, +0.2339, +0.2390, +0.0754, -0.1682, +0.1400, +0.0491, -0.0236, -0.2536, +0.4251, +0.0865, +0.0029, +0.0760, +0.1105, -0.3518, -0.2579, +0.0791, -0.0084, +0.0980, -0.1747, -0.0248, +0.2036, +0.1455, +0.0777, +0.1339, +0.0312, -0.0317, -0.1719, -0.0117, +0.1489, +0.1063, -0.0889, +0.1407, +0.0333, -0.0166, -0.0968, -0.0817, +0.1649, -0.3201, +0.0559, -0.2659, -0.3532, -0.2145, -0.5800, +0.1837, +0.2101, -0.0314, -0.3535, +0.2216, -0.1411, -0.0607, +0.2873, +0.2608, -0.1978],
[ +0.2141, -0.2108, -0.8797, +0.0238, +0.0454, -0.1148, -0.2579, -0.7209, +0.0974, -0.2771, +0.0657, +0.6528, +0.0939, -0.2971, -0.0733, -0.2314, +0.3966, -0.3055, +0.4393, -0.0427, +0.0188, -0.4266, -0.0273, +0.0768, -0.1979, -0.2472, -0.2714, -0.2936, +0.1786, +0.0435, -0.1313, -0.0018, +0.4775, -0.1881, -0.3278, -0.1240, -0.5681, -1.2343, +0.1551, -0.4680, -0.4757, -0.1193, -0.5585, +0.2304, -0.2541, +0.2395, -0.6477, +0.2128, +0.2748, -1.0998, +0.1706, +0.2613, +0.2089, -0.0099, -0.0296, -0.2868, +0.1754, -0.3425, +0.3730, -0.6916, +0.2285, +0.1801, +0.0383, +0.1947, -0.0647, +0.0993, +0.0198, +0.3515, +0.1604, +0.0694, +0.2514, -0.3918, -0.2157, -0.5071, -0.0470, -0.4754, +0.1252, +0.3496, +0.7031, +0.3324, -0.1008, +0.3104, -1.3213, +0.1462, +0.6363, +0.0464, -0.2404, -0.5755, +0.5624, +0.0178, +0.1149, -0.2541, +0.0864, +0.2136, -0.0880, +0.6711, -0.1423, -0.6767, -0.4868, +0.1885, -0.8827, +0.1765, -0.0707, -0.1048, -0.3284, -0.1201, +0.0548, -0.4826, +0.0128, -0.5814, +0.0229, +0.1974, -0.1306, +0.0991, -0.1648, +0.1138, +0.2713, +0.1715, -0.0349, +0.4142, -0.0558, -0.1978, +0.3317, +0.4670, +0.0716, +0.0513, -0.8078, +0.4929],
[ -0.0515, +1.0268, -0.4057, -0.8338, -0.4905, -0.3290, -0.0866, -0.1162, -0.1458, -0.0397, +0.7533, -0.2234, +0.2872, +0.2357, -0.5397, +0.3668, +0.2610, -0.0847, +0.1737, +0.1083, -0.0954, -0.1132, +1.0523, +0.1595, +0.1934, +0.2134, +0.3349, +0.2042, -0.0818, +0.0441, +0.3153, +0.3232, +0.1294, -0.0610, -0.0740, +0.2299, -0.2358, +0.0938, -0.0943, +0.2142, -0.0540, -0.2196, -0.3812, -0.0770, -0.5177, -0.3670, +0.7474, +0.0160, -0.4676, +0.3387, -0.2152, +0.3190, +0.5474, +0.6528, -0.1221, +0.5144, +0.9256, +0.5490, -0.7006, -0.4042, -0.1242, +0.1614, +0.0923, +0.1034, -0.0932, +0.4056, -0.4639, -1.1242, -0.1253, +0.0586, -1.0914, +0.3918, -0.3549, -0.3210, +0.4046, +0.7602, -0.6578, -0.2219, +0.1335, +1.2671, -0.2414, -0.1175, +1.1504, -0.5572, -0.9198, -0.0171, +0.0153, +0.6880, +0.0140, +0.0673, -0.2854, -0.0980, -0.6430, +0.5155, +0.0184, -0.1184, +0.2331, -0.7963, +0.1444, +0.8638, -0.0501, -0.5729, -0.5017, +0.0217, -0.0931, -0.8828, +0.2614, +0.2385, -0.3722, -0.1558, -0.0297, +0.0210, -0.1852, -0.3302, +0.2987, -0.6410, -0.0118, +0.0274, -0.2460, +0.8094, +0.1739, -0.2087, +0.1177, +0.4056, -0.5209, -0.4408, -0.8024, -0.1946],
[ +0.3517, +1.5585, -0.0587, +0.1592, +0.2563, -0.2532, +0.0981, -0.3835, +1.0275, +0.7797, +0.2932, +1.8206, -0.9264, +0.1744, +2.0999, -1.1529, -0.2132, -0.0844, -0.0420, -1.1164, +0.1863, +0.9130, -0.5688, -0.2276, -0.9082, +0.4289, +0.2634, +1.0650, +0.8059, -0.4511, -0.4029, +0.7678, -0.4242, +0.6402, +0.1889, +0.4063, -0.9148, -0.9022, -0.8633, +0.1951, -0.0261, +0.5777, -0.4589, -0.1885, +0.4090, -1.7452, -0.3144, -0.8601, -0.4372, +0.4910, -0.7766, +0.2782, -0.7096, -0.1750, +0.1248, -0.4771, -0.6455, -0.1635, -1.1242, +0.7589, -0.5471, -0.8327, +2.1337, -0.0223, +0.6180, +0.3580, -0.1917, -1.3092, -0.7519, -0.2744, -0.1273, -0.9218, +0.1166, +2.3017, -0.7570, +0.4878, +0.0313, +0.4343, -1.1920, +0.7484, +1.9650, +0.2080, +0.2012, +0.4138, -1.4901, +0.7184, +0.3392, +0.2155, +0.7834, +0.3273, -1.6548, +0.3552, -0.3858, -1.0333, +0.4873, +0.7160, -0.0984, -1.2492, -0.1584, -0.8973, -0.4789, +0.4412, +0.9126, +0.6325, -0.6158, +0.9595, -0.7681, -0.1279, -0.9068, -0.1432, -0.6093, +0.6740, +0.6779, +0.3860, +0.3702, -0.1213, -1.6382, -0.7076, -0.9219, +1.1536, +0.6644, -0.0009, +0.4831, +0.0905, +0.2078, -0.1882, +0.2479, -0.0492],
[ -0.6211, -2.4663, -0.3977, +0.6041, -0.1472, +0.0190, +0.1829, -0.0524, -0.9959, -0.0593, -0.6383, -0.4426, +0.3720, +0.1403, +0.6343, +0.1096, -0.7855, +0.0442, +0.2575, -0.8399, +0.5018, +0.3614, -0.3248, -0.4739, +0.4365, +0.1762, -0.0929, -0.5539, +0.9527, +1.1450, +0.4000, +0.4935, +0.5632, +1.3632, -0.3671, -0.3402, +0.9514, +0.5060, -0.1173, +0.3104, -0.0952, +0.6371, +0.3037, -0.0178, -0.2001, +0.8452, -0.7650, -1.1436, +0.9417, -1.0516, +0.7865, -1.1398, -2.4920, +0.1461, +0.8742, -0.2309, -1.0825, +0.1396, -0.0870, +0.1590, -0.5392, +0.7881, +1.1852, -0.4646, -0.1644, +0.3382, +0.0473, +0.3746, +1.4815, +0.6162, +0.4588, +0.3333, +0.4898, +1.2737, -0.0309, -1.6376, +0.4024, -0.8852, -0.7440, -0.5763, +1.2362, -1.4095, -1.1422, +2.2353, +1.1421, +0.2402, +0.4574, -1.8715, +0.6558, -0.8337, +1.0918, +1.0731, +0.2927, -0.9119, +1.1935, -1.5082, -0.1171, +0.0123, +0.8243, -1.5107, -0.9542, +0.6903, +0.4774, -0.2693, -0.3357, +2.2502, -0.4523, +0.1636, -0.5341, -0.6001, -0.1120, -0.5388, -0.5106, +1.0320, +0.3095, -0.3107, -1.6445, -0.1664, +0.8239, -1.7574, +0.0541, +0.5377, -1.4109, -1.7950, +2.3125, +1.4869, -0.5914, +0.5358],
[ -0.2797, -0.2966, -0.4091, -0.3568, +0.3021, +0.2933, -0.4222, -0.0847, -0.5485, -0.3536, +1.1174, +1.9111, -1.0023, +0.0795, +0.8961, -0.8022, +0.1350, +0.8920, -0.0487, +0.8466, -0.3751, -1.9474, +0.1223, +1.1521, +0.3999, -0.1481, -0.4233, -1.4264, -0.3774, -0.8483, -0.4486, +0.4399, +0.6824, -1.2777, +0.1043, +0.0548, +0.1201, -1.2516, +1.3086, -1.1497, -0.3851, -1.1546, -1.0100, +0.3406, +0.0041, -0.2313, -1.5818, +0.3393, +0.5404, -1.3158, +0.4759, -0.5813, +0.3713, -0.1426, -0.2842, +0.3064, +0.2043, -1.0342, -0.3519, -0.6227, +0.0473, +0.6966, +1.2128, -0.6450, -0.4815, +0.3611, +0.7075, +1.1383, +1.1622, +0.0561, +0.3135, +0.4333, -0.3482, -1.8637, +0.1331, -1.7558, -0.3294, -1.7921, -0.0334, -0.1028, -1.0403, +0.4358, +0.1287, -0.2494, +1.9037, +1.1263, -0.0836, -1.7001, +1.9935, -0.4336, -0.8980, -0.1381, -1.2585, +1.3739, -0.4509, +2.2641, -0.0958, -0.1913, -0.2347, +0.5925, -0.7653, -0.3348, -0.2066, -0.5210, -0.3081, -0.4580, +0.8983, +0.2981, +0.1394, +0.7190, +0.1107, -0.6982, +0.2945, -1.3154, -0.3611, +0.7428, +1.4527, +0.0966, -0.8130, -0.3448, -0.0085, -0.0770, +0.0450, +0.0151, +0.1696, +0.1714, -0.5370, +0.2776],
[ -0.3810, -0.0139, -1.4267, +0.2240, +0.0206, -0.1598, -0.5566, -0.7046, +0.1907, +0.3697, -0.0271, +0.1520, +0.4086, -0.6957, +0.2012, +0.1844, -0.0231, +0.0371, -0.3136, -0.4117, +0.1749, +0.4671, -0.5741, +0.1969, -0.0382, -0.0806, -0.2487, -0.1276, +0.2300, +0.0357, -0.3456, +0.1727, +0.1671, +0.4982, -0.5113, -0.7625, -0.4833, -0.5277, +0.3869, +0.1051, +0.1047, -0.0742, +0.1091, -0.0316, -0.2016, -0.2913, +0.0399, -0.1491, -0.1104, +0.4290, +0.3812, +0.1850, -0.0215, -0.1507, +0.1380, -0.1487, -0.2851, -0.1049, +0.2507, +0.1111, -0.2215, +0.2597, +0.0476, -0.5295, -0.1948, -0.6886, -0.2676, -0.2892, +0.0338, +0.3673, +0.1844, -0.2418, -0.0717, +0.3291, -0.0568, +0.2334, -0.2719, +0.1540, +0.2428, -0.0539, -0.0005, +0.2307, -0.4798, -0.0188, +0.0841, +0.2668, +0.0574, +0.0548, -0.1391, -0.4998, +0.0578, -0.2787, -0.2532, -0.0905, -0.0731, -0.2043, -0.1758, -0.1376, -0.2158, +0.0864, -0.2766, -0.0444, +0.2131, -0.4672, -0.2200, +0.0778, +0.3723, -0.9998, +0.0401, -0.3599, -0.5110, -0.4527, -0.5847, -0.0281, -0.6775, -0.4912, -0.1634, -0.7750, +0.2931, -0.2600, +0.1875, -0.0528, -0.0761, +0.3257, +0.0416, +0.0716, +0.1957, -0.3335],
[ +0.1578, -0.3286, -0.1220, +0.1107, -0.0971, +0.3957, -0.3495, -0.3170, +0.6924, +0.5250, +0.1880, +0.3017, -0.1338, -0.7608, +0.1929, +0.5544, -0.2109, +0.1310, +0.2031, +0.6283, -0.3820, +0.3377, +0.0644, +0.0705, +0.0029, +0.0635, -0.7575, -0.3795, -0.3230, +0.2534, -0.4713, +0.4543, +0.7787, -0.2212, +0.5634, -0.2020, -0.5028, -0.6343, +0.2233, +0.0748, -0.0019, +0.0657, -0.3704, -0.0748, +0.3990, -0.7338, -0.0022, +0.3501, -0.2665, -0.1438, -0.0118, -0.0579, +0.0675, +0.4821, +0.4502, -0.7455, +0.0254, -0.0365, +0.0994, +0.6156, +0.0919, +0.5901, -0.1937, -0.1608, +0.1584, +0.0152, +0.2463, -0.0752, +0.0849, +0.2883, -0.0560, -0.3411, +1.1422, -0.1358, +0.4897, +0.2979, -0.0271, -0.3748, +0.6957, +0.1306, -0.3930, -0.0206, -0.4046, -0.4564, -0.1931, +0.1413, +0.0673, +0.1673, -0.3326, +0.0183, -0.4749, -0.3822, +0.2179, -0.0197, +0.0208, -0.3501, -0.4176, -0.0741, -0.7728, -0.0485, -0.2480, -0.3073, +0.5189, -0.5787, +0.5744, -0.3141, +0.1156, -0.3025, -0.2190, +0.2007, -0.7333, -0.0002, +0.1530, -0.1668, -0.1318, -0.6635, -0.1785, +0.0897, +0.3488, -0.0873, +0.6293, -0.4715, -0.1853, +0.5039, +0.2129, +0.0539, -0.0727, -0.5675],
[ -0.0958, -0.3118, +0.5325, +0.0124, -0.3928, -0.2309, +0.2044, -0.3977, +0.2829, +0.0691, +0.4114, +0.3339, -0.6504, +0.1378, +0.1429, -0.2101, -0.4710, +0.2167, -0.4401, -0.6348, +1.0213, -0.2784, -0.4286, +0.0908, -0.2285, +0.6220, +0.1572, +0.0050, -0.6149, +0.1351, +0.4521, -0.2488, +0.5107, -0.5702, -0.2364, +0.5028, +0.3536, -0.2031, +0.3386, -0.6669, +0.6832, -0.1650, +0.0704, +0.2989, +0.2287, -0.2781, +0.0247, -0.0772, +0.2035, +0.3927, +0.8083, +0.3128, +0.3960, -0.1892, -0.0963, +0.2202, +0.1020, -0.2098, +0.4992, +0.0161, +0.3881, +0.0536, +0.1429, -0.1066, +0.7268, -0.1770, +0.7555, +0.5184, -0.1143, +0.0025, +0.2980, +0.1477, +0.2663, -0.2501, -0.2764, -0.0356, +0.1364, +0.0031, +0.4132, +0.2867, -0.4063, +0.2658, -0.2480, -0.0905, +0.0589, -0.1136, -0.2536, +0.1854, +0.2068, +0.5333, -0.2262, +0.1218, +0.1631, -0.2021, -0.1296, +0.2940, -0.1802, -0.4476, +0.1779, +0.6506, -0.3492, +0.3908, -0.3260, +0.3559, +0.1021, -0.0427, +0.5970, -0.1639, +0.3413, -0.3239, -0.2989, -0.5814, -0.0889, -0.6217, -0.4855, -0.2509, +0.1340, +0.0987, -0.4162, -0.2679, +0.5876, +0.4778, +0.2799, +0.5404, -0.1254, -0.2887, +0.6422, -0.0782],
[ +0.3053, -0.1460, -0.1484, +0.3177, +0.5241, -0.1871, -0.1695, -0.0216, +0.4839, +0.1536, -0.2404, +0.1559, -0.5712, -0.3424, +0.0951, -0.0646, -0.6863, +0.1010, -0.5756, +0.5175, +0.2291, +0.1266, +0.4864, +0.0886, +0.0893, -0.2243, -0.0015, +0.0097, -0.2121, -0.0715, +0.2152, -0.0477, +0.4043, +0.0998, +0.0323, +0.0606, -0.3291, -0.3558, -0.4372, -0.5585, +0.0466, -0.2567, -0.3052, +0.4453, +0.0987, -0.2717, +0.2913, +0.2096, -0.1404, +0.2627, +0.3142, -0.3399, -0.0623, -0.1742, -0.0962, +0.1471, +0.0510, -0.2632, -0.1072, +0.3292, +0.2147, -0.2232, +0.0676, -0.0220, +0.3121, +0.1083, +0.4404, +0.0956, -0.5246, +0.0762, +0.4450, -0.0450, +0.1534, -0.0837, -0.5173, +0.0303, +0.0013, +0.2214, +0.0568, -0.3097, +0.0499, +0.3745, +0.1671, +0.1839, +0.3896, +0.0093, +0.0524, +0.2542, -0.1100, +0.1949, -0.3098, +0.1600, -0.1534, -0.4289, +0.1344, -0.2929, -0.1303, +0.2937, +0.0146, +0.2027, +0.2709, +0.2491, -0.1188, +0.0207, +0.1596, +0.5239, +0.4427, -0.1682, -0.1239, -0.1367, -0.1087, +0.2095, +0.1374, -0.2162, -0.5507, -0.0553, -0.2032, +0.3562, -0.0715, -0.0359, +0.3833, +0.0607, +0.1999, -0.0361, -0.1880, -0.0288, +0.5660, -0.3188],
[ -0.6255, -0.3792, -0.2063, -0.4974, +0.2679, -0.5309, -0.7526, -0.0902, -0.6210, -0.8259, +0.0446, -0.3728, +0.0168, +0.0368, +0.1003, -0.1338, +0.1234, +0.9134, -0.3228, +0.0696, +0.3242, -0.6431, -0.9755, +0.4792, +0.2482, +0.1138, -0.0641, +0.1018, -0.0700, +0.1362, -0.4090, -0.6665, +0.3198, +0.3750, +0.2726, +0.9581, -0.7744, -0.1963, +0.9063, +0.7304, -0.5030, -1.0095, +0.0326, +0.2146, -0.2699, -0.0343, +0.0795, -0.0058, +0.4338, -0.4578, +0.2593, -0.5608, -0.4311, +0.9387, +0.2168, +0.8335, -0.2341, +1.1806, -0.5185, +0.0121, +0.2883, +0.5669, +1.0904, +0.6065, +0.5147, -0.1224, -0.0787, -0.5023, +0.7656, +0.0089, +0.1060, +0.4734, -0.3887, +0.0769, -0.4342, -0.5806, -0.4875, -0.0288, -0.4325, +0.6218, +0.3560, -0.4415, -0.4048, +0.2600, +0.0760, +0.2840, +0.1867, +0.2962, +0.5637, +0.5055, -0.4016, +0.2681, +0.0727, -0.6029, -0.2234, -0.3725, -0.0503, +0.0343, +0.5992, +0.2016, -0.9054, -0.2139, -0.2304, +0.4992, +0.3966, +0.8077, -0.4033, -0.5299, +0.8556, -0.5479, -0.7739, +0.1387, +0.9342, -0.3374, +0.6027, -0.3531, -1.1507, -0.3619, -0.0124, -0.2998, +0.2580, +0.4213, -0.0859, +0.2783, +0.7197, +0.9301, -0.4765, +0.6434],
[ +0.6020, +0.8109, +0.2556, -0.6891, +0.5911, -0.4248, +0.1453, +0.5709, +0.2948, +0.1158, -0.4619, -0.4889, -0.1907, -0.1961, -0.3825, +0.5623, +0.2303, +0.3576, -0.6642, -0.0087, -0.2395, -0.5188, +0.4227, +0.1388, -0.0650, -0.1628, -0.0082, +0.5012, -0.2498, -0.2726, -0.2125, -0.4391, -0.3877, +0.5344, +0.2250, +0.3356, -0.1684, -0.4520, +0.5818, +0.0897, -0.4988, -0.9216, -0.2708, +0.0849, +0.0999, -0.6865, +1.0282, +0.4355, +0.2538, +0.3370, -0.3559, +0.0832, -0.0401, +0.9493, +0.0518, +0.5035, +0.2089, +0.1832, -0.4697, +0.1033, -0.1181, +0.4501, +0.6588, +0.1808, +0.3622, -0.4307, -0.2737, -0.2900, +0.2288, -0.1786, +0.0628, -0.3781, -0.0190, -0.2020, -0.2872, +0.3330, -0.8623, +0.3390, +0.4913, +0.5460, +0.1926, +0.1050, +0.4333, -0.2348, -0.1086, -0.0726, +0.0664, +1.0564, +0.3232, -0.1827, -0.5298, +0.0426, +0.1414, -0.1815, -0.3710, +0.1785, +0.5155, +0.0936, +0.1482, +0.2670, +0.0959, -0.1962, -0.6473, +0.4796, +0.0781, -0.3515, -0.6166, +0.1725, -0.3228, +0.0665, -0.2714, -0.0248, +0.3559, +0.3327, +0.3348, -0.1562, -0.4303, -0.4198, -0.1395, +0.0761, -0.0504, +0.5314, +0.1413, +0.6137, -0.1394, +0.4054, -0.0090, -0.1563],
[ +0.6349, -0.0010, +0.1497, -0.1887, +0.8436, +0.1261, +0.1484, +0.4698, -0.1898, +0.1278, -0.5226, +0.0098, +0.0394, +0.5163, +0.1361, -0.0357, -0.1387, -0.1257, -0.1039, +0.0652, -0.1128, +0.2548, +0.6053, +0.0383, +0.3489, +0.0528, +0.1491, +0.2641, +0.0270, -0.0199, +0.5305, +0.2811, +0.0711, +0.0599, -0.1965, +0.0571, +0.0796, +0.0155, -0.5031, -0.1086, -0.1722, +0.1088, +0.1925, +0.2711, -0.1538, -0.0076, -0.0021, -0.0936, -0.1864, -0.1035, +0.6052, +0.1170, +0.3355, -0.1901, +0.1356, -0.1569, -0.0461, -0.6203, +0.2269, +0.0713, +0.2080, +0.0164, -0.3417, +0.2817, +0.0867, +0.5028, +0.0217, +0.0442, -0.1331, -0.0718, -0.2450, +0.0752, +0.1334, +0.0255, +0.2708, +0.2447, -0.5129, -0.0023, -0.0050, -0.1667, -0.0774, +0.3666, +0.0294, -0.0876, -0.0488, -0.0865, -0.0318, -0.0165, -0.2491, +0.0559, +0.2179, +0.0593, +0.0756, +0.0551, -0.1040, -0.3187, +0.3894, +0.0438, -0.1800, -0.0710, +0.0986, -0.1820, +0.4419, -0.0886, +0.4164, -0.2455, -0.2202, +0.4373, +0.5124, -0.5955, +0.5490, +0.0559, -0.1474, +0.3612, +0.3392, -0.2194, +0.0549, +0.0046, -0.0440, +0.1698, +0.6794, +0.1484, -0.0675, -0.0070, -0.3688, -0.1251, -0.0164, -0.0314],
[ +0.1148, +0.3144, -0.3129, -0.6208, +0.4041, -0.3225, -0.2125, -0.4009, -0.9165, -0.2021, -1.0238, -0.0016, -0.1531, -0.0669, +0.3120, -0.4523, +0.5590, +0.1721, -0.2818, -0.0421, -0.3305, +0.1931, -0.4615, +0.2990, +0.6513, +0.7230, +0.0085, -0.0958, -0.3856, +0.1104, +0.4484, +0.2412, -0.2287, +0.0264, -0.9168, +0.1393, +0.1956, +0.2524, -0.1182, -0.2339, +0.1626, +0.1431, +0.0649, +0.0371, -0.4206, +0.0741, +0.0475, -0.3565, -0.3698, -0.1300, +0.0726, +0.0368, +0.5741, -0.1140, +0.0517, +0.1893, -0.3559, -0.4301, +0.2434, -0.2176, -0.6280, +0.4484, -0.3339, +0.4273, -0.2281, +0.6533, +0.1410, -0.0853, -0.4260, -0.4032, +0.0576, +0.0588, -0.5827, +0.2102, +0.3093, +0.0044, +0.1753, -0.0398, -0.2056, -0.0723, +0.5683, +0.3167, +0.2894, +0.4020, -0.1197, -0.0664, -0.3400, -0.1529, -0.0486, -0.8373, +0.5080, +0.5111, +0.0129, +0.3350, +0.3243, -0.7541, +0.0776, -0.2360, -0.4307, -0.1071, -0.1746, -0.1050, +0.2178, +0.1034, -0.4659, +0.0187, +0.0913, -0.6736, +0.0941, -0.4949, +0.4789, -0.1918, -0.5917, +0.7965, -0.1066, +0.1610, +0.0791, +0.2802, -0.3301, +0.4765, -0.0781, +0.0213, +0.1878, +0.0426, -1.4165, +0.3276, -0.4890, -0.6005],
[ +0.3762, +0.1437, +1.0546, -0.2836, +0.2637, -0.0826, +0.3923, +0.4735, -0.0347, -0.0310, -0.0534, +0.0497, +0.1389, +0.3416, -0.2296, -0.1223, +0.0238, +0.0437, -0.2454, +0.4597, +0.4345, +0.0904, +0.3179, -0.3921, -0.3734, +0.3854, +0.3580, +0.1193, +0.0966, +0.0017, +0.3507, +0.0435, -0.2086, -0.1813, +0.5450, +0.2774, +0.2969, -0.2604, +0.0577, +0.1105, +0.1000, +0.0929, -0.0599, -0.0841, +0.1890, +0.0320, -0.1636, -0.3413, -0.0622, -0.0770, +0.2684, +0.1320, +0.0371, -0.0496, +0.2671, +0.0270, -0.5148, -0.2085, +0.1643, +0.1065, +0.3975, -0.0703, -0.0226, +0.0919, +0.3424, +0.3849, +0.0347, +0.2009, -0.0883, +0.3542, -0.1010, +0.2456, -0.0670, -0.2096, +0.1322, +0.0316, +0.1878, -0.1558, +0.2372, -0.2039, +0.0803, +0.1304, -0.1298, -0.2025, +0.1076, -0.0135, -0.2777, +0.0022, +0.1854, +0.1841, -0.3090, +0.1722, -0.0970, +0.0769, +0.1117, +0.1324, +0.1770, +0.3757, +0.0459, -0.2542, +0.2518, +0.4598, +0.0551, -0.1139, +0.4739, -0.3376, -0.0381, +0.5212, -0.0612, +0.7047, -0.2509, -0.0486, +0.5667, -0.1761, +0.1502, -0.0948, +0.0924, +0.5119, -0.0874, +0.0142, +0.5598, -0.0529, +0.0249, +0.3512, -0.3346, -0.1272, -0.0853, -0.1746],
[ +0.6876, +0.2892, +0.3457, -0.3115, -0.1525, -0.0940, -0.9597, +0.2184, -0.0169, +0.2502, -0.1247, +0.1182, -0.1603, +0.0815, -0.2189, -0.0654, -0.0675, -0.0515, -0.0894, +0.0421, -0.1488, -0.0207, +0.4645, -0.4978, -0.2388, -0.0660, +0.0341, -0.3828, +0.0933, -0.0305, +0.2843, +0.6501, +0.0700, -0.1563, -0.5641, +0.1282, +0.3411, +0.1414, +1.0046, -0.0933, +0.2050, +0.0517, -0.2411, +0.4349, +0.3677, +0.1452, -0.1518, -0.1148, -0.1346, -0.0002, +0.1106, -0.2204, -0.1105, -0.7710, +0.3029, -0.3444, +0.1817, +0.0110, -0.3617, +0.0006, +0.1971, -0.1281, -0.1719, -0.2199, -0.0939, -0.4847, +0.1126, +0.0996, +0.1444, +0.1673, -0.3019, +0.1027, -0.3217, +0.0692, -0.3201, +0.1422, +0.2489, +0.2626, -0.4343, -0.7359, -0.0703, +0.0056, +0.1422, -0.3634, +0.4375, -0.4963, +0.2716, +0.5089, -0.5249, +0.4630, -0.3929, +0.0607, -0.0997, -0.1773, -0.3669, +0.4047, +0.5984, +0.2549, +0.0708, -0.3240, +0.6645, -0.3513, -0.3802, -0.3727, -0.2842, -0.1380, +0.2228, -0.2610, -0.1504, +0.6229, +0.0626, -0.0178, -0.1634, -0.1990, +0.0276, +0.6640, +0.2901, +0.2375, -0.6390, -0.3607, -0.2077, -0.2321, -0.0713, -0.1237, -0.3102, +0.0672, -0.4186, +0.5795],
[ -0.2102, +0.2890, -0.2758, +0.1415, -0.1117, +0.1396, +0.1364, -0.2963, +0.2868, +0.1667, -0.1267, -0.2278, -0.0438, -0.1970, -0.2024, +0.3709, -0.2089, +0.4094, -0.0797, -0.3035, +0.0230, +0.2409, -0.2157, -0.2740, -0.0254, +0.2560, +0.0722, -0.3764, +0.5113, -0.1792, +0.2713, +0.0924, +0.2372, +0.5198, -0.0365, +0.2807, +0.0707, +0.1260, -0.3105, +0.0432, -0.2485, -0.0417, +0.2449, +0.0230, -0.1244, -0.0457, +0.2303, -0.1207, +0.0273, +0.0260, -0.0382, +0.1167, -0.5012, +0.0440, -0.0593, -0.0006, -0.3234, +0.0278, +0.2636, -0.3454, +0.1070, +0.1042, -0.1009, -0.4294, -0.1774, -0.0240, +0.0264, +0.4452, -0.1202, -0.0662, -0.2027, -0.1619, -0.3369, +0.0735, -0.3622, -0.2056, +0.1786, -0.0735, +0.1978, -0.2491, -0.0969, -0.1062, +0.0241, -0.3015, -0.0373, -0.0187, +0.2149, -0.0554, +0.2089, +0.0758, +0.0950, +0.1030, -0.1193, +0.0572, -0.3277, +0.0159, -0.1699, -0.1967, +0.0998, -0.1163, +0.0045, -0.2864, -0.0266, -0.1650, -0.3307, +0.0199, -0.2485, -0.2409, +0.3353, +0.2139, +0.1382, +0.0241, -0.0374, -0.3100, +0.2040, -0.1242, -0.0200, +0.0767, -0.0194, -0.0091, -0.0839, -0.0707, +0.0000, +0.0905, -0.1803, +0.3950, -0.2423, +0.5174],
[ +0.4202, -0.0953, -0.4493, +0.5311, +0.1445, +0.5735, -0.5122, -0.7312, +0.2391, +0.2977, +0.3320, +0.1314, -0.1510, -0.2593, -0.2613, +0.5422, -0.6977, +0.1925, -0.4385, +0.0284, -0.1761, +0.3112, -0.8881, +0.1061, -0.4171, -0.1280, -0.3632, +0.1256, +1.1498, -0.1849, +0.0754, -0.5489, +0.6096, +1.0151, +0.4766, -0.0757, +0.4961, +0.1515, -0.3226, +0.4321, -0.0171, +0.1248, -0.4574, +0.1230, +0.5445, +0.0770, -0.1833, +0.2548, -0.2954, +0.2345, -0.5427, +0.6584, -0.6040, -0.0230, -0.0032, +0.1325, -0.3562, +0.1597, -0.0003, -0.1428, +0.4450, +0.0526, -0.0520, -0.2257, -0.3086, -0.0815, -0.1068, +0.4010, -0.1460, +0.0770, -0.6693, -0.5041, -0.3245, -0.1567, -0.6508, -0.2029, +0.3669, +0.0054, +0.4929, -0.1422, -0.3909, -0.1846, -0.6940, -1.0379, +0.4902, +0.2017, -0.0303, +0.1066, +0.4236, +0.2445, +0.2041, +0.1600, -0.6435, -0.1904, -0.2158, +0.0210, -0.0796, +0.4626, -0.0346, -0.3094, +0.2081, -0.4456, +0.0050, -0.4921, -0.4134, -0.3079, -0.7521, +0.1343, +0.5855, -0.4979, -0.2565, +0.1585, -0.4820, -0.2312, -0.7743, -0.6061, +0.0219, +0.3247, +0.3239, +0.3966, -1.0079, -0.3109, -0.1205, +0.1524, -0.4308, +0.1497, -0.2911, +0.2655],
[ +0.0802, +0.0852, -0.4407, -0.1603, -0.3674, -0.2896, -0.1992, +0.1208, -0.2278, +0.0305, +0.4762, +0.0074, +0.1066, -0.3402, -0.0496, -0.3070, -0.0098, +0.2256, +0.0137, +0.6308, +0.0594, +0.2237, -0.5431, -0.1659, +0.4184, +0.0462, +0.1041, -0.1696, +0.0373, +0.1371, +0.0203, -0.3347, -0.3085, -0.1353, -0.0210, -0.1386, -0.1178, -0.0312, -0.4749, -0.2589, -0.0710, +0.1246, -0.2714, -0.1992, -0.4236, -0.1512, +0.2769, +0.0153, +0.0435, -0.1038, -0.3236, +0.0972, +0.1225, +0.1774, +0.2061, -0.2722, -0.3546, -0.0559, +0.0918, -0.0342, +0.0046, +0.2007, +0.0482, -0.3863, +0.0664, -0.0194, +0.1472, -0.0861, +0.0101, +0.4891, +0.2437, -0.0649, +0.3341, -0.0418, +0.3353, -0.0172, +0.3992, -0.1390, -0.1369, +0.1858, +0.2688, +0.1902, -0.2340, -0.0338, +0.1287, -0.1435, -0.0882, +0.2619, -0.0459, -0.1617, -0.2429, +0.0724, +0.0851, +0.1221, +0.1795, +0.3192, -0.2861, -0.1352, +0.1653, +0.0778, +0.0462, +0.3147, -0.3504, +0.2441, +0.0166, +0.0193, +0.2764, -0.3346, +0.0951, -0.1342, -0.0491, -0.2674, +0.0099, -0.1644, -0.2735, -0.2288, -0.0842, +0.0425, +0.0621, -0.0207, -0.2926, -0.1745, -0.0553, +0.2154, -0.2878, +0.1670, -0.1529, -0.0322],
[ +0.3243, +0.2517, +0.1484, -0.1633, -0.5132, +0.2082, -0.0782, +0.3062, -0.9678, +0.1869, +0.5666, +0.4489, +0.6184, -0.5147, -0.3679, -0.3664, -0.1718, +0.0857, -0.2945, +0.2614, +0.5556, +0.2578, -0.1351, -0.5020, +0.7807, -0.3964, +0.2642, -0.1728, +0.3754, +0.1409, -0.5494, -0.4320, -0.4059, -0.1872, +0.3738, -0.2539, -0.2656, -0.1886, -0.5749, -0.1741, -0.2764, -0.1634, -0.5497, +0.5955, -0.1805, -0.1771, -0.2785, +0.0518, -0.8088, -0.2381, -0.8375, -0.7555, +0.1798, +0.3094, -0.0141, -0.5886, -0.7872, -0.8358, +0.1442, -0.1784, +0.7164, +0.2881, +0.2094, -0.9567, -0.1846, +0.4590, -0.0498, -0.0636, +0.6847, +0.3232, -0.1032, -0.3848, +0.4678, +0.4115, +0.5919, +0.0658, +0.5313, -0.0279, -0.1585, +0.2902, +0.6515, +0.0811, -0.3096, -0.0837, +0.0692, +0.1494, -0.1750, +0.2819, -0.1136, -0.4710, -0.7780, +0.2952, +0.6234, +0.0663, +0.0377, +0.3127, +0.5904, +0.4320, +0.4461, +0.3121, +0.2979, -0.3591, +0.0970, -0.1302, +0.6992, -0.0005, +0.4009, +0.4606, +0.0133, -0.1136, +0.1328, -0.1008, +0.2633, -0.0240, -0.7878, -0.5295, +0.2416, +0.0230, +0.1794, -0.1299, +0.2110, -0.2824, -0.4210, -0.1146, -0.4459, +0.0127, +0.2195, -0.1529],
[ +0.0964, -0.2813, -0.1214, -0.1132, -0.2150, +0.0666, -0.1740, +0.0510, +0.0738, +0.2642, +0.1200, -0.3150, +0.0325, -0.2772, -0.2122, +0.0240, -0.0549, +0.1875, +0.0986, +0.0782, -0.2799, -0.2327, +0.0777, +0.3851, +0.1167, -0.0367, +0.1808, +0.0857, +0.0034, -0.3160, +0.0843, -0.0671, -0.0531, -0.2107, +0.2095, +0.3403, +0.2127, +0.0961, +0.1144, -0.0404, -0.0842, -0.1589, -0.0458, -0.0225, +0.1755, -0.0612, -0.2036, +0.4007, +0.3044, +0.2123, +0.1638, +0.1828, +0.1322, -0.2737, -0.1399, -0.0094, -0.0450, +0.1544, +0.1764, -0.3916, -0.1666, +0.0341, -0.1101, +0.1735, +0.1899, +0.1122, +0.1806, +0.0114, -0.5312, +0.1469, +0.3118, +0.1470, +0.4097, +0.1582, -0.1897, -0.0422, +0.3497, -0.1753, +0.0019, +0.0528, -0.0250, -0.1606, +0.1460, -0.3878, -0.3684, +0.0783, -0.1196, -0.1428, +0.0197, +0.2588, -0.1397, -0.0282, -0.1650, +0.1278, +0.1632, -0.0237, +0.0463, +0.0637, -0.5178, -0.0782, -0.1466, +0.1701, +0.1654, -0.0938, +0.3431, -0.0937, +0.1538, +0.0964, +0.0839, +0.0753, +0.1694, +0.0535, +0.1251, +0.1967, -0.1445, -0.0134, -0.3257, +0.5049, +0.0368, +0.1734, -0.1333, +0.4268, -0.1026, -0.0085, -0.0277, +0.2482, -0.4903, -0.0813],
[ +0.4845, -0.0813, +0.5596, +0.1442, -0.2599, +0.2756, +1.2115, +0.6625, +0.0445, +0.0828, +0.2722, -0.2627, -0.2651, -0.2297, -0.4222, +0.0353, -0.3564, +0.0329, +0.3051, -0.6606, -0.3382, -0.3421, -0.4271, +0.9898, -0.0598, -0.4321, +0.1606, +0.1398, -0.0148, -0.6099, -0.5558, -0.0173, -0.0779, -0.3072, +0.5736, -0.1602, +0.3114, +0.1194, +0.3914, -0.0370, +0.6211, -0.5073, -0.2037, -0.4726, +0.3050, -0.3893, -0.4940, +0.0553, -0.0883, +0.3243, -0.1330, +0.3224, -0.0314, -0.6612, +0.2229, -0.4117, +0.0205, +0.6673, -0.0151, -0.5345, -0.2337, +0.1804, -0.2994, -0.3331, +0.2900, +0.3917, -0.1021, -0.2796, -0.7709, +0.0016, +0.2923, +0.3270, +0.4955, +0.3776, -0.2031, +0.0264, +0.4225, +0.1688, -0.3300, +0.2712, +0.0495, +0.0855, +0.0029, -0.1533, +0.3321, -0.4964, -0.3523, +0.1001, +0.3009, -0.3422, -0.3162, -0.6171, +0.7982, -0.0872, -0.0040, -0.2905, -0.3515, -0.0544, -0.2563, -0.4272, -0.1087, +0.3863, +0.0775, -0.4728, +0.2454, +0.1671, +0.0363, +0.1398, +0.4786, -0.2368, +0.1150, -0.4110, -0.5834, +0.3194, +0.4403, -0.0793, -0.5158, +0.4603, +0.0218, +0.6568, +0.3066, -0.4721, -0.3398, -0.0667, -0.2363, +0.3289, -0.6116, +0.0171],
[ -0.1131, -0.1884, -0.1023, -0.0124, +0.3630, +0.0357, -0.3372, +0.3509, +0.5317, -0.0256, +0.0826, +0.0603, -0.0096, -0.1519, +0.0219, +0.0461, +0.4703, +0.8128, -0.0746, -0.7126, +0.2213, +0.0058, -0.4048, -0.2423, +0.6751, -0.2444, -0.2228, +0.0794, -0.2437, +0.0205, -0.0554, -0.2247, +0.0485, -0.0851, +0.7370, +0.1417, +0.0739, -0.0236, -0.1062, +0.4809, +0.2952, -0.1990, +0.1880, -0.1727, -0.3276, +0.3920, +0.3854, -0.1694, +0.1613, +0.1137, +0.2739, +0.3941, -0.1940, +0.0344, +0.7429, -0.1756, -0.4297, +0.1874, +0.5353, -0.3042, -0.0539, +0.0938, +0.1091, -0.4153, -0.1440, -0.2985, +0.1220, +0.1572, +0.0595, +0.0669, +0.2988, -0.2746, +0.5681, +0.0985, +0.0770, -0.3644, +0.0925, +0.1663, +0.5665, +0.0351, -0.0713, -0.4162, -0.1201, +0.5780, -0.1469, +0.3255, +0.3916, +0.1974, +0.1765, -0.1781, -0.1234, +0.2579, +0.0802, -0.0824, -0.1170, +0.2681, +0.0870, +0.5886, -0.2772, -0.0080, -0.0041, -0.0223, -0.2441, +0.1458, +0.6532, -0.3004, +0.3168, +0.8476, -0.1945, +0.5276, +0.3049, -0.2039, +0.1032, -0.0619, +0.4550, -0.0014, -0.4110, -0.1853, +0.5023, +0.3930, +0.3307, +0.2101, +0.2918, -0.1234, -0.1785, -0.2181, +0.1250, +0.1488],
[ +0.2819, -0.1016, +0.1208, -0.1138, -0.1146, -0.0581, +0.0480, +0.0615, +0.0495, -0.1008, -0.0235, -0.0292, +0.0998, -0.1373, +0.0563, -0.0939, +0.1559, -0.0115, +0.0110, -0.0863, -0.1031, -0.2560, +0.0641, -0.3819, +0.2299, -0.5826, -0.1517, +0.0271, -0.1888, +0.0705, -0.0631, +0.0212, +0.0145, -0.0057, +0.2593, -0.4411, +0.7128, -0.1567, -0.1386, +0.0860, +0.3602, -0.1230, -0.1010, +0.5377, +0.1908, +0.3012, +0.1006, -0.1061, -0.0179, +0.1335, -0.0039, +0.0631, -0.0595, -0.1512, +0.0454, -0.0351, -0.1746, +0.1099, +0.4610, -0.1700, -0.0651, +0.0189, -0.0276, -0.1634, -0.0285, +0.0775, +0.1601, +0.0366, -0.0961, -0.2265, -0.1772, -0.5698, +0.0611, -0.0834, +0.1289, +0.0439, +0.1060, +0.1104, +0.0784, +0.1059, -0.1838, -0.3578, -0.7125, +0.2980, +0.0846, +0.1012, -0.0254, -0.0224, -0.0118, +0.5632, -0.1002, +0.0624, +0.1792, -0.1879, -0.1343, +0.1028, -0.1495, +0.1556, +0.0022, +0.0823, +0.0838, -0.2772, -0.1674, -0.0607, -0.6154, -0.1904, +0.2447, -0.0237, +0.1747, -0.1519, -0.0018, +0.1226, +0.3426, -0.0941, +0.2248, +0.4729, -0.3354, +0.1179, -0.0668, +0.2849, +0.1252, +0.1206, -0.2537, +0.3209, +0.1078, -0.0857, +0.0314, -0.2371],
[ -0.0123, +0.0730, -0.3817, +0.0688, +0.1177, -0.2292, -0.1358, -0.0018, +0.0603, +0.0841, -0.0430, +0.0219, +0.0195, +0.0649, -0.0100, -0.0288, -0.0503, -0.1122, +0.0343, -0.1068, +0.1601, -0.1120, +0.2503, +0.0141, +0.0545, +0.2783, +0.0086, -0.0353, +0.0561, +0.0372, -0.1599, -0.0985, -0.0502, +0.0241, +0.1100, +0.1801, -0.2681, +0.0068, +0.0559, +0.0108, +0.0700, -0.0090, +0.0079, -0.3744, +0.2401, -0.0840, -0.0619, +0.1848, +0.0096, -0.1007, -0.0573, +0.1424, +0.0311, -0.0853, -0.0291, -0.0388, +0.0156, -0.0607, +0.0264, -0.1278, -0.1272, -0.0735, +0.0051, +0.2642, +0.1195, +0.1098, -0.0580, +0.0227, +0.0430, -0.2345, -0.1763, -0.0376, +0.0221, +0.0085, +0.1705, -0.0265, +0.0210, -0.0408, +0.0194, +0.0672, +0.0041, -0.0783, -0.1060, -0.0035, -0.0148, -0.1343, +0.0452, -0.0313, +0.1163, -0.1359, +0.0117, -0.1630, +0.0153, -0.0298, -0.1189, -0.1039, -0.1065, -0.0224, +0.0744, +0.1388, -0.0647, -0.0562, -0.0204, -0.0398, -0.0984, -0.0740, -0.0243, +0.4633, -0.2718, +0.3439, +0.0984, -0.0445, -0.3940, +0.0221, +0.1075, -0.2018, -0.0178, +0.2145, +0.0741, -0.0361, +0.0224, +0.0384, -0.0527, +0.0130, -0.0196, -0.0463, -0.0166, +0.1520],
[ +0.4033, -0.0611, -0.0248, -0.0563, -0.0997, -0.0627, -0.1308, +0.2584, +0.0483, -0.1499, +0.1183, +0.1033, +0.0846, +0.3533, +0.0984, -0.0506, +0.1770, -0.1423, -0.0001, -0.0862, +0.2407, -0.0940, -0.2265, +0.1954, -0.0475, +0.2577, -0.5254, +0.0296, -0.1875, +0.1727, -0.0980, -0.0270, -0.1531, -0.2955, +0.0599, +0.1918, +0.0883, +0.2301, -0.2977, +0.0286, +0.0761, -0.0491, -0.0356, +0.3759, +0.0748, -0.4216, +0.1708, -0.0513, +0.3791, -0.0905, -0.2157, -0.1655, +0.0153, -0.0068, +0.1177, -0.0433, +0.3243, +0.1605, -0.4613, +0.2260, -0.0001, -0.1733, +0.1277, +0.3671, +0.0817, -0.0242, -0.0581, +0.0861, -0.3455, +0.1873, +0.4850, -0.7832, +0.1031, +0.1952, -0.1888, -0.1452, -0.2275, +0.0421, -0.1323, +0.1516, +0.0757, +0.0762, +0.0861, -0.0543, +0.0033, +0.1209, +0.0569, +0.0063, +0.0490, -0.0280, +0.0103, +0.0769, +0.2758, -0.0046, -0.4853, +0.0660, +0.1353, -0.1286, +0.1738, +0.0273, -0.1501, +0.3795, +0.1081, +0.0251, -0.1813, +0.2142, +0.1547, +0.2665, +0.1785, +0.0601, -0.2273, -0.0725, +0.6607, +0.1654, +0.2661, -0.2531, +0.2036, -0.1635, -0.0436, -0.1289, +0.0742, +0.1177, -0.0289, -0.1706, -0.1896, -0.0214, -0.0545, +0.2153],
[ +0.2600, -0.0990, +0.2052, -0.4189, -0.2386, +0.2896, +0.5329, +0.7830, -0.0933, -0.0126, +0.1461, -0.2459, +0.1656, -0.0769, -0.2517, +0.1358, +0.0883, -0.1262, -0.2702, +0.1573, -0.0471, -0.0544, +0.6106, -0.3650, -0.3037, +0.2599, +0.4534, -0.2017, +0.0198, -0.2209, +0.3604, -0.1089, -0.1575, +0.0605, +0.1965, +0.3490, +0.5162, +0.4372, +0.1219, -0.1002, -0.1420, +0.2030, +0.1029, +0.2702, +0.5030, -0.0216, -0.1876, +0.2001, -0.0599, -0.0200, +0.5783, +0.0174, +0.0075, -0.0979, -0.0745, -0.3855, +0.1144, +0.1412, -0.0218, +0.0122, +0.1740, -0.3451, +0.1085, -0.0063, +0.2479, +0.0921, -0.0825, -0.1543, +0.0515, +0.1965, +0.5385, +0.4584, +0.5065, -0.1502, +0.3271, -0.0309, -0.1589, -0.0118, +0.0415, +0.0213, -0.1874, +0.1281, +0.3382, +0.1382, -0.0404, +0.1993, -0.3125, -0.5275, -0.2537, +0.5509, -0.2774, +0.0439, +0.2723, +0.0535, +0.0582, -0.3883, +0.3427, +0.0198, -0.1759, -0.0879, +0.0795, +0.5949, +0.2451, -0.0239, +0.2217, +0.0369, -0.2210, +0.0084, +0.1562, +0.1497, +0.4939, +0.0338, +0.0924, -0.4258, +0.0130, -0.0448, -0.2349, +0.4100, +0.1281, -0.0982, +0.1066, +0.1489, -0.1422, -0.2565, -0.2198, -0.4026, -0.3516, +0.2038],
[ +0.0752, -0.1651, +0.3651, +0.1877, -0.8652, -0.2114, +0.3995, +0.5051, -0.2182, -0.3305, +0.4486, -0.1433, +0.1396, -0.3323, -0.0886, +0.3074, +0.6865, -0.1026, -0.3352, +0.1244, -0.4439, +0.0452, +0.3996, -0.1318, -0.4890, +0.5517, -0.1387, -0.0229, +0.0153, -0.5569, -0.4975, -0.1563, +0.0202, -0.2169, -0.2241, -0.4916, +0.5866, +0.7699, +0.3427, -0.3848, -0.6746, -0.1559, +0.3443, +0.1776, -0.3773, +0.1173, -0.0781, +0.0967, +0.1911, +0.1174, -0.0568, -0.2705, +0.1301, -0.2671, -0.0272, -0.1705, +0.1128, -0.1273, -0.3010, +0.1625, -0.1454, -0.5266, +0.4034, +0.1873, +0.2859, -0.4372, +0.1971, -0.2142, +0.1909, -0.1645, +0.0596, -0.0088, +0.4053, -0.2436, -0.0874, -0.3117, -0.0738, +0.6170, -0.2544, +0.2545, -0.2626, +0.0550, +0.3773, +0.0206, -0.3901, +0.3849, -0.0923, -0.5639, -0.0758, +0.1362, -0.0085, -0.1686, -0.2045, -0.1880, -0.5074, -0.3698, +0.6205, +0.1987, -0.1569, -0.2908, -0.2635, +0.1889, +0.6028, -0.2267, -0.5122, -0.1529, -0.1609, -0.4517, +0.4907, -0.1168, +0.3226, +0.0510, +0.3944, -0.3980, -0.1664, -0.3984, -0.2209, +0.0601, +0.2432, +0.2081, +0.0476, +1.0066, -0.2134, -0.0828, -0.1782, -0.4836, +0.0246, +0.4805],
[ -0.0400, -0.1693, +0.1208, +0.0594, +0.5562, -0.2521, -0.0553, +0.2498, +0.0035, -0.1446, +0.1831, +0.2342, -0.1087, +0.1424, -0.0659, +0.1642, -0.1226, +0.0597, -0.4083, -0.3198, +0.1470, +0.0580, +0.0846, +0.1428, -0.0532, +0.2144, +0.4093, +0.0160, -0.4286, -0.1653, +0.3365, +0.0443, +0.0821, -0.2129, +0.0510, +0.2726, +0.4494, +0.4672, -0.0851, -0.1343, -0.0099, -0.0063, +0.2179, +0.0525, +0.2914, +0.0086, +0.0144, -0.5057, +0.0168, -0.0906, +0.2131, +0.0548, -0.1579, -0.0909, +0.2945, +0.2738, +0.1786, -0.0811, -0.0486, +0.1894, +0.2200, +0.1206, +0.0858, +0.2875, -0.1481, +0.0024, -0.1874, +0.0436, +0.0014, +0.0161, +0.0668, +0.2140, +0.1705, -0.0074, +0.5376, -0.4440, +0.0025, -0.2433, -0.0850, +0.0821, -0.1934, +0.0239, +0.1245, -0.2070, +0.0888, -0.1807, -0.0547, -0.1732, +0.1548, +0.2936, +0.1511, +0.4034, -0.0548, -0.2841, -0.1034, +0.0751, +0.1792, -0.1280, -0.1802, +0.2338, -0.2139, -0.0917, -0.2921, -0.1407, +0.2168, -0.1262, -0.1308, -0.0834, -0.1948, +0.0297, +0.2829, -0.4319, +0.5121, -0.3715, +0.3672, +0.0012, +0.0468, +0.6905, -0.1409, +0.0682, +0.0588, +0.5509, +0.3352, +0.1272, -0.3672, -0.0086, +0.2601, +0.8177],
[ +0.4188, -0.8219, +0.1089, +0.1761, +0.7429, +0.0511, +0.1799, +0.6307, +0.2165, -0.0038, -0.3460, +0.0956, -0.0429, +0.2095, -0.3950, -0.2261, -0.4543, +0.3164, +0.0007, -0.3031, -0.0245, +0.0116, -0.1487, +0.5214, -0.7345, +0.1424, +0.3063, +0.3971, -0.4165, -0.3428, +0.1385, -0.6403, +0.1236, -0.6090, -0.0063, -0.0233, +0.0458, +0.2146, -0.2546, +0.1780, -0.3549, +0.2880, +0.4575, +0.5286, +0.0018, -0.0618, -0.0550, -1.0945, -0.1430, +0.0485, +0.1386, +0.4331, -0.1422, -0.1407, +0.0309, +0.7736, -0.1123, +0.3348, +0.2868, +0.0580, +0.6707, +0.3394, +0.1186, +0.4459, -0.7397, -0.2943, -0.7476, -0.4708, +0.3939, +0.8113, +0.2044, -0.1087, -0.2181, -0.1190, +0.0828, -0.2753, +0.1744, -0.5486, -0.6359, +0.6100, -0.1407, +0.2204, +0.8416, -0.3475, +0.0268, -0.4567, -0.0994, +0.0954, -0.0787, -0.4271, +0.1931, -0.1284, -0.4671, -0.1976, -0.1566, +0.8115, +0.3813, +0.7006, +0.0878, -0.2220, -0.3854, +0.2917, -0.1109, -0.2340, +0.0039, -0.1798, -0.2667, -0.0572, -0.9754, +0.4806, -0.2286, +0.1635, +0.1726, -0.4726, +0.0489, -0.6074, -0.0430, -0.3362, +0.0127, +0.2562, -0.2384, +0.0394, +0.5303, +0.4956, -1.0252, +0.5423, +0.0719, +0.6307],
[ -0.0236, +0.4932, -0.8043, -0.0973, -0.1690, -0.1784, -0.3016, -0.2377, +0.1509, -0.0891, +0.0994, +0.0903, +0.0632, -0.4391, +0.2212, +0.0772, +0.0550, +0.0018, -0.1052, -0.3909, -0.2092, -0.0948, -0.1151, +0.0413, +0.0234, -0.1314, -0.4942, -0.2671, +0.0960, -0.2047, -0.1572, +0.0162, +0.0443, -0.0032, -0.7156, -0.3243, -0.0384, -0.1030, +0.2405, +0.2277, +0.1506, +0.2399, -0.2285, +0.2365, -0.3952, -0.1658, +0.0367, -0.2083, -0.1495, +0.0065, -0.1280, -0.1918, -0.0488, +0.0672, -0.0310, +0.0275, -0.3396, -0.1828, -0.0591, -0.2108, +0.0585, +0.3785, -0.1612, -0.2592, +0.2239, -0.3743, +0.0164, -0.0537, -0.3059, -0.0449, +0.4059, -0.6368, +0.1078, +0.1051, -0.2226, -0.1026, +0.1831, +0.1957, +0.0413, -0.0303, -0.0922, +0.0583, -0.1951, -0.0443, -0.1008, -0.0208, +0.3215, +0.2155, +0.0133, -0.2493, -0.1160, -0.1820, +0.0382, -0.1048, -0.1710, -0.1108, -0.0928, -0.1071, -0.2703, +0.1303, +0.0523, -0.0608, -0.1299, -0.0223, -0.1813, +0.1287, +0.2913, -0.5361, +0.0968, -0.3857, -0.3833, -0.2251, -0.5407, +0.1559, -0.1203, +0.0197, -0.1299, -0.2264, +0.1071, +0.2982, -0.4565, -0.0334, +0.1575, -0.0718, +0.0823, -0.1482, +0.2796, -0.0785],
[ +0.9657, +0.5391, -0.4886, +0.3217, -0.4974, +0.1666, +0.3191, -0.2855, -0.1771, -0.0630, -0.2687, +0.0019, +0.5504, -0.1396, +0.1195, -0.2312, -0.1731, +0.1084, -0.4914, -1.2702, -0.3968, -0.1176, -0.6774, -0.1117, -0.1315, +0.0756, -0.0090, +0.3214, +0.3530, -0.0777, -0.1898, -0.0292, -0.0592, -0.1948, -0.7041, -0.1482, -0.3869, +0.3483, +0.2116, +0.4901, -0.5411, -0.4038, -0.1148, -0.0748, +0.5733, -0.0656, -0.0181, -0.7605, -0.3196, +0.0400, +0.2616, +0.4255, +0.3768, +0.2355, +0.3484, +0.1137, -0.1988, -0.5268, +0.5851, -0.1780, +0.5895, +0.0537, -0.3276, -0.1818, +0.2637, +0.5429, -0.1814, +0.2935, +0.0469, -0.6839, +0.3675, -0.2544, -0.4837, -0.1330, +0.3830, -0.2311, -0.0473, +0.2437, -0.0463, -0.2148, -0.1425, -0.0728, +0.0437, -0.1449, -0.2350, +0.0960, -0.6002, +0.0465, +0.4215, +0.3561, +0.0780, -0.3436, +0.2906, +0.4220, +0.1082, +0.1987, -0.5154, +0.3729, +0.4239, +0.2464, +0.2924, -0.4973, +0.0575, -0.2058, +0.0909, +0.1077, +0.3479, +0.4514, -0.0840, +0.1234, -0.2731, -0.3543, -0.7532, +0.4607, +0.3989, +0.0152, +0.1909, -0.0231, +0.4345, +0.4169, -0.0608, +0.1713, +0.2750, +0.3530, +0.4265, -0.3935, +0.3390, -0.2986],
[ +0.0197, +0.0832, +0.2901, +0.1843, -0.0515, +0.4274, +0.1710, +0.0956, +0.3706, -0.0990, -0.2957, -0.1642, +0.0052, +0.0296, -0.2310, -0.2589, -0.0207, +0.3195, +0.1189, +0.0894, +0.1261, -0.3735, +0.2226, -0.0407, -0.2029, +0.4543, +0.0626, -0.0652, +0.1124, +0.0749, +0.3006, +0.3256, -0.0073, -0.2301, -0.0723, +0.1620, +0.2681, +0.3119, -0.1610, -0.1010, -0.5195, +0.0428, -0.1670, +0.1659, -0.1428, -0.1844, +0.0050, +0.3921, -0.0289, -0.1232, -0.0511, +0.0333, -0.2519, -0.0684, -0.2016, +0.1231, +0.2311, -0.1187, +0.1793, +0.0790, +0.6507, -0.2851, -0.0384, +0.0938, +0.2268, +0.3493, -0.0920, -0.0098, -0.0587, +0.3124, +0.0911, +0.6562, +0.0437, -0.5152, +0.3229, +0.0840, +0.0427, -0.2638, +0.0551, -0.0293, -0.0951, +0.2424, +0.1977, +0.2647, -0.1228, -0.0747, -0.0810, -0.0943, -0.3281, +0.4843, -0.3743, +0.2281, -0.1004, +0.1352, +0.0488, +0.1874, -0.2387, -0.2279, +0.0289, +0.1772, -0.1100, +0.2639, -0.2171, -0.1496, -0.2803, +0.1399, -0.0765, +0.0831, +0.1690, -0.0683, +0.0891, -0.3557, +0.0125, +0.0287, +0.1011, -0.1216, -0.2380, +0.2871, +0.0063, +0.0067, -0.3675, +0.2489, +0.0485, +0.2529, -0.1813, +0.2062, -0.2078, +0.3231],
[ -0.5468, -0.1024, +0.0166, +0.3904, -0.4238, +0.3237, +0.3643, -0.0432, +0.5388, -0.1903, -0.0291, -0.0739, -0.1506, -0.0619, -0.2286, -0.2223, +0.2555, +0.3411, +0.0059, -0.1516, +0.2735, -0.5639, +0.2326, +0.0282, -0.1971, +0.2611, -0.5961, +0.0598, +0.2074, -0.0748, +1.0556, -0.0046, +0.2938, -0.5105, +0.2669, +0.2683, +0.6128, +0.7666, -0.1267, -0.1747, -0.7618, +0.1779, +0.1168, -0.0648, +0.2546, +0.0411, +0.1306, +0.2403, +0.0682, +0.0280, +0.0568, -0.5276, -0.5090, +0.0851, -0.1705, +0.3974, -0.2124, -0.0152, +0.0092, +0.5470, +0.0017, -0.3094, +0.1700, -0.2243, +0.5634, +0.1140, -0.4541, +0.0066, +0.4623, -0.2693, -0.1255, +0.2549, +0.1817, -0.2493, +0.0903, -0.1313, +0.2123, -0.3519, -0.1504, +0.0341, -0.1763, +0.3519, -0.0929, +0.5007, -0.1123, +0.0340, -0.3871, +0.0641, -0.5423, +0.6644, -0.1267, +0.2545, +0.0553, -0.2231, +0.3744, +0.1808, +0.1335, -0.2751, +0.2908, +0.1184, -0.0914, +0.6776, -0.2217, -0.1955, -0.5595, +0.1962, -0.0034, +0.1685, -0.0597, +0.0609, +0.2291, -0.5412, -0.6971, +0.3045, -0.0322, -0.4896, +0.1727, +0.1257, +0.0618, +0.0932, +0.0402, -0.1801, +0.2379, +0.2918, -0.4530, +0.0666, +0.4164, +0.0354],
[ -0.3088, -0.0912, -0.0045, +0.4230, -0.0171, -0.3747, -0.3634, +0.0408, -0.1245, -0.1040, +0.0709, +0.2898, +0.1473, +0.1200, -0.1270, +0.1558, +0.0405, -0.0109, +0.0321, -0.0617, +0.0056, +0.2363, +0.1412, +0.0004, +0.4876, -0.0423, +0.0030, +0.1556, -0.2015, +0.0922, +0.2763, +0.2675, -0.0182, +0.0448, +0.1681, +0.0932, -0.3139, -0.3487, +0.0723, +0.0306, -0.1533, -0.0819, +0.2258, -0.0101, +0.4859, +0.1141, +0.2432, -0.0742, +0.0914, -0.1595, -0.1728, -0.2104, +0.2868, -0.0748, +0.1411, -0.3992, +0.1555, -0.0612, -0.1432, +0.0350, +0.1636, +0.2034, +0.2937, +0.3793, -0.5345, -0.2583, -0.1176, -0.0139, -0.2111, -0.0878, -0.0674, -0.1804, -0.0605, -0.0868, +0.1541, +0.0894, -0.0774, -0.1349, -0.1189, -0.0253, +0.0576, -0.0019, -0.2242, -0.0368, +0.2952, -0.0504, -0.5341, -0.0256, -0.2303, +0.0197, +0.0124, +0.1453, -0.0229, +0.0482, -0.3298, +0.1812, +0.3730, -0.0400, +0.0223, -0.1432, +0.1021, -0.2563, +0.0152, -0.0232, +0.4017, +0.2864, -0.1531, -0.0075, +0.2001, +0.0070, -0.2590, +0.1986, +0.4734, -0.0228, +0.2061, +0.0762, +0.0840, +0.0250, -0.1410, +0.0050, +0.3629, +0.3544, -0.0079, +0.1193, +0.3333, -0.0075, +0.2500, +0.3029],
[ -0.3783, -0.2846, +0.1749, +0.1480, +0.4713, +0.0640, -0.3743, +0.1719, +0.3128, +0.0476, -0.1749, +0.4652, +0.2345, +0.2588, -0.3334, +0.1028, +0.5190, -0.4267, +0.0410, -0.2192, +0.4144, +0.1966, +0.3753, -0.3285, +0.4361, -0.2808, +0.4847, -0.0687, -0.3018, -0.2266, +0.2126, +0.4526, -0.2024, -0.2980, -0.0590, -0.1674, -0.6165, -1.1431, -0.2766, +0.2167, +0.1211, -0.3169, +0.3275, -0.2992, -0.2794, -0.5439, +0.3387, +0.4004, +0.4764, -0.1501, -0.2052, -0.3623, +0.1480, -0.3270, +0.6566, -0.3290, -0.1481, +0.3368, -0.3886, -0.4635, +0.4355, +0.5022, +0.3976, +0.6395, -1.0909, -0.5170, -0.0875, +0.2283, -0.7894, +0.3101, -0.4219, +0.7071, -0.5804, +0.0016, -0.5652, +0.2542, +0.0135, -0.0231, -0.3645, -0.1990, +0.1714, -0.3400, -0.0028, -0.2686, +0.2962, -0.0776, -1.0121, -0.0422, -0.6606, -0.4588, +0.2572, +0.1963, -0.4216, -0.0879, -0.1895, -0.0525, +0.4040, -0.9062, -0.0590, +0.0080, -0.2018, +0.7731, -0.0877, +0.1242, +0.2124, +0.2937, -0.1931, -0.5369, -0.0783, -0.1614, +0.0597, +0.1056, +0.1435, +0.0400, -0.6970, +0.8603, +0.0449, +0.0060, +0.0300, +0.2735, -0.1557, -0.1932, -0.1419, +0.3678, +0.2821, +0.0046, +0.2296, +0.4082],
[ +0.2380, +0.0081, -0.2393, -0.0928, -0.0209, +0.0956, -0.1200, -0.1818, +0.0449, -0.0847, -0.1977, -0.2318, +0.1256, -0.3529, -0.0930, +0.0345, -0.1989, -0.6479, -0.2364, -0.2402, +0.1069, +0.2080, +0.0715, -0.3937, -0.1688, +0.0489, -0.0320, -0.1329, +0.0940, -0.0314, +0.1458, -0.0181, +0.1110, +0.0094, -0.2962, -0.2264, +0.2878, +0.2956, -0.3261, +0.1256, +0.2774, +0.1057, +0.0177, -0.1929, -0.1472, -0.4070, -0.3980, +0.2318, +0.0841, +0.2219, -0.4079, -0.1691, -0.1614, -0.0901, -0.2564, +0.2606, +0.3500, +0.2127, -0.2771, -0.0793, -0.3667, +0.0058, -0.0644, -0.3206, +0.2414, -0.0046, -0.0027, -0.2527, +0.4095, +0.2653, +0.2939, -0.0058, +0.2405, -0.0360, -0.0629, +0.0335, +0.1890, -0.4815, -0.0267, -0.0486, -0.0813, +0.1023, +0.4114, +0.3131, +0.2498, -0.0428, +0.1808, -0.2088, -0.2115, -0.3141, +0.0775, +0.1622, -0.0926, -0.0337, +0.3216, -0.1403, -0.3542, -0.3385, -0.0781, +0.1013, -0.0022, +0.4625, +0.0825, +0.2227, -0.2928, -0.1510, +0.4184, -0.2774, +0.0893, +0.0073, +0.3198, -0.2440, -0.1871, +0.0666, -0.0014, +0.3026, -0.0110, -0.0298, +0.1110, +0.2974, -0.2447, -0.1064, -0.1849, +0.2416, -0.1328, +0.1592, -0.1387, -0.1724],
[ +0.7789, +0.3226, +0.1947, +0.0537, +0.2445, -0.1491, +0.4249, -0.4211, +0.0316, -0.2972, +0.0423, -0.0065, +0.3317, -0.3942, +0.0169, -0.0151, +0.2221, -0.6036, -0.6427, +0.1817, -0.3604, -0.0616, +0.0586, -0.5988, -0.2959, +0.0084, -0.0767, +0.2535, +0.3356, +0.1207, +0.0082, -0.5540, +0.2562, -0.4036, +0.4781, -0.1950, -0.1713, +0.3667, -0.0907, +0.0188, +0.5734, +0.2693, -0.3753, -0.8163, +0.4174, -0.2414, -0.7318, +0.1036, -0.4394, +0.1837, -0.3420, +0.2318, -0.2684, +0.3148, -0.4051, +0.2091, -0.2221, +0.3075, -0.4144, +0.2647, -0.2537, -0.1653, +0.1330, +0.0586, +0.2348, +0.0518, -0.3967, -0.6090, +0.6927, +0.0357, +0.3661, -0.0917, +0.1998, +0.1525, -0.4312, +0.1006, -0.2145, -0.5226, +0.0449, +0.2391, +0.1106, +0.1163, -0.0901, +0.3796, +0.0924, +0.0282, +0.2458, -0.0218, -0.1119, -0.7173, +0.1649, -0.1163, +0.1994, -0.0446, +0.2214, +0.0485, -0.2121, -0.5597, +0.0793, +0.0284, -0.0951, +0.4254, +0.1769, +0.0078, -0.5708, +0.0986, +0.4790, -0.1962, +0.2396, -0.0380, +0.6720, -0.2060, -0.0392, +0.0861, +0.1401, -0.3203, +0.3046, -0.5218, +0.0799, +0.4216, -0.1769, +0.5211, -0.2026, +0.2574, -0.1235, +0.1730, +0.0010, -0.5590],
[ +0.1996, -0.2210, -0.3012, +0.0987, +0.6847, +0.8370, -0.1918, +0.0964, -0.4458, +0.1663, -0.2282, +0.2463, +0.0037, +0.3360, -0.2742, -0.0837, +0.3874, -0.5052, +0.1844, +0.1734, -0.1121, -0.1374, +0.0437, -0.2601, -0.3681, +0.0521, -0.4138, -0.0742, -0.4406, -0.0026, +0.2577, +0.6256, +0.6398, -0.1567, -0.6100, +0.2921, +0.3082, -0.0046, -0.0024, +0.0516, +0.0294, -0.0996, +0.4710, +0.2937, +0.0173, -0.0302, -0.0930, +0.1914, +0.4952, -0.2471, +0.1780, -0.2728, -0.4715, +0.2442, +0.0510, +0.2392, +0.1644, +0.6214, +0.1083, -0.0950, +0.5007, +0.1876, -0.7464, -0.3234, +0.0337, -0.3762, -0.1397, -0.2514, -0.3542, +0.2286, -0.2056, -0.4625, +0.2683, +0.2489, +0.1256, -0.1503, -0.0260, +0.4389, -0.4128, +0.0644, -0.3119, +0.5083, -0.3926, +0.0017, -0.1445, +0.3419, +0.0841, -0.2256, +0.1970, +0.2875, -0.1904, -0.1122, -0.0982, +0.0931, -0.0904, +0.0559, -0.1804, +0.3030, +0.0460, +0.3411, -0.2670, -0.3295, +0.3798, +0.1220, -0.4070, -0.0715, +0.2495, +0.6508, +0.3631, +0.1831, +0.0407, +0.0303, -0.1278, +0.1642, +0.0938, -0.0081, -0.1437, +0.0928, +0.1338, -0.3138, +0.1828, +0.4369, +0.0913, -0.3345, +0.0459, -0.0701, -0.2482, +0.3154],
[ +0.1235, -0.0985, +0.0917, -0.1250, +0.3720, -0.1406, +0.2572, +0.1456, -0.0322, -0.0083, -0.1634, +0.1354, +0.1355, +0.4275, +0.1423, -0.0368, +0.1400, -0.3989, +0.2613, -0.0949, +0.2215, +0.1251, -0.0271, -0.2659, -0.2422, -0.0908, -0.0372, -0.0022, -0.2609, +0.0323, -0.2295, -0.0827, +0.4757, +0.2506, -0.9901, +0.6095, -0.1742, -0.3448, +0.0250, +0.2827, +0.4155, -0.0061, -0.0442, -0.0987, +0.0058, -0.1497, +0.1073, +0.0173, +0.4222, -0.2206, +0.2197, +0.2772, -0.3356, +0.1780, +0.1720, +0.0081, -0.2142, +0.4406, -0.0671, -0.1619, +0.1663, -0.0702, -0.1633, +0.1246, +0.2809, -0.3714, +0.0556, +0.1719, -0.0638, +0.0717, +0.3675, -0.2216, -0.3005, -0.1915, -0.3763, -0.0415, +0.0306, +0.0052, -0.2474, +0.0520, -0.1143, +0.3297, -0.2218, -0.0825, -0.0549, -0.0028, +0.2803, +0.0604, -0.1364, -0.2286, -0.1272, -0.1501, +0.2543, +0.0735, +0.0179, +0.0704, +0.0222, +0.2191, +0.0320, +0.2147, +0.0790, +0.3473, -0.0885, +0.0609, -0.2625, +0.0274, +0.2264, -0.3547, -0.2608, +0.1218, +0.1915, +0.0722, +0.3651, +0.0817, -0.5410, +0.3935, -0.0242, +0.1319, +0.0666, +0.0014, +0.0561, -0.0305, +0.0316, +0.1258, -0.0190, -0.1594, -0.0127, -0.0423],
[ +0.1228, -0.0388, -0.2688, -0.0046, -0.0074, -0.0947, +0.1409, +0.4431, -0.0282, -0.0086, +0.0529, +0.0066, +0.0033, -0.1846, -0.0209, +0.0036, -0.0396, +0.1228, +0.0333, +0.0769, +0.1245, +0.0346, +0.2693, -0.0544, +0.1087, -0.1712, -0.1462, +0.0215, +0.0157, -0.0015, -0.2738, +0.0526, -0.0491, +0.0593, +0.0734, -0.0091, -0.2092, -0.0475, +0.0265, +0.0066, -0.0365, +0.0876, -0.0240, -0.1499, +0.3757, -0.0569, -0.0521, +0.0991, -0.1254, +0.0012, -0.0714, -0.0608, -0.0035, +0.0589, +0.0344, -0.0797, -0.0176, -0.0058, +0.1200, -0.0694, +0.2137, +0.0546, +0.0543, -0.1194, -0.0087, -0.1492, -0.0209, -0.0053, -0.0641, +0.1805, +0.0483, +0.0078, -0.1291, -0.0008, +0.1364, +0.0560, +0.0461, -0.0003, +0.0826, -0.0421, +0.0287, +0.0376, -0.1337, +0.0432, -0.0165, +0.0036, +0.0525, +0.0332, +0.0830, +0.2102, +0.0228, -0.2194, -0.0166, +0.0153, +0.0083, -0.0208, +0.1284, +0.0008, -0.0936, -0.0423, -0.0103, +0.4146, -0.1188, +0.1903, -0.2786, +0.0928, +0.0540, -0.1740, -0.0491, -0.1509, +0.0671, +0.0102, +0.4449, -0.0500, +0.0322, -0.1408, +0.0139, +0.1266, +0.0206, +0.0307, -0.1858, +0.0698, +0.0486, -0.0866, -0.0462, +0.0825, +0.0406, -0.0752],
[ -0.2525, -0.3993, -0.0806, -0.2168, -0.1889, -0.0303, -0.2743, +0.0976, +0.1045, +0.0747, +0.2655, +0.1176, -0.0866, -0.0073, -0.0658, -0.1369, +0.4020, -0.0645, +0.0422, +0.0485, -0.1895, +0.0695, +0.0722, -0.1082, +0.1355, -0.5678, +0.0404, +0.0727, +0.0789, +0.1706, -0.2632, -0.2328, +0.0468, +0.2843, -0.2507, -0.1043, -0.5609, -0.0010, +0.1351, -0.0847, -0.2274, +0.0579, -0.0464, -0.0495, -0.0090, -0.0437, +0.0590, +0.1376, -0.0560, +0.1828, -0.2075, -0.2528, -0.0373, -0.1410, +0.1075, +0.0852, -0.1632, +0.2402, -0.0202, -0.1088, +0.1613, -0.2031, +0.0025, -0.0211, -0.2304, -0.1403, +0.0914, -0.0599, +0.2931, -0.0777, +0.2456, +0.2085, -0.2089, -0.0527, -0.1238, -0.0537, -0.1834, +0.0493, -0.0772, +0.1103, -0.0162, -0.0388, -0.1474, -0.0477, -0.0550, +0.1392, -0.0054, +0.0964, -0.1381, +0.0361, -0.0187, -0.0928, +0.1557, -0.4361, +0.5560, -0.0888, +0.1594, +0.1508, +0.1013, +0.1123, -0.1363, +0.4324, -0.2045, +0.3986, -0.0738, -0.0388, +0.0452, +0.0001, -0.1309, -0.1501, +0.3146, +0.0325, +0.1639, -0.0093, +0.0359, +0.0523, +0.0638, +0.6743, -0.0713, +0.0017, +0.7870, -0.0397, -0.0649, -0.0543, +0.0086, -0.1236, -0.0683, -0.9280],
[ -0.4083, +0.3155, +0.1931, -0.1325, +0.2922, -0.0298, -0.4052, +0.1134, -0.5541, -0.2688, -0.4304, -0.1269, -0.0535, -0.4183, -0.0898, -0.5060, -0.0834, -0.2039, -0.2373, -0.4959, +0.2312, +0.2927, -0.4156, +0.3995, -0.2736, +0.5962, +0.2976, +0.0816, +0.2111, +0.3043, -0.1431, -0.4342, -0.0545, -0.0385, +0.2557, -0.0653, +0.3316, +0.3180, +0.1144, +0.2730, -0.0306, +0.5553, -0.2193, +0.0381, +0.1208, -0.0673, +0.0252, -0.2126, -0.0405, -0.2865, -0.2845, +0.0230, +0.1565, -0.2116, +0.6389, +0.0719, +0.0626, +0.0787, -0.5115, -0.3170, -0.2624, -0.2703, -0.0870, -0.1435, -0.1550, +0.1257, +0.0181, +0.2749, -0.3040, -0.1372, +0.1321, +0.2789, +0.5307, -0.0682, -0.0233, -0.4869, -0.0007, -0.0674, -0.5120, -0.1369, +0.1053, -0.3382, +0.2142, +0.2507, +0.4448, +0.3375, +0.0855, -0.4081, -0.1997, +0.1623, -0.0751, +0.0931, +0.0560, -0.0756, +0.0401, -0.0629, -0.1533, +0.3650, +0.4107, +0.2932, +0.1139, +0.3215, -0.2791, +0.0343, -0.0898, +0.0336, -0.0659, +0.1762, +0.2354, +0.3488, +0.2719, -0.4242, -0.2992, -0.1562, +0.0045, +0.3201, -0.5237, +0.1479, -0.5690, -0.2330, +0.2845, -0.1342, -0.2929, -0.1850, -0.0158, +0.4821, +0.2490, +0.4284],
[ -0.3999, +0.2818, -0.1922, +0.0555, +0.5171, -0.3590, -0.1971, +0.3165, -0.5062, -0.2215, -0.1065, -0.2786, +0.0039, -0.0639, -0.0693, -0.3796, +0.2258, +0.0181, +0.0522, -0.5439, -0.3408, +0.2508, -0.2804, +0.0888, -0.0386, +0.0317, -0.7447, +0.2331, +0.0700, -0.0133, -0.4177, -0.4858, +0.0373, +0.0400, +0.0761, +0.2410, -0.2575, +0.0742, +0.0296, -0.0151, -0.2920, +0.7251, +0.1683, +0.3903, +0.5179, -0.2204, -0.0683, +0.0713, -0.4436, -0.4224, -0.0096, +0.0525, +0.6168, +0.1136, -0.1638, +0.3279, -0.0538, +0.0551, +0.0334, -0.1560, +0.4072, -0.0137, +0.0115, -0.2680, -0.3222, -0.3704, -0.2564, +0.2464, -0.5738, +0.3043, +0.0199, +0.0104, +0.4810, -0.0185, -0.0046, -0.3035, +0.0769, +0.2963, -0.3765, +0.0459, +0.0438, -0.4679, -0.2162, +0.1311, +0.2579, +0.5481, +0.3108, -0.4519, -0.1390, +0.2490, -0.2255, +0.1434, +0.0299, -0.2468, +0.4253, +0.1226, -0.2089, +0.2808, +0.0797, +0.3141, +0.1863, -0.0943, -0.1062, +0.1340, +0.1595, -0.1996, -0.3027, -0.2943, -0.0383, -0.0017, -0.4060, -0.2167, -0.3518, -0.1092, +0.2760, +0.6024, -0.3738, -0.0077, -0.1995, -0.1501, +0.5304, -0.0985, -0.4326, -0.0948, +0.1197, +0.3657, +0.5967, -0.0161],
[ -0.0163, -0.1598, -0.0898, -0.3031, +0.3562, -0.1880, +0.4982, -0.2006, +0.1333, +0.1070, -0.3469, +0.1700, -0.1478, +0.2706, -0.1245, -0.1629, -0.2600, -0.5547, -0.0283, +0.0651, -0.3661, +0.1613, -0.4730, -0.1073, +0.2278, -0.2080, -0.5867, -0.3301, -0.0710, -0.4903, -0.1177, -0.0403, +0.3137, +0.2758, +0.9692, +0.3555, +0.6843, -0.0946, -0.4898, +0.1578, +0.3236, -0.6893, +0.3377, +0.7591, -0.0431, +0.1656, -0.5355, +0.0391, +0.4429, +0.0714, -0.1343, +0.0260, -0.3001, -1.0302, +0.2593, -0.2896, -0.6946, -0.1065, -0.3011, -0.6970, -0.2210, -0.8150, +0.5162, -0.2254, +0.6869, -0.6117, +0.2350, +0.2737, +0.4368, +0.1905, +0.8666, -0.1589, -0.7668, +0.2078, -0.2320, +0.0586, +0.1064, +0.3494, +0.1311, -0.4138, +0.2237, +0.7141, -1.0423, +0.0040, -0.0100, +0.5651, +0.5926, -0.9485, -0.3266, +0.1448, +1.1084, +0.1485, -0.1714, -0.1923, -0.2472, +0.5949, -0.2317, +0.2637, -0.1421, +0.5580, -0.5107, -0.0185, +0.8448, -0.7895, +0.5584, +0.0620, +0.7197, -0.2934, +0.1666, -0.1414, -1.2340, +0.2950, +0.9330, +0.7952, -0.4286, +0.4100, -0.0755, -0.6794, -0.0747, -0.9528, -0.0623, +0.0717, +0.5494, +0.1058, +0.2360, +0.3673, +0.6112, -0.0558],
[ -0.2686, +0.0490, -0.1198, -0.4539, +0.4067, +0.0165, +0.6562, +0.2215, -0.2212, -0.1458, -0.4807, +0.4419, -0.3207, -0.1915, -0.4500, -0.2861, -0.0018, +0.0653, -0.2872, +0.0901, +0.0277, +0.3768, +0.0179, +0.1501, +0.0858, +0.1207, -0.0850, +0.1383, +0.2918, -0.0698, -0.1961, +0.0895, +0.8368, +0.0447, -0.0362, +0.0989, +0.5607, -0.1372, -0.3217, +0.1940, +0.1282, -0.1251, -0.1102, +0.3082, +0.4847, +0.4016, +0.1210, -0.6052, -0.1095, +0.1520, -0.4554, -0.1176, +0.3743, -0.9020, -0.4544, -0.5999, -0.4318, +0.0143, +0.0415, -0.3687, -0.1845, -0.8618, +0.1576, -0.1542, +0.3844, -0.6150, -0.0861, +0.0730, -0.1538, +0.2426, +0.1985, -0.3463, +0.2234, -0.4343, -0.2519, +0.9082, +0.0262, +0.3952, +0.0999, +0.0080, +0.5727, +0.6077, -0.0763, -0.1144, +0.1336, +0.0213, +0.2326, -0.4168, -0.3262, +0.2290, +0.5080, +0.1930, -0.1609, -0.2510, -0.2280, +0.3438, -0.3668, -0.2520, -0.1654, +0.1198, -0.3119, -0.1896, +0.7685, -0.0996, +0.2927, +0.2777, +0.3240, -0.2404, -0.0032, -0.0015, +0.0565, -0.1223, +0.2349, +0.0215, -0.5983, +0.2445, -0.1651, -0.4043, -0.0670, -0.4702, -0.4719, +0.3458, -0.0142, +0.5066, -0.1046, +0.1497, +0.1548, +0.1159],
[ -0.0869, +0.7785, -0.4428, -0.2821, -0.1208, -0.7714, -0.4869, +0.4759, +0.3538, -0.7488, +0.1591, +0.1048, +0.2760, +0.0767, -0.4448, -0.8686, +1.0696, +0.1309, +0.4479, -0.6458, -0.1333, -0.2056, +0.5272, +0.3068, +0.5122, -0.2175, +0.0008, +0.7808, -0.0567, -1.0409, +0.0710, +0.2238, +0.2457, +0.4153, -0.0591, -0.5756, -0.4392, +0.1109, +0.1691, +0.3497, +0.3588, -0.2234, +0.8087, -0.0991, +0.3706, +0.6791, -0.5741, -0.2647, +0.7902, +0.4770, +0.4626, -0.4370, +0.3041, +0.4613, +0.0076, -0.7466, -0.9034, +0.0446, +0.4102, -0.9529, +0.3532, -0.7463, -0.7031, +0.4634, -0.1488, -0.1927, -0.1005, -0.7875, +0.2942, -0.6019, +0.4367, +0.0235, +0.0634, -0.1854, -0.3933, -0.0176, +0.4786, -0.6456, -0.3334, -1.0670, -0.7521, -0.1139, -0.9621, -0.6963, +0.6526, -0.0873, +0.2599, -0.4947, +0.1064, +0.2584, -0.4584, -0.3163, +0.7724, +0.2765, -0.2403, +0.8032, -0.7883, -0.1984, -0.9589, +0.7584, -1.3177, -0.1216, -0.6863, -0.0421, -0.1855, -0.6028, -0.4343, -0.0256, -0.3400, +0.0291, +0.1210, -0.1589, -0.4215, -0.0463, +0.0042, -0.6658, +1.0685, -0.3378, -0.4608, +0.4908, +0.0795, -0.2491, -0.1487, -0.2365, -0.4315, +0.0934, -0.4263, -0.4182],
[ +0.0216, +0.2248, +0.0352, +0.0225, +0.0930, -0.5563, -0.2834, +0.0195, +0.1119, -0.4193, -0.2230, -0.2451, +0.1093, -0.4057, -0.0665, +0.2316, +0.0756, -0.1837, +0.1613, -0.1873, +0.3417, +0.0270, +0.4112, -0.1691, +0.1678, -0.0362, -0.1879, +0.6701, +0.1895, -0.0597, -0.0828, +0.2675, -0.2948, +0.1289, +0.0837, -0.0493, -0.5382, -0.1488, -0.0458, +0.5465, +0.2561, +0.2230, +0.5423, -0.1369, +0.3440, +0.3392, +0.1561, -0.2631, +0.1115, +0.6029, +0.1100, -0.1383, +0.2176, +0.4454, +0.5600, -0.3063, -0.1538, +0.5763, +0.3399, -0.5415, +0.0139, -0.2154, -0.2847, +0.3459, +0.0203, +0.1617, +0.2227, -0.1136, +0.2933, +0.1459, +0.1667, +0.0429, +0.3696, +0.4176, -0.0082, +0.5549, +0.2607, +0.0170, +0.1608, -0.3064, -0.4853, -0.0267, -0.3323, -0.0542, -0.0051, +0.4153, -0.1407, -0.0137, -0.1059, +0.2713, +0.2524, -0.3758, +0.2509, -0.1231, +0.1014, -0.2181, -0.1138, -0.3402, -0.1206, +0.0895, -1.0112, +0.3187, -0.1129, +0.1377, -0.1708, -0.2406, -0.1802, +0.1804, +0.1812, -0.3818, +0.1249, +0.1805, -0.1716, -0.0246, +0.0674, -0.6118, +0.2825, -0.0008, -0.2797, -0.1397, +0.2884, -0.4107, +0.2854, +0.0711, -0.1799, +0.1339, +0.0259, +0.1404],
[ +0.2737, -0.0637, +0.1152, +0.0756, +0.1408, +0.7369, +0.1416, -0.3230, -0.3606, -0.2058, -0.0154, -0.4064, -0.1001, +0.0205, -0.9191, -0.0970, +0.3451, -0.0445, +0.1756, -0.0773, -0.1344, -0.1830, +0.0676, +0.0193, +0.3778, -0.0874, +0.0989, -0.4022, -0.8557, +0.3901, +0.5519, +0.6791, -0.1552, +0.1149, +0.3713, +0.4078, +0.1512, -0.1269, +0.2204, -0.2497, -0.2122, -0.0120, -0.9529, +0.5725, +0.1137, +0.0532, -0.0010, +0.3827, -0.2471, -0.2011, +0.1239, -0.2750, +0.6558, +0.5338, -0.2118, -0.2040, +0.0979, +0.3669, -0.1151, +0.0028, +0.0926, -0.4209, -0.5859, +0.1027, +0.1409, +0.1851, -0.5285, +0.2847, +0.6363, +0.7517, -0.1865, +0.2350, +0.2326, -0.4999, -0.1746, +0.1962, +0.2770, +0.3472, +0.7287, -0.0607, +0.1556, +0.1384, -0.4810, -0.8055, +0.3837, +0.7801, -0.0209, -0.2393, -0.3846, +0.0448, +0.4687, -0.1277, -0.8119, +0.2255, -0.5438, +0.0358, -0.1966, -0.1509, -0.6774, -0.1940, -0.2138, -0.0826, -0.4056, -0.1520, +0.0884, -0.8490, -0.2066, -0.1791, +0.5360, -0.1656, -0.0296, +0.0011, -0.3769, -0.2967, +0.1354, +0.1510, +0.3657, +0.4350, +0.3093, +0.6680, +0.1791, +0.8760, -0.2529, +0.5332, +0.1795, -0.0058, -0.2217, +0.8652],
[ +0.2892, +0.0128, +0.0532, +0.0615, +0.0288, +0.2884, +0.3573, +0.0641, -0.1649, -0.0251, -0.1110, -0.3908, -0.0156, +0.0455, -0.3047, -0.0710, +0.0487, +0.4414, +0.2271, -0.3107, -0.2726, +0.1943, +0.0232, -0.0340, -0.0660, -0.4519, +0.0417, +0.2712, -0.0739, +0.3723, +0.5794, +0.4364, +0.0464, +0.0742, +0.3525, -0.1208, -0.2606, -0.3368, -0.1554, +0.1393, +0.2278, -0.0459, -0.2098, +0.2492, +0.3334, -0.0302, +0.0550, +0.0309, -0.2083, +0.2029, +0.2538, -0.2008, +0.0620, +0.2235, -0.5540, -0.2590, -0.1601, +0.1647, +0.0136, +0.1276, +0.3693, -0.2614, -0.1148, +0.1206, -0.0086, -0.1913, +0.1267, +0.0320, +0.1427, +0.0735, -0.2284, -0.1885, +0.2945, -0.1118, -0.4166, +0.0575, +0.2516, +0.3123, -0.0000, -0.0695, +0.0042, -0.1320, +0.2382, -0.3170, +0.0214, +0.1288, +0.1548, -0.0192, +0.0433, +0.0666, +0.1847, -0.0714, +0.2692, -0.2471, -0.1453, -0.2341, -0.1699, -0.0121, -0.3128, -0.0809, -0.1795, -0.1694, -0.3374, +0.1925, +0.4930, -0.1543, +0.0764, +0.2613, -0.1087, +0.0851, +0.1678, -0.1040, -0.1425, -0.0289, -0.2243, +0.1988, +0.1223, -0.0357, +0.0518, +0.2071, +0.3595, +0.7848, -0.1094, +0.1486, +0.1033, -0.3156, -0.1112, +0.0775],
[ +0.0726, -0.2349, +0.4435, -0.3221, -0.2640, -0.3025, +0.3943, +0.4265, -0.4076, -0.0645, -0.1306, -0.4443, -0.2518, +0.4729, +0.1835, +0.0613, +0.1935, +0.0464, +0.3667, +0.0282, +0.2514, -0.3173, +0.1491, -0.4907, -0.1731, +0.2800, +0.5797, +0.3626, -0.1521, -0.3768, -0.0963, -0.3199, -0.3708, +0.1425, +0.7492, -0.0729, +0.3939, +0.8268, -0.4126, +0.0015, +0.4013, -0.2242, +0.6532, +0.3272, +0.5444, -0.1875, +0.0934, -0.3247, -0.0158, +0.2957, -0.1633, +0.0210, -0.2375, -0.3235, +0.3632, +0.3804, -0.5069, -0.2513, -0.1814, -0.3878, -0.2203, -0.0347, +0.4101, +0.0975, +0.4437, +0.2957, +0.0973, -0.2275, +0.3284, +0.0153, -0.2754, -0.2662, +0.2289, +0.3586, -0.0261, +0.3879, -0.0380, -0.2800, -0.2977, -0.3532, -0.3512, -0.1964, +0.5441, -0.1821, -0.2217, +0.1326, -0.0759, +0.1321, -0.1777, +0.8902, +0.0419, -0.1888, +0.2723, +0.1060, +0.2127, +0.1252, -0.8234, -0.3166, -0.0091, +0.1212, +0.2661, +0.3220, -0.3574, +1.2784, +0.2983, +0.1012, -0.0309, +0.5751, +0.0483, -0.1876, +0.2627, -0.3778, +0.5287, -0.5014, +0.1711, +0.3556, -0.1348, -0.5603, -0.1250, +0.1921, +0.3296, -0.2619, +0.6369, +0.1296, -0.0840, -0.5925, -0.3893, -0.7311],
[ +0.1877, +0.0268, +0.1300, -0.0720, -0.2039, -0.1456, +0.1332, +0.2174, -0.3371, +0.1322, -0.4050, -0.1086, -0.0192, -0.1423, +0.1563, +0.0454, +0.0143, -0.2112, +0.0713, +0.2697, -0.0367, -0.0874, -0.0583, +0.0733, -0.0737, -0.1927, +0.3577, -0.0547, -0.0115, -0.2177, +0.1929, -0.0371, +0.0556, +0.0550, -0.2477, -0.1494, -0.0886, -0.0866, +0.0387, +0.1801, +0.0047, +0.0447, -0.0429, -0.1321, -0.3278, -0.2299, -0.0776, -0.1158, +0.1326, -0.0833, +0.1113, -0.0963, +0.0412, +0.0582, -0.1412, -0.0199, +0.0472, -0.3096, +0.0842, +0.0327, -0.2144, -0.0893, -0.0967, -0.1523, +0.0163, -0.0363, +0.0282, +0.0374, +0.2111, -0.5603, +0.2389, -0.5278, +0.1647, -0.1870, -0.1685, +0.1081, -0.1251, +0.1992, -0.1025, -0.1088, -0.0631, -0.1702, -0.0618, -0.0731, +0.1023, +0.2131, +0.0240, -0.0918, -0.0022, +0.5687, +0.2330, +0.2725, -0.1810, -0.0538, -0.0589, +0.0720, -0.1091, -0.0781, +0.0610, +0.0721, +0.0008, -0.1568, -0.0838, -0.1508, +0.1178, +0.0478, +0.0703, +0.1897, +0.1183, -0.3671, +0.3609, -0.1267, +0.0616, -0.0138, +0.4850, -0.1615, +0.0599, -0.2622, +0.0921, +0.1333, +0.0178, +0.0985, -0.0415, +0.0790, +0.0535, -0.2706, -0.0425, +0.0723],
[ -0.4575, +0.0883, +0.0828, -0.0903, -0.2759, +0.6346, -0.1173, -0.9548, -0.2303, +0.1553, -0.2614, -0.0100, -0.4209, -0.4210, +0.2638, +0.0814, -0.3042, +0.3774, -0.0995, -0.3107, +0.0579, +0.3937, +0.0684, +0.3157, -0.0361, +0.6631, -0.1025, +0.0281, +0.1242, -0.0353, -0.0010, +0.4134, -0.0598, -0.3030, -0.1688, -0.0677, +0.2697, +0.2479, -0.0570, -0.4857, -0.5667, +0.1100, -0.4842, -0.3906, +0.4288, +0.3151, +0.0519, -0.0833, -1.5897, +0.2826, -0.4043, -0.0965, -0.3609, -0.1125, -0.8306, -0.0657, +0.0739, +0.0250, -0.2110, +0.0748, -1.2815, -0.2667, +0.2791, +0.0389, -0.1955, +0.6815, -0.3044, -0.2299, +0.1501, -0.7659, -0.0867, +0.6538, +0.2794, -0.2846, +0.4493, -0.3823, +0.0467, +0.3972, +0.4505, -0.0732, -0.4104, +0.0297, +0.7162, -0.1124, +0.3431, -0.2618, +0.1096, -0.1875, -0.7107, +0.6329, +0.0971, -0.5898, +0.0167, +0.1514, -0.6291, +0.0164, -0.1854, +0.1326, -0.0985, +0.4765, -0.1437, +0.1697, +0.2805, -0.1302, -0.3222, +0.0073, -0.0066, +0.3029, +0.1412, -0.0061, -0.0989, -0.1120, +0.2595, +0.1952, +0.0711, -0.0839, +0.0136, -0.3861, +0.0017, +0.1406, +0.5712, -0.9303, +0.1058, -0.7283, -0.1189, +0.2331, -0.0292, -0.0765],
[ -0.0852, -0.1283, -0.2468, -0.0610, +0.0185, +0.4123, +0.1511, -0.2597, +0.1836, +0.0200, -0.1263, +0.0216, -0.0367, +0.1705, +0.0310, +0.0122, +0.0538, +0.0634, -0.0669, +0.1518, -0.0326, +0.2243, +0.0778, -0.1312, -0.1686, -0.5675, -0.2666, -0.0431, +0.0084, +0.1037, -0.3643, +0.1132, -0.1260, -0.1224, -0.0799, +0.0850, -0.0083, +0.3561, +0.1402, +0.0424, -0.0229, -0.1774, -0.1412, -0.2557, -0.1044, +0.1358, +0.0585, -0.1080, -0.2509, -0.0000, -0.0432, -0.1251, -0.0317, -0.1283, -0.0321, -0.0166, -0.1913, +0.1041, +0.0964, +0.0342, -0.0571, +0.0112, -0.0025, -0.0368, +0.4442, +0.2436, +0.0345, -0.1151, -0.0153, -0.0046, -0.1074, +0.3189, -0.3559, -0.0808, -0.2582, +0.1425, +0.0607, +0.0523, +0.0618, -0.1210, +0.0637, +0.0579, +0.0832, -0.0013, +0.0834, -0.0203, +0.0361, -0.0416, -0.0802, -0.2742, +0.0927, -0.2084, +0.0065, -0.0154, +0.1259, +0.0489, +0.0771, +0.1588, -0.0412, +0.0134, -0.0364, -0.1453, -0.0420, -0.0261, -0.4316, -0.0358, +0.0577, +0.3093, -0.1545, -0.5068, -0.0966, -0.0648, +0.1518, -0.1199, +0.3313, +0.0962, -0.0006, -0.2006, +0.0968, +0.0405, +0.0055, -0.2441, -0.0059, -0.0071, +0.0576, +0.0303, +0.0366, +0.0350],
[ +0.3816, -0.3247, -0.5616, +0.2768, +0.0713, -0.4458, +0.0236, -0.1845, +0.0192, -0.0806, +0.3298, -0.0147, +0.4114, +0.0580, +0.1674, +0.1655, -0.0503, +0.1795, +0.0341, -0.2277, -0.2257, +0.0140, -0.9017, +0.0488, -0.1260, -0.2432, -0.7213, -0.0826, +0.3134, +0.1833, +0.1741, +0.2243, +0.0444, +0.0490, -0.0227, -0.1501, -0.0132, +0.0290, -0.3004, -0.1732, -0.2257, -0.2236, -0.2197, -0.1843, -0.1801, +0.2033, +0.2965, -0.4986, -0.3707, +0.0972, -0.4070, -0.0559, +0.3487, -0.0273, -0.1587, +0.3442, -0.0333, -0.0154, +0.2600, -0.2376, -0.0363, -0.4062, +0.2059, +0.2729, +0.3398, +0.0643, -0.1574, +0.0578, -0.0239, -0.0400, -0.5308, -0.0193, -0.5373, +0.1816, -0.3782, -0.1737, -0.3600, +0.0229, -0.3912, -0.1709, -0.2198, +0.0588, -0.2671, +0.2957, +0.1524, +0.0470, +0.1582, +0.6196, -0.0026, +0.0879, +0.1006, +0.2473, +0.2091, -0.2634, +0.3874, -0.0082, +0.1566, -0.0351, -0.2606, +0.1078, +0.1361, -0.3899, +0.2310, +0.0877, +0.3040, +0.2857, +0.3292, +0.0508, -0.0586, -0.2252, -0.3415, -0.1395, -0.1580, -0.1437, +0.0771, -0.4271, +0.0222, -0.2012, +0.3024, +0.2392, -0.4016, -0.2786, +0.1577, -0.1132, -0.0824, +0.3754, -0.3069, +0.1386],
[ -0.0755, -0.2996, -0.1296, +0.0604, -0.2116, +0.7881, +0.4133, -0.2161, +0.3088, +0.6014, +0.5466, -0.0803, +0.4058, -0.2764, -0.0219, +0.0447, -0.0777, +0.1856, -0.0344, +0.3402, +0.0922, -0.2630, -0.1563, -0.0030, -0.2137, -0.0201, -0.3140, -0.1622, +0.0924, +0.0082, -0.2290, +0.0624, +0.3494, +0.7148, -0.0825, +0.0978, -0.2303, +0.3803, -0.3025, -0.0474, +0.1549, -0.2196, -0.2769, +0.2408, +0.0981, +0.2985, +0.1576, -0.3519, -0.1784, -0.0699, -0.1060, -0.0898, +0.2946, +0.0852, +0.1465, -0.1051, +0.2698, -0.0081, -0.2419, -0.4288, -0.2285, -0.8437, +0.3060, +0.3875, -0.0923, -0.3370, +0.1410, +0.0077, -0.3634, -0.5353, -0.3654, +0.1611, +0.3171, +0.1363, +0.5227, +0.0148, -0.4323, -0.0802, -0.1009, -0.2429, -0.2048, +0.2783, +0.2030, -0.0075, +0.0669, +0.0378, -0.2999, +0.3543, -0.0043, +0.2866, +0.1184, -0.6193, -0.0946, +0.6482, -0.0439, -0.0386, +0.3405, -0.4165, +0.3446, +0.0955, +0.3346, -0.9070, -0.2877, +0.4198, -0.2797, -0.0508, +0.2402, +0.2460, +0.3363, -0.1159, -0.0076, +0.0651, -0.0291, -0.3098, +0.0319, -0.1971, +0.1458, +0.5342, +0.0906, +0.0390, -0.6057, +0.0000, +0.5078, -0.1008, -0.1861, +0.0003, -0.5298, +0.1631],
[ +0.1138, -0.8185, -0.8924, +1.6414, +0.9027, -0.4393, +0.0480, -0.3144, -0.3434, +0.1701, -0.5808, -0.0033, -0.2701, -1.0223, +0.2481, +0.2163, -0.4073, +0.9436, -0.2430, -0.5072, +0.6304, +0.2936, -1.2520, -0.6804, -0.6398, +0.2105, -0.3102, -0.3583, -0.1891, +0.0355, +0.3419, +0.0037, -1.0429, +0.1983, -0.4930, -0.4885, +0.4501, -0.1774, +0.2960, -0.5498, -0.3421, +0.6180, +0.2807, -0.3380, +0.3267, -0.2056, -0.5404, +0.3548, +0.3193, +0.0771, -0.5154, +0.3144, -0.3657, +0.1271, +0.1569, +0.0008, -0.1132, -0.2385, +1.0192, -0.0347, +0.0864, -0.4185, -0.5911, +0.1149, +0.0957, -0.0345, +0.9026, +0.4557, -0.1960, -0.3154, +0.1732, +0.3606, -0.1417, +0.2279, -0.2861, -0.6662, -0.3525, +0.0668, +0.2993, -0.1905, -0.5031, +0.3325, -0.7507, -0.0682, +0.6465, +0.0282, +0.1365, +0.1087, -0.0463, -0.0131, +0.0107, -0.2120, +0.5243, +0.3221, +0.7508, +0.1844, +0.1429, +0.5806, -0.7104, +0.3892, +0.4980, +0.2435, +0.0829, +0.2531, +0.8711, +0.4893, -0.4815, -0.5873, +0.3852, +0.1803, +0.3265, -0.2590, +0.5784, +0.4960, +0.2079, +0.2113, +0.0366, -0.2275, +0.0427, +0.1713, -0.2477, -0.3319, -0.3610, -0.0326, -0.4390, +0.0692, +0.3147, +0.0691],
[ +0.1436, -0.1510, -0.3292, +1.2564, +0.7298, -0.2063, +0.0808, +0.0930, +0.1372, +0.2215, +0.2300, -0.2476, +0.1232, -0.2652, +0.5093, +0.1414, -0.1087, +0.3320, -0.0052, +0.0809, -0.1755, +0.3351, -0.3095, -0.5126, -0.2271, -0.2852, +0.0977, -0.1178, -0.4411, -0.0954, -0.2779, -0.1031, -1.2071, -0.0841, -0.0812, -0.2906, +0.0405, -0.0272, +0.0241, -0.6556, -0.0906, +0.1422, +0.2308, -0.3684, +0.3169, +0.0129, -0.2395, +0.2086, +0.0928, -0.0771, -0.1844, +0.2267, -0.0837, +0.4392, -0.1696, +0.0897, +0.3167, +0.0450, +0.5110, +0.0087, +0.0881, +0.0651, -0.4001, -0.0161, -0.3443, -0.2631, +0.4374, +0.1643, -0.1741, -0.1510, +0.2289, -0.6355, +0.2009, +0.0716, -0.7153, -0.3138, +0.0375, -0.1336, -0.0969, -0.4926, -0.8953, +0.3378, +0.1166, +0.0150, +0.2521, -0.0370, +0.2136, +0.0646, -0.0671, -0.1567, -0.3154, +0.3044, +0.2054, +0.7251, -0.1772, -0.1496, +0.1741, +0.0851, +0.4585, +0.3174, +0.1829, -0.1001, -0.3607, -0.2487, -0.0002, -0.4292, -0.0638, -0.0211, +0.8328, -0.0993, +0.2617, +0.3100, +0.2706, -0.1149, +0.1958, +0.5716, -0.1675, -0.1821, +0.0429, +0.1021, +0.1540, +0.5026, -0.1616, +0.0998, -0.3449, -0.5164, +0.4014, -0.2241],
[ +0.1072, -0.6413, -0.0805, +0.0679, -0.3707, -0.2004, -0.1814, +0.3136, -0.5324, -1.1547, +0.1700, +0.2385, +0.8959, +0.3630, -0.5144, +1.0350, +0.3202, -0.2102, +0.7385, -0.0361, +0.3834, +0.1235, +0.1039, +0.4855, +0.1504, +0.0078, +0.1033, -1.4490, +0.6291, -0.4976, +0.5192, -0.0919, -0.3304, -0.1331, +0.2814, -0.5231, +0.5177, -0.0709, +0.1550, +0.1280, +0.8392, +0.2043, -0.2186, +0.0927, -0.2483, +0.2085, -0.0826, -0.6281, +0.1504, -0.6132, +0.3405, +0.3745, -0.0010, -0.0260, +0.2384, +0.5982, -0.1388, +0.4349, +0.6661, -0.8261, +0.5933, +0.4324, +0.0321, +0.4807, -0.0807, -0.1687, +1.2021, -0.8566, +0.3062, -0.7050, +0.4617, +0.4503, -0.1489, -0.6842, -0.3012, +0.1301, +0.2108, -0.0161, +0.6429, -0.2715, -0.5533, +0.1526, -0.1951, -0.0762, -0.1544, -1.1001, +0.4126, -1.2340, +0.2117, +0.2711, +0.3057, -0.1357, -0.0235, -0.3365, +0.5847, +0.5711, -0.3166, -0.4825, +0.2661, -0.3780, -0.1899, -0.0361, +0.0045, +0.5510, -0.1000, -0.7202, -0.3582, +0.2163, +0.0429, -0.9643, +0.3246, -0.8588, +0.2461, +0.8309, +0.0493, -0.3180, +0.2676, +0.0323, -0.9626, +0.2523, -0.8256, +0.3090, -0.3455, +0.0623, +0.4007, -0.1485, -0.6633, +0.3027],
[ +0.2821, -0.3047, +0.0034, -0.1331, +0.0282, -0.1470, +0.2721, +0.1011, +0.2451, +0.3916, -0.2271, -0.0818, +0.6927, +0.2877, -0.0150, +0.4313, +0.0658, -0.3675, +0.3623, -0.2200, -0.0895, +0.1236, +0.0658, +0.4430, -0.0536, -0.3915, -0.0161, -0.6227, +0.2997, -0.1969, +0.4530, +0.1025, -0.3560, +0.0474, -0.1682, +0.0795, -0.2016, +0.0701, -0.0666, -0.2199, +0.0664, +0.0713, -0.1747, -0.1563, -0.1510, +0.2657, -0.1601, -0.0339, -0.0957, -0.3877, -0.0910, +0.3721, -0.0974, -0.0091, +0.0630, -0.0565, +0.3120, +0.0983, -0.1108, +0.3243, +0.3042, +0.1399, -0.2815, +0.0534, -0.1111, -0.0353, +0.2473, -0.3125, -0.1657, -0.2442, +0.4346, -0.1212, -0.2051, -0.3086, -0.1731, +0.0120, -0.0429, -0.1764, +0.2475, -0.0224, +0.2229, -0.2253, +0.0928, +0.1455, -0.2394, -0.2864, -0.1549, -0.3785, +0.2204, +0.2668, +0.2644, +0.1710, +0.0111, +0.4326, -0.2507, -0.1007, +0.2296, -0.0425, +0.3168, +0.1126, +0.3718, +0.3513, +0.2796, -0.0329, +0.1666, -0.1706, -0.0423, +0.1418, +0.1150, -0.3973, +0.4120, -0.2970, +0.2863, +0.3577, -0.1482, +0.1489, -0.0260, +0.1930, -0.3021, +0.1780, -0.5228, -0.0494, -0.4920, -0.1714, +0.1751, -0.2078, -0.1833, +0.2465],
[ -0.1379, -0.5338, +0.0481, +0.3319, -0.1849, +0.1427, +0.2808, +0.2464, -0.2221, -0.7888, +0.2023, -0.6479, +0.8309, +0.2994, -0.2227, -0.3204, +0.0148, +0.2257, +0.0482, +0.1791, -0.2571, -0.2621, -0.0084, +0.1249, +0.3880, +0.2359, +0.3945, -0.3898, +0.2194, +0.0218, -0.0051, +0.1271, -0.0524, -0.2772, -0.3264, -0.1499, -0.7183, -0.4052, -0.3033, -0.0983, +0.6579, -0.3005, -0.0020, +0.1609, -0.2055, +0.6377, +0.0399, +0.5395, +0.4407, -0.4725, -0.1695, -0.1474, -0.5403, -0.4549, -0.0180, -0.2834, +0.6901, -0.1303, +0.2792, -0.6329, -0.1681, +0.3548, -0.3353, -0.2212, +0.3462, +0.5350, -0.3834, +0.4827, +0.4583, +0.2545, +0.7802, +0.1368, -0.3416, -0.5987, +0.1435, -0.0086, -0.4619, +0.1925, +0.5983, -0.5293, -0.1930, -0.5743, +0.5291, +0.0208, -0.0213, -0.6488, +0.6222, -0.2060, +0.2725, +0.0139, +0.5933, -0.2082, +0.3808, +0.7167, +0.1195, -0.3807, -0.0885, -0.0746, +0.0201, +0.2418, +0.0572, +0.5145, +0.0773, +0.2193, +0.2651, +0.2684, +0.0061, +0.0859, +0.1731, +0.4043, -0.6799, +0.3337, +0.1547, +0.3663, +0.0766, +0.4000, +0.2603, +0.3363, +0.2661, -0.8120, -0.0255, -0.2192, +0.0968, +0.1541, -0.0597, +0.2089, -0.1289, +0.2547],
[ +0.3313, -0.2036, +0.0381, +0.1114, +0.0466, +0.0533, -0.1936, +0.5904, +0.1385, -0.0356, -0.0055, -0.1371, +0.1848, -0.1110, +0.0421, +0.2156, +0.0396, +0.2169, +0.0987, -0.1641, +0.3992, -0.1502, +0.1728, +0.0968, +0.0351, +0.2539, +0.4136, +0.1599, +0.3619, +0.1195, +0.1226, +0.1748, -0.1976, -0.0055, +0.2407, +0.2299, -0.1593, -0.1462, -0.4414, -0.2101, +0.1034, +0.0914, +0.0914, +0.2948, -0.3458, +0.0141, +0.3138, +0.0446, +0.1681, -0.1188, -0.1054, -0.3435, -0.2560, -0.1490, -0.0675, -0.0017, +0.2886, +0.2396, +0.0629, +0.0950, +0.4458, +0.1452, -0.2160, -0.1574, +0.0047, +0.1423, +0.0671, -0.0249, -0.1655, +0.1260, +0.3074, -0.2060, -0.0590, -0.1822, +0.3272, +0.0991, -0.2488, -0.0131, +0.2782, +0.2679, +0.2583, -0.2889, +0.1555, -0.1044, +0.1360, -0.4408, +0.2825, -0.1184, +0.1039, +0.0668, +0.1565, -0.5826, +0.2335, -0.1172, +0.3571, -0.2391, +0.1337, -0.1326, -0.1011, +0.1118, +0.1823, +0.1088, +0.0264, +0.1570, -0.1687, +0.1027, -0.0664, +0.0961, -0.1465, +0.1056, -0.6408, +0.2970, +0.4550, +0.1441, +0.3116, -0.3601, -0.0068, +0.3784, -0.2745, +0.0555, +0.0876, +0.2246, -0.0315, +0.3332, -0.0417, -0.1425, -0.2327, -0.4427],
[ -0.2104, +0.0778, +0.4891, +0.0462, -0.0111, -0.0137, +0.3261, +0.2946, +0.2801, +1.1352, -0.1209, +0.4107, +0.1685, +1.0778, +0.1036, -0.1691, +0.0816, +0.4114, -0.4579, -0.2433, +0.0691, -0.3680, +0.1854, +0.2050, +0.1642, +0.0474, +0.2090, +0.1938, -0.1330, -0.0193, -0.4173, +0.0519, -0.0353, +0.0905, +0.8507, +0.2200, +0.8114, +2.4094, -0.0701, -0.0495, -0.0591, -0.3660, -0.1992, +0.0976, +0.9462, -0.0891, -0.1575, -0.2738, -0.0088, +0.0507, +0.2517, -0.1440, -0.2139, -0.1174, +0.0377, -0.4399, -0.3036, -0.3874, -0.1385, +0.6156, -0.0790, +0.0873, -0.1493, +0.2035, -0.0619, -0.3821, -0.3895, -0.4232, -0.1344, +0.1387, +0.3495, +0.3665, +0.4984, +0.1288, -0.0406, +0.1423, -0.1409, -0.3282, -0.0891, -0.4012, +0.3626, -0.2908, +0.2692, -0.2525, +0.0427, +0.2974, +0.4572, -0.0395, -0.3629, +0.1782, -0.2125, +0.2632, -0.4767, +0.0455, +0.4814, -0.3184, -0.4883, -0.0542, -0.1627, +0.1164, +0.6662, +0.0165, -0.0387, +0.4397, +0.0110, -0.0822, +0.0892, +0.5543, -0.2189, +0.2069, +0.5751, +0.1634, -0.1970, -0.1993, -0.1732, +0.3274, -0.2648, -0.1804, -0.2024, -0.2233, +0.3707, +0.3345, -0.5045, -0.3710, -0.2141, +0.0400, -0.2628, -0.3386],
[ -0.1437, -0.0886, -0.3503, -0.0622, +0.0026, -0.3113, -0.1828, -0.0186, +0.0827, -0.1907, -0.0929, +0.0180, +0.0602, +0.4362, +0.0740, -0.1144, -0.0231, +0.1743, +0.0669, -0.1436, +0.0637, -0.0840, -0.1445, -0.0610, -0.0663, +0.1649, +0.0083, +0.0446, +0.1259, +0.0481, -0.2842, -0.2931, -0.0614, -0.1707, +0.1582, +0.6573, -0.3016, -0.1986, -0.0960, +0.1488, -0.0713, -0.2296, +0.0899, +0.4796, +0.1501, +0.1303, +0.2280, +0.1109, +0.0839, -0.0605, +0.0813, +0.1224, -0.0578, -0.0030, +0.0691, +0.2131, -0.1971, -0.0527, +0.1132, +0.2369, +0.4025, +0.0091, -0.0403, -0.0468, -0.0296, +0.3975, +0.0178, -0.1152, +0.0583, -0.1278, +0.0664, -0.2520, +0.1146, -0.0536, +0.0236, +0.0193, +0.0916, -0.0563, -0.0011, -0.1349, +0.1637, +0.0121, +0.0848, -0.1874, -0.0188, +0.1703, +0.1569, +0.0681, -0.0649, +0.2595, +0.0374, -0.2621, -0.1171, -0.1120, +0.4122, -0.0263, +0.0274, +0.2174, -0.1421, -0.2118, -0.1261, +0.0723, +0.1000, +0.0791, +0.1788, +0.0018, -0.0271, -0.2864, +0.1787, -0.1001, -0.1019, +0.0298, -0.1209, +0.0996, -0.0666, -0.0638, -0.0426, +0.3082, -0.0495, -0.0084, -0.2860, +0.1247, -0.3558, -0.0776, +0.1503, -0.0872, -0.0473, -0.0275],
[ -0.3090, +0.2727, +1.0996, +0.1803, -0.6783, +0.5138, -0.0437, +0.4478, +0.0502, +0.0756, -0.2818, +0.2702, -0.0729, +0.3439, +0.0519, +0.1164, -0.0860, -0.1543, +0.1795, +0.0672, +0.2913, +0.0568, +0.0676, +0.0412, -0.5890, +0.1912, -0.2060, +0.0206, -0.4862, -0.2644, +0.5449, -0.0195, -0.2337, -0.0224, +0.3316, +0.6228, -0.0259, +0.0985, +0.0574, -0.0340, +0.1161, +0.5461, +0.3814, +0.3550, +0.0593, +0.2842, +0.0861, +0.0700, -0.0948, +0.1986, -0.2377, +0.1416, -0.1528, +0.0841, -0.7725, +0.1854, +0.4352, +0.4489, -0.1293, +0.1833, +0.0157, -0.1694, -0.1312, +0.0996, +0.1241, -0.7957, +0.3174, -0.0343, +0.2618, +0.3105, -0.0144, -0.3473, -0.4244, +0.0321, +0.6457, +0.0430, -0.1629, +0.3828, +0.1509, -0.1778, +0.2314, -0.2613, +0.8030, -0.0964, +0.4746, +0.1662, -0.1641, +0.0478, +0.1450, -0.6709, -0.4083, +0.6596, -0.2490, +0.2675, +0.1739, +0.0344, +0.2514, +0.1781, -0.0234, -0.3458, +0.2042, -0.5216, +0.0381, +0.4873, -0.4942, +0.4178, -0.1815, -0.1259, +0.4834, +0.5550, -0.4302, -0.5905, -0.0232, +0.4113, +0.1534, +0.0665, +0.4837, +0.1492, +0.2411, -0.2995, +0.5860, +0.0436, -0.5899, +0.2769, -0.0182, +0.1061, +0.0240, -0.5939],
[ -0.1074, +0.0012, +0.1334, +0.0604, +0.1064, -0.0104, +0.1540, +0.5976, -0.1020, -0.0324, -0.0725, -0.0086, -0.0229, +0.0998, +0.0606, -0.1051, -0.0093, +0.2518, +0.0078, +0.0414, +0.1533, +0.1210, -0.3470, -0.1590, +0.1837, -0.3236, +0.1272, +0.1133, -0.1718, -0.1203, -0.2923, -0.0453, -0.1113, -0.0136, -0.1908, +0.0114, -0.0440, -0.1712, +0.1321, +0.1129, -0.2536, -0.1125, +0.1342, +0.1226, +0.1948, -0.1308, -0.1324, +0.0073, -0.0832, -0.0660, -0.0176, -0.0389, +0.0514, +0.0446, -0.0137, +0.0737, -0.0236, +0.0885, +0.0114, +0.0426, +0.0530, +0.0169, -0.1673, +0.1441, -0.0247, -0.1024, +0.0565, -0.0961, -0.0078, +0.0536, -0.0066, -0.1778, +0.1427, -0.0839, +0.0442, -0.0304, +0.0745, +0.0511, +0.0649, +0.0551, -0.0687, -0.1275, +0.1849, +0.1188, -0.0207, -0.0121, -0.0263, -0.0104, -0.0108, +0.1776, -0.0249, -0.5449, -0.2839, +0.2418, +0.0476, +0.0377, -0.0183, +0.1237, +0.1425, -0.0671, -0.0216, +0.3867, +0.2215, +0.0957, -0.3998, +0.0418, -0.0622, +0.0052, -0.0344, +0.3154, +0.1544, -0.1371, +0.2774, +0.1264, +0.2881, +0.1164, -0.0092, +0.3780, -0.0153, -0.0323, -0.1582, -0.2160, -0.3687, +0.1280, -0.0838, -0.0879, +0.0625, +0.0414],
[ +0.1598, +0.0820, -0.6638, -0.0882, +0.0838, -0.2637, -0.0835, -1.0032, +0.0640, +0.1296, -0.1190, -0.1617, +0.1101, -0.4482, +0.0886, +0.1509, +0.1216, -0.1013, +0.1272, +0.0129, -0.2263, +0.1117, -0.1196, -0.1467, +0.1220, -0.0071, -0.2535, -0.0915, -0.0797, -0.1340, -0.1324, -0.0290, -0.1032, -0.1445, -0.1055, -0.4659, +0.0832, +0.0639, -0.0765, +0.2628, -0.0588, +0.1690, -0.1611, -0.5035, +0.1111, +0.0674, -0.0142, -0.2612, +0.0091, -0.0920, +0.0152, +0.2416, -0.1378, +0.0818, +0.0489, +0.1546, +0.1534, +0.2909, +0.1434, +0.0235, -0.0650, +0.1772, +0.1273, -0.1220, +0.1447, +0.0644, -0.1467, +0.2426, -0.1368, +0.2662, +0.1477, -0.3713, +0.0242, -0.0807, +0.0726, -0.0543, +0.0477, -0.2259, -0.0255, -0.0961, -0.0056, +0.1689, -0.1184, +0.0517, +0.2532, +0.2831, -0.1449, +0.1510, +0.0337, -0.0440, +0.1368, -0.3167, -0.3223, +0.1846, +0.3514, +0.0667, +0.0645, +0.1432, -0.1352, +0.0161, -0.0486, -0.5958, +0.1326, -0.3881, -0.1432, -0.0267, +0.0047, +0.0134, +0.1914, -0.3669, -0.1292, +0.0538, -0.7897, +0.0292, -0.2800, -0.3306, +0.0332, +0.1506, +0.2752, -0.0330, -0.0747, +0.0930, -0.2933, -0.2250, +0.0146, +0.0866, +0.1583, -0.1611],
[ -0.0167, +0.1728, -0.5427, +0.1111, -0.0695, -0.6905, +0.0651, -0.6193, +0.0720, -0.1142, -0.0731, +0.1047, +0.2510, -0.6533, -0.0398, -0.0335, -0.0664, -0.1580, -0.1407, +0.0636, -0.0690, -0.0794, -0.4309, -0.0031, -0.1951, +0.0739, -0.6207, -0.0409, -0.0236, -0.0639, -0.6473, +0.0561, +0.2636, -0.2077, +0.1757, -0.0702, -0.1796, +0.3736, +0.0941, +0.1912, +0.2062, +0.2709, +0.0777, -0.4989, -0.4499, -0.0029, +0.1517, -0.1830, -0.1392, -0.0468, +0.1179, +0.0197, +0.1388, -0.1045, +0.0428, +0.1444, +0.0649, +0.2791, -0.1086, -0.1376, +0.0975, -0.0278, +0.0725, -0.1678, +0.4461, -0.4895, +0.1806, -0.0752, -0.0241, -0.0069, +0.0347, -0.0972, +0.2977, -0.0520, +0.1356, +0.0772, +0.3880, +0.2221, -0.1306, +0.0297, -0.1697, +0.0735, +0.3252, -0.1041, +0.1114, -0.1212, +0.2693, +0.1263, +0.0623, +0.0685, +0.0242, -0.1850, -0.2343, +0.0310, +0.0125, +0.0503, -0.4812, -0.0840, +0.3291, +0.0948, -0.0568, -0.0502, -0.2386, +0.1480, -0.4681, -0.0685, +0.0366, -0.4335, +0.2922, +0.3418, +0.1410, -0.0158, -0.5766, +0.0055, +0.0344, -0.1258, +0.0847, -0.1198, -0.0927, +0.0925, -0.2485, -0.0497, +0.0970, -0.1257, +0.0205, -0.0044, -0.0865, -0.2478]
])

weights_dense1_b = np.array([ -0.0151, +0.0967, -0.0808, +0.1691, +0.0800, -0.2722, -0.0442, -0.1241, +0.0528, -0.0458, -0.0985, -0.0243, +0.0051, -0.0412, -0.0188, -0.1997, +0.1363, -0.0424, +0.0252, -0.0957, -0.1292, +0.0074, -0.0469, +0.1758, -0.0315, -0.2319, -0.3494, +0.0731, -0.1385, +0.0209, -0.0670, -0.1024, +0.0426, -0.0876, -0.0347, -0.2719, -0.1016, +0.0706, +0.0027, -0.0648, +0.0780, +0.1067, -0.1417, +0.0747, -0.1335, +0.0298, +0.1241, -0.0175, -0.2418, -0.0223, -0.0645, -0.0835, +0.1544, +0.0288, +0.0841, +0.1417, -0.0985, -0.0655, -0.0377, +0.0203, -0.0473, +0.1265, -0.0858, -0.0657, -0.1281, -0.2944, +0.0631, -0.0073, +0.0521, -0.2323, -0.0375, -0.3024, -0.0666, -0.0837, -0.1394, +0.0330, +0.2208, +0.0880, -0.1027, +0.0589, -0.1190, +0.0690, -0.1735, -0.0283, +0.1709, +0.0536, -0.0023, +0.0955, -0.1561, -0.2252, +0.0160, -0.1721, -0.1104, -0.1401, -0.0740, +0.0515, +0.0771, +0.1484, -0.0230, +0.0785, +0.1216, -0.2259, -0.1709, +0.0271, -0.0160, -0.0618, +0.2165, -0.0152, -0.0277, -0.0786, -0.0231, +0.1164, -0.1289, +0.0382, -0.1755, -0.1879, +0.0584, -0.2770, -0.1274, +0.1132, -0.0172, -0.2253, +0.0899, +0.1331, -0.1182, +0.0019, +0.2867, -0.1570])

weights_dense2_w = np.array([
[ +0.5182, -0.4189, +0.0537, +0.0210, +0.1509, +0.0572, +0.0662, +0.1784, +0.4782, -0.3093, +0.0434, +0.0564, -0.1609, +0.4019, -0.0476, +0.1153, -0.1077, +0.2316, +0.1823, -0.0987, +0.0236, +0.1750, +0.3560, -0.0595, -0.6462, -0.1195, +0.0969, +0.2775, -0.0328, +0.1237, -0.0431, +0.2114, -0.0805, -0.0402, -0.2950, -0.0249, -0.2667, +0.1926, +0.1325, -0.0157, +0.2406, -0.2849, +0.0213, -0.2649, +0.0879, +0.0040, +0.0992, -0.2644, -0.1637, -0.3200, +0.0872, -0.0269, -0.7228, -0.1377, +0.0631, -0.2510, -0.2157, -0.1051, +0.3185, +0.2237, -0.0650, +0.3984, -0.1375, -0.0691],
[ -0.2328, +0.0270, +0.0942, -0.0533, +0.3991, -0.9936, -0.0398, +0.5043, -0.2528, -0.7857, +0.0593, -0.5139, -0.0382, -0.0133, -0.1234, +0.0562, -0.4176, -0.1082, -0.0491, +0.3554, -0.1311, -0.2403, -0.1827, -0.0524, -0.0066, -0.5203, -0.1987, +0.7344, -0.3203, +0.2084, +0.0544, +0.2104, +0.0775, -0.0713, +0.1732, -0.2822, -0.0346, +0.1216, -0.3196, +0.3614, +0.1157, +0.1767, -0.0077, +0.2628, -0.2786, +0.0738, -0.0264, +0.2670, -0.0024, +0.1531, +0.4294, -0.3826, -0.4107, +0.1352, -0.0806, +0.3122, -0.0576, +0.1413, +0.0595, +0.4702, -0.1374, -0.3611, -0.0348, -0.0823],
[ +0.2447, -0.4451, +0.0375, -0.4046, -0.0311, -0.2162, +0.0536, -0.2090, -0.0916, +0.6655, -0.0457, -0.8121, +0.2127, -0.6718, +0.2934, -0.3236, -0.2194, -0.8139, +0.6121, -0.2898, -0.2670, -0.1378, -0.1193, +0.1159, -0.3510, -0.5428, -0.2436, +0.1770, +0.1505, +0.2644, -0.0717, -0.6981, -0.3132, +0.2799, +0.2026, -0.0653, +0.2348, -0.4321, -0.0043, -0.3260, -0.4908, -0.0099, -0.1119, -0.0573, -0.1614, +0.0262, -0.7194, +0.3779, -0.5542, -0.0954, -0.3454, +0.6071, +0.3109, +0.0084, -0.2746, -0.3964, +0.0732, -0.6150, +0.2582, -0.4043, +0.6396, -0.3018, +0.0599, -0.1558],
[ +0.2985, +0.0771, +0.4443, +0.1636, -0.0579, -0.0182, +0.5091, -0.0526, +0.0150, +0.1110, -0.0522, -0.1540, -0.0434, -0.2959, -0.3047, +0.0245, +0.1830, +0.2331, -0.1663, +0.2444, -0.0255, +0.5200, -0.4746, +0.0558, +0.2527, +0.0762, +0.2251, -0.2941, -0.2629, -0.0240, +0.0052, +0.0374, +0.0580, +0.1204, -0.3535, +0.0345, +0.1993, -0.1570, -0.1004, -0.7200, +0.0565, +0.1599, +0.0476, -0.1161, +0.0897, +0.1685, +0.3669, -0.0176, -0.2036, +0.0537, -0.4611, -0.1618, -0.2607, -0.0635, +0.1543, +0.0056, +0.1952, +0.2062, +0.1189, +0.0320, +0.1075, -0.0226, -0.1204, +0.1306],
[ -0.2190, +0.2685, +0.0536, -0.0296, -0.0716, -0.0740, -0.0862, -0.5205, -0.1958, -0.7289, +0.3004, -0.1903, -0.0236, +0.1645, +0.0440, -0.3193, -0.0529, -0.2337, -0.0519, -0.2080, -0.0250, -0.0742, -0.0044, +0.1328, -0.0753, +0.0416, -0.0297, -0.4180, -0.1271, +0.1105, -0.2047, +0.0184, +0.3494, +0.0746, +0.0164, -0.5413, +0.2413, +0.2832, -0.2494, +0.2211, +0.3256, +0.0305, +0.5210, -0.3386, +0.1503, +0.0424, -0.0194, -0.1651, +0.5296, -0.6052, -0.1608, +0.1977, -0.5368, -0.0294, -0.1265, -0.0102, -0.0615, -0.0002, +0.2442, -0.0925, -0.1273, +0.2675, +0.0236, -0.0245],
[ +0.2407, +0.5256, -0.2631, -0.2038, +0.0948, -0.1007, -0.3042, -0.0731, +0.2363, +0.6628, +0.0276, -0.7541, -0.2194, +0.1486, -0.2389, +0.0370, -0.3806, +0.1953, -0.1963, -0.3829, -0.0465, +0.3209, +0.3060, +0.2439, +0.2254, -0.1646, -0.2121, -0.1004, -0.3071, +0.1990, -0.0269, -0.1747, +0.1215, -0.6351, -0.2357, -0.2449, -0.0041, +0.1008, -0.6369, -0.5370, -0.5260, -0.4144, +0.5633, +0.0595, +0.0796, -0.0423, +0.4325, +0.0855, +0.5404, -0.2129, -0.0536, -0.3231, +0.5234, -0.0861, +0.1493, +0.1011, -0.0661, +0.3776, +0.2202, -0.1939, +0.1611, +0.0072, +0.3093, -0.3270],
[ +0.1085, +0.2738, -0.0708, +0.1378, +0.1335, -0.2672, -0.1761, +0.1595, +0.0254, -0.2243, +0.0765, -0.0972, -0.1507, +0.1047, +0.4602, +0.2982, -0.1311, +0.2532, -0.6858, -0.4695, +0.3027, +0.2887, +0.2932, -0.2541, -0.3683, -0.0299, +0.2589, +0.2224, -0.4710, +0.1148, +0.0792, +0.0281, -0.4982, +0.1813, -0.2043, +0.0218, -0.3608, -0.1067, -0.2434, -0.7970, -0.1007, -0.1171, -0.2963, +0.2188, -0.1580, -0.0982, +0.0050, +0.2484, +0.0145, -0.1143, +0.3214, +0.0256, -0.0912, +0.1119, +0.1441, -0.4062, +0.0043, +0.2632, +0.2708, +0.1851, -0.2465, +0.1121, -1.0095, +0.1645],
[ -0.4014, -0.2026, +0.2846, -0.6558, +0.0347, +0.3577, +0.5068, +0.2295, -0.0671, +0.2854, +0.0606, +0.1284, -0.1989, +0.4217, -0.2977, -0.0018, -0.1862, +0.1605, -0.3136, -0.0787, +0.0600, -0.3946, -0.2211, +0.1092, -0.8535, -0.1927, +0.2168, -0.1391, -0.0491, +0.3785, -0.3388, +0.1676, +0.6633, -0.1240, -0.2232, -0.5539, +0.3391, +0.0774, -0.2397, +0.1715, -0.3901, -0.1495, -0.1945, -0.5558, -0.5401, -0.0403, +0.1773, -0.1364, -0.8861, -0.3095, -0.3624, -0.1893, -0.6739, -0.0664, +0.0423, +0.4223, -0.5428, +0.0579, -0.3165, -0.0048, -0.4670, +0.6076, +0.3093, +0.2623],
[ -0.1719, +0.3504, +0.1833, +0.1477, +0.0261, +0.0451, -0.1517, +0.4268, -0.1964, +0.0034, -0.0210, -0.0706, -0.2194, -0.0217, -0.3978, -0.0496, -0.0988, -0.0469, +0.1169, +0.0353, +0.1432, +0.4205, -0.0959, +0.1608, -0.0568, +0.2131, +0.1387, -0.0369, -0.2115, +0.0554, +0.3212, -0.2237, -0.0502, -0.2807, -0.2186, +0.1481, -0.3117, -0.0658, +0.0712, +0.0629, +0.1294, -0.1859, -0.1108, -0.1558, +0.0817, -0.0779, -0.0488, -0.0866, -0.2799, -0.1268, -0.0543, -0.2779, -0.1710, -0.0950, +0.3560, +0.0146, +0.2197, -0.4120, -0.0778, +0.4091, +0.2296, -0.6751, +0.3213, -0.0674],
[ -0.1059, +0.0068, -0.1438, +0.5933, +0.1308, -0.0400, +0.0812, +0.1777, +0.1475, +0.0797, -0.0084, -0.1350, +0.3455, -0.0605, +0.0910, -0.1240, -0.4803, -0.0662, -0.0615, +0.3251, -0.5353, +0.0038, -0.1402, -0.1655, +0.3568, +0.1347, +0.2741, -0.4235, -0.4194, -0.2106, +0.1872, -0.2549, -0.4104, -0.3447, -0.0416, -0.4719, -0.1906, +0.4272, +0.5201, +0.5004, +0.3452, +0.2016, +0.2914, +0.0317, +0.1510, -0.3496, +0.3332, -0.5135, +0.0054, -0.5988, -0.1678, -0.1000, -0.2546, +0.0079, +0.0912, +0.3928, +0.1183, -0.2694, +0.1489, +0.2103, +0.1661, +0.1418, +0.4398, -0.0656],
[ -0.0195, +0.1870, -0.1248, +0.1177, -0.0078, +0.1383, -0.0500, +0.3533, -0.2109, +0.4485, +0.1252, +0.2562, +0.0425, +0.1847, +0.0458, +0.3071, +0.0780, +0.0944, -0.1016, -0.5257, +0.0555, -0.0311, -0.2092, -0.5289, -0.2156, -0.2939, +0.2833, -0.1974, -0.6966, +0.3681, -0.2333, -0.3826, +0.0275, -0.0503, -0.1362, +0.1575, -0.2092, -0.0921, -0.0722, -0.4085, -0.0318, +0.0419, -0.1912, +0.0607, -0.3340, -0.0973, -0.1430, +0.2284, -0.0927, +0.3001, -0.1493, -0.0616, +0.1854, +0.0056, -0.1449, -0.2151, -0.1728, -0.0871, +0.1354, +0.0776, -0.0375, -0.0746, -0.0278, -0.1334],
[ -0.3822, -0.3932, -0.2103, +0.0972, +0.2112, -0.1231, -0.2574, -0.0029, -0.1786, -0.1599, +0.4116, +0.0375, +0.0221, +0.1877, +0.0255, -0.1355, +0.1670, -0.1492, -0.0601, +0.0232, +0.1488, -0.0682, -0.5803, -0.0816, +0.0175, -0.0961, +0.2995, -0.5726, +0.1919, +0.2955, +0.1316, +0.0757, +0.0199, -0.1009, -0.0442, -0.0637, +0.1080, +0.2183, -0.0234, -0.0653, +0.0331, -0.5678, -0.1834, -0.1544, +0.4640, +0.3347, +0.2779, +0.4620, -0.2515, +0.3186, +0.0829, -0.1316, -0.0217, -0.3495, +0.2158, +0.0353, -0.6992, +0.1088, -0.0673, +0.0954, +0.2027, -0.0296, +0.0658, +0.1745],
[ -0.0605, -0.2223, +0.1711, -0.3795, -0.7144, +0.3274, +0.2722, +0.4172, +0.0764, -0.1555, -0.1385, +0.3599, +0.1211, -0.0131, -0.0206, +0.3810, -0.1118, +0.2771, +0.0802, +0.1563, +0.0199, +0.2994, -0.4652, -0.3576, -0.3130, -0.1283, +0.0482, -0.2842, -0.5856, +0.0901, +0.1206, +0.1322, +0.1290, +0.0326, +0.1722, +0.2630, -0.1363, -0.0421, +0.0451, +0.1274, -0.2715, +0.1764, -0.1012, +0.1012, -0.0388, -0.2583, -0.2889, +0.1208, +0.1140, +0.0427, -0.2385, -0.0069, +0.0094, +0.1447, -0.1292, +0.1133, +0.4653, -0.1502, -0.0376, -0.6518, -0.0730, +0.2560, -0.0980, +0.1052],
[ +0.6443, -0.5361, -0.3105, -0.8694, -0.1024, -0.2693, +0.1653, -0.0868, +0.1197, +0.2414, -0.1494, -0.0676, +0.5761, -0.0355, -0.2653, -0.0357, +0.3097, -0.2331, +0.0953, -0.2471, +0.1249, +0.2378, -0.0510, -0.3424, +0.1945, -0.1950, -0.1748, +0.2752, -0.0734, -0.1434, -0.2893, -0.5022, -0.1479, +0.5078, +0.2914, -0.7655, +0.1676, +0.3477, -0.1369, +0.2448, +0.2735, -0.0949, -0.2488, +0.0998, -0.1965, -0.4407, +0.1348, -0.0462, +0.1083, -0.2382, -0.0508, +0.0322, +0.1262, -0.0323, +0.0455, +0.1707, +0.0710, +0.0490, -0.0590, -0.1585, +0.2960, +0.3273, +0.3040, +0.1016],
[ -0.1326, +0.2417, -0.4109, +0.1350, +0.2307, -0.3674, +0.1846, -0.0259, +0.3036, -0.1128, -0.1861, -0.1119, -0.1620, -0.1398, +0.2717, -0.2280, -0.1919, +0.0281, -0.0054, -0.2005, +0.0862, +0.3368, +0.0724, +0.0609, -0.2420, +0.0455, -0.2250, -0.1898, +0.1215, +0.1590, +0.0225, +0.3130, +0.0326, -0.0205, -0.0462, -0.1136, +0.1200, +0.2168, +0.0145, +0.0303, -0.0601, -0.1354, -0.1955, -0.1817, +0.3528, +0.0268, -0.0282, +0.0659, -0.1400, -0.4186, -0.2049, +0.1641, +0.2318, +0.3214, +0.0474, +0.2514, -0.7143, -0.2880, +0.3319, +0.2842, +0.1571, -0.0368, +0.2043, +0.1810],
[ -0.0739, -0.2970, +0.0941, +0.1027, -0.6547, +0.1803, +0.0386, -0.1237, -0.0137, +0.1162, -0.2699, -0.1136, -0.0843, -0.0808, +0.1833, +0.1394, +0.0526, +0.2046, +0.0638, -0.1984, -0.9595, -0.0241, -0.2129, +0.0324, +0.0618, +0.0582, +0.3178, -0.0338, +0.1736, +0.1007, +0.2776, -0.3235, -0.1017, +0.0333, -0.0706, -0.5985, -0.4251, +0.2707, +0.0847, -0.4468, -0.0653, +0.2370, +0.1995, -0.5153, -0.1756, -0.1634, -0.2775, +0.0931, +0.0393, -0.1703, +0.0444, -0.0163, +0.0622, +0.3296, +0.2991, -0.0265, -0.0263, -0.1455, -0.1887, -0.3039, -0.0179, +0.1650, +0.2597, -0.0090],
[ -0.1978, -0.2755, +0.1728, -0.1789, +0.1035, -0.2724, +0.0445, +0.0062, +0.0434, +0.0953, +0.1366, +0.1298, -0.1849, +0.0408, -0.2760, -0.1725, -0.1317, +0.0070, +0.2329, -0.0528, +0.1999, -0.0674, -0.2158, -0.0563, -0.1515, -0.0704, -0.0616, -0.1842, +0.0352, -0.0066, -0.1191, +0.1803, -0.3112, +0.0620, +0.2773, +0.4794, -0.0942, -0.2689, -0.2769, -0.0947, +0.0837, +0.0869, -0.3098, -0.1150, -0.0767, +0.0069, -0.1419, +0.1668, +0.1063, +0.1274, +0.2971, -0.0621, -0.2502, -0.3885, -0.4501, +0.2214, +0.0898, -0.0116, -0.1742, -0.0604, +0.0499, -0.2864, +0.0181, -0.2254],
[ -0.1022, +0.0675, -0.1046, +0.3019, -0.2542, +0.0912, +0.2791, -0.1668, -0.1508, +0.0673, +0.2539, -0.0353, -0.2882, +0.1563, -0.0798, +0.1140, +0.0927, +0.2254, +0.0477, +0.2645, +0.2529, +0.2444, +0.0264, +0.5441, +0.1837, -0.0147, +0.0501, -0.0805, +0.4287, -0.1217, +0.0621, -0.0112, +0.3316, +0.0262, -0.1870, +0.0158, -0.2525, -0.3677, +0.3915, -0.1570, +0.4636, -0.1263, -0.4133, +0.1593, -0.3453, -0.0135, +0.1291, -0.3324, -0.5259, -0.4501, -0.0331, -0.1657, +0.0195, -0.0939, +0.4609, -0.0321, +0.2384, +0.3020, -0.1030, -0.0926, +0.1575, +0.3610, -0.5751, +0.0661],
[ -0.0382, +0.2062, -0.2596, -0.0711, -0.3055, +0.0457, -0.0309, -0.0244, +0.2194, +0.2482, +0.1817, -0.0178, +0.0885, +0.1595, -0.2245, -0.1541, +0.3960, +0.2807, -0.0229, +0.1601, +0.0488, +0.0060, +0.4601, +0.0988, +0.2593, -0.1009, +0.0029, -0.2401, +0.0318, -0.1329, +0.1666, +0.0013, -0.1069, +0.1317, -0.0007, +0.1752, -0.1267, -0.4065, +0.2204, -0.1011, +0.3025, +0.1179, -0.3029, +0.0473, -0.1119, +0.0222, -0.3392, +0.4600, +0.1443, -0.3701, -0.1283, -0.2881, -0.2034, -0.1904, -0.0428, +0.0056, +0.2758, +0.0068, -0.2393, -0.1729, -0.0836, -0.0588, +0.0020, -0.0815],
[ +0.3471, +0.4317, -0.1161, +0.0449, +0.0050, +0.0961, -0.4823, +0.2328, -0.1653, -0.1468, -0.1486, +0.4360, -0.0632, +0.1432, +0.0087, -0.0512, -0.2344, -0.0102, +0.1651, +0.0246, +0.2162, +0.1100, +0.0975, +0.1876, +0.0694, +0.2708, +0.3610, +0.1482, +0.5449, -0.3128, +0.3967, +0.2450, +0.5441, -0.1881, +0.0162, -0.5922, -0.0861, -0.1250, -0.0447, -0.2822, -0.9453, +0.1361, -0.0902, +0.0170, -0.1518, -0.3040, +0.3247, +0.1936, -0.1466, -0.6617, +0.1230, -0.1005, +0.0451, -0.4780, -0.4344, -0.7798, -0.2074, +0.0143, -0.6049, +0.0167, +0.0176, +0.0829, -0.2657, -0.1117],
[ -0.0566, -0.2554, +0.0922, +0.1329, -0.0637, -0.1691, -0.7467, +0.2688, -0.0595, +0.0032, +0.1688, -0.0117, -0.7590, -0.2106, -0.0086, +0.2853, +0.2414, +0.1946, -0.1886, -0.0579, +0.2865, -0.0960, -0.7561, -0.2120, -0.1942, +0.0752, -0.1595, -0.0166, -0.5397, -0.2271, -0.0077, -0.2794, +0.0731, -0.3727, +0.3225, -0.2276, +0.1783, -0.0103, -0.0069, -0.6666, -0.4894, -0.2111, -0.3080, -0.1703, -0.0572, +0.0271, +0.1209, +0.3309, +0.0649, +0.0066, +0.0520, -0.1134, +0.0518, +0.2228, -0.0655, -0.4560, +0.2398, +0.3655, -0.1868, +0.2941, +0.1604, -0.4650, +0.0593, -0.1371],
[ +0.0403, -0.0122, +0.0969, -0.3156, -0.1005, +0.1031, -0.1481, -0.1076, +0.2276, +0.0388, -0.1574, +0.0217, -0.0203, -0.1458, +0.2504, +0.0702, +0.5039, +0.0035, -0.0965, -0.0350, -0.3649, -0.2921, -0.1710, -0.1763, -0.3255, +0.0464, -0.2342, -0.1771, +0.1025, +0.3519, +0.6704, -0.0161, -0.0398, -0.0397, -0.1314, -0.2516, +0.0786, +0.1558, +0.0304, +0.4443, -0.1499, +0.3062, -0.3467, -0.1288, +0.1297, -0.1038, -0.0285, -0.0522, +0.3859, +0.0927, -0.0098, +0.3045, +0.4045, +0.3493, +0.2691, +0.4336, +0.0318, -0.0402, -0.3010, +0.1520, -0.3728, -0.1197, +0.1927, +0.1588],
[ -0.0013, -0.3808, -0.1411, -0.4128, +0.0970, +0.1468, +0.4123, +0.1087, +0.3604, +0.1977, +0.3536, +0.3106, -0.0164, -0.4650, -0.1986, -0.1953, -0.3187, -0.2939, -0.6298, +0.4226, +0.2784, +0.1282, -0.2342, -0.2545, -0.6298, -0.3650, -0.0238, +0.3743, -0.8932, +0.2866, -0.1870, -0.0106, -0.3717, +0.0775, +0.0058, +0.0359, -0.0334, -0.7920, -0.3092, +0.2649, -0.3234, +0.1809, -0.8165, -0.3215, -0.3481, +0.4637, +0.0091, -0.2756, -0.1453, -0.9285, -0.4959, +0.0046, -0.4818, -0.0238, -0.0884, +0.3588, +0.0197, -0.0621, -0.2592, -0.2603, +0.4387, +0.3264, -0.0912, +0.0068],
[ -0.1870, -0.0427, +0.0765, -0.0647, -0.0770, +0.2825, -0.2109, -0.0953, +0.0203, -0.1633, +0.1579, -0.0627, +0.1797, +0.4872, -0.3755, -0.0651, -0.0641, +0.4970, +0.2071, -0.1331, +0.1534, +0.2254, +0.5375, -0.1598, -0.0651, +0.1228, +0.0028, -0.0031, -0.3692, -0.3297, +0.1652, -0.3708, -0.0532, +0.3925, +0.1538, +0.0345, +0.0777, +0.1399, +0.1334, -0.2490, -0.1238, -0.3203, +0.1191, +0.0943, +0.0145, +0.0727, +0.1883, +0.1748, -0.3185, +0.2363, +0.1582, +0.2475, -0.2665, -0.2220, -0.1297, -0.1738, +0.0412, +0.3838, +0.2247, +0.0391, +0.0418, -0.2974, -0.0086, +0.2516],
[ +0.2383, -0.0043, -0.2184, +0.0831, +0.1771, +0.2511, +0.2407, +0.1862, -0.0785, -0.0017, -0.1224, +0.2378, +0.2595, +0.0668, -0.2188, -0.4204, -0.3148, -0.0416, +0.1323, +0.0829, +0.2477, +0.0226, -0.4138, -0.0416, +0.1765, +0.2080, +0.1926, +0.1536, +0.0897, +0.3054, -0.0337, +0.0084, -0.1391, +0.0558, +0.4580, +0.3654, +0.0735, -0.0567, +0.0570, +0.1390, -0.0869, +0.4630, +0.0466, +0.4569, -0.1855, +0.2372, -0.1761, +0.3506, -0.2867, +0.0355, +0.0034, +0.0568, -0.1194, +0.2309, -0.1519, -0.1738, +0.1318, -0.0006, -0.0128, -0.0415, +0.1176, -0.3012, +0.2602, -0.6551],
[ -0.2165, -0.2043, -0.0407, -0.0021, -0.2475, -0.5003, +0.1174, -0.5645, +0.2294, -0.7098, -0.0850, +0.0087, -0.7054, -0.0304, +0.4289, -0.0664, +0.3738, -0.1368, +0.3550, +0.1465, +0.0907, -0.0676, +0.0412, +0.1191, -0.1538, +0.2874, +0.3340, +0.0672, -0.4169, -0.1932, -0.0945, +0.0354, +0.0665, +0.2364, -0.1876, +0.0133, -0.3061, +0.1044, -0.1093, +0.1152, +0.0305, -0.5244, +0.4529, -0.1952, -0.0589, +0.2792, -0.2381, -0.0503, -0.0691, -0.0609, +0.5304, +0.0002, +0.0118, +0.3001, -0.5737, +0.0245, -0.1293, +0.2015, -0.1249, +0.1715, -0.2372, +0.3565, +0.1182, -0.0657],
[ -0.2340, -0.2107, -0.2013, +0.0389, -0.0412, +0.6698, +0.4140, -0.4177, +0.0214, -0.2974, -0.1738, -0.0551, +0.1461, +0.0923, -0.1126, -0.1396, -0.0551, -0.0768, -0.1095, +0.4246, +0.1729, -0.0590, +0.0349, +0.3832, +0.0297, +0.2209, -0.0297, -0.2295, -0.2429, +0.1144, -0.1120, -0.1940, +0.1629, +0.2635, +0.1892, -0.1303, -0.0976, -0.0158, -0.2324, -0.1895, +0.2100, -0.2431, -0.3638, +0.2575, +0.4036, +0.1106, +0.0744, +0.2129, +0.1899, -0.3621, +0.1393, +0.6464, -0.3189, -0.1076, -0.2738, +0.1284, +0.1790, -0.1511, -0.3172, -0.6230, -0.3015, +0.2738, -0.3524, +0.1602],
[ -0.1970, -0.1120, +0.0975, -0.2831, +0.3243, -1.3188, +0.0375, +0.1861, +0.4376, -0.0179, -0.1076, +0.1917, +0.4778, +0.1558, -0.2861, +0.2611, +0.1770, -0.2430, +0.2632, +0.0587, +0.3669, -0.1362, -0.3884, +0.6586, -0.1424, -0.2870, -0.0663, +0.4068, +0.0752, -0.0627, -0.1279, -0.2130, +0.1657, -0.0365, -0.3581, -0.0534, +0.5405, -0.1753, +0.1166, -0.3898, -0.0546, -0.4579, +0.3436, +0.2864, -0.4675, -0.2519, +0.0647, -0.2795, +0.4284, -0.5265, +0.3633, +0.1719, -0.1952, -0.0018, -0.1962, -0.0394, +0.3354, +0.0215, -0.1851, +0.2358, +0.3445, +0.2866, -0.2699, -0.0757],
[ -0.1774, +0.0895, -0.0974, -0.1511, -0.3653, +0.1924, -0.2832, +0.3813, +0.1532, -0.4048, -0.2548, -0.2171, +0.0728, -0.1632, +0.2108, +0.3672, +0.2373, +0.0606, +0.1275, +0.0153, -0.2875, +0.3095, -0.0589, +0.0327, -0.1820, -0.0156, -0.3628, +0.2347, -0.5755, +0.2236, +0.3847, +0.0082, -0.0199, -0.0045, -0.0766, +0.0630, -0.3892, +0.3404, +0.2710, -0.4245, -0.1333, +0.2659, +0.2038, -0.0951, +0.2315, -0.1562, +0.0856, -0.0045, +0.3259, +0.0075, +0.1974, -0.2448, +0.1181, -0.4853, +0.0899, -0.0431, -0.0159, +0.1071, +0.0937, -0.1731, +0.1065, -0.3506, +0.0093, +0.2909],
[ -0.0888, -0.2677, -0.3962, -0.0806, +0.0171, +0.0339, -0.0342, +0.0016, +0.1005, +0.0587, +0.1371, +0.1769, -0.0201, -0.1308, +0.1351, +0.1879, +0.0508, +0.1420, -0.1227, +0.0408, -0.2464, -0.2122, -0.2929, +0.2600, +0.0820, -0.0216, -0.2166, -0.1016, -0.2578, +0.0780, +0.1049, +0.1988, -0.0318, +0.0164, +0.1450, -0.1296, +0.0225, +0.3259, -0.2695, +0.0886, +0.1384, +0.2675, +0.1353, -0.1297, +0.1897, +0.0361, +0.3122, -0.0314, -0.0349, -0.1618, -0.0801, +0.0982, -0.1650, -0.6592, +0.1678, +0.0939, +0.2711, -0.1591, -0.1353, -0.0342, +0.2077, +0.4509, +0.1098, -0.3925],
[ +0.1807, +0.2677, -0.0084, -0.0160, -0.1053, +0.1512, -0.2849, -0.5778, +0.2285, -0.3417, +0.3470, -0.3348, -0.4980, +0.2757, +0.0217, -0.4564, +0.6450, -0.1132, +0.3799, +0.2007, -0.2839, -0.1393, +0.1774, +0.1823, -0.1440, -0.5545, -0.0167, +0.0010, +0.1101, -0.3735, -0.1889, -0.0723, +0.4840, +0.0109, -0.3460, +0.4521, +0.0696, -0.0495, +0.5106, +0.0888, +0.2762, -0.0984, +0.6507, -0.4121, -0.2609, +0.0806, -0.1082, -0.0743, -0.0106, -0.5530, -0.2929, +0.0523, -0.2577, -0.3875, +0.6666, -0.0041, +0.2712, -0.2332, -0.3291, -0.1554, -0.0816, +0.2087, +0.6977, -0.3388],
[ +0.1251, -0.0121, +0.0121, +0.3163, +0.1309, +0.0464, -0.4722, +0.0429, +0.2493, -0.1650, -0.1630, -0.1376, -0.1345, +0.1320, -0.5876, -0.2795, +0.0182, +0.2368, -0.0634, +0.2229, +0.2678, -0.2174, -0.0511, +0.2635, +0.2053, +0.3891, -0.0295, -0.5624, +0.0546, -0.3031, +0.4465, +0.1553, -0.4066, +0.0002, +0.1791, -0.6401, -0.0541, -0.0939, +0.2058, +0.1194, -0.1805, +0.0157, -0.0932, +0.2732, -0.0843, +0.1328, +0.0328, +0.0468, +0.0180, +0.0445, +0.0499, +0.1526, -0.0741, -0.4016, +0.1665, -0.0478, +0.0162, -0.3923, -0.5001, +0.0137, +0.3040, +0.3412, +0.1603, +0.0540],
[ +0.0942, -0.2767, -0.2412, +0.0967, +0.1465, +0.2306, -0.6020, -0.2597, +0.0271, -0.4136, -0.0501, -0.5466, -0.2564, -0.0516, -0.1116, +0.3082, -0.0688, -0.0626, +0.1491, +0.2895, +0.2324, -0.1053, +0.0145, -0.2913, +0.2153, +0.0256, +0.3946, -0.0450, -0.3095, -0.1796, +0.1421, -0.0655, -0.2077, -0.2103, -0.0139, +0.3437, +0.0246, -0.0576, -0.3388, +0.2189, -0.1387, -0.1484, -0.1822, +0.2976, +0.0836, +0.1571, +0.0843, +0.1511, +0.0398, -0.0630, +0.3525, +0.0227, -0.3423, -0.1457, +0.5758, +0.0282, +0.1395, -0.2482, +0.1033, +0.0440, +0.1287, -0.1831, -0.0418, +0.0945],
[ -0.6291, -0.0032, +0.0681, +0.1307, +0.0207, +0.2823, +0.2134, -0.2167, +0.0635, -0.6624, +0.1488, -0.2110, +0.0904, -0.2652, -0.0213, -0.1736, +0.3279, +0.1690, -0.2461, +0.2105, +0.0517, +0.1614, +0.1707, +0.0494, +0.0421, +0.3173, -0.0158, +0.1013, -0.0940, +0.2423, +0.1062, +0.0693, +0.1048, -0.4015, +0.1935, -0.1850, -0.0091, +0.1678, -0.0917, -0.0349, -0.0691, +0.6117, -0.1676, +0.0088, +0.3704, -0.4575, +0.0383, -0.1905, +0.1865, -0.0222, +0.4076, -0.1894, -0.2520, +0.0551, -0.1634, +0.0015, +0.1114, -0.3029, -0.1562, +0.0015, -0.2600, -0.2177, +0.1082, +0.2172],
[ -0.0677, +0.0039, -0.0338, -0.2890, -0.1254, -0.1668, +0.5133, +0.1827, -0.1576, +0.2132, +0.5946, -0.3120, -0.2381, -0.0580, +0.1747, +0.4745, -0.5024, +0.3951, +0.3263, +0.0601, +0.1128, +0.4130, -0.0049, -0.3297, +0.0273, +0.4232, -0.0441, +0.1572, -0.0971, -0.2428, +0.0069, -0.0980, -0.1768, -0.1221, -0.4689, -0.1625, -0.1711, +0.1735, +0.7481, +0.0468, +0.1403, +0.1251, +0.5483, +0.3498, +0.0699, -0.1717, -0.0904, +0.1489, -0.0987, +0.1127, -0.5247, +0.2838, +0.0133, +0.1317, +0.1756, -0.7177, +0.3899, +0.1058, -0.1937, +0.0623, -0.3199, -0.2190, -0.7409, -0.2409],
[ -0.5880, +0.5615, -0.1183, -0.3175, -0.0278, -0.2732, -0.0417, -0.4918, +0.2375, -0.2411, +0.0500, +0.1810, +0.1690, -0.3814, -0.4404, +0.1103, -0.0108, -0.1556, +0.2023, +0.2723, -0.0517, +0.3908, -0.0328, -0.1600, -0.2407, -0.0752, -0.0481, +0.0497, +0.0014, -0.5295, +0.0068, +0.0295, -0.1680, -0.2176, +0.1996, +0.1011, -0.1805, +0.0194, +0.0246, +0.0275, +0.2443, -0.0051, +0.5000, +0.1951, -0.4283, -0.2476, +0.2095, +0.3373, -0.2396, -0.2651, +0.1420, -0.0526, -0.1718, +0.4073, +0.3726, +0.2376, -0.0560, +0.4961, +0.0695, -0.1009, +0.1812, +0.1296, -0.4310, -0.2585],
[ +0.4020, +0.1064, +0.0825, -0.0141, -0.0981, +0.2918, -0.1011, -0.3782, -0.1187, -0.1681, -0.2909, +0.4309, -0.1844, +0.5059, +0.5662, -0.2895, -0.1733, +0.2365, -0.0298, -0.4077, -0.3736, +0.0985, -0.3185, -0.1740, -0.4285, +0.1427, +0.0308, +0.6170, -0.2303, -0.3097, +0.3993, +0.5490, -0.9874, -0.3185, +0.4994, -0.1486, -0.5048, +0.4050, -0.4669, -0.3807, -0.0842, -0.0928, +0.2747, -0.4314, -0.4337, +0.0807, -0.4655, -0.5543, -0.0201, -0.1588, +0.0410, +0.0709, -0.2474, -0.1174, -0.5194, -0.3941, -0.0936, -0.5136, -0.3831, -0.8023, -0.1093, -0.5173, -0.0323, -0.3515],
[ +0.3207, +0.1516, -0.9030, +0.3079, +0.0712, -0.5695, -1.1105, +0.0038, -0.2928, -0.0691, +0.6932, +0.4123, +0.1021, -0.4672, +0.3795, -0.4115, -0.6110, +0.3305, -0.5308, -0.7386, -0.4514, +0.0343, -0.8573, -0.0276, -0.4753, -0.4059, +0.3052, +0.2842, -0.2480, +0.2726, +0.4324, +0.0477, -0.6364, -0.0051, -0.2560, -0.1127, -0.1164, +0.0808, -0.5083, -0.2596, +0.1790, -0.4965, +0.3910, -0.0742, -0.7266, +0.1271, -0.5876, -0.2302, +0.0428, +0.3302, -0.0355, +0.1025, +0.3317, +0.1654, -0.1466, -0.9274, -0.6385, -0.5677, -0.0182, +0.2386, +0.5524, -0.2693, -0.2206, -0.8103],
[ +0.0137, -0.1105, -0.1941, +0.2592, -0.0814, +0.1399, +0.1645, +0.1851, +0.1089, +0.3233, -0.0200, +0.0534, +0.0616, +0.0483, -0.1642, +0.0318, -0.1254, +0.1072, +0.0642, +0.3023, +0.0869, -0.4043, -0.1344, +0.0199, +0.1430, +0.1475, +0.1931, +0.0971, -0.0441, +0.0017, -0.1992, -0.3028, -0.6983, +0.3145, +0.2174, +0.2341, -0.0157, -0.2118, -0.0345, -0.4786, -0.0930, -0.1552, -0.2247, -0.3364, -0.3760, -0.1952, +0.0946, -0.3493, -0.1848, +0.0094, +0.0582, +0.1082, -0.2865, -0.0937, -0.1130, -0.0630, -0.1218, +0.2107, +0.2271, -0.1445, -0.0751, -0.2315, -0.1317, +0.0068],
[ +0.1205, -0.0542, +0.2574, -0.2720, +0.1138, -0.3059, +0.3300, -0.0127, +0.0380, -0.0834, -0.0322, -0.3479, +0.3156, +0.1242, -0.1784, +0.2794, -0.1835, -0.1977, +0.1537, +0.1032, -0.3062, -0.1807, +0.1288, +0.1175, +0.2074, -0.0396, -0.5236, -0.2744, +0.1423, +0.0919, +0.0964, -0.1907, +0.1639, -0.0414, +0.0808, +0.1209, +0.1530, -0.0742, +0.2545, +0.0800, -0.0373, +0.1604, +0.1901, -0.3515, -0.0762, -0.1451, -0.1988, +0.0920, +0.3343, -0.0617, +0.4146, -0.0081, -0.1291, +0.1680, +0.2233, +0.0421, +0.2823, -0.1211, +0.2422, -0.0224, -0.1207, -0.1214, -0.2309, -0.1438],
[ +0.5015, -0.1171, -0.1107, +0.0756, -0.4706, -0.4983, +0.2953, +0.0539, -0.0478, -0.3402, -0.0554, +0.0526, +0.2525, +0.2402, -0.3020, +0.1749, +0.2178, -0.3935, -0.0026, +0.1332, -0.4599, -0.0429, +0.0429, -0.3585, -0.0541, +0.4999, +0.0875, +0.1862, -0.3737, +0.3538, +0.0729, +0.5155, -0.2404, +0.1473, -0.0846, +0.0719, -0.1162, -0.0723, -0.0535, +0.3236, +0.2526, +0.1187, +0.1427, -0.2201, -0.3758, +0.2010, +0.2717, +0.2394, +0.5419, +0.3792, -0.2836, +0.3487, +0.1900, -0.0003, -0.0207, -0.0992, +0.1062, -0.4236, +0.1483, -0.1234, +0.0234, +0.1450, +0.3184, -0.0030],
[ -0.0565, +0.4235, +0.1189, -0.0516, -0.1428, +0.0560, -0.2450, -0.2446, +0.1377, +0.2584, -0.0286, +0.0035, +0.0299, -0.3522, +0.2452, +0.0922, +0.3694, -0.0901, -0.1512, +0.2378, -0.2716, +0.0136, -0.1893, -0.0290, -0.3591, -0.0824, -0.2285, -0.0742, +0.3169, +0.0582, +0.2584, +0.4226, +0.0137, +0.0774, -0.1940, -0.3938, +0.0343, -0.1348, +0.2146, -0.3989, -1.1966, +0.0074, +0.0716, -0.7460, +0.1243, +0.1348, -0.5400, +0.1177, +0.1448, -0.2361, -0.0745, +0.1181, -0.1362, -0.1412, -0.0378, +0.1068, +0.3488, +0.1217, +0.1188, -0.0590, -0.1220, +0.1855, -0.1229, +0.0534],
[ -0.0398, -0.4494, -0.0301, -0.2926, +0.2913, -0.0639, +0.0326, -0.5073, +0.3205, -0.0017, +0.1798, -0.1544, -0.4128, +0.2074, -0.3151, -0.0905, +0.2180, -0.2778, +0.2952, +0.0445, +0.4867, +0.2129, -0.2179, +0.2269, +0.1847, -0.0494, -0.5705, -0.3842, -0.0794, +0.3908, +0.1321, -0.1341, +0.1547, -0.0775, -0.5521, +0.1908, +0.2408, +0.0893, -0.1312, +0.1343, -0.0353, +0.0603, -0.6131, -0.1561, -0.4111, -0.1812, -0.1274, +0.1957, +0.0164, -0.1277, +0.0773, -0.0866, -0.4444, -0.3618, -0.2032, +0.5229, -0.3339, +0.1099, +0.3983, +0.3633, +0.0566, +0.0112, -0.1679, +0.2025],
[ -0.6095, -0.0147, +0.1274, -0.0710, +0.0673, -0.3818, -0.6802, -0.4320, -0.1566, -0.6649, -0.3622, -0.3016, +0.3599, +0.4427, -0.2626, +0.0683, +0.3183, -0.0102, -0.2444, -0.3838, +0.0800, -0.0518, -0.1091, +0.1206, +0.5122, -0.3048, -0.1711, +0.1226, +0.0761, +0.3250, -0.1590, +0.1478, -0.4915, -0.0714, +0.2999, -0.0968, -0.0799, +0.0226, -0.0257, -0.1239, -0.1299, -0.2144, +0.1403, +0.3091, -0.2391, -0.0308, -0.2184, +0.1551, -0.1017, -0.2943, -0.1126, -0.2844, +0.0941, -0.4044, -0.2976, +0.5766, -0.3036, -0.0388, -0.2637, +0.0223, +0.1434, -0.1087, +0.1303, -0.0823],
[ +0.6040, +0.2736, +0.2676, -0.0231, +0.2937, +0.0906, +0.7410, -0.3129, +0.0966, +0.5723, +0.1787, +0.1491, -0.1573, +0.1013, -0.5174, +0.2970, -0.4713, -0.1099, -0.0449, +0.0377, +0.0319, -0.1992, -0.0840, +0.1417, +0.1076, +0.0349, +0.2196, -0.0774, -0.0470, +0.1538, +0.2042, -0.1210, +0.1681, +0.2611, -0.0164, +0.5905, +0.1814, -0.4200, +0.1464, -0.6004, -0.3995, +0.0130, -1.2540, -0.0604, -0.5264, -0.0350, -0.0603, -0.0781, -0.2499, -0.4536, +0.0268, +0.3809, +0.0040, +0.1968, -0.0576, +0.3196, -0.1794, +0.4848, -0.1058, +0.2144, +0.0095, -0.0155, -0.3360, -0.0583],
[ +0.0699, +0.0571, +0.4402, -0.2232, +0.2019, +0.4001, -0.0916, +0.1629, +0.0738, +0.1974, -0.0559, -0.3632, +0.0902, +0.2513, -0.2527, +0.1484, +0.1896, -0.0781, +0.0524, -0.4268, +0.1315, -0.0526, +0.0586, +0.1903, +0.0987, +0.1384, +0.2330, -0.2099, +0.2384, +0.2354, +0.1904, +0.2404, -0.1477, +0.2111, +0.2005, +0.3399, +0.1134, -0.2812, -0.1407, -0.0697, +0.0823, +0.1282, +0.2007, +0.0426, -0.0657, -0.2504, -0.1793, +0.0808, +0.0602, +0.1142, +0.0521, +0.0056, -0.2531, -0.2954, -0.1716, -0.0496, +0.1372, -0.1585, +0.0900, -0.2423, +0.4631, -0.1106, -0.0665, -0.2033],
[ -0.3083, -0.1488, +0.3953, -0.0640, -0.2997, -0.2518, -0.1307, +0.1566, +0.1725, +0.1049, -0.4752, -0.2008, -0.2905, +0.2183, -0.4507, +0.0324, +0.1959, +0.3099, +0.1246, +0.1554, -0.3475, +0.0765, +0.0134, -0.0532, +0.2352, -0.1160, -0.1357, -0.0082, +0.1991, -0.1778, +0.1466, -0.0240, +0.0905, -0.1505, +0.2405, -0.5685, +0.4334, +0.0432, -0.3014, +0.1227, +0.2145, +0.0182, +0.1232, -0.0774, +0.1636, +0.1400, -0.0024, +0.0581, -0.0105, -0.2805, +0.3684, +0.0463, +0.2940, +0.2513, +0.0209, -0.0233, +0.0367, -0.3469, -0.0101, +0.0012, +0.1121, +0.0831, +0.2182, -0.4708],
[ -0.2216, +0.5790, +0.1601, -0.1500, +0.1610, -0.3998, -0.3192, +0.1948, +0.0915, -0.0963, -0.1138, +0.1750, -0.0423, -0.5254, -0.0899, -0.2128, -0.1407, -0.0147, +0.2051, +0.2922, +0.1934, +0.0812, +0.0817, +0.0467, -0.3107, -0.2356, -0.1372, +0.3155, -0.7030, -0.2158, -0.1743, -0.0948, +0.1300, -0.0957, +0.0092, -0.0280, +0.0368, +0.2047, -0.1139, +0.0372, +0.0373, +0.1000, -0.0335, +0.6758, -0.3660, +0.1443, +0.0610, +0.1879, -0.4563, -0.3780, -0.0316, -0.0278, -0.2973, -0.0836, +0.0807, +0.0162, -0.0488, +0.4995, -0.0429, +0.3392, +0.0073, +0.1484, -0.2559, -0.3795],
[ -0.0301, -0.7482, +0.3772, -0.1626, +0.2862, +0.2395, +0.2130, -0.0401, +0.0983, +0.1277, +0.5838, +0.0160, -0.1323, +0.0257, +0.1384, -0.1036, -0.1004, -0.2294, +0.1914, -0.1119, +0.3918, +0.2942, -0.1707, +0.2513, -0.2003, -0.0632, -0.1203, -0.0295, -0.0138, +0.0503, -0.4102, -0.2586, -0.3431, +0.1134, +0.1728, +0.3339, +0.1086, -0.1274, -0.1749, -0.0205, -0.0745, +0.0504, -0.5303, -0.0976, -0.3707, -0.0653, +0.0291, +0.3598, +0.1090, -0.1965, +0.0115, -0.4794, +0.2954, +0.4551, +0.3760, +0.2215, +0.1680, +0.0999, -0.1091, -0.3823, +0.1688, -0.3804, -0.1510, -0.2317],
[ +0.5293, +0.3565, +0.2616, -0.0049, -0.0741, -0.3735, +0.0294, -0.0711, +0.0273, -0.1086, +0.4174, +0.0640, +0.2633, +0.2134, -0.0068, -0.0063, -0.2693, -0.6457, -0.0099, -0.6433, +0.0969, -0.0909, +0.1019, +0.0016, -0.3093, -0.0270, -0.3555, +0.5279, -0.1148, -0.0132, +0.3908, -0.2490, -0.0587, -0.2580, -0.3187, -0.1844, +0.2920, -0.0457, -0.0764, -0.1217, -0.3195, -0.0262, +0.1473, +0.0131, -0.4217, -0.2028, -0.0147, -0.0492, +0.0521, -0.2008, +0.4162, -0.0873, +0.0384, -0.0398, -0.0254, +0.1336, -0.0962, -0.1936, -0.2700, +0.3369, +0.0171, +0.0604, +0.2942, +0.3882],
[ +0.4770, -0.3754, +0.4092, +0.1824, -0.2678, +0.0143, -0.0620, -0.1893, -0.3641, -0.2777, +0.1399, -0.0081, -0.1285, -0.1727, -0.2582, -0.1976, +0.0057, -0.3112, -0.1478, +0.4043, -0.1371, -0.3872, -0.0593, -0.2228, +0.0321, +0.2134, -0.2259, -0.1780, -0.1793, -0.0909, +0.0610, -0.2763, -0.6735, +0.1745, +0.1993, -0.0824, +0.0891, -0.4174, -0.3506, -0.1156, +0.1087, -0.3104, -0.0592, -0.3644, -0.2220, -0.0995, +0.0456, +0.1574, +0.0232, +0.2380, +0.0191, +0.1938, -0.3760, +0.5487, +0.0685, -0.0992, +0.0416, +0.2947, +0.1494, -0.3099, +0.0741, +0.3375, -0.0292, +0.3214],
[ +0.1222, +0.3371, +0.0062, +0.0671, -0.3129, -0.1655, -0.1300, -0.2491, -0.0616, +0.2192, -0.1626, -0.3767, +0.1512, +0.3055, +0.1256, +0.2497, +0.1170, +0.1043, +0.0181, -0.0154, -0.0424, -0.0667, -0.1153, +0.2526, +0.0341, +0.0010, +0.2425, -0.0702, -0.4358, +0.0602, +0.1291, -0.0971, -0.1222, -0.1263, -0.2412, -0.2112, +0.0426, +0.2015, -0.2164, -0.1215, +0.1231, -0.0830, -0.4098, -0.6542, -0.1633, +0.1517, -0.1455, -0.0050, +0.2311, -0.1131, -0.0810, -0.4420, +0.1214, +0.2765, +0.1036, -0.7303, +0.0521, -0.0541, +0.0801, +0.1260, -0.1570, +0.1061, +0.4255, +0.1914],
[ -0.2529, -0.3916, +0.0633, +0.2030, +0.1024, +0.1336, +0.0794, +0.0437, -0.3642, -0.0811, +0.2230, +0.1293, +0.1637, +0.1426, -0.2527, -0.0606, -0.2479, -0.0369, -0.0187, +0.1262, -0.0558, -0.2605, +0.0352, -0.3293, +0.2983, -0.4149, -0.0530, +0.1769, +0.0166, +0.0049, +0.4127, -0.0064, +0.0072, +0.0273, +0.2938, +0.0344, +0.3580, +0.0161, -0.0002, +0.0774, -0.1962, -0.0585, -0.3322, +0.5596, -0.2407, +0.3505, +0.0622, +0.1392, +0.1967, +0.1334, -0.1926, +0.1532, -0.1197, -0.0804, -0.6349, +0.2146, +0.2918, +0.1207, +0.1752, +0.2225, +0.1439, -0.1699, +0.1119, +0.2100],
[ -0.0469, -0.0001, +0.1237, -0.0254, -0.0751, -0.5268, -0.1196, +0.1138, +0.5923, -0.0540, +0.6184, +0.2041, -0.2341, -0.3209, -0.1727, +0.1187, +0.2574, +0.3551, +0.1803, +0.1942, -0.0046, -0.4156, -0.2799, -0.0497, +0.1905, -0.0357, -0.0055, +0.0343, +0.1635, -0.0727, -0.2640, -0.1404, +0.4230, -0.0678, +0.4181, -0.0475, -0.1425, -0.4179, -0.1888, +0.2541, -0.4472, +0.1832, +0.0713, -0.0642, -0.1479, +0.0141, +0.0404, -0.3321, -0.0990, +0.1329, +0.0745, +0.0653, -0.2698, -0.1160, -0.1253, +0.1705, +0.1437, +0.0412, +0.2454, +0.1914, -0.0788, -0.2867, -0.1166, -0.2133],
[ -0.0234, -0.8552, +0.0842, +0.1906, -0.1332, -0.0149, -0.0740, -0.0586, +0.1238, +0.0833, -0.0457, +0.1336, -0.1206, +0.1638, -0.2780, -0.0007, +0.1409, +0.1508, -0.1104, +0.0284, +0.0558, -0.4297, -0.0596, +0.0615, -0.1775, +0.1522, -0.0714, -0.0853, -0.3502, -0.1746, -0.2757, -0.0165, +0.0843, -0.0772, -0.0217, +0.1124, +0.0695, -0.0220, +0.1204, -1.0159, +0.2840, +0.3653, +0.4502, -0.2963, -0.1933, +0.2888, -0.0344, +0.0768, -0.2806, +0.2001, +0.0092, +0.3621, +0.2636, -0.1087, +0.0610, +0.1475, +0.0181, -0.4925, +0.0521, -0.0863, -0.0779, +0.0015, +0.0117, -0.1775],
[ +0.0524, -0.0913, +0.0905, +0.2547, -0.2749, -0.2516, -0.0681, -0.3018, +0.1213, +0.3117, -0.1108, -0.5373, -0.0335, +0.1720, +0.0940, +0.2742, +0.2002, +0.0689, +0.0319, +0.1931, -0.1454, +0.2832, +0.1740, -0.2103, +0.0583, -0.1842, +0.2393, +0.1395, +0.0108, -0.3865, -0.0785, +0.1232, +0.1928, +0.1845, +0.2064, +0.0482, +0.0274, +0.0609, -0.2075, -0.0976, -0.1087, -0.1842, +0.4248, +0.2685, -0.2429, +0.4411, +0.3092, -0.2872, +0.0002, -0.2025, +0.0289, +0.0159, +0.4430, -0.0033, +0.1018, -0.0369, +0.0879, -0.2220, +0.3732, -0.0657, +0.2615, +0.1740, -0.2855, -0.0748],
[ +0.1194, -0.1323, +0.1094, +0.0452, -0.1262, +0.0092, -0.7209, -0.0512, -0.0516, -0.3427, -0.1608, +0.4078, -0.2238, -0.4385, -0.1269, +0.0573, +0.4052, +0.2397, +0.1959, +0.1492, -0.0273, -0.0229, +0.1339, +0.1347, +0.1098, -0.1775, +0.0438, -0.0335, -0.3670, +0.0926, -0.1797, -0.2620, +0.2285, -0.0832, -0.1336, -0.2462, +0.1887, -0.1770, +0.0691, +0.1683, -0.6003, -0.2031, -0.8994, -0.3645, +0.1039, -0.2933, -0.2392, -0.0260, -0.5801, -0.4749, -0.0043, +0.1091, -0.1675, -0.2221, -0.1672, -0.4976, -0.0892, -0.3530, +0.0850, -0.1951, +0.0056, +0.2821, -0.0673, +0.2261],
[ -0.4063, +0.1076, -0.1068, -0.1531, -0.2660, -0.5626, -0.2666, -0.0695, -0.0512, +0.3986, +0.1527, -0.0454, +0.4261, -0.2644, -0.2249, +0.0133, -0.1167, +0.2593, -0.2567, +0.1875, -0.3186, +0.2615, +0.2224, +0.0574, -0.0199, +0.3355, +0.1355, -0.2071, +0.0306, -0.0055, +0.0496, +0.0245, -0.2550, +0.2006, +0.1209, +0.0734, +0.0667, -0.5211, -0.0668, -0.2071, +0.0397, -0.1430, +0.0516, -0.1057, -0.8747, -0.4072, +0.0611, -0.0378, +0.3958, +0.1072, +0.3282, +0.5085, -0.2959, -0.2021, +0.0351, -0.3564, +0.2423, -0.1374, +0.3635, -0.4542, +0.0860, -0.2765, -0.1167, -0.2078],
[ +0.5211, +0.1771, +0.3069, +0.0870, +0.0594, -0.4296, +0.2470, +0.2006, -0.1770, +0.1964, -0.0024, -0.1596, -0.6143, -0.0291, -0.2181, -0.0852, +0.2357, -0.1880, -0.1216, -0.0310, +0.0119, +0.1315, +0.0093, -0.1751, +0.6616, +0.0438, +0.1087, -0.1048, -1.0502, +0.0309, +0.2567, -0.0130, +0.0512, -0.3064, -0.1533, +0.1839, -0.1417, -0.6121, -0.0936, -0.5551, +0.0204, +0.0332, +0.2233, -0.0032, -0.2392, +0.1777, +0.1011, -0.0453, -0.0002, +0.2951, -0.2672, -0.0339, +0.0888, -0.3089, -0.1483, -0.0766, -0.1331, -0.0436, -0.3146, -0.0495, +0.0728, -0.0172, +0.1830, -0.1003],
[ -0.2570, +0.0940, +0.2393, +0.3173, -0.0217, -0.3896, -0.1349, +0.0239, +0.3556, +0.0342, +0.1750, +0.2039, +0.3332, +0.0657, +0.5660, +0.1103, +0.0569, +0.3217, +0.2929, +0.1269, -0.3295, -0.1103, +0.1738, +0.0270, -0.4494, -0.2644, +0.1447, -0.1966, +0.0070, -0.2052, +0.0011, -0.3802, +0.1231, +0.1362, +0.1591, -0.1147, +0.0815, -0.1926, -0.8875, -0.4582, -0.1277, -0.1313, +0.0916, -0.1440, +0.4420, +0.0111, -0.0502, -0.2659, -0.3220, -0.6949, -0.0098, +0.4001, +0.2575, -0.2495, +0.3586, +0.0874, +0.0050, -0.0547, +0.1422, -0.0044, +0.5492, +0.1640, +0.4104, +0.0151],
[ +0.1905, +0.0568, +0.4439, -0.1737, +0.1366, +0.1887, -0.5037, -0.1237, -0.0343, -0.0875, +0.0200, +0.2461, -0.0153, +0.1387, -0.4497, -0.1269, +0.0312, +0.0938, +0.3698, +0.5282, +0.1683, +0.0348, +0.4745, +0.2273, +0.3403, -0.3748, +0.0322, -0.1746, +0.2382, -0.1360, -0.2307, -0.1794, +0.4105, -0.2239, -0.5101, +0.0220, -0.1392, +0.2096, +0.1438, +0.1463, -0.6884, -0.0765, +0.2690, +0.5475, +0.2510, +0.1828, +0.1828, +0.3168, +0.3493, +0.3239, +0.0070, -0.0736, -0.0505, -0.4411, +0.3636, -0.2548, +0.1148, +0.2454, +0.0858, -0.0036, -0.0835, -0.1151, +0.2342, -0.0853],
[ +0.2806, -0.4244, -0.2728, -0.3960, -0.5862, +0.1748, -0.4243, +0.2895, -0.0602, +0.1419, -0.2212, +0.0112, +0.2878, +0.2368, +0.1428, -0.0974, +0.2006, +0.4285, +0.3253, +0.4745, +0.0699, +0.0245, -0.1376, +0.0063, +0.1911, +0.4971, +0.3070, -0.0230, -0.1926, +0.1697, -0.2759, -0.0620, +0.1636, +0.1698, -0.0925, +0.1512, +0.2989, -0.0834, -0.0062, +0.0021, +0.0047, -0.1870, +0.2432, -0.0995, +0.1666, +0.3287, -0.0184, -0.0031, -0.2882, +0.1287, +0.2006, +0.1161, +0.3720, -0.1048, +0.2680, +0.1392, +0.0522, +0.1738, +0.0910, +0.0304, -0.2150, +0.2297, +0.0448, +0.0792],
[ -0.9405, -0.5400, -0.2911, +0.2878, -0.1862, +0.0121, -0.0868, -0.2024, -0.4039, -0.0409, +0.2192, +0.1943, -0.1682, -0.1084, +0.4139, +0.0199, +0.1742, -0.0525, -0.2030, -0.5987, -0.0223, +0.5572, +0.1050, -0.0384, -0.4109, +0.1111, +0.0421, -0.0268, +0.0887, -0.0091, -0.1798, -0.4640, -0.1293, -0.0329, +0.2979, +0.0335, +0.0203, +0.1504, -0.0426, -0.3761, +0.2346, +0.0528, -0.1618, +0.5550, +0.2210, +0.2065, -0.0084, -0.1881, +0.0775, -0.0851, +0.2832, +0.3174, +0.2498, +0.4013, +0.4327, -0.0152, -0.4221, +0.0285, -0.1882, +0.0482, -0.1743, +0.1327, -0.0466, -0.0094],
[ -0.6150, -0.1858, -0.0927, -0.4074, -0.3241, +0.0582, +0.2685, -0.1007, -0.0478, -0.6214, +0.1968, -0.1926, +0.3691, +0.2873, -0.6615, -0.2229, +0.1732, -0.1066, -0.1297, +0.0285, -0.2100, +0.0482, -0.4222, -0.4841, -0.2798, -0.2620, +0.0930, +0.0484, -0.4821, -0.1353, -0.0631, -0.1075, -0.1494, +0.0720, -0.0413, -0.1464, -0.1442, -0.0388, -0.2277, +0.3864, +0.3828, +0.1844, -0.0788, +0.2435, +0.1145, -0.2702, +0.2642, -0.3138, +0.1316, -0.1518, -0.0019, +0.4323, -0.2238, -0.2658, -0.1059, +0.3625, +0.0360, -0.0563, +0.1040, -0.1834, -0.1469, +0.2465, -0.3229, +0.0085],
[ +0.5645, +0.0369, +0.0132, +0.2636, -0.1679, -0.2392, -0.0631, -0.2646, +0.2911, -0.3837, +0.1598, -0.1934, -0.3258, +0.2324, -0.1827, +0.3690, -0.6632, +0.3567, -0.1261, -0.2447, +0.0454, -0.0207, +0.4898, -0.2033, -0.0646, +0.0778, +0.3643, +0.1865, +0.0814, -0.1583, -0.2311, -0.0546, -0.4322, -0.0364, +0.2364, -0.4312, -0.0441, +0.1032, +0.1946, +0.3868, -0.6528, -0.0876, -0.2771, +0.4890, -0.2338, -0.3790, +0.0482, +0.1563, +0.0000, +0.0192, -0.0588, +0.1491, +0.2519, +0.4287, -0.1012, -0.0589, -0.0872, +0.4354, -0.1247, +0.0915, +0.0769, -0.1145, -0.2699, +0.5207],
[ +0.2858, +0.5389, -0.6188, -0.3253, +0.2332, +0.1636, +0.4974, -0.1036, +0.1363, -0.1994, +0.0481, -0.1565, -0.1655, +0.1514, +0.2075, +0.0125, -0.3081, -0.3344, +0.2779, -0.2142, +0.1161, +0.4471, +0.1350, +0.1933, -0.4881, -0.2883, +0.1809, +0.1834, -0.4621, -0.2264, -0.0406, +0.3630, +0.3781, -0.0976, +0.3265, +0.0996, -0.0993, -0.2306, -0.1160, +0.1858, +0.3173, -0.0106, +0.1044, +0.2541, -0.0047, +0.0603, -0.1183, -0.1677, +0.0924, +0.2065, -0.4116, +0.6073, +0.0962, -0.3375, -0.2197, +0.0342, +0.0583, +0.7827, +0.0869, +0.1510, +0.1244, +0.2806, -0.7157, -0.4886],
[ +0.0743, +0.0933, -0.2620, +0.2209, -0.3622, -0.4151, -0.0460, -0.1272, +0.2152, -0.1168, -0.2640, +0.1074, -0.3797, +0.0261, -0.1885, -0.4397, +0.1829, +0.0561, +0.3702, -0.2169, -0.4391, -0.1190, +0.2212, -0.4655, +0.4361, +0.1370, +0.2184, +0.1709, +0.0690, +0.3910, -0.0652, +0.3083, -0.1743, -0.2529, -0.1260, -0.3740, -0.0802, -0.1078, +0.1114, -0.3434, -0.0757, -0.0125, -0.0266, +0.1397, -0.2706, +0.2522, -0.0420, +0.3058, -0.1531, +0.0366, -0.5445, +0.1359, -0.0672, -0.2485, -0.0488, +0.0599, -0.1858, +0.2887, -0.0249, -0.3154, +0.2588, +0.0024, -0.2203, +0.0743],
[ +0.3025, +0.4329, +0.1923, +0.1225, +0.1224, +0.2024, -0.2161, -0.3197, -0.2715, +0.2124, +0.0443, -0.0926, -0.0431, +0.0376, -0.0693, +0.0692, -0.3014, +0.0758, -0.3986, +0.1838, +0.2021, -0.3140, +0.0993, +0.1919, +0.5939, -0.2367, -0.1488, +0.2414, -0.4195, +0.3308, +0.0019, -0.1339, +0.0676, -0.0966, -0.3194, -0.0858, +0.6964, +0.2206, -0.0443, +0.0252, -0.6221, -0.1297, +0.0172, -0.0786, -0.2550, +0.1502, -0.1052, +0.2009, -0.2713, +0.0779, +0.1162, -0.1933, -0.0590, -0.0220, +0.0522, +0.0922, -0.2390, +0.0160, +0.1406, +0.0926, +0.3161, +0.4449, +0.1350, -0.3143],
[ +0.1201, -0.0340, -0.0389, +0.2448, +0.0773, +0.1789, -0.1471, -0.2115, -0.0024, +0.1796, +0.3563, +0.2928, -0.1775, -0.1528, -0.0166, +0.3961, +0.2262, +0.3043, +0.0189, -0.1140, +0.2552, -0.2681, +0.1554, +0.0013, -0.2191, +0.1874, -0.1359, +0.2757, -0.3130, +0.4780, -0.5077, +0.2139, +0.2250, +0.3517, +0.4684, +0.0086, -0.0551, -0.4065, -0.1303, +0.1051, -0.0048, +0.1848, -0.3664, +0.1856, -0.2583, +0.0009, -0.2163, -0.3235, -0.0789, +0.1987, +0.1509, -0.1162, -0.1644, -0.0071, +0.5537, -0.2929, +0.1062, +0.1634, -0.1536, -0.3268, +0.3932, +0.1866, +0.1119, +0.1474],
[ +0.0142, -0.0993, -0.3203, +0.2203, +0.1826, +0.0739, -0.4311, -0.2367, -0.1681, -0.3958, +0.0997, +0.4901, +0.0237, -0.2148, +0.0365, +0.2112, -0.0449, +0.1284, +0.1338, +0.1394, +0.2342, +0.1176, -0.6435, -0.3328, -0.2502, -0.1318, +0.3134, +0.1531, -0.3200, -0.0256, +0.1667, +0.3992, -0.2006, +0.0348, +0.0558, +0.4010, +0.0780, -0.2531, +0.2522, +0.4957, -0.4136, -0.1343, +0.2136, +0.3185, +0.0266, +0.0862, +0.0159, +0.0952, -0.4685, +0.0040, -0.2379, +0.2009, -0.3173, -0.5862, +0.1336, -0.1231, +0.0124, +0.0691, -0.2836, -0.1575, +0.5874, +0.3214, -0.9054, -0.3527],
[ -0.1059, -0.0387, +0.0189, -0.2929, +0.0290, -0.1398, +0.0713, -0.0938, +0.1796, +0.0111, +0.0015, +0.5559, -1.2078, -0.1615, -0.0925, -0.0656, -0.1847, -0.1078, +0.0846, -0.2353, -0.0068, +0.1648, +0.0476, -0.5346, -0.0740, +0.1855, -0.2328, -0.0312, -0.0377, +0.0308, -0.2681, +0.0499, -0.6216, +0.1574, -0.0591, +0.1277, -0.2699, +0.1994, -0.2957, -0.4754, -0.8020, -0.2003, -0.2620, +0.1135, -0.3351, +0.0144, +0.2535, +0.2343, -0.3767, +0.1887, -0.4704, +0.0655, +0.0082, +0.2721, -0.0776, +0.2063, +0.0522, +0.1414, +0.1775, -0.4667, -0.0262, +0.3054, -0.0343, +0.1326],
[ -0.0944, +0.0687, +0.0429, -0.3561, -0.1968, -0.0692, +0.1979, +0.0508, +0.1279, -0.2800, +0.2372, -0.2334, +0.1609, -0.3954, -0.0385, -0.4805, -0.0246, +0.4076, +0.1872, -0.5398, +0.2978, +0.1593, -0.2653, -0.0049, +0.6545, -0.3312, +0.4015, -0.2824, +0.0679, -0.1267, +0.4482, +0.0637, -0.5610, +0.0890, +0.0209, -0.0047, +0.1194, -0.5188, -0.4086, -0.5192, +0.0604, -0.1054, +0.0918, -0.0288, -0.0074, -0.0196, -0.2045, -0.6647, +0.0798, -0.0586, +0.2773, -0.0977, -0.2254, -0.0513, -0.1226, +0.2995, +0.1935, -0.2491, -0.2953, -0.4115, +0.1534, +0.0546, -0.3809, +0.0408],
[ +0.2063, +0.0455, -0.0526, -0.3284, -0.2577, -0.3672, +0.0391, -0.0004, -0.0058, -0.5207, +0.1750, -0.2451, -0.1859, +0.1936, -0.4411, +0.1065, +0.0902, +0.2457, +0.1994, -0.1245, -0.0648, -0.1738, -0.5218, +0.1404, +0.0248, +0.2713, +0.1440, +0.4007, +0.1890, -0.0259, -0.2872, +0.0669, -0.8903, -0.1543, -0.5039, -0.1024, -0.1635, +0.3719, +0.0290, -0.4887, -0.2508, -0.2638, -0.1018, -0.3418, +0.2499, -0.1101, -0.0331, -0.4549, -0.2994, -0.2924, +0.3173, +0.0600, -0.0567, -0.1957, -0.0770, -0.4031, +0.0600, +0.7265, -0.0813, +0.3988, -0.4320, -0.4959, +0.0523, +0.1368],
[ -0.1476, +0.0743, -0.0658, -0.2890, +0.3666, -0.1478, +0.3773, -0.3211, +0.2370, -0.0153, +0.1826, -0.1452, +0.1886, -0.1678, +0.3284, -0.0733, +0.1826, -0.3888, -0.4845, +0.1015, -0.0870, -0.0794, -0.1185, -0.3348, -0.5251, +0.5470, +0.0555, -0.2144, +0.1589, +0.2827, -0.0293, -0.2797, -0.0275, -0.1539, -0.1238, -0.7424, +0.5685, +0.1096, +0.2752, +0.0236, +0.2567, +0.3483, -0.0039, +0.1292, +0.0550, -0.3177, +0.0190, -0.1787, +0.4918, -0.7343, +0.1046, -0.1065, +0.4025, +0.0512, -0.1233, +0.0134, +0.2500, -0.2037, -0.2264, +0.0889, -0.1584, -0.0409, +0.1919, +0.2113],
[ -0.4071, +0.1545, +0.2181, +0.0650, -0.0045, -0.1224, -0.5152, +0.3001, +0.0370, +0.1704, -0.0137, -0.0037, -0.4079, +0.4075, +0.2259, -0.2221, +0.0434, +0.3951, -0.0135, +0.1263, -0.0327, +0.2273, -0.6257, -0.0697, +0.0219, -0.3439, +0.0075, +0.0396, +0.1484, -0.1487, +0.2648, +0.0884, -0.6251, +0.1616, +0.2289, +0.1192, +0.5014, -0.0013, -0.3678, -0.5161, +0.0548, -0.3480, +0.3190, -0.3520, -0.4553, -0.0024, -0.1714, -0.0449, +0.1667, +0.3051, -0.1769, +0.1724, +0.1267, -0.1976, +0.2538, -0.1062, -0.0655, -0.1992, -0.0084, -0.1504, +0.0212, +0.1979, +0.4614, -0.0243],
[ +0.0155, +0.0346, +0.2300, -0.2500, -0.0590, -0.3079, +0.1280, +0.0243, -0.0939, -0.1572, +0.2208, +0.1864, +0.2283, -0.0581, -0.1514, -0.2499, -0.4172, -0.0109, +0.0207, +0.4273, -0.2715, -0.1691, -0.0745, -0.0516, -0.5832, +0.0751, -0.4696, +0.4893, +0.1412, -0.3262, +0.2960, -0.0760, +0.0291, -0.0170, -0.0601, -0.4856, +0.0527, -0.2092, +0.1662, +0.2670, +0.3699, -0.0822, +0.0826, +0.3220, +0.1915, -0.2385, +0.0153, +0.3710, +0.3485, -0.3379, +0.1008, -0.1491, +0.0983, +0.1098, +0.1218, +0.2479, +0.0393, -0.0165, -0.5000, -0.0565, -0.0665, +0.1202, +0.1958, +0.1652],
[ -0.0260, +0.0096, -0.1167, +0.3083, +0.1050, +0.4216, +0.0138, +0.2243, +0.2227, +0.1780, +0.3205, +0.0809, -0.0086, +0.2379, -0.1272, +0.0003, +0.2207, -0.0275, -0.4828, -0.0498, +0.2176, -0.1565, +0.0155, +0.1837, +0.2994, +0.2075, -0.1920, +0.2678, -0.1939, +0.1475, -0.0555, +0.1782, +0.0323, +0.1079, -0.3576, -0.4854, -0.4049, -0.4148, +0.0854, -0.2094, -0.1035, -0.3336, -0.3677, -0.2871, -0.0565, +0.0709, +0.0006, +0.2194, +0.0029, -0.1377, -0.1070, +0.0423, -0.4406, -0.4174, +0.1095, -0.1128, +0.2473, +0.2802, -0.0444, +0.1113, -0.2865, +0.0833, -0.2118, -0.2638],
[ -0.0911, +0.3135, +0.3976, -0.0957, -0.2627, -0.4086, +0.2340, -0.0677, +0.1377, +0.0447, -0.3164, +0.2154, -0.1067, +0.0647, +0.2372, +0.0443, -0.1576, +0.0042, -0.4562, -0.1443, -0.2174, -0.1132, +0.1305, +0.3033, +0.1461, +0.1287, +0.2707, +0.1232, +0.2582, +0.0615, +0.0199, -0.0319, -0.4083, +0.0414, +0.3738, -0.3539, +0.1584, +0.0043, +0.0278, -0.2233, -0.3325, +0.0009, -0.4560, -0.1136, +0.1232, -0.2123, +0.1892, +0.1868, +0.3310, +0.0035, +0.3691, -0.0236, -0.1921, +0.0891, +0.1162, +0.2183, +0.0728, -0.1317, -0.0537, +0.0711, -0.3516, +0.2881, +0.0266, -0.2357],
[ +0.1630, +0.3912, -0.0135, -0.2461, -0.5509, -0.1707, -0.1908, +0.1996, -0.4963, +0.1934, -0.0896, +0.0192, +0.1525, +0.1089, -0.1422, +0.3245, -0.0370, +0.0892, +0.2088, -0.1851, +0.0458, -0.1261, -0.1976, +0.3390, +0.1772, +0.1110, +0.2541, +0.5915, -0.0684, +0.0616, +0.2082, +0.0045, +0.0822, -0.1932, +0.3797, -0.1986, -0.0857, -0.3672, -0.1397, +0.0029, -0.1508, -0.0658, +0.5730, -0.2114, +0.0963, -0.0645, +0.0346, +0.0292, -0.0416, +0.1192, -0.3294, +0.0654, -0.4378, +0.3177, +0.1805, -0.1884, +0.2616, -0.1490, -0.1172, -0.1680, -0.0391, -0.2110, +0.4775, +0.2041],
[ -0.2090, -0.0867, -0.0316, -0.2632, -0.0833, -0.1139, -0.1187, -0.0057, +0.0900, +0.2975, +0.0698, +0.3754, +0.0224, -0.3070, +0.0235, +0.2797, -0.2223, +0.1967, +0.1714, -0.5326, -0.1556, +0.2027, +0.2475, +0.2375, -0.2827, -0.0910, +0.1670, -0.0049, -0.1393, -0.1362, -0.1945, -0.0307, +0.3437, +0.0964, -0.0688, -0.0802, +0.4165, +0.2761, +0.2269, +0.1068, +0.1084, -0.5953, +0.0252, -0.1215, -0.0682, -0.0258, -0.0262, +0.0501, -0.1782, +0.1275, +0.2232, -0.2725, -0.1698, +0.1202, -0.0176, -0.1798, +0.1512, +0.2020, +0.1476, +0.2363, -0.3545, +0.3259, +0.0483, +0.0271],
[ +0.0425, -0.0979, +0.0663, +0.0244, +0.3175, +0.0035, +0.0619, +0.1534, -0.0445, -0.2085, +0.1984, +0.1496, +0.5243, -0.1575, +0.2604, -0.1788, -0.3693, -0.0274, -0.0230, -0.0421, -0.2612, +0.2179, +0.0494, -0.1162, -0.2627, +0.2782, -0.0924, +0.1101, +0.2226, +0.1173, +0.0913, -0.1051, +0.2597, +0.1135, +0.3338, -0.3653, -0.0406, +0.2781, -0.3513, +0.1340, -0.1707, -0.0966, -0.3291, -0.0513, +0.5456, -0.2158, -0.6516, +0.2843, -0.2882, -0.3927, +0.1156, +0.3408, +0.3106, -0.6086, -0.0828, +0.3000, +0.0250, -0.1021, +0.0159, +0.0522, -0.1317, -0.0907, -0.4251, -0.1134],
[ +0.0361, -0.2899, +0.0973, +0.2793, -0.0427, -0.1415, -0.4320, -0.0748, -0.1431, -0.1738, +0.2088, +0.1487, -0.1370, -0.1103, -0.0430, +0.1095, -0.2704, -0.2414, -0.4316, -0.0102, +0.0887, -0.2723, -0.1054, -0.0289, -0.1507, -0.1237, +0.3909, +0.0043, +0.3644, -0.6322, +0.2782, +0.1685, +0.2415, +0.2440, -0.1952, -0.0268, -0.0210, -0.1018, +0.0588, -0.0897, +0.0181, -0.0333, +0.3120, +0.3882, -0.1843, -0.0865, +0.3599, +0.0431, -0.0989, +0.0616, -0.0561, -0.1112, -0.3506, -0.1863, -0.1134, -0.0934, -0.2850, +0.0672, -0.2332, -0.0067, -0.1347, -0.0355, +0.0895, +0.2657],
[ +0.0749, -0.3445, -0.4463, +0.2697, -0.4533, -0.6023, +0.1176, +0.4220, +0.1515, +0.0709, +0.1201, -0.7122, -0.2710, -0.5180, +0.4231, -0.6783, +0.0183, +0.1231, -0.0453, -0.4910, -0.1281, +0.3470, +0.4139, -0.1313, -0.7775, -0.2810, +0.2517, -0.4886, -0.2454, +0.3433, -0.3129, -0.9677, -0.5874, -0.1246, -0.2613, -0.4252, -0.0363, -0.0033, +0.2010, +0.3287, -0.2976, +0.4440, -0.4051, -0.2951, -0.7107, +0.3604, +0.0083, +0.2228, -0.5394, +0.2879, -0.2672, -0.1727, +0.6908, -0.3928, -0.0666, +0.4681, -0.4800, -0.2670, -0.0279, -0.5640, +0.0384, +0.4839, -0.7490, -0.3814],
[ +0.1412, -0.0575, -0.1321, -0.0647, +0.0187, -0.0201, +0.3041, -0.0787, +0.3259, +0.2995, +0.0956, +0.0668, +0.0506, -0.3596, +0.4898, +0.0535, +0.0505, -0.4045, -0.0791, -0.0201, -0.0997, +0.4296, +0.1827, +0.1199, -0.1099, +0.3086, -0.0554, +0.0808, -0.1152, +0.0492, +0.3040, +0.3085, -0.2243, -0.0605, +0.2724, -0.1311, +0.2565, +0.3901, -0.2024, -0.3716, +0.2060, +0.0096, -0.0854, +0.0897, +0.3007, +0.0582, -0.4583, -0.1288, -0.4200, -0.3854, +0.0498, +0.3196, +0.2622, -0.0582, +0.0570, -0.5543, +0.1612, +0.0750, +0.3226, -0.1246, +0.3872, +0.0833, -0.2056, -0.2349],
[ -0.1686, -0.2218, -0.2939, +0.1789, +0.2053, +0.4048, +0.0360, -0.0850, -0.2085, -0.1734, +0.1136, -0.2785, -0.1532, -0.0100, -0.1877, -0.0020, +0.1149, -0.2064, +0.1268, -0.1865, +0.7975, -0.0565, +0.0932, +0.2323, +0.0113, +0.1770, -0.2419, -0.0154, -0.0018, +0.0399, -0.2455, +0.1194, -0.2517, -0.1631, -0.2352, +0.2348, +0.0849, -0.0010, +0.2730, -0.1909, -0.2230, +0.0525, +0.0756, -0.3349, -0.0196, +0.2946, +0.3400, -0.3140, -0.6794, +0.3530, -0.2234, +0.0553, -0.4608, -0.0180, -0.0194, +0.1352, +0.2131, +0.2740, -0.1475, -0.1991, +0.0360, -0.0451, -0.3852, +0.0833],
[ -0.1050, -0.2275, -0.0302, +0.2786, +0.3946, -0.0109, -0.0017, -0.1051, -0.2192, +0.0290, +0.0311, -0.2059, -0.3525, -0.3862, +0.0111, +0.2281, -0.8662, +0.3166, -0.2334, +0.0513, +0.1893, +0.0802, +0.0646, +0.0006, +0.1565, +0.1965, +0.0329, +0.1527, +0.0271, +0.1250, -0.0723, +0.1069, -0.0742, -0.0588, -0.0390, -0.6050, -0.0613, -0.0658, -0.0388, +0.5054, +0.0974, +0.1428, -0.5064, +0.1998, +0.1709, +0.1940, +0.2506, +0.4479, -0.8026, -0.4646, +0.1419, -0.0521, -0.0256, -0.0465, -0.0074, +0.1982, +0.0607, +0.0324, +0.3568, +0.0607, -0.0666, -0.2546, -0.0794, -0.0285],
[ +0.2195, +0.2812, +0.1461, -0.0733, -0.2234, -0.1728, +0.2592, -0.0520, -0.3661, -0.5127, -0.1192, -0.4069, -0.1336, +0.0549, +0.2022, +0.3897, +0.0600, -0.0234, +0.0552, +0.0599, -0.1368, -0.1193, +0.1302, -0.3623, -0.0269, +0.2087, -0.2629, -0.0805, +0.0010, +0.0475, -0.3059, +0.1640, +0.1154, +0.1689, +0.1651, +0.0111, -0.2058, -0.0382, +0.2909, +0.1417, -0.1912, +0.0563, -0.1450, -0.2857, -0.0771, -0.1964, +0.2631, +0.0021, -0.0850, +0.1594, -0.0975, -0.4255, +0.2853, -0.0028, +0.1312, -0.1354, +0.0312, -0.2332, +0.0205, -0.1271, +0.2128, -0.3083, +0.3587, -0.0186],
[ +0.1014, +0.1514, +0.1971, +0.2186, +0.2783, -0.3467, -0.0134, +0.6314, +0.3050, -0.2803, -0.0510, -0.1937, +0.1359, -0.0083, -0.1691, -0.0778, -0.2169, +0.2847, -0.2439, -0.0396, -0.3531, -0.0309, -0.3176, -0.2350, -0.3094, -0.5735, +0.3704, +0.2366, +0.2710, -0.3633, -0.0036, -0.2733, +0.2801, -0.7404, +0.2456, -0.3113, +0.5818, +0.0624, -0.0120, +0.2439, +0.3342, +0.0445, +0.0795, -0.2049, +0.1364, -0.3062, -0.0440, -0.7126, +0.5455, -0.2516, -0.1074, -0.0691, +0.3672, +0.5358, -0.2354, +0.1471, -0.1116, -0.3275, -0.1727, +0.5189, +0.0758, +0.1196, -0.0837, -0.3373],
[ -0.1779, -0.0134, -0.1380, +0.0187, -0.1732, -0.0400, +0.1369, -0.3203, +0.2186, -0.0468, +0.0910, -0.3323, -0.1836, +0.1829, +0.2422, +0.0330, -0.0946, +0.0484, +0.0811, +0.0050, +0.1248, +0.0335, +0.0894, -0.1750, +0.3270, +0.1264, +0.5534, +0.3109, -0.6803, +0.2830, -0.2489, -0.2128, +0.0285, -0.0616, +0.1873, +0.4221, -0.1250, -0.2668, +0.1128, -0.1706, +0.4020, -0.0613, -0.1724, -0.1172, +0.2177, -0.0682, +0.0959, +0.0391, -0.0429, +0.1116, -0.0561, -0.0832, +0.2643, -0.7224, +0.1871, -0.1984, -0.5711, +0.0314, +0.4821, -0.0693, +0.0019, +0.0911, -0.0162, +0.0416],
[ -0.1079, +0.0036, +0.0858, +0.0651, +0.1251, +0.2102, -0.6925, +0.1962, +0.0107, +0.2620, -0.2953, +0.0383, -0.5347, -0.0562, -0.1229, +0.0088, -0.3332, +0.2430, -0.7208, +0.2296, -0.2454, -0.0415, +0.1679, +0.0644, +0.5393, -0.1609, -0.2533, -0.2495, +0.1430, -0.1157, +0.0425, +0.0127, +0.3647, +0.2542, +0.1893, -0.3235, -0.3585, -0.0336, -0.3622, -0.4502, -0.3375, -0.3524, -0.6786, -0.1081, -0.0497, -0.0417, +0.1961, -0.0419, +0.2591, -0.6628, +0.4420, +0.1639, +0.1667, +0.2534, +0.2039, -0.2187, +0.3177, +0.0763, -0.3111, +0.2323, -0.2931, +0.0833, -0.5989, -0.1641],
[ +0.2527, +0.1992, +0.2990, -0.0389, -0.2021, +0.2928, -0.0444, -0.3077, -0.0187, +0.0386, +0.0077, -0.1157, +0.1781, +0.0621, +0.1187, -0.0114, -0.1287, +0.0152, -0.1720, -0.0066, -0.0873, +0.0786, +0.1859, +0.2193, -0.1179, +0.0601, +0.0423, +0.1095, -0.0085, +0.3047, +0.2369, -0.0138, +0.2164, +0.4661, +0.0852, +0.2240, +0.2824, +0.1814, +0.0162, -0.1359, +0.2834, +0.6096, +0.2349, +0.0675, -0.2046, +0.0374, -0.0712, +0.0083, +0.0759, -0.0044, +0.1442, +0.0871, +0.3323, +0.1052, +0.2050, +0.1211, +0.4875, -0.3261, -0.1544, -0.2502, +0.2057, -0.0179, +0.1240, +0.3203],
[ +0.0357, -0.2920, +0.1721, +0.2219, -0.0244, -0.2967, +0.0325, -0.0216, -0.0467, +0.1548, +0.2694, -0.0631, +0.0219, +0.4049, -0.0196, +0.4261, +0.6962, +0.1439, +0.2500, -0.2941, +0.0126, +0.1531, -0.1166, +0.1501, -0.0110, -0.2142, -0.1981, +0.0716, -0.2858, -0.1305, -0.1828, -0.2683, +0.4329, +0.0338, -0.0559, -0.2110, +0.2415, +0.3667, +0.4146, -0.0323, +0.0113, -0.6723, -0.0404, +0.0869, +0.5138, -0.0981, +0.0426, -0.0036, +0.2356, -0.0310, +0.2347, +0.0532, -0.3200, -0.3260, +0.5802, +0.2519, -0.0406, -0.1058, -0.1501, -0.1716, +0.1779, -0.2536, +0.1470, -0.0944],
[ -0.0292, +0.0003, +0.0387, +0.0054, +0.3651, -0.4123, +0.4570, +0.3365, +0.3065, -0.3405, +0.1849, +0.2971, -0.2624, -0.0992, +0.3043, -0.0365, +0.0008, -0.1717, +0.5312, -0.1827, +0.1921, -0.0037, +0.0214, +0.0544, -0.1299, +0.2135, -0.0440, +0.1722, -0.4182, -0.1780, +0.0983, -0.0019, -0.0323, -0.1045, -0.0508, +0.1173, +0.1064, -0.0799, -0.1009, -0.9873, -0.2146, +0.1782, +0.0576, +0.1155, -0.0983, +0.1103, -0.0915, -0.1455, -0.1294, -0.1339, -0.2614, -0.2904, -0.2526, -0.1257, -0.2941, -0.3675, +0.0117, +0.2198, -0.0896, +0.0531, -0.2761, -0.2358, +0.3290, -0.0602],
[ +0.4236, +0.3655, +0.0359, +0.1956, +0.1510, +0.0330, -0.0793, +0.3292, +0.0400, +0.3221, -0.1718, +0.0837, -0.4517, -0.0648, -0.3480, -0.2822, -0.2623, +0.0474, +0.1530, -0.2234, +0.3162, -0.2084, +0.0521, +0.2040, +0.1564, -0.4446, +0.1535, -0.0316, +0.3228, +0.0364, +0.1340, -0.0323, +0.1550, -0.0263, -0.0777, -0.0052, +0.1703, +0.1157, -0.0141, +0.3355, -0.1618, +0.0504, -0.2969, -0.3633, -0.4625, -0.0749, +0.3221, -0.2092, -0.5488, -0.0243, -0.2180, -0.1481, -0.0890, +0.0965, -0.3498, -0.2517, -0.1390, +0.1790, -0.0509, -0.2493, -0.0274, +0.0919, -0.2114, +0.2976],
[ +0.2644, +0.2090, +0.0633, -0.1268, -0.0599, +0.0284, +0.0813, +0.1702, -0.0567, -0.3952, +0.2836, -0.6299, -0.3440, +0.1447, +0.2234, +0.0027, +0.2899, +0.6088, -0.1386, -0.3315, +0.1396, +0.3649, +0.0243, +0.1266, -0.0294, +0.0368, -0.0501, +0.0541, +0.0016, -0.3894, -0.1202, +0.5999, +0.1747, +0.1921, +0.1513, -0.2294, -0.0289, +0.1886, -0.0357, +0.5478, -0.3787, -0.2211, +0.3738, +0.1265, -0.0221, +0.1378, +0.1057, +0.1893, +0.1694, +0.1892, -0.1525, -0.2253, -0.1673, +0.1694, -0.0721, +0.1326, +0.0857, -0.2437, +0.0493, +0.0321, +0.2266, +0.0044, -0.1672, +0.1493],
[ -0.1102, -0.3961, +0.2519, +0.3730, -0.0006, -0.1153, -0.3954, +0.0059, -0.3876, +0.2810, +0.4361, -0.1025, -0.3040, +0.4484, -0.2901, -0.2973, -0.1730, -0.2076, +0.2166, -0.2178, +0.3075, -0.3478, -0.2174, -0.1184, +0.0366, -0.4735, -0.0242, +0.0721, -0.0580, +0.0264, -0.2233, +0.3913, +0.1703, -0.1805, +0.0202, +0.2869, -0.1726, -0.1132, +0.6778, -0.1385, +0.0843, -0.1418, -0.2475, +0.0497, -0.1990, +0.1442, -0.0073, +0.1827, +0.1355, +0.0986, -0.1838, -0.1865, +0.1692, -0.4658, +0.4467, -0.3176, -0.3614, +0.0003, +0.0602, +0.0397, -0.0250, -0.2435, -0.1341, -0.0446],
[ +0.0383, -0.3444, +0.1458, +0.0075, +0.1428, -0.0649, -0.3146, +0.1099, +0.1578, +0.1121, -0.2096, +0.2301, +0.2019, -0.0238, -0.1351, +0.0901, -0.2510, -0.0681, +0.2813, +0.1587, -0.0990, -0.1544, +0.1091, +0.2972, -0.0270, -0.5291, +0.0119, -0.2590, +0.3401, +0.1121, -0.0104, -0.0251, +0.0384, -0.1476, -0.1065, -0.5903, +0.2326, +0.2800, +0.0839, -0.3054, -0.4898, -0.0217, -0.1271, -0.4094, -0.3255, -0.0135, -0.3048, -0.1536, -0.0363, -0.9790, +0.0750, +0.3379, -0.0138, +0.1359, -0.0234, +0.2242, -0.4072, +0.1760, -0.1182, +0.1759, -0.1840, +0.5797, +0.0987, +0.1210],
[ +0.2328, +0.1287, +0.1524, -0.2866, +0.1292, -0.1823, +0.0576, -0.1963, -0.3391, -0.1681, -0.0900, -0.4237, +0.1512, +0.3880, +0.1940, +0.1491, +0.1925, -0.2388, -0.2645, +0.0341, -0.0213, -0.2066, +0.2230, +0.3038, -0.5238, -0.0729, +0.0031, +0.1376, +0.1982, +0.0996, +0.0705, +0.4464, -0.1415, +0.1403, +0.1675, -0.4531, +0.0612, -0.1734, +0.2393, +0.0172, +0.0457, +0.0595, -0.8221, -0.1509, -0.4281, -0.0950, +0.0201, -0.0703, -0.2627, -0.4535, -0.1560, +0.1246, -0.2124, +0.2910, +0.0554, -0.1800, -0.2412, +0.0722, +0.2058, +0.1655, -0.1150, +0.0432, -0.2586, -0.7599],
[ +0.1087, -0.0738, -0.1913, +0.1016, -0.5592, +0.0964, -0.2612, +0.3334, +0.2771, +0.1028, +0.0510, -0.1074, -0.1861, -0.1382, +0.2289, +0.2520, +0.3477, -0.0905, +0.0764, +0.1308, -0.4080, +0.2522, -0.3001, +0.2684, -0.2450, -0.0601, -0.2079, +0.0955, -0.1911, +0.1271, -0.1471, +0.0364, +0.2841, +0.2306, +0.0218, -0.2685, +0.0615, +0.7573, +0.0729, +0.2046, -0.0251, -0.0830, -0.4702, +0.1098, +0.1279, -0.0733, +0.1917, -0.0173, -0.1401, -0.4548, +0.4188, -0.1860, +0.1765, -0.0207, +0.1410, -0.1508, +0.0812, +0.1099, +0.4419, -0.0073, +0.1401, +0.5210, +0.0469, -0.5455],
[ +0.1478, -0.1462, +0.0595, -0.0555, -0.0963, -0.1743, -0.4607, +0.1260, +0.2643, +0.2064, +0.0051, -0.0717, -0.5835, +0.2349, -0.2578, +0.0985, -0.1751, -0.1043, +0.0939, -0.0269, +0.2807, +0.0057, -0.3075, -0.3509, -0.1542, -0.0109, -0.0978, +0.1136, -0.6857, -0.3110, +0.0709, +0.1987, -0.1245, +0.0641, +0.4018, +0.2761, +0.0920, -0.0038, -0.1586, +0.2828, -0.4420, +0.0082, -0.2252, -0.1342, -0.4605, +0.4232, +0.0852, -0.1053, -0.2416, +0.0730, -0.1493, -0.2711, -0.2168, -0.1187, +0.1187, -0.0218, +0.0022, +0.0938, +0.1860, +0.0201, -0.0745, -0.1548, +0.6445, -0.2248],
[ +0.1302, -0.1398, +0.7537, +0.1383, -0.5086, +0.0545, -0.3660, +0.2780, -0.2497, -0.1659, -0.5407, +0.0406, +0.2827, +0.0671, +0.4195, -0.2269, +0.0264, -0.2525, -0.0190, +0.0868, -0.3568, -0.1169, +0.0496, -0.1620, +0.0165, -0.2250, +0.4267, +0.2168, +0.0021, -0.0930, +0.3241, +0.1526, +0.3213, -0.0451, -0.5578, +0.1170, -0.1235, +0.4526, -0.4232, -0.2525, +0.0646, +0.1047, -0.5120, -0.1974, +0.2188, +0.4676, -0.0113, -0.0569, +0.1487, -0.3116, +0.0071, +0.1809, +0.4505, +0.1717, -0.1122, +0.5637, +0.5229, -0.1974, +0.2414, -0.2873, +0.2274, +0.0985, -0.3526, -0.0650],
[ +0.5322, +0.5838, +0.3066, -0.0447, -0.4926, +0.1226, -0.2968, +0.4411, -0.2813, +0.0133, -0.0917, -0.9095, -0.6942, -0.1584, -0.0158, -0.0415, +0.2842, -0.0849, +0.0081, +0.1006, -0.1806, +0.2545, -0.0702, +0.2139, -0.7846, -0.1128, -0.0370, -0.0182, -0.3695, -0.0357, -0.0790, -0.0014, -0.0999, -0.0408, -0.5365, +0.1014, -0.3627, +0.1566, -0.2306, +0.1502, -0.3747, +0.0484, -0.6206, -0.3506, +0.1784, -0.1409, -0.2110, -0.2758, +0.0556, +0.5386, -0.0272, +0.1074, -0.0227, -0.2939, +0.1937, -0.0113, +0.0356, -0.3483, +0.1974, -0.2345, +0.5157, +0.0645, -0.5039, +0.0335],
[ +0.0854, -0.2422, +0.3192, -0.1538, -0.1908, +0.1884, -0.1621, -0.2583, -0.0354, -0.2273, +0.0210, -0.1983, +0.1332, -0.0799, +0.3607, -0.0500, +0.0147, -0.1671, -0.2046, -0.0505, -0.1382, +0.0815, +0.0095, -0.1806, -0.2811, +0.0207, -0.1240, -0.0615, +0.1323, -0.1915, +0.2524, -0.1157, -0.1691, +0.2042, -0.1481, -0.1134, +0.1108, +0.2766, +0.1472, -0.0591, -0.0232, +0.0738, +0.1079, -0.0070, +0.3365, -0.1386, -0.1922, +0.1916, +0.0077, -0.5986, +0.3365, -0.1571, +0.0404, +0.0008, -0.0684, +0.1178, -0.0623, +0.1870, -0.0683, -0.0194, +0.3098, -0.1173, +0.2522, +0.5147],
[ +0.0431, +0.3529, -0.2172, +0.2305, -0.1550, -0.1934, -0.0375, -0.3424, +0.2204, +0.1204, -0.0151, +0.2537, -0.2432, +0.4461, -0.2474, +0.0377, -0.2390, -0.0405, +0.1470, +0.1798, -0.2362, +0.4609, +0.2270, -0.0387, +0.0956, -0.1044, -0.0736, -0.2755, +0.5806, +0.0843, -0.0228, +0.1490, +0.4448, -0.0509, +0.3144, -0.0046, +0.3466, +0.3394, -0.2300, -0.8838, +0.1503, +0.1127, +0.1052, +0.1555, -0.1990, +0.2116, +0.1065, -0.2913, +0.0781, -0.2671, +0.1246, -0.0662, +0.0866, -0.1592, +0.0961, +0.3755, -0.2982, +0.1358, -0.2747, -0.1484, -0.1547, +0.1429, +0.0380, -0.0317],
[ -0.5473, -0.0753, +0.0262, -0.1786, -0.1250, +0.0426, -0.1150, +0.2411, -0.4113, -0.8943, +0.1717, +0.4366, -0.2856, +0.0529, -0.0598, -0.0095, +0.5480, +0.0000, +0.2781, +0.1064, -0.0185, -0.0854, -0.4660, -0.4285, -0.4955, -0.3631, +0.0804, +0.1754, +0.0726, +0.4435, -0.3222, +0.0179, -0.1059, +0.0551, -0.1274, -0.0478, +0.1583, -0.1331, +0.3105, -0.4682, -0.0816, +0.3200, -0.0358, +0.0576, -0.0160, -0.2500, +0.2872, +0.0759, +0.1068, -0.3476, -0.0587, -0.1402, +0.1804, -0.5405, -0.3722, -0.1204, +0.4614, -0.2617, +0.1028, -0.2566, -0.0372, +0.0024, -0.0266, +0.2123],
[ +0.0999, +0.2877, -0.1863, +0.0461, +0.3460, +0.0645, +0.2480, -0.3094, +0.3726, -0.6047, -0.0567, -0.0629, +0.0377, -0.2853, +0.5711, -0.2738, +0.2291, -0.2856, +0.1165, -0.0528, -0.2972, +0.5926, +0.2315, -0.0101, -0.2790, +0.1800, -0.0957, +0.0315, -0.0415, -0.3105, -0.2582, -0.3666, -0.1313, -0.0954, +0.2363, -0.1974, +0.2422, +0.2477, +0.0480, -0.5666, +0.1782, -0.0861, +0.0374, +0.3289, +0.2384, -0.1874, +0.0505, +0.1744, -0.0534, -0.0888, +0.0892, -0.2003, +0.3478, +0.0312, +0.3776, -0.0330, +0.0414, +0.0171, +0.0769, -0.2743, +0.1367, +0.1933, -0.2324, +0.0365],
[ +0.1785, -0.1122, -0.2831, +0.1849, -0.0992, +0.3791, -0.1068, -0.0855, +0.0207, +0.2323, -0.0044, +0.1958, +0.1852, +0.3399, -0.0256, +0.1774, -0.4276, -0.2823, -0.3379, +0.0866, +0.2101, +0.0131, -0.2663, -0.0845, -0.1494, +0.0548, +0.1993, +0.2739, -0.5014, -0.2326, -0.2824, +0.3746, -0.2623, -0.1623, -0.0328, -0.0134, +0.0970, +0.0388, +0.0140, +0.2769, +0.0521, -0.2303, -0.1229, -0.1527, +0.2421, +0.2330, +0.3564, +0.1682, -0.4525, -0.1253, -0.1900, -0.0262, +0.2722, +0.1425, -0.0268, -0.3193, +0.2537, -0.0439, -0.1250, +0.3318, +0.2772, -0.1929, +0.3152, +0.2810],
[ -0.3670, -0.2762, -0.4161, -0.2056, +0.2310, -0.3049, +0.1498, +0.3978, +0.2436, -0.0663, +0.0115, -0.7049, +0.1884, -0.0436, -0.0234, -0.2039, -0.2695, -0.3920, -0.4772, +0.2428, +0.1676, +0.2518, -0.1180, -0.1186, -0.2333, -0.4051, -0.0411, +0.3249, -0.3408, +0.0656, -0.3001, -0.2062, -0.4585, -0.0022, -0.1315, -0.3576, -0.1472, +0.1294, -0.1529, -0.1078, +0.6348, -0.1159, -0.2419, +0.4743, +0.0535, -0.2574, +0.4136, -0.5154, +0.3080, -0.1191, -0.2063, -0.1299, +0.5128, -0.3273, +0.1894, -0.1496, +0.2328, +0.1088, +0.2355, +0.1916, -0.1193, +0.0808, +0.0300, -0.5794],
[ +0.1957, +0.4934, -0.3835, -0.1728, -0.1420, -0.1773, -0.0964, -0.0198, -0.0873, +0.1293, +0.1083, -0.5931, -0.6758, -0.1756, +0.0005, +0.2318, -0.1142, +0.0221, -0.0696, -0.4323, -0.0577, +0.0718, +0.1480, +0.2719, +0.1460, +0.1078, +0.2433, -0.1229, -0.5580, +0.0863, +0.1028, -0.0749, +0.0373, -0.1733, +0.0263, -0.1305, -0.2804, -0.1738, -0.1685, -0.2052, -0.6723, +0.2801, -0.0618, +0.3867, -0.0818, -0.0747, +0.0693, +0.2544, +0.1115, -0.1408, -0.1755, +0.1060, -0.0848, -0.1159, -0.2659, +0.0770, +0.1069, +0.5496, -0.1213, -0.3043, -0.1008, -0.2097, -0.6576, -0.4030],
[ +0.2352, -1.2198, +0.3415, +0.4012, +0.1491, +0.2011, -0.3524, +0.1913, +0.0022, -0.3440, -0.2671, -0.2184, +0.2202, +0.3994, -0.2331, +0.1422, -0.1278, -0.1052, -0.0429, +0.4241, +0.1648, -0.0626, +0.0286, -0.0347, +0.0999, -0.7259, -0.1441, -0.2610, +0.0523, +0.5524, -0.5383, +0.0029, -0.6297, -0.1463, -0.1886, -0.2937, -0.0598, +0.2567, +0.4021, +0.1207, +0.2705, +0.1052, -0.3745, -0.6421, -0.3636, -0.2094, +0.2534, +0.0584, -0.1214, -0.0528, +0.2144, -0.0489, +0.1428, -0.4547, +0.3023, +0.1876, -0.2271, -0.2712, -0.0368, +0.0226, +0.3567, +0.3778, +0.0462, -0.6882],
[ +0.6798, -0.4377, +0.1569, +0.0333, +0.2554, -0.7306, +0.0552, -0.0964, +0.0233, -0.2414, +0.4599, +0.1201, +0.1526, +0.3449, -0.3901, -0.0520, +0.0142, +0.1143, -0.0628, -0.1422, +0.0065, -0.1712, -0.2435, +0.2696, +0.1976, -0.3010, +0.0841, -0.0520, +0.0530, -0.4799, +0.1579, +0.0542, -0.2293, +0.0175, +0.0998, -0.4996, -0.0021, +0.0976, +0.2630, +0.2560, -0.3273, -0.6430, +0.1433, -0.2714, -0.4301, -0.1063, -0.5331, +0.0453, -0.0422, -0.7346, +0.0103, +0.1141, -0.3075, +0.5838, -0.4402, +0.0107, -0.2519, +0.3035, +0.0617, -0.1239, -0.0582, +0.0819, -0.2549, -0.0617],
[ -0.4620, +0.1039, +0.2718, -0.4127, +0.5362, -0.1675, -0.0134, +0.0474, +0.1751, -0.1708, -0.3052, -0.0923, +0.2314, -0.0473, -0.1889, +0.2227, -0.0617, +0.1827, -0.0638, +0.0832, +0.1307, -0.0376, +0.2549, +0.1163, +0.0217, -0.0295, +0.1856, +0.0447, +0.3144, +0.0192, +0.1334, -0.1732, +0.1038, +0.5194, -0.1748, -0.3605, +0.0401, -0.1904, -0.0520, +0.1078, +0.2092, +0.1732, -0.0869, +0.0862, +0.2042, +0.1082, +0.1115, +0.1921, -0.2242, -0.1484, -0.1547, -0.1516, +0.0972, -0.1834, -0.0674, -0.1024, -0.2689, -0.1438, -0.2595, +0.2955, +0.0165, -0.1716, -0.4096, -0.2054],
[ +0.1132, +0.0516, +0.2309, +0.1508, +0.4150, +0.6007, -0.0352, +0.2317, -0.0671, +0.2011, -0.3415, +0.1591, -0.2383, +0.6372, +0.3010, +0.3118, +0.1479, +0.0164, -0.2021, -0.5601, +0.0992, -0.1180, +0.3660, -0.0074, -0.0110, +0.3083, +0.4824, -0.4372, +0.3548, +0.4300, -0.3224, -0.5314, +0.1288, -0.2895, -0.6216, -0.3745, +0.1898, +0.4399, +0.5817, +0.1331, -0.2474, +0.2019, -0.4515, +0.3305, -0.0683, +0.0029, +0.4052, -0.0851, +0.2337, +0.2265, +0.2858, +0.1127, +0.0817, +0.3689, +0.4294, +0.0295, -0.2713, -0.0449, +0.1425, +0.4592, -0.4234, -0.1197, +0.4217, +0.4013],
[ +0.2244, +0.0371, +0.1917, -0.3505, -0.3589, -0.0197, +0.3228, +0.2821, +0.1560, -0.3783, +0.1291, -0.1117, +0.1405, -0.1386, +0.1467, -0.5553, +0.2028, -0.1745, -0.1661, +0.0878, -0.1963, +0.3390, +0.2130, +0.0866, +0.0769, +0.1475, +0.1181, -0.1046, -0.3478, +0.0398, +0.2143, +0.3020, -0.1104, +0.5029, +0.3219, +0.1769, -0.0049, -0.1178, +0.2728, +0.0490, -0.1552, -0.0796, +0.2879, -0.1114, +0.0906, -0.3729, -0.0256, +0.1075, +0.1313, +0.1239, +0.1413, -0.0573, +0.0635, -0.3302, +0.1189, +0.3353, +0.2585, +0.1093, -0.0779, -0.1743, -0.3092, +0.0579, +0.0981, +0.1322],
[ -0.4991, +0.1559, +0.0673, -0.4170, +0.2502, -0.0966, +0.1419, +0.1655, -0.0472, +0.5364, +0.2014, -0.1711, -0.0572, -0.0236, +0.1309, +0.0174, +0.4913, -0.3201, +0.3377, -0.5432, -0.0636, -0.1694, +0.0226, +0.5256, +0.3893, +0.1476, +0.0357, +0.0000, +0.7093, +0.2149, +0.0833, +0.1663, -0.3381, -0.0484, +0.2107, -0.0243, +0.1685, +0.1339, -0.2678, -0.1244, +0.0983, -0.0201, +0.0867, -0.0718, +0.0917, -0.1346, -0.3112, -0.3083, -0.1345, -0.2397, +0.0241, +0.0975, -0.0785, +0.2825, -0.1737, -0.2374, +0.0487, -0.2247, +0.1715, -0.0550, +0.3994, -0.0521, -0.3960, -0.1537],
[ -0.4554, +0.0323, +0.0113, -0.0103, +0.2303, -0.3589, +0.5005, +0.4360, +0.0542, +0.3385, +0.2570, -0.2263, +0.1576, -0.1348, -0.2946, -0.2221, -0.3633, +0.1250, -0.0961, -0.3598, +0.0836, -0.0563, +0.5804, +0.0244, -0.2834, +0.0415, -0.3893, -0.2688, -0.4176, -0.1889, +0.1634, -0.0584, -0.1259, +0.4351, +0.2028, +0.1172, -0.0276, +0.0620, +0.2088, +0.1379, -0.2203, +0.1408, -0.3491, -0.3407, -0.2507, +0.5658, +0.2345, -0.0798, +0.0558, -0.6434, +0.1232, +0.2756, +0.3574, -0.1813, -0.0455, +0.5372, +0.3477, +0.1892, -0.5011, -0.2192, -0.3892, -0.0979, -0.4526, -0.2306],
[ +0.0244, +0.1531, -0.1644, +0.1040, -0.0407, -0.0134, -0.1597, +0.1814, +0.1349, +0.1318, +0.1877, -0.0383, -0.1732, +0.4492, -0.3200, -0.2095, -0.1788, -0.1462, +0.3578, +0.0233, +0.5702, -0.2862, -0.0157, +0.0450, -0.0630, -0.7301, +0.2157, +0.2055, +0.0876, +0.2803, +0.1552, +0.0790, +0.1829, +0.2815, -0.1324, +0.2568, -0.0221, -0.2449, -0.0130, +0.3108, -0.1357, +0.1916, +0.1227, -0.1729, -0.5393, -0.0019, -0.0845, +0.1748, -0.2540, +0.6049, -0.1314, -0.2955, -0.4838, +0.0778, -0.0178, +0.0918, -0.0080, +0.1067, -0.2145, -0.1394, +0.4584, +0.2449, -0.0853, +0.3650],
[ -0.3841, +0.3191, -0.0523, +0.2066, +0.3247, -0.2838, +0.2937, +0.1549, +0.0304, -1.0016, -0.3347, -0.5035, -0.0512, +0.2749, -0.0137, +0.0266, +0.2564, +0.0883, +0.6045, -0.2271, +0.2179, +0.4793, -0.3314, +0.2457, -0.0318, -0.0753, +0.1263, -0.1123, -0.0472, +0.2331, +0.0713, +0.0378, -0.0470, -0.4414, +0.3262, +0.0750, +0.2206, -0.3277, -0.1568, -0.0708, +0.0958, +0.0573, +0.7739, -0.4665, +0.0893, -0.0905, +0.0016, -0.4959, +0.0596, -0.3073, +0.2977, +0.2246, +0.1135, -0.4823, +0.1464, -0.3549, +0.1816, -0.6204, +0.0460, -0.2280, +0.2199, -0.2556, +0.2287, -0.1095],
[ +0.3204, +0.2019, -0.0716, +0.0316, +0.5188, -0.0643, +0.0722, -0.0804, +0.1496, +0.5213, -0.5768, +0.4262, -0.2018, +0.0577, +0.0983, +0.3329, -0.0696, +0.2850, -0.1771, -0.1407, +0.2019, -0.1076, +0.0969, +0.4154, +0.0837, +0.1716, -0.0282, -0.0705, -0.3540, -0.0656, +0.0531, -0.2986, +0.2031, -0.2475, +0.0558, -0.0648, +0.1712, -0.1422, -0.0049, +0.1512, -0.2116, +0.1054, -0.4684, -0.2090, +0.2465, -0.1349, +0.1034, -0.0784, -0.1470, -0.2842, +0.1957, -0.1686, +0.3573, -0.0297, -0.0216, +0.0152, +0.2972, +0.0237, -0.0475, +0.0569, -0.1298, +0.0107, +0.0574, +0.4169],
[ -0.1421, -0.2681, +0.3620, +0.1567, +0.0211, -0.2771, -0.0415, +0.1698, +0.0932, -0.0334, +0.3452, +0.1091, +0.0137, +0.0540, -0.3061, -0.2377, -0.0829, +0.1320, +0.2162, -0.1576, +0.0637, -0.0493, +0.3047, +0.0225, -0.0322, -0.1344, +0.2098, +0.0802, +0.0620, +0.1275, +0.2456, +0.0968, +0.0848, -0.1860, -0.1085, -0.2026, -0.5984, -0.0784, +0.1113, -0.0947, +0.1317, -0.0481, +0.2911, -0.1539, -0.2196, +0.4990, -0.2887, -0.2207, +0.2388, -0.2251, +0.1192, -0.1048, +0.0450, +0.4368, -0.1313, +0.0553, +0.2936, +0.0331, +0.1042, +0.6131, -0.1217, -0.1598, -0.1806, +0.3852],
[ +0.0514, -0.2830, -0.1279, +0.0255, -0.1907, -0.5928, -0.4551, +0.0489, -0.4074, +0.3205, -0.0464, +0.1832, +0.1579, -0.1833, -0.8387, -0.1496, +0.1634, +0.4095, +0.1423, -0.2789, -0.0155, -0.1965, -0.1727, +0.0814, +0.0707, -0.3121, -0.4674, -0.0054, +0.1682, -0.1615, -0.0786, +0.2362, -0.7577, +0.1548, +0.1652, -0.1758, +0.1049, -0.3197, -0.2067, +0.2096, -0.0779, -0.0603, -0.0938, +0.5626, -0.2058, +0.0687, +0.1848, -0.1480, -0.0133, -0.3408, +0.2978, +0.1723, -0.4943, -0.2329, -0.4655, -0.0721, +0.0663, -0.2466, -0.1562, -0.0441, -0.1437, +0.3350, -0.0391, +0.0345],
[ -0.0723, +0.1156, +0.2149, -0.0761, +0.0012, -0.1175, +0.2979, -0.5510, +0.1459, -0.1094, -0.0764, +0.0530, -0.8413, -0.2452, +0.5943, -0.1389, -0.8146, -0.3985, -0.5863, -0.0938, -0.2923, +0.1091, +0.1469, -0.2870, -0.3903, -0.1749, +0.4955, -0.1858, +0.2394, +0.4946, -0.0707, -0.4239, -0.0418, +0.0148, +0.1007, -0.4017, -0.0068, -0.5673, -0.4331, +0.4999, -0.0010, +0.0391, +0.4218, +0.2711, +0.0624, -0.3756, +0.2174, +0.1804, -0.2304, -0.0461, +0.0934, -0.7057, -0.4299, +0.1648, -0.0769, +0.2740, +0.0061, +0.0052, -0.0816, +0.2290, -0.0728, -0.4457, -0.1315, -0.5928],
[ +0.0100, -0.1567, +0.1922, +0.1805, -0.0324, -0.3645, +0.0037, -0.1908, +0.1814, +0.0161, -0.1200, +0.2586, -0.3445, +0.4750, -0.2137, +0.2889, -0.1879, -0.2689, -0.0462, -0.1182, +0.0357, +0.1932, -0.2172, -0.0211, +0.1449, -0.0863, +0.1842, +0.2997, -0.0595, -0.4969, +0.2058, +0.0158, +0.2561, +0.1801, +0.0082, +0.1412, +0.3388, -0.2166, +0.2486, +0.0698, +0.1575, +0.2887, +0.1297, +0.1775, -0.1643, +0.2977, -0.3498, +0.1496, +0.2660, -0.0704, +0.1957, +0.0524, +0.0750, +0.3847, +0.4883, -0.1209, -0.1070, -0.5514, +0.0134, -0.0614, +0.0777, -0.2794, +0.1039, -0.0016],
[ -0.1775, +0.0231, +0.1289, +0.1551, -0.1735, -0.3305, -0.2516, -0.0066, -0.2482, +0.2593, -0.2319, -0.2041, +0.0789, -0.2738, -0.3242, -0.0968, -0.4328, +0.1848, -0.0633, +0.2825, +0.1585, +0.2109, +0.1973, +0.2197, +0.0799, -0.2457, +0.2551, +0.1533, -0.1153, +0.1828, -0.1943, +0.2050, +0.1979, -0.1467, -0.1880, +0.0098, +0.1268, -0.0545, +0.2020, +0.1492, +0.2350, -0.4275, +0.1185, +0.4156, -0.0520, -0.0226, -0.2318, -0.1595, +0.1029, +0.5155, -0.0145, +0.1085, +0.1511, -1.0908, +0.0153, +0.0952, +0.0446, +0.0161, -0.2392, +0.0711, +0.0120, +0.1907, -0.0549, +0.1207],
[ -0.1350, +0.0492, -0.1316, -0.1407, -0.1874, +0.3319, -0.2022, +0.2373, +0.2025, +0.1855, +0.2579, +0.0744, +0.4433, -0.4318, +0.0705, -0.0050, -0.1234, -0.2623, +0.1706, -0.1430, +0.0378, -0.0313, +0.1015, +0.1084, +0.1800, +0.2237, +0.0672, -0.1713, -0.1269, +0.2099, -0.4321, -0.3458, -0.2965, +0.2089, +0.2316, -0.3361, +0.0394, -0.0234, -0.1346, -0.3534, -0.1437, +0.5744, -0.4584, -0.0098, +0.3013, -0.1432, +0.1335, +0.1690, -0.1816, +0.0062, -0.0260, -0.0444, +0.0422, +0.2972, +0.4833, +0.2370, +0.2996, -0.4458, +0.2057, -0.2652, +0.1873, -0.1082, +0.1451, +0.0747],
[ +0.0050, +0.1049, -0.2272, +0.1488, +0.0247, +0.2145, +0.1779, +0.0617, -0.2001, -0.2955, +0.2225, -0.0174, -0.2364, +0.2018, +0.3447, +0.1928, +0.1651, -0.1127, +0.1105, +0.1212, +0.1382, +0.2438, -0.0179, -0.2546, +0.3055, +0.1761, -0.3366, -0.1768, -0.5368, +0.0849, +0.1534, +0.0046, +0.2855, +0.2781, +0.0155, +0.2849, -0.0040, -0.1324, +0.2333, -0.0518, +0.0237, -0.2335, +0.2474, +0.3611, +0.3797, -0.0494, +0.0667, -0.4717, +0.0258, +0.1816, +0.1485, +0.1670, -0.1302, -0.4282, +0.1608, -0.0990, +0.3083, +0.0694, +0.1913, -0.2014, -0.3348, +0.2261, -0.4767, -0.2007],
[ +0.0133, +0.0808, +0.5594, +0.0913, -0.0358, +0.0399, +0.3061, -0.1481, -0.0093, +0.0621, +0.1026, +0.2710, -0.0678, -0.0027, +0.0976, -0.0762, +0.1627, -0.2535, -0.0537, +0.2125, -0.2350, -0.0102, +0.1494, -0.0528, +0.2681, -0.0750, -0.4646, +0.2000, +0.1575, +0.0146, +0.2363, +0.1998, +0.0753, +0.2565, -0.0991, -0.4272, +0.4909, +0.1872, +0.0403, +0.3341, -0.0672, -0.0377, -0.1925, +0.1410, +0.3147, +0.0978, +0.2105, +0.1167, -0.3527, -0.1541, -0.3279, +0.4349, +0.2786, +0.4845, +0.2873, +0.0183, -0.1336, +0.1418, +0.3117, +0.1688, +0.0637, -0.2348, +0.4402, -0.3123],
[ -0.2538, +0.3040, +0.0899, +0.2645, +0.0941, -0.1083, -0.2675, +0.1211, -0.2321, -0.5406, -0.0029, -0.3387, -0.3885, +0.1895, -0.5119, +0.0688, +0.1893, -0.1504, +0.2037, +0.0806, +0.0228, +0.3811, -0.3368, +0.4758, -0.0404, +0.1066, -0.0081, -0.1985, -0.1016, -0.0983, +0.1177, +0.1220, +0.1594, -0.1280, -0.3425, -0.9586, -0.2100, -0.4235, -0.0118, +0.1288, -1.0922, +0.2203, +0.1109, -0.4652, -0.1308, +0.1751, -0.0878, +0.2067, +0.2125, -0.0403, +0.3188, +0.5829, -0.2007, +0.1964, +0.3079, +0.1082, +0.0707, -0.5270, +0.2327, -0.6367, -0.2662, +0.1057, +0.2461, -0.2917]
])

weights_dense2_b = np.array([ -0.0062, -0.0597, +0.3193, +0.0630, +0.0960, +0.0460, -0.0640, -0.0349, -0.0196, +0.0161, -0.0852, -0.0269, +0.0919, +0.0922, -0.2487, +0.0164, +0.0726, +0.0023, +0.0208, +0.2103, -0.0391, -0.0191, +0.0557, +0.1259, -0.0983, +0.0312, +0.0342, +0.1537, -0.0326, -0.0866, -0.0330, +0.1431, -0.0363, +0.1159, -0.0913, +0.0426, -0.0147, -0.0281, -0.0079, -0.0690, +0.0695, -0.0918, +0.0595, +0.0119, -0.0501, +0.2369, +0.0302, +0.0953, -0.0052, -0.0380, +0.1089, +0.0980, +0.0275, -0.1203, +0.0170, +0.0807, +0.3654, +0.0909, +0.0009, +0.1108, -0.0626, -0.1164, -0.0237, -0.0377])

weights_final_w = np.array([
[ -0.4958, +0.0583, +0.1571, -0.2753, -0.5351, +0.1571, -0.2700, -0.0832, -0.1300, -0.0165, +0.5059, +0.5604, -0.2117, +0.0330, +0.4174, -0.2236, +0.1770, -0.1347, -0.1080, +0.1477, +0.0314, +0.0104, -0.0750, -0.0045, +0.2224, -0.0848, +0.0059, -0.0291, -0.0073, -0.0501],
[ -0.0828, -0.0607, +0.2324, +0.1151, +0.3574, -0.9202, +0.2626, -0.3078, +0.0817, +0.0155, +0.2598, +0.4199, +0.4443, +0.1001, +0.5658, +0.3378, +0.0510, -0.0542, -0.1407, -0.0501, -0.0045, -0.0483, -0.0520, -0.0219, +0.0907, -0.0805, +0.0871, +0.0093, +0.0983, -0.1131],
[ -0.1233, -0.0430, -0.1464, -0.2046, -0.0370, -0.1873, +0.1559, +0.2000, -0.2558, +0.0072, -0.1093, -0.2616, -0.3092, -0.1855, -0.0924, +0.1958, -0.0460, +0.0066, +0.0512, -0.2508, -0.0980, -0.1351, +0.0095, +0.1369, +0.1248, -0.3103, -0.1825, -0.0583, -0.0990, -0.0605],
[ +0.2245, -0.1386, -0.1233, +0.2801, -0.4393, +0.0417, +0.0710, +0.0053, +0.2499, +0.0634, -0.2130, -0.2245, +0.0247, -0.2894, +0.1658, +0.0786, +0.1555, +0.0191, -0.0897, +0.1723, +0.1459, -0.0111, -0.3512, -0.0027, -0.3825, -0.2609, +0.1653, +0.1329, +0.0459, -0.0970],
[ -0.2336, -0.1503, +0.3133, -0.2849, -0.0299, +0.1366, -0.1011, +0.2499, +0.1489, -0.1970, -0.1558, -0.1678, +0.1576, +0.0868, -0.2514, -0.1529, +0.1422, -0.0290, +0.0220, -0.0319, +0.8079, -0.1520, +0.2233, +0.0049, -0.0236, +0.3530, +0.4237, -0.0161, +0.1185, +0.0780],
[ +0.4607, -0.3870, +0.1094, +0.2148, -0.0538, -0.3037, -0.1996, -0.0689, -0.0392, +0.1317, +0.1018, -0.6892, +0.0455, +0.2905, +0.1983, -0.1986, +0.0460, +0.0239, +0.0143, -0.3713, -0.0754, +0.1000, -0.2077, -0.1325, +0.1276, +0.4746, +0.3222, -0.1217, +0.7665, +0.1633],
[ -0.0712, -0.2248, +0.1954, +0.1512, +0.6215, +0.2611, +0.1039, -0.3719, -0.0058, -0.0302, -0.0973, +0.6152, +0.0495, +0.3807, +0.0645, -0.1791, -0.0329, -0.0131, +0.1752, +0.0420, -0.1983, -0.0644, -0.0745, +0.5177, -0.0950, -0.3592, +0.1073, -0.0843, -0.1147, -0.4011],
[ -0.1381, +0.1242, -0.1426, +0.0525, -0.2688, -0.1197, -0.3854, -0.1921, -0.1425, +0.0908, +0.1906, +0.4111, -0.2929, -0.1851, -0.3351, +0.0855, +0.0512, +0.0699, +0.0992, +0.1157, +0.0434, +0.0997, +0.1388, -0.0501, +0.0878, +0.0227, +0.0269, -0.0321, -0.1314, +0.1127],
[ +0.1847, -0.1483, -0.1219, -0.0093, +0.2040, +0.2027, +0.1154, +0.0568, +0.1185, +0.0081, -0.0294, +0.0389, -0.0811, +0.0059, +0.0749, -0.1267, -0.3015, +0.0140, +0.1409, +0.3100, -0.2159, -0.0324, -0.0376, +0.0975, +0.0654, -0.0340, -0.2005, -0.1239, +0.0844, -0.0972],
[ -0.2435, +0.5052, -0.0409, +1.2030, +0.3283, +0.3040, -0.2470, +0.7616, -0.1371, +0.0095, -0.1678, -0.9347, -0.3222, -0.7137, -0.2085, -0.1845, +0.0968, -0.1444, -0.0373, -0.0475, -0.0026, -0.0218, +0.0478, -0.0733, -0.0843, +0.1231, +0.0584, +0.0021, +0.2321, -0.0070],
[ -0.1330, +0.0680, +0.1811, +0.0572, +0.2950, +0.2317, -0.0277, +0.0279, +0.1866, -0.0474, +0.0972, -0.0045, +0.2358, -0.1276, -0.0598, -0.1688, +0.0673, -0.0469, -0.0676, -0.1729, -0.1178, -0.0368, +0.0135, +0.2699, +0.0987, +0.0251, +0.0584, +0.3608, +0.0574, -0.0588],
[ -0.2041, -0.2451, -0.0836, -0.1957, +0.5082, +0.4476, -0.5937, +0.1220, -0.1178, -0.0124, -0.4236, +0.2590, +0.1327, +0.0143, -0.4020, -0.2518, -0.0085, -0.0159, -0.0226, -0.0022, +0.0064, -0.0483, -0.1093, -0.0387, -0.0558, -0.0000, -0.2290, -0.1187, +0.0168, -0.0043],
[ +0.0998, -0.0964, -0.0137, +0.2036, -0.0498, +0.2561, +0.2857, -0.2745, +0.2472, -0.0239, +0.5374, +0.2914, -0.1035, +0.3711, -0.4266, -0.1358, +0.1607, -0.0037, -0.3158, -0.1725, +0.0069, -0.2913, +0.0400, +0.1159, +0.2572, +0.0248, -0.0274, -0.0182, -0.0860, +0.2448],
[ +0.0382, -0.1209, -0.0540, -0.2378, -0.1450, -0.0149, -0.2669, -0.3465, -0.0729, -0.0385, +0.1126, -0.7367, -0.1597, +0.0954, +0.1861, +0.3065, +0.0625, +0.0135, +0.1402, -0.0400, -0.0408, -0.1071, -0.1394, -0.0340, -0.1219, +0.2329, -0.0692, -0.0133, -0.0916, +0.2053],
[ +0.4964, -0.3633, -0.2663, -0.1092, -0.0258, -0.1605, -0.1015, +0.0076, -0.0789, -0.1076, -0.0437, +0.5593, +0.3672, +0.3440, +0.3764, -0.3240, -0.1748, +0.0394, +0.0844, -0.1564, +0.3079, +0.2783, +0.2161, +0.0815, -0.0004, +0.0558, -0.0748, -0.1920, +0.1638, +0.1230],
[ -0.1195, -0.0013, +0.0319, +0.1646, +0.0447, -0.2032, -0.1237, +0.0131, +0.0262, +0.0050, -0.3316, -0.0756, +0.0649, -0.0358, +0.3980, -0.2196, -0.0904, -0.0256, -0.1345, -0.0990, -0.0256, -0.0274, +0.1809, -0.0701, -0.1079, +0.1795, +0.0789, -0.0486, -0.0071, +0.2587],
[ +0.1079, +0.0566, +0.1490, -0.0134, -0.0418, -0.4326, -0.0364, +0.1519, +0.2270, -0.0262, +0.2329, -0.3832, +0.2663, -0.2935, +0.0684, -0.0861, +0.1498, +0.0244, -0.3959, +0.3895, +0.0223, -0.0853, -0.2651, +0.0233, +0.0605, -0.2523, +0.0621, +0.0540, -0.0434, -0.2461],
[ -0.1960, +0.1834, -0.1690, +0.0280, +0.1150, -0.2395, -0.2143, -0.1701, +0.0300, +0.0274, +0.0571, -0.1672, +0.2170, -0.0913, +0.2470, +0.2341, +0.0572, -0.0277, +0.1188, +0.2821, -0.0263, +0.0312, -0.1828, +0.2126, -0.1215, +0.0201, -0.0982, -0.1000, -0.1494, +0.0193],
[ -0.3230, -0.0830, -0.0834, +0.2201, +0.1228, -0.1088, +0.1163, +0.3904, +0.1982, -0.1039, +0.2071, -0.3125, +0.1547, -0.0335, -0.0241, +0.1961, +0.2504, -0.0015, -0.1610, +0.2419, -0.0537, -0.0011, -0.1178, +0.3417, -0.0419, -0.1009, -0.0956, +0.0240, -0.0120, +0.0713],
[ -0.3012, +0.1334, -0.0529, -0.1071, -0.3268, +0.1834, +0.3261, +0.2093, +0.1273, -0.0027, +0.3364, +0.1688, -0.1167, -0.1510, -0.2269, -0.0734, -0.1907, +0.0104, -0.1913, +0.1304, -0.0016, -0.0014, +0.1591, +0.4235, +0.1665, +0.0202, +0.0280, +0.0211, -0.0635, -0.0234],
[ +0.5916, -0.0932, -0.5956, +0.4391, +0.0281, +0.2541, +0.1836, -0.2988, -0.1455, +0.1074, +0.1351, +0.0484, +0.4044, +0.0214, +0.2477, -0.0426, -0.2591, +0.0688, +0.0874, -0.2102, -0.7843, +0.3530, -0.0594, -0.0646, +0.0485, -0.2013, -0.1384, -0.3288, -0.1008, -0.0606],
[ +0.4839, -0.0426, -0.0278, +0.1332, +0.0675, +0.0274, +0.4270, -0.3047, +0.0292, -0.0011, -0.2389, +0.0777, +0.1338, -0.2570, -0.1427, -0.1288, +0.0967, -0.0817, +0.0509, +0.0301, +0.0076, +0.1049, -0.0850, -0.0497, -0.1054, -0.0895, -0.0111, -0.0761, -0.2206, +0.0592],
[ +0.1468, +0.0889, -0.1996, -0.2638, +0.1809, -0.0773, +0.4074, -0.5797, -0.0675, +0.0428, +0.1178, -0.1119, +0.0034, -0.1248, +0.2828, +0.2853, +0.1481, +0.0138, +0.0069, -0.0343, +0.0015, +0.0001, -0.1286, +0.0186, +0.1330, +0.1296, -0.0016, +0.0629, +0.0650, +0.0059],
[ +0.1366, +0.1014, -0.0877, -0.1697, +0.0211, -0.3200, +0.2748, +0.0535, -0.2636, +0.0140, -0.2807, -0.2203, +0.0095, -0.3067, -0.1156, -0.0087, +0.0097, +0.0122, +0.0740, -0.0700, -0.0163, -0.0099, -0.0804, -0.2997, -0.0127, +0.0527, +0.1934, +0.0047, +0.1441, -0.0742],
[ -0.2375, +0.0209, -0.0199, -0.1342, +0.1754, -0.2763, +0.1687, +0.0836, -0.0121, -0.0450, +0.2922, +0.2487, -0.1810, -0.2690, +0.3646, +0.7631, +0.1698, +0.0169, -0.0959, +0.0694, +0.1482, +0.0147, +0.1736, +0.1208, +0.1457, -0.0439, +0.0042, +0.1010, +0.0378, -0.0384],
[ -0.3504, -0.0497, -0.1339, +0.2483, +0.1932, -0.0194, +0.3014, -0.4209, -0.1312, -0.0138, -0.1723, +0.4969, +0.2699, +0.3291, -0.0300, -0.2050, -0.1834, -0.0059, -0.1075, +0.2453, -0.0533, +0.0778, -0.1092, -0.2826, +0.3417, -0.1938, +0.0013, -0.0169, -0.1522, -0.0129],
[ +0.1904, -0.0436, +0.0626, +0.0433, -0.0218, -0.0745, -0.1321, -0.3070, -0.1438, +0.0191, -0.0944, -0.0450, +0.0125, +0.2094, +0.0773, +0.0807, -0.2160, +0.0233, +0.4663, -0.0244, +0.3801, -0.1178, +0.2103, +0.1089, -0.1006, -0.0622, +0.0450, +0.0551, +0.1391, +0.0289],
[ -0.0598, -0.2797, -0.2118, -0.1411, -0.0199, -0.0248, -0.2265, +0.0208, +0.0367, -0.0071, +0.2823, +0.2403, +0.0521, +0.0779, +0.3242, -0.1559, +0.2974, +0.0006, +0.0792, -0.2118, -0.1189, -0.0958, -0.1942, +0.1400, +0.1869, +0.0809, +0.1093, -0.0864, +0.1951, +0.0386],
[ -0.1982, -0.3087, -0.1721, -0.3693, +0.1553, +0.1465, -0.2879, +0.6148, -0.2535, +0.2906, +0.3220, -0.0369, -0.1563, +0.2935, +0.1307, -0.4515, -0.0716, +0.2643, -0.0998, -0.2219, -0.2726, -0.6155, -0.0018, +0.1952, -0.0253, +0.3233, +0.3734, +0.0672, +0.1341, +0.1433],
[ +0.1298, +0.0401, +0.1698, +0.1629, -0.0261, -0.2351, +0.0175, +0.3321, -0.1733, -0.0741, -0.1452, +0.0727, -0.1070, +0.5468, -0.1106, -0.0910, +0.1280, -0.0295, -0.0200, +0.0728, -0.0593, +0.0175, +0.0552, +0.0539, +0.0770, -0.0014, -0.0515, +0.0379, -0.0343, -0.2301],
[ -0.1042, -0.1670, +0.2301, -0.5550, -0.0157, -0.2102, +0.1307, -0.0184, +0.0629, -0.0549, -0.0629, +0.1540, -0.0706, -0.1575, -0.1314, +0.1653, +0.0373, -0.0195, +0.0276, -0.0547, -0.0606, +0.1028, +0.2279, -0.1384, -0.0849, +0.1024, -0.1092, +0.0253, +0.1197, +0.1349],
[ +0.2562, +0.0780, +0.2104, -0.5002, -0.1916, +0.0976, -0.3273, +0.1806, -0.2221, +0.0858, +0.0314, +0.1095, +0.0448, -0.1314, +0.2616, -0.0936, -0.1747, +0.0238, -0.1586, -0.1117, +0.1205, +0.1047, -0.0713, -0.1944, +0.0370, -0.0878, -0.0581, +0.0053, -0.0429, -0.0524],
[ +0.1726, -0.0223, -0.1705, -0.3478, +0.5108, -0.5640, -0.2758, +0.4293, +0.0059, +0.0452, +0.2646, -0.7224, +0.3057, -0.2989, -0.1545, -0.1150, -0.0227, +0.0852, +0.1208, +0.2119, -0.0392, +0.0008, -0.0509, +0.0620, -0.1189, -0.1766, +0.0268, -0.0735, -0.0243, +0.0808],
[ +0.1618, +0.3223, +0.2053, -0.1057, +0.0238, +0.3087, +0.2562, +0.0943, +0.2747, +0.0161, +0.0598, -0.0948, -0.0467, +0.0653, +0.1459, +0.0344, +0.1129, +0.0238, +0.0019, +0.0004, +0.0214, -0.0137, +0.1751, -0.1245, +0.3448, -0.1260, -0.0671, +0.0093, -0.0186, +0.0509],
[ +0.0499, +0.1088, -0.4640, -0.1262, +0.3361, +0.3326, +0.0233, +0.3668, -0.0989, +0.0416, +0.0829, +0.2929, +0.3120, +0.0378, +0.0955, +0.1524, +0.0514, +0.0018, +0.0477, -0.0094, +0.0892, +0.0106, -0.0443, -0.1586, -0.1777, +0.1083, -0.0791, +0.0747, -0.0638, -0.0256],
[ +0.0896, -0.6348, -0.0895, -0.1831, -0.1288, +0.1935, +0.1220, -0.2739, -0.0480, -0.0219, -0.0668, -0.0255, -0.3382, -0.3915, +0.1426, +0.1652, +0.1247, +0.0652, -0.2241, +0.4658, -0.4069, -0.0096, +0.3491, +0.4211, -0.6592, +0.1756, -0.2260, +0.2873, +0.0403, +0.1466],
[ -0.0522, -0.1313, -0.1093, +0.0457, +0.1537, +0.3939, +0.0610, +0.2143, -0.0030, -0.0119, -0.0808, -0.3546, -0.0844, +0.1259, -0.1259, +0.2784, -0.0204, +0.0700, -0.0961, -0.0759, -0.1523, -0.0054, +0.0558, +0.0925, -0.1422, -0.1084, +0.3005, -0.1500, +0.2277, -0.1637],
[ +0.1524, -0.0937, -0.0901, -0.2100, +0.0138, -0.2351, -0.2280, -0.3467, -0.0983, -0.0484, -0.1762, -0.2597, -0.7011, +0.2172, -0.1122, +0.1159, -0.0074, +0.1225, -0.1415, -0.0366, +0.2503, +0.0562, +0.1485, -0.0124, +0.1255, -0.0949, -0.1435, -0.0459, +0.0434, +0.0897],
[ -0.1252, +0.1896, +0.0775, +0.3378, -0.1835, -0.0522, -0.2287, -0.2140, -0.0301, +0.0100, +0.1823, -0.2608, -0.0015, +0.0253, -0.3036, -0.0799, +0.0064, -0.0019, -0.0246, -0.0344, +0.0557, +0.1023, -0.1432, -0.0715, -0.0662, -0.0578, -0.0940, -0.0024, +0.2350, -0.0507],
[ -0.1420, +0.0905, -0.1990, -0.0421, +0.6497, +0.5198, +0.5665, +0.8429, +0.0356, -0.2376, -0.1419, +0.3868, -0.7027, +0.7172, +0.5084, -0.0468, -0.1501, +0.3498, +0.0046, -0.0330, -0.1664, -0.0006, -0.2942, -0.0391, +0.0377, +0.3132, +0.1948, -0.0813, -0.4295, +0.3970],
[ -0.1016, +0.0089, +0.0649, -0.1253, -0.0631, +0.0995, -0.0077, -1.0424, +0.1422, -0.0664, +0.3882, +0.2072, +0.8026, +0.3006, +0.0109, -0.0291, +0.0593, +0.4614, -0.1444, -0.0981, -0.1081, -0.0319, -0.4824, +0.0035, +0.0368, +0.4567, +0.0707, +0.0271, -0.3418, +0.2681],
[ +0.0045, +0.2878, +0.0834, +0.2041, -0.0713, -0.1339, +0.1448, +0.4257, +0.0026, +0.0523, -0.0218, +0.4282, -0.0911, +0.5445, -0.2889, +0.0369, -0.0053, +0.0130, +0.0968, +0.0727, -0.0153, -0.0213, -0.2070, -0.0424, -0.0925, -0.2243, -0.0712, -0.0078, +0.0707, +0.3461],
[ -0.3657, -0.3839, +0.0349, -0.6038, +0.5356, -1.0367, +0.1486, +0.0636, -0.0219, +0.0350, +0.5370, -0.6410, +0.2191, -0.5166, -0.5250, -0.0339, +0.0483, +0.0384, +0.1007, +0.0414, -0.0257, -0.0865, -0.1105, -0.1095, +0.0777, +0.0127, -0.0144, -0.0282, -0.1235, -0.0311],
[ +0.4108, +0.1877, -0.2130, +0.2728, +0.2816, +0.0278, +0.0841, -0.6196, +0.3260, +0.0168, -0.3817, +0.2181, +0.0556, -0.5944, -0.2129, -0.0740, +0.2385, +0.0099, +0.1223, -0.1342, +0.1593, +0.0497, -0.0430, +0.5557, -0.0299, +0.1203, -0.0287, -0.0136, -0.0705, +0.2716],
[ -0.1862, +0.0952, -0.3075, +0.3837, +0.2762, -0.4720, -0.0696, +0.0928, -0.1060, +0.1384, +0.3274, -0.0935, +0.6347, -0.1176, -0.0861, +0.0508, -0.0300, -0.0683, +0.0457, -0.3815, +0.0202, -0.0083, +0.1682, -0.2067, -0.0503, +0.3465, -0.2087, -0.0179, -0.3383, +0.1104],
[ +0.1855, -0.1830, +0.1106, -0.1512, -0.0211, +0.1935, -0.1099, +0.0172, -0.0454, +0.0119, +0.1032, -0.1531, -0.0468, -0.0347, -0.1668, -0.0584, +0.0513, -0.1247, -0.2709, +0.2373, +0.2503, +0.0770, -0.1626, -0.0685, +0.1600, -0.0020, +0.1876, +0.1118, +0.0084, +0.2686],
[ +0.0773, -0.2049, -0.0315, +0.3208, +0.0636, -0.0122, -0.1314, -0.2350, +0.2696, +0.0282, +0.2355, +0.0164, -0.0210, +0.0613, +0.0790, +0.0055, -0.0307, +0.0159, -0.1992, -0.1839, +0.0499, -0.0659, -0.0121, -0.2701, -0.1560, -0.2230, +0.1521, +0.0097, -0.2933, -0.0222],
[ +0.0938, +0.0329, +0.5802, +0.0825, +0.0548, +0.2225, -0.1310, +0.0161, +0.0625, +0.0014, -0.1218, +0.3372, -0.0438, -0.0203, -0.0891, +0.4399, -0.0448, -0.0181, -0.1351, -0.1055, -0.0128, +0.0397, -0.1610, +0.1030, +0.0972, +0.2063, -0.0425, +0.0050, -0.0901, +0.0366],
[ +0.4144, +0.5129, -0.2837, -0.1561, -0.2237, -0.2320, +0.0754, -0.5355, -0.0200, +0.0760, +0.1734, -0.0139, -0.0286, +0.1996, -0.4991, -0.1875, -0.2632, +0.1833, -0.0018, -0.2972, -0.3105, +0.2746, +0.2141, +0.1415, -0.1027, +0.1377, +0.0791, -0.0634, -0.0011, +0.1275],
[ -0.2141, -0.6099, -0.0861, +0.1516, -0.4209, -0.3394, -0.5745, -0.0863, +0.1213, -0.0325, -0.1023, -0.0807, -0.5906, -0.2858, +0.1759, -0.0552, +0.1181, -0.0674, +0.0791, -0.0344, +0.2965, -0.1714, +0.3687, +0.1600, -0.0265, -0.0198, -0.1722, +0.0336, -0.0709, -0.0928],
[ +0.0268, -0.0493, -0.4796, +0.0391, +0.1204, -0.4107, +0.1875, +0.1791, -0.0159, -0.0518, -0.3068, +0.0092, +0.0256, -0.1872, -0.1309, +0.0859, -0.1358, -0.0939, -0.0768, -0.0907, -0.0415, +0.0060, -0.0094, +0.0304, +0.1054, +0.3526, +0.1302, +0.0692, -0.0004, +0.1295],
[ -0.1069, -0.2221, -0.0187, -0.1176, -0.1152, +0.3084, +0.2392, +0.0674, +0.0404, -0.0375, -0.1311, -0.1281, +0.2425, +0.1536, -0.0206, +0.0822, +0.1799, +0.0547, -0.3519, +0.0732, -0.0064, -0.1275, +0.1217, +0.0137, +0.1010, -0.0116, -0.0478, -0.0048, +0.1097, -0.0888],
[ +0.2074, -0.4106, -0.2367, +0.0967, -0.1265, +0.1722, +0.0840, -0.6320, -0.2261, +0.0644, +0.3687, -0.1547, -0.3896, -0.3575, -0.2835, +0.5675, -0.0158, +0.1496, +0.1042, +0.1651, +0.3033, +0.3066, -0.0512, -0.0582, -0.0219, -0.2673, -0.1327, +0.0544, -0.1725, +0.3429],
[ +0.0788, -0.5015, -0.3271, -0.2431, +0.0599, +0.7093, +0.2388, +1.1560, +0.1806, -0.1328, -0.1023, +0.6908, +0.0171, +0.0014, -0.1784, -0.0714, +0.0573, -0.0336, +0.1371, +0.1670, +0.1783, -0.2348, +0.1847, +0.1184, +0.0905, +0.0535, -0.2442, -0.0596, -0.2282, -0.2288],
[ +0.0093, -0.1363, -0.0188, +0.6369, -0.1635, -0.1291, +0.1739, +0.2329, +0.0356, +0.0301, +0.1231, -0.1887, +0.1391, -0.2094, -0.1063, -0.2948, -0.0914, -0.0109, +0.1801, -0.0910, +0.1433, +0.0437, +0.0180, -0.3045, +0.1742, +0.1258, -0.0081, +0.0160, +0.0857, -0.1113],
[ +0.0828, -0.2645, -0.2044, -0.3344, +0.1033, -0.1312, +0.2448, +0.0769, +0.2416, +0.0140, +0.0165, +0.1382, -0.4232, +0.2292, -0.3949, +0.1057, -0.0528, +0.0047, -0.1042, +0.1099, -0.1012, -0.1007, -0.2090, +0.0605, +0.1269, -0.0760, +0.0268, +0.0087, -0.2758, -0.1977],
[ -0.0836, +0.1035, +0.1439, -0.1553, +0.2589, -0.0782, +0.0643, -0.0859, -0.0945, +0.0310, +0.1948, +0.2080, -0.1005, -0.0715, -0.3123, -0.3842, -0.0036, +0.0072, -0.2799, +0.0009, +0.0812, -0.3453, +0.0313, +0.0874, -0.1294, +0.1382, -0.1367, -0.1935, -0.0187, -0.0350],
[ -0.0859, +0.0438, -0.0619, +0.0209, +0.3237, -0.0203, -0.5572, -0.3976, +0.0457, +0.0852, -0.2770, -0.0297, +0.2910, -0.4663, +0.1289, +0.1715, -0.0429, -0.0934, -0.1777, -0.0184, +0.0245, -0.0051, +0.0120, +0.0167, +0.1878, -0.1198, +0.0465, -0.0485, +0.0444, -0.1585],
[ +0.0280, -0.0857, -0.0174, +0.2349, +0.1047, +0.0607, +0.2748, -0.0808, -0.1349, +0.0600, -0.1147, -0.1097, -0.2572, -0.0196, +0.2805, -0.0751, -0.0608, +0.0706, -0.3885, +0.0604, +0.0710, +0.1960, +0.0845, +0.0707, +0.0669, -0.0023, -0.0493, +0.0547, +0.0931, -0.0614],
[ -0.0243, +0.0201, +0.0901, +0.0501, +0.0900, -0.1029, -0.0856, -0.4752, -0.3439, -0.0332, +0.2076, -0.2519, -0.0671, +0.1072, -0.0912, -0.2991, +0.0351, -0.0034, +0.0407, +0.4211, -0.2389, -0.1561, -0.0490, +0.1161, -0.1679, -0.3890, +0.2711, +0.3418, +0.0000, +0.0285],
[ +0.1844, -0.0449, +0.3222, +0.0954, -0.3124, +0.3328, +0.2239, +0.2846, +0.0208, -0.0611, +0.1240, +0.1004, -0.0396, -0.0948, +0.3208, +0.0681, +0.2289, +0.0130, +0.1303, +0.1179, -0.0603, +0.0119, +0.0050, +0.1910, -0.2826, +0.0926, +0.1133, -0.0142, -0.1109, +0.0083],
[ -0.0660, -0.1440, +0.1617, -0.0929, -0.4689, +0.2976, -0.3512, +0.0371, +0.3633, -0.1382, +0.1776, -0.1773, +0.1801, -0.1366, -0.2308, -0.0811, +0.1375, -0.0349, +0.0194, +0.0553, +0.0002, -0.1890, -0.0443, -0.0186, +0.2556, +0.1146, +0.1554, -0.0088, +0.2339, -0.4247],
[ -0.5567, -0.1665, +0.2342, +0.0180, +0.0720, +0.1996, +0.0276, +0.6250, -0.0621, -0.1045, +0.1263, -0.4124, -0.1256, +0.5378, +0.1017, +0.3122, -0.0339, -0.0457, +0.0835, -0.1182, -0.0323, +0.0318, -0.0388, -0.1192, +0.2608, -0.0805, -0.0655, +0.0181, +0.0370, -0.0558],
[ -0.2319, +0.1864, +0.2550, -0.2172, +0.1518, -0.0633, +0.1556, -0.2934, +0.1383, +0.0540, -0.1603, +0.0356, -0.4335, +0.1832, -0.0577, -0.3895, +0.0012, -0.0079, +0.2270, +0.0726, +0.0264, +0.0770, -0.0918, -0.1486, -0.1768, -0.0448, +0.0885, +0.0585, -0.1178, -0.0794]
])

weights_final_b = np.array([ +0.0449, -0.1522, -0.0433, -0.2231, -0.0719, -0.0756, +0.0016, -0.1192, +0.0573, +0.0971, -0.1479, -0.0977, +0.0036, -0.1116, -0.1280, +0.0642, -0.1467, +0.0757, -0.1889, +0.0940, +0.0337, -0.2948, -0.0653, +0.0744, +0.1656, -0.0347, +0.0075, -0.1553, -0.2673, -0.1759])



if __name__ == "__main__":
    main()
