import os
import torch
import torch.distributed as dist # Import PyTorch distributed module

# --- Helper: check if current process is the main process (Rank 0) ---
def is_main_process():
    if dist.is_available() and dist.is_initialized():
        return dist.get_rank() == 0
    return True

# --- Get current process rank ---
def get_rank():
    if dist.is_available() and dist.is_initialized():
        return dist.get_rank()
    return 0

# --- Helper: print project structure ---
def print_project_structure(root_path=".", max_depth=1, current_depth=0):
    """Print project structure."""
    if current_depth > max_depth:
        return
    
    items = []
    try:
        for item in sorted(os.listdir(root_path)):
            if item.startswith('.') and item not in ['.gitignore', '.python-version']:
                continue
            item_path = os.path.join(root_path, item)
            if os.path.isdir(item_path):
                items.append((item, 'dir'))
            else:
                items.append((item, 'file'))
    except PermissionError:
        return
    
    for item, item_type in items:
        indent = "  " * current_depth
        if item_type == 'dir':
            print(f"{indent}{item}/")
            if current_depth < max_depth:
                print_project_structure(os.path.join(root_path, item), max_depth, current_depth + 1)
        else:
            print(f"{indent}{item}")