import ml_collections


def get_config():
    config = ml_collections.ConfigDict()

    config.actor_lr = 3e-4
    config.value_lr = 3e-4
    config.critic_lr = 3e-4

    config.hidden_dims = (256, 256, 128)

    config.discount = 0.99

    config.expectile = 0.9  # The actual tau for expectiles.
    config.bernoulli_p = 0.6
    config.bellman_expectile = 0.9
    config.temperature = 10.0
    config.dropout_rate = None

    config.tau = 0.005  # For soft target updates.

    # config.clip = 5.0
    # config.recon_loss = 0.15

    return config
