# Optimizing Q-Learning Using Expectile Regression: A Dual Approach to Handle In-Sample and Out-of-Sample Data

This repository contains the implementation of EIQL

## How to run the code

- **Python Version**: This codebase is developed and tested with Python 3.9.

### Install dependencies

```bash
pip install --upgrade pip
pip install -r requirements.txt
pip install -U "jax[cuda12]"

### Run training

Locomotion
```bash
python train_offline.py --env_name=halfcheetah-medium-replay-v2 --config=configs/mujoco_config.py
```

AntMaze
```bash
python train_offline.py --env_name=antmaze-large-play-v2 --config=configs/antmaze_config.py --eval_episodes=100 --eval_interval=50000
```

Kitchen and Adroit
```bash
python train_offline.py --env_name=kitchen-partial-v0 --config=configs/kitchen_config.py
```


## Misc
The project is based on https://github.com/ikostrikov/implicit_q_learning.
