import matplotlib.pyplot as plt
import os
from load_all_result import load_all_result
import numpy as np
import argparse

def load_data(input_data_path):
    x = []
    with open(input_data_path, "r") as f:
        for line in f:
            x.append(float(line.strip()))
    return x

def create_histogram(data, figsize=(8, 2.5), ax=None, ylabel=True):
    """
    The function to create the histogram
    
    Args:
        data: the list of data to display in the histogram
        figsize: the size of the figure (only used if ax is not specified)
        ax: the axes object to draw on (if None, a new figure is created)
    
    Returns:
        fig, ax: the figure and axes object of matplotlib
    """
    # if ax is not specified, a new figure is created
    if ax is None:
        fig, ax = plt.subplots(1, 1, figsize=figsize)
        new_fig = True
    else:
        fig = ax.figure
        new_fig = False
    
    ax.grid(True, which="both", linestyle="--", c="gray", zorder=-1)
    ax.hist(data, bins=100, density=True, zorder=0)
    ax.set_xlabel("Value", fontsize=28)
    if ylabel:
        ax.set_ylabel("Density", fontsize=28)
    else:
        ax.set_ylabel("")
    ax.set_yticks([])
    ax.tick_params(axis='x', which='major', labelsize=18)
    return fig, ax

def plot_hist_from_data(data, output_path, figsize=(8, 2.5)):
    """
    The function to create the histogram from data and save it
    
    Args:
        data: the list of data to display in the histogram
        output_path: the path of the output file
        figsize: the size of the figure
    """
    fig, ax = create_histogram(data, figsize)
    os.makedirs(os.path.dirname(output_path), exist_ok=True)
    plt.savefig(output_path, bbox_inches='tight')
    plt.close()
    print(f"Histogram saved to: {output_path}")

def plot_hist_from_file(input_data_path, output_fig_file_path, figsize=(8, 2.5)):
    """
    The function to create the histogram from data and save it
    
    Args:
        input_data_path: the path of the input data file
        output_fig_file_path: the path of the output figure file
        figsize: the size of the figure
    """
    if not os.path.exists(input_data_path):
        print(f"The input data file does not exist: {input_data_path}")
        return
    
    x = load_data(input_data_path)
    plot_hist_from_data(x, output_fig_file_path, figsize)

if __name__ == "__main__":
    input_data_file_path = ""
    output_fig_file_path = ""
    parser = argparse.ArgumentParser()
    parser.add_argument("--input_data_file_path", type=str, required=True, help="Path to the input data file (text format).")
    parser.add_argument("--output_fig_file_path", type=str, required=True, help="Path to the output figure directory.")
    args = parser.parse_args()
    input_data_file_path = args.input_data_file_path
    output_fig_flie_path = args.output_fig_file_path

    plot_hist_from_file(input_data_file_path, output_fig_flie_path)
