#!/bin/bash

# set -e

make

seed=1
n=100000

distributions=(
    "uniform"
    "normal"
    "exponential"
    "lognormal"

    "uniform_shift"
    "normal_shift"
    "exponential_shift"
    "lognormal_shift"

    "data/wiki_ts_200M_uint64"
    "data/osm_cellids_800M_uint64"
    "data/books_800M_uint64"
    "data/fb_200M_uint64"

    "data/nyc_pickup"
    "data/nyc_dist"
    "data/nyc_tot"

    "data/stks_vol"
    "data/stks_open"
    "data/stks_date"
    "data/stks_low"

    "data/sof_hum"
    "data/sof_press"
    "data/sof_temp"

    "data/chic_start"
    "data/chic_tot"
)

mkdir -p result/fig/hist/tmp
for dist in "${distributions[@]}"; do
    command="./bin/create_input_vector $n $dist $seed"
    data_file="result/fig/hist/tmp/${dist//\//_}_n${n}_seed${seed}.txt"
    fig_file="result/fig/hist/hist_${dist//\//_}_n${n}_seed${seed}.pdf"
    # echo "$command"
    eval "$command" > "$data_file"
    python3 plot/plot_hist.py --input_data_file_path "$data_file" --output_fig_file_path "$fig_file"
done
