#ifndef FAST_SPLAY_TREE_H
#define FAST_SPLAY_TREE_H

#include <vector>
#include <stack>
using namespace std;

struct SplayNode {
    double key;
    int count;
    SplayNode *left, *right;
    SplayNode(double k) : key(k), count(1), left(nullptr), right(nullptr) {}
};

class FastSplayTree {
private:
    SplayNode *root;
    SplayNode *lastInserted;

    SplayNode* splay(SplayNode *t, double key) {
        if (!t) return nullptr;

        static SplayNode dummyLeft(0.0), dummyRight(0.0);
        SplayNode *L = &dummyLeft, *R = &dummyRight;
        L->right = R->left = nullptr;

        while (true) {
            if (key < t->key) {
                if (!t->left) break;
                if (key < t->left->key) {
                    SplayNode *y = t->left;
                    t->left = y->right;
                    y->right = t;
                    t = y;
                    if (!t->left) break;
                }
                R->left = t;
                R = t;
                t = t->left;
            }
            else if (key > t->key) {
                if (!t->right) break;
                if (key > t->right->key) {
                    SplayNode *y = t->right;
                    t->right = y->left;
                    y->left = t;
                    t = y;
                    if (!t->right) break;
                }
                L->right = t;
                L = t;
                t = t->right;
            }
            else {
                break;
            }
        }
        L->right = t->left;
        R->left  = t->right;
        t->left  = dummyLeft.right;
        t->right = dummyRight.left;
        return t;
    }

public:
    FastSplayTree() : root(nullptr), lastInserted(nullptr) {}

    void insert(double key) {
        if (!root) {
            root = new SplayNode(key);
            lastInserted = root;
            return;
        }

        SplayNode *start = nullptr;
        if (lastInserted) {
            if (key >= lastInserted->key) {
                if (lastInserted->right) start = lastInserted->right;
                else start = lastInserted; 
            } else {
                if (lastInserted->left) start = lastInserted->left;
                else start = lastInserted; 
            }
        }
        if (!start) start = root;

        SplayNode *curr = start;
        SplayNode *parent = nullptr;
        while (curr) {
            parent = curr;
            if (key < curr->key) {
                curr = curr->left;
            } else if (key > curr->key) {
                curr = curr->right;
            } else {
                root = splay(root, key);
                root->count++;
                return;
            }
        }
        SplayNode *node = new SplayNode(key);
        if (key < parent->key) {
            parent->left = node;
        } else {
            parent->right = node;
        }
        root = splay(root, key);
        lastInserted = root;
    }

    vector<double> getSortedKeys() {
        vector<double> result;
        stack<SplayNode*> st;
        SplayNode *curr = root;
        while (curr || !st.empty()) {
            while (curr) {
                st.push(curr);
                curr = curr->left;
            }
            curr = st.top();
            st.pop();
            for (int i = 0; i < curr->count; i++) result.push_back(curr->key);
            curr = curr->right;
        }
        return result;
    }
};

#endif // FAST_SPLAY_TREE_H
