#ifndef COUNTER_H
#define COUNTER_H

#include <chrono>
#include <unordered_map>

namespace counter {
class Counter {
public:
    bool increment(const std::string& key) {
        total_counts[key]++;
        return true;
    }
    std::unordered_map<std::string, size_t> get_total_counts() const {
        return total_counts;
    }
    void clear() {
        total_counts.clear();
    }
private:
    std::string current_key;
    std::unordered_map<std::string, size_t> total_counts;
};
Counter counter;
}  // namespace counter

#endif  // COUNTER_H
