#ifndef MERGE_SORT_H
#define MERGE_SORT_H

#include <algorithm>
#include <cmath>
#include <cstdint>
#include <cstring>
#include <iterator>
#include <numeric>
#include <vector>
#include <iostream>
#include <cassert>
#include <memory>
#include <execution>
#include <set>
#include "../counter.h"

namespace merge_sort {

template <typename RandomIt>
void merge_sort(RandomIt begin, RandomIt end) {
  using T = typename std::iterator_traits<RandomIt>::value_type;
  if (end - begin < 2) {
    return;
  }
  // Check if the input is already sorted
  bool is_sorted = true;
  for (auto it = begin; it != end - 1; ++it) {
    if (counter::counter.increment("mergesort") && *it > *(it + 1)) {
      is_sorted = false;
      break;
    }
  }
  if (is_sorted) {
    return;
  }
  auto mid = begin + (end - begin) / 2;
  merge_sort(begin, mid);
  merge_sort(mid, end);
  // ---- merge [begin, mid) and [mid, end) ----
  std::vector<T> tmp;
  tmp.reserve(end - begin);
  auto leftIt  = begin;
  auto rightIt = mid;
  while (leftIt < mid && rightIt < end) {
    if (counter::counter.increment("mergesort") && *leftIt <= *rightIt) {
      tmp.push_back(*leftIt);
      ++leftIt;
    } else {
      tmp.push_back(*rightIt);
      ++rightIt;
    }
  }
  while (leftIt < mid) {
    tmp.push_back(*leftIt);
    ++leftIt;
  }
  while (rightIt < end) {
    tmp.push_back(*rightIt);
    ++rightIt;
  }
  std::copy(tmp.begin(), tmp.end(), begin);
}

}  // namespace merge_sort

#endif  // MERGE_SORT_H
