# Reward Evaluation
- This directory contains classes / functions used in evaluating reward functions
- The main evaluation class is `EPIC` defined in `epic.py`
- The `EPIC` class makes use of a `TransitionSampler` subclass in evaluating reward functions
- `TransitionSampler` subclasses sample actions and next states
- The original version of `EPIC` uses a `TransitionSampler` that samples actions and next states from their marginal distributions in the dataset of transitions
- Alternatively, environment-specific `TransitionSampler` subclasses can be defined that sample actions and next states in a manner more appropriate for a given environment
  - These are also defined in this directly, with the environment name prepended to the file name
  - The reason these classes are defined here as opposed to in the corresponding environment file is that they aren't really "part of" the environment in the same way that a reward model or dynamics model would be
