import datetime
import json


def save_json(filepath: str, data, indent: int = 2):
    """Saves data to a json file.

    Args:
        filepath: Where to save the data.
        data: Data to write to the json file (must be json-serializable).
        indent: Indentation to use in the json file.
    """
    with open(filepath, "w", encoding="utf-8") as outfile:
        json.dump(data, outfile, indent=indent)


def load_json(filepath: str):
    """Loads a json file."""
    with open(filepath, "r", encoding="utf-8") as infile:
        return json.load(infile)


def get_datetime_string() -> str:
    """Gets the datetime as a string in the format specified in the function."""
    now = datetime.datetime.now()
    string = now.strftime("%d-%m-%Y_%H-%M-%S")
    return string
