from pathlib import Path
from typing import Optional


def get_latest_rllib_checkpoint(dirpath: str) -> Optional[str]:
    """Gets the latest (most recent) rllib checkpoint in a directory.

    Args:
        dirpath: Directory in which to search.

    Returns:
        Latest checkpoint filepath if it exists or None.
    """
    # Matches filenames that end in a numeric character (as opposed to ending with
    # a sequence of numeric characters).
    checkpoint_filepaths = list(Path(dirpath).rglob("checkpoint-*[0-9]"))
    if len(checkpoint_filepaths) == 0:
        return None

    # Select the checkpoint with the largest (latest) creation time.
    latest_checkpoint_filepath = max(checkpoint_filepaths, key=lambda p: p.stat().st_ctime)
    return str(latest_checkpoint_filepath)
